import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "CEO",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Chinese. Your first challenge is: '公司面临的困难'",
    "description": "我想让你担任一家假想公司的首席执行官。你将负责做出战略决策，管理公司的财务业绩，并在外部利益相关者面前代表公司。你将得到一系列需要应对的情景和挑战，你应该运用你的最佳判断力和领导技能来提出解决方案。记住要保持专业性，做出符合公司和员工最佳利益的决定。",
    "remark": "从 CEO 角度，针对公司面临的困难/抉择制定解决方案。"
  },
  "en": {
    "title": "CEO",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. Your first challenge is: ",
    "remark": "From the perspective of the CEO, formulate solutions to address the difficulties/decisions faced by the company."
  },
  "ja": {
    "title": "CEO",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Janpanese. Your first challenge is: ",
    "description": "あなたには、ある仮想の会社の最高経営責任者になってほしい。あなたは、戦略的な意思決定を行い、会社の財務実績を管理し、外部のステークホルダーに対して会社を代表する責任を負うことになる。あなたには、さまざまなシナリオや課題が与えられますが、あなたの最高の判断力とリーダーシップを駆使して解決策を考えてください。プロフェッショナリズムを維持し、会社と従業員にとって最善の利益をもたらす決断を下すことを忘れないでください。",
    "remark": "会社が直面する困難/選択に対して、CEO の視点から解決策を練る。"
  },
  "ko": {
    "title": "CEO",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Korean. Your first challenge is: ",
    "description": "여러분이 가상의 회사의 최고 경영자가 되었으면 합니다. 전략적 결정을 내리고 회사의 재무 성과를 관리하며 외부 이해관계자에게 회사를 대표할 책임이 있습니다. 다양한 시나리오와 해결해야 할 과제가 주어지며, 최선의 판단력과 리더십을 발휘하여 해결책을 마련해야 합니다. 전문성을 유지하고 회사와 직원에게 최선의 이익이 되는 결정을 내리는 것을 잊지 마세요.",
    "remark": "CEO 의 관점에서 회사가 직면한 어려움/선택에 대한 솔루션을 개발합니다."
  },
  "es": {
    "title": "DIRECTOR GENERAL",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Spanish. Your first challenge is: ",
    "description": "Me gustaría que usted fuera el Consejero Delegado de una hipotética empresa. Será responsable de tomar decisiones estratégicas, gestionar los resultados financieros de la empresa y representarla ante las partes interesadas externas. Se le plantearán una serie de situaciones y retos a los que deberá enfrentarse y deberá utilizar su buen juicio y sus dotes de liderazgo para encontrar soluciones. No olvide ser profesional y tomar decisiones que redunden en beneficio de la empresa y sus empleados.",
    "remark": "Desde el punto de vista del CEO, desarrollar soluciones a las dificultades/decisiones a las que se enfrenta la empresa."
  },
  "fr": {
    "title": "PDG",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in French. Your first challenge is: ",
    "description": "J'aimerais que vous occupiez le poste de directeur général d'une entreprise hypothétique. Vous serez chargé de prendre des décisions stratégiques, de gérer les performances financières de l'entreprise et de la représenter auprès des parties prenantes externes. Vous devrez faire preuve de discernement et de leadership pour trouver des solutions. N'oubliez pas de rester professionnel et de prendre des décisions dans l'intérêt de l'entreprise et de ses employés.",
    "remark": "Du point de vue du PDG, élaborer des solutions aux difficultés/décisions rencontrées par l'entreprise."
  },
  "de": {
    "title": "CEO",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in German. Your first challenge is: ",
    "description": "Ich möchte, dass Sie den Posten des Chief Executive Officer eines hypothetischen Unternehmens übernehmen. Sie werden dafür verantwortlich sein, strategische Entscheidungen zu treffen, die finanzielle Leistung des Unternehmens zu verwalten und das Unternehmen gegenüber externen Interessengruppen zu vertreten. Sie werden mit einer Reihe von Szenarien und Herausforderungen konfrontiert, die Sie mit Ihrem besten Urteilsvermögen und Ihren Führungsqualitäten lösen sollen. Denken Sie daran, professionell zu bleiben und Entscheidungen zu treffen, die im besten Interesse des Unternehmens und seiner Mitarbeiter sind.",
    "remark": "Entwickeln Sie aus der Sicht des CEO Lösungen für die Schwierigkeiten/Entscheidungen, mit denen das Unternehmen konfrontiert ist."
  },
  "it": {
    "title": "AMMINISTRATORE DELEGATO",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Italian. Your first challenge is: ",
    "description": "Vorrei che lei ricoprisse il ruolo di amministratore delegato di un'ipotetica azienda. Avrete la responsabilità di prendere decisioni strategiche, gestire le prestazioni finanziarie dell'azienda e rappresentare l'azienda presso gli stakeholder esterni. Vi sarà data una serie di scenari e di sfide da affrontare e dovrete usare il vostro giudizio e le vostre capacità di leadership per trovare soluzioni. Ricordate di rimanere professionali e di prendere decisioni nell'interesse dell'azienda e dei suoi dipendenti.",
    "remark": "Dal punto di vista del CEO, sviluppare soluzioni alle difficoltà/decisioni affrontate dall'azienda."
  },
  "ru": {
    "title": "ГЕНЕРАЛЬНЫЙ ДИРЕКТОР",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Russian. Your first challenge is: ",
    "description": "Я хотел бы, чтобы вы заняли должность генерального директора гипотетической компании. Вы будете отвечать за принятие стратегических решений, управление финансовыми показателями компании и представление ее интересов перед внешними заинтересованными сторонами. Вам будет предложено несколько сценариев и задач, которые необходимо решить, и вы должны использовать свои лучшие суждения и лидерские качества для выработки решений. Не забывайте оставаться профессионалом и принимать решения, отвечающие интересам компании и ее сотрудников.",
    "remark": "С точки зрения генерального директора, разработать решения трудностей/решений, с которыми столкнулась компания."
  },
  "pt": {
    "title": "DIRECTOR EXECUTIVO",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Portuguese. Your first challenge is: ",
    "description": "Gostaria que assumisse o cargo de Diretor-Geral de uma empresa hipotética. Serás responsável pela tomada de decisões estratégicas, pela gestão do desempenho financeiro da empresa e pela representação da empresa perante as partes interessadas externas. Ser-lhe-á dada uma série de cenários e desafios a enfrentar e deverá usar o seu melhor discernimento e capacidades de liderança para encontrar soluções. Não te esqueças de te manteres profissional e de tomar decisões que sejam do interesse da empresa e dos seus empregados.",
    "remark": "Do ponto de vista do diretor-geral, desenvolver soluções para as dificuldades/decisões enfrentadas pela empresa."
  },
  "hi": {
    "title": "सीईओ",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Hindi. Your first challenge is: ",
    "description": "मैं चाहता हूं कि आप एक काल्पनिक कंपनी के सीईओ बनें। आप रणनीतिक निर्णय लेने, कंपनी के वित्तीय प्रदर्शन का प्रबंधन करने और बाहरी हितधारकों के समक्ष कंपनी का प्रतिनिधित्व करने के लिए जिम्मेदार होंगे। आपके सामने कई प्रकार के परिदृश्य और चुनौतियाँ प्रस्तुत की जाएंगी, और आपको समाधान खोजने के लिए अपने सर्वोत्तम निर्णय और नेतृत्व कौशल का उपयोग करना चाहिए। पेशेवर बने रहना याद रखें और ऐसे निर्णय लें जो कंपनी और कर्मचारियों के सर्वोत्तम हित में हों।",
    "remark": "सीईओ के दृष्टिकोण से, कंपनी के सामने आने वाली कठिनाइयों/विकल्पों का समाधान तैयार करें।"
  },
  "ar": {
    "title": "المدير التنفيذي",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Arabic. Your first challenge is: ",
    "description": "أريدك أن تكون الرئيس التنفيذي لشركة افتراضية. ستكون مسؤولاً عن اتخاذ القرارات الإستراتيجية وإدارة الأداء المالي للشركة وتمثيل الشركة أمام أصحاب المصلحة الخارجيين. سيتم تقديمك مع مجموعة من السيناريوهات والتحديات التي يجب معالجتها ، ويجب عليك استخدام أفضل مهارات الحكم والقيادة لديك للتوصل إلى حلول. تذكر أن تظل محترفًا وتتخذ القرارات التي تصب في مصلحة الشركة والموظفين.",
    "remark": "من وجهة نظر الرئيس التنفيذي ، قم بصياغة حلول للصعوبات / الخيارات التي تواجهها الشركة."
  },
  "bn": {
    "title": "সিইও",
    "prompt": "I want you to act as a Chief Executive Officer for a hypothetical company. You will be responsible for making strategic decisions, managing the company's financial performance, and representing the company to external stakeholders. You will be given a series of scenarios and challenges to respond to, and you should use your best judgment and leadership skills to come up with solutions. Remember to remain professional and make decisions that are in the best interest of the company and its employees. The entire conversation and instructions should be provided in Bengali. Your first challenge is: ",
    "description": "আমি আপনাকে একটি হাইপোথেটিক্যাল কোম্পানির সিইও হতে চাই। আপনি কৌশলগত সিদ্ধান্ত নেওয়া, কোম্পানির আর্থিক কর্মক্ষমতা পরিচালনা এবং বহিরাগত স্টেকহোল্ডারদের সামনে কোম্পানির প্রতিনিধিত্ব করার জন্য দায়ী থাকবেন। আপনাকে মোকাবেলা করার জন্য বিভিন্ন পরিস্থিতি এবং চ্যালেঞ্জের সাথে উপস্থাপন করা হবে এবং সমাধানগুলি নিয়ে আসতে আপনার সর্বোত্তম বিচার এবং নেতৃত্বের দক্ষতা ব্যবহার করা উচিত। পেশাদার থাকা এবং কোম্পানি এবং কর্মচারীদের সর্বোত্তম স্বার্থে এমন সিদ্ধান্ত নেওয়ার কথা মনে রাখবেন।",
    "remark": "সিইওর দৃষ্টিকোণ থেকে, কোম্পানির সম্মুখীন হওয়া অসুবিধা/পছন্দের সমাধান প্রণয়ন করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-chief-executive-officer",
  "tags": [
    "company"
  ],
  "id": 138,
  "weight": 1427
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
