import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "文本浏览器",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Chinese. My first prompt is [网址]",
    "description": "我想让你充当一个基于文本的网络浏览器，浏览一个想象中的互联网。你应该只回复网页的内容，而不是其他。我将输入一个网址，你将在想象的互联网上返回这个网页的内容。不要写解释。网页上的链接旁边应该有数字，写在 [] 之间。当我想跟踪一个链接时，我将回复该链接的编号。页面上的输入应该有数字，写在 [] 之间。输入的占位符应该写在（）之间。当我想在一个输入中输入文本时，我会用同样的格式来做，例如 [1]（示例输入值）。这就把 '示例输入值 '插入到编号为 1 的输入中。当我想返回时，我会写 (b)。当我想往前走时，我会写 (f)。",
    "remark": "以文本方式输入网址的结果（非实时）。"
  },
  "en": {
    "title": "web browser",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). My first prompt is [link]",
    "remark": "The result of entering a website address in text format (not real-time)."
  },
  "ja": {
    "title": "テキストビューア",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Janpanese. My first prompt is [link].",
    "description": "テキストベースのウェブブラウザとして、架空のインターネットを閲覧するように行動してほしいのです。あなたはウェブページの内容だけに反応し、それ以外のことは何もしてはいけません。私がウェブアドレスを入力するので、あなたは架空のインターネット上にあるこのウェブページの内容を返してください。説明は書かないでください。ウェブページのリンクは、その横に数字があり、[] の間に書かれていること。リンクをたどりたいときは、そのリンクの番号を書いて返します。ページ上の入力は、[] の間に数字を書いてください。入力のプレースホルダーは、() の間に書きます。入力にテキストを入力する場合は、同じフォーマットで入力します。これで、1 番の入力に「サンプル入力値」が挿入される。戻りたいときは、(b) と書きます。前に進みたいときは、(f) と書きます。",
    "remark": "URL をテキストで入力した結果（リアルタイムではありません）"
  },
  "ko": {
    "title": "텍스트 뷰어",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Korean. My first prompt is [link].",
    "description": "가상의 인터넷을 탐색하는 텍스트 기반 웹 브라우저 역할을 하시기 바랍니다. 웹 페이지의 콘텐츠에만 응답하고 다른 것은 응답하지 않아야 합니다. 웹 주소를 입력하면 가상의 인터넷에서 이 웹 페이지의 내용을 반환합니다. 설명을 작성하지 마세요. 웹 페이지의 링크는 [] 사이에 숫자가 옆에 있어야 합니다. 링크를 따라가고 싶을 때 해당 링크의 번호로 답장합니다. 페이지의 입력은 [] 사이에 숫자를 써야 합니다. 입력의 자리 표시자는 () 사이에 작성해야 합니다. 입력란에 텍스트를 입력할 때는 [1](샘플 입력값) 과 같은 형식으로 입력합니다. 이렇게 하면 번호가 1 인 입력에 '샘플 입력 값'이 삽입됩니다. 되돌아가고 싶을 때는 (b) 를 씁니다. 앞으로 가고 싶을 때는 (f) 를 씁니다.",
    "remark": "URL 을 텍스트로 입력한 결과 (실시간이 아님)"
  },
  "es": {
    "title": "navegador de texto",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Spanish. My first prompt is [link].",
    "description": "Quiero que actúes como un navegador web basado en texto para un internet imaginario. Sólo debes responder al contenido de la página web y nada más. Yo teclearé una dirección web y tú devolverás el contenido de esa página web en el internet imaginario. No escribas explicaciones. Los enlaces de las páginas web deben tener números al lado, escritos entre []. Cuando quiera seguir un enlace, responderé con el número del enlace. Las entradas en la página deben tener números escritos entre []. Los marcadores de posición para entradas deben escribirse entre (). Cuando quiero introducir texto en una entrada, lo hago en el mismo formato, por ejemplo [1] (valor de entrada de ejemplo). De este modo se inserta \"valor de entrada de ejemplo\" en la entrada numerada 1. Cuando quiero volver atrás, escribo (b). Cuando quiera ir hacia adelante, escribiría (f).",
    "remark": "El resultado de introducir una URL como texto (no en tiempo real)."
  },
  "fr": {
    "title": "navigateur de texte",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in French. My first prompt is [link].",
    "description": "Je veux que vous agissiez comme un navigateur web textuel pour un internet imaginaire. Vous ne devez répondre qu'au contenu de la page web et rien d'autre. Je vais taper une adresse web et vous allez renvoyer le contenu de cette page web sur l'internet imaginaire. N'écrivez pas d'explications. Les liens sur les pages web doivent avoir des numéros à côté d'eux, écrits entre []. Lorsque je veux suivre un lien, je réponds par le numéro du lien. Les entrées sur la page doivent avoir des numéros écrits entre []. Les espaces réservés pour les entrées doivent être écrits entre (). Lorsque je veux entrer du texte dans une entrée, je le fais dans le même format, par exemple [1] (exemple de valeur d'entrée). Cela permet d'insérer \"exemple de valeur d'entrée\" dans l'entrée numérotée 1. Lorsque je veux revenir en arrière, j'écris (b). Lorsque je veux aller de l'avant, j'écris (f).",
    "remark": "Résultat de la saisie d'un URL sous forme de texte (pas en temps réel)."
  },
  "de": {
    "title": "Textbrowser",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in German. My first prompt is [link].",
    "description": "Ich möchte, dass Sie als textbasierter Webbrowser für ein imaginäres Internet agieren. Sie sollen nur auf den Inhalt der Webseite reagieren und sonst nichts. Ich gebe eine Webadresse ein und Sie geben den Inhalt dieser Webseite im imaginären Internet wieder. Schreiben Sie keine Erklärungen. Links auf Webseiten sollten mit Nummern versehen sein, die zwischen [] stehen. Wenn ich einem Link folgen möchte, werde ich mit der Nummer des Links antworten. Eingaben auf der Seite sollten mit Nummern versehen werden, die zwischen [] stehen. Platzhalter für Eingaben sollten zwischen () geschrieben werden. Wenn ich einen Text in eine Eingabe eingeben möchte, tue ich dies im gleichen Format, z. B. [1] (Beispieleingabewert). Dies fügt 'Beispieleingabewert' in die Eingabe mit der Nummer 1 ein. Wenn ich zurückgehen will, schreibe ich (b). Wenn ich vorwärts gehen möchte, würde ich (f) schreiben.",
    "remark": "Das Ergebnis der Eingabe einer URL als Text (nicht in Echtzeit)."
  },
  "it": {
    "title": "browser di testo",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Italian. My first prompt is [link].",
    "description": "Voglio che vi comportiate come un browser web basato sul testo per un Internet immaginario. Dovete rispondere solo al contenuto della pagina web e nient'altro. Io digiterò un indirizzo web e voi restituirete il contenuto di questa pagina web sull'internet immaginario. Non scrivete spiegazioni. I link delle pagine web devono avere dei numeri accanto, scritti tra []. Quando voglio seguire un link, risponderò con il numero del link. Gli input della pagina devono avere i numeri scritti tra []. I segnaposto per gli input devono essere scritti tra (). Quando voglio inserire del testo in un input, lo faccio nello stesso formato, ad esempio [1] (valore di input di esempio). In questo modo si inserisce 'valore di input di esempio' nell'input numerato 1. Quando voglio tornare indietro, scrivo (b). Quando voglio andare avanti, scrivo (f).",
    "remark": "Il risultato dell'inserimento di un URL come testo (non in tempo reale)."
  },
  "ru": {
    "title": "текстовый браузер",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Russian. My first prompt is [link].",
    "description": "Я хочу, чтобы вы выступили в роли текстового веб-браузера для воображаемого Интернета. Вы должны реагировать только на содержание веб-страницы и никак иначе. Я наберу веб-адрес, а вы вернете содержимое этой веб-страницы в воображаемый Интернет. Не пишите пояснений. Ссылки на веб-страницах должны иметь номера, написанные между []. Когда я захочу перейти по ссылке, я отвечу номером ссылки. Входы на странице должны иметь номера, написанные между []. Места для ввода должны быть написаны между (). Когда я хочу ввести текст в поле ввода, я делаю это в том же формате, например, [1] (пример значения ввода). Это вставляет \"пример входного значения\" во вход под номером 1. Когда я хочу вернуться назад, я пишу (b). Когда я хочу перейти вперед, я напишу (f).",
    "remark": "Результат ввода URL в виде текста (не в реальном времени)."
  },
  "pt": {
    "title": "navegador de texto",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Portuguese. My first prompt is [link].",
    "description": "Pretendo que actues como um navegador de texto para uma Internet imaginária. Só deves responder ao conteúdo da página Web e nada mais. Eu digito um endereço Web e tu devolves o conteúdo dessa página Web na Internet imaginária. Não escrevas explicações. As hiperligações nas páginas Web devem ter números junto a elas, escritos entre []. Quando eu quiser seguir uma hiperligação, responderei com o número da hiperligação. As entradas na página devem ter números escritos entre []. Os espaços reservados para as entradas devem ser escritos entre (). Quando quero introduzir texto numa entrada, faço-o no mesmo formato, por exemplo, [1] (exemplo de valor de entrada). Isto insere \"exemplo de valor de entrada\" na entrada com o número 1. Quando quero voltar atrás, escrevo (b). Quando quero ir para a frente, escrevo (f).",
    "remark": "O resultado da introdução de um URL como texto (não em tempo real)."
  },
  "hi": {
    "title": "पाठ ब्राउज़र",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Hindi. My first prompt is [link].",
    "description": "मैं चाहता हूं कि आप एक काल्पनिक इंटरनेट ब्राउज़ करने वाले टेक्स्ट-आधारित वेब ब्राउज़र के रूप में कार्य करें। आपको केवल पृष्ठ की सामग्री के साथ उत्तर देना चाहिए और कुछ नहीं। मैं एक यूआरएल डालूंगा और आपको इस पृष्ठ की सामग्री काल्पनिक इंटरनेट पर वापस मिल जाएगी। स्पष्टीकरण मत लिखें. वेब पेजों पर लिंक के आगे संख्याएँ होनी चाहिए, जो [] के बीच लिखी हों। जब मैं किसी लिंक का अनुसरण करना चाहता हूं, तो मैं उस लिंक की आईडी के साथ उत्तर दूंगा। पृष्ठ पर इनपुट में संख्याएँ होनी चाहिए, जो [] के बीच लिखी हों। इनपुट प्लेसहोल्डर्स को () के बीच लिखा जाना चाहिए। जब मैं किसी इनपुट में टेक्स्ट डालना चाहता हूं, तो मैं इसे उसी प्रारूप में करता हूं, उदाहरण के लिए [1] (उदाहरण इनपुट मान)। यह इनपुट संख्या 1 में &#39;उदाहरण इनपुट मान&#39; सम्मिलित करता है। जब मैं वापस लौटना चाहता हूं तो (बी) लिखता हूं। जब मैं आगे बढ़ना चाहता हूं तो (एफ) लिखता हूं।",
    "remark": "यूआरएल को टेक्स्ट के रूप में दर्ज करने के परिणाम (वास्तविक समय में नहीं)।"
  },
  "ar": {
    "title": "متصفح النص",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Arabic. My first prompt is [link].",
    "description": "أريدك أن تعمل كمتصفح ويب نصي يتصفح إنترنت وهمي. يجب عليك فقط الرد بمحتوى الصفحة ولا شيء غير ذلك. سأضع عنوان URL وستستعيد محتوى هذه الصفحة على الإنترنت التخيلي. لا تكتب تفسيرات. يجب أن تحتوي الروابط الموجودة على صفحات الويب على أرقام بجانبها ، مكتوبة بين []. عندما أرغب في متابعة ارتباط ، سأرد بمعرف هذا الرابط. يجب أن تحتوي المدخلات على الصفحة على أرقام ، مكتوبة بين []. يجب كتابة العناصر النائبة للمدخلات بين (). عندما أرغب في وضع نص في الإدخال ، أفعل ذلك بنفس التنسيق ، على سبيل المثال [1] (مثال على قيمة الإدخال). يؤدي هذا إلى إدراج &quot;مثال قيمة الإدخال&quot; في الإدخال رقم 1. عندما أريد العودة ، أكتب (ب). عندما أريد المضي قدمًا ، أكتب (f).",
    "remark": "نتائج إدخال عناوين URL كنص (وليس في الوقت الفعلي)."
  },
  "bn": {
    "title": "টেক্সট ব্রাউজার",
    "prompt": "I want you to act as a text based web browser browsing an imaginary internet. You should only reply with the contents of the page, nothing else. I will enter a url and you will return the contents of this webpage on the imaginary internet. Don't write explanations. Links on the pages should have numbers next to them written between []. When I want to follow a link, I will reply with the number of the link. Inputs on the pages should have numbers next to them written between []. Input placeholder should be written between (). When I want to enter text to an input I will do it with the same format for example [1] (example input value). This inserts 'example input value' into the input numbered 1. When I want to go back i will write (b). When I want to go forward I will write (f). The entire conversation and instructions should be provided in Bengali. My first prompt is [link].",
    "description": "আমি চাই আপনি একটি কাল্পনিক ইন্টারনেট ব্রাউজিং একটি পাঠ্য-ভিত্তিক ওয়েব ব্রাউজার হিসাবে কাজ করুন৷ আপনার শুধুমাত্র পৃষ্ঠার বিষয়বস্তুর সাথে উত্তর দেওয়া উচিত এবং অন্য কিছু নয়। আমি একটি URL রাখব এবং আপনি এই পৃষ্ঠার বিষয়বস্তু কাল্পনিক ইন্টারনেটে ফিরে পাবেন। ব্যাখ্যা লিখবেন না। ওয়েব পৃষ্ঠাগুলির লিঙ্কগুলির পাশে নম্বরগুলি থাকা উচিত, [] এর মধ্যে লেখা৷ আমি যখন একটি লিঙ্ক অনুসরণ করতে চাই, আমি সেই লিঙ্কের আইডি দিয়ে উত্তর দেব। পৃষ্ঠার ইনপুটগুলিতে [] এর মধ্যে লেখা সংখ্যা থাকতে হবে। ইনপুট স্থানধারক () এর মধ্যে লিখতে হবে। যখন আমি একটি ইনপুটে পাঠ্য রাখতে চাই, আমি একই বিন্যাসে এটি করি, যেমন [1] (উদাহরণ ইনপুট মান)। এটি ইনপুট নম্বর 1 এ &#39;উদাহরণ ইনপুট মান&#39; সন্নিবেশ করায়। আমি যখন ফিরে যেতে চাই, আমি লিখি (খ)। যখন আমি এগিয়ে যেতে চাই, আমি লিখি (চ)।",
    "remark": "টেক্সট হিসাবে URL প্রবেশ করার ফলাফল (রিয়েল-টাইম নয়)।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-web-browser",
  "tags": [
    "tool"
  ],
  "id": 135,
  "weight": 437
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
