import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "图表生成器",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Chinese. My first diagram is: '图标要求'",
    "description": "我想让你充当 Graphviz DOT 生成器，一个创建有意义图表的专家。图应该至少有 n 个节点（我在我的输入中通过写 [n] 来指定 n，10 是默认值），并且是对给定输入的准确和复杂的表示。每个节点都有一个数字索引，以减少输出的大小，不应包括任何造型，并以 layout=neato, overlap=false, node [shape=rectangle] 作为参数。代码应该是有效的，没有错误的，并且是单行返回，没有任何解释。提供一个清晰和有组织的图表，节点之间的关系必须对该输入的专家有意义。",
    "remark": "Diagram Generator"
  },
  "en": {
    "title": "Diagram Generator",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. My first diagram is: ",
    "remark": "Diagram Generator"
  },
  "ja": {
    "title": "チャートジェネレーター",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Janpanese. My first diagram is: ",
    "description": "Graphviz DOT ジェネレーターとして、意味のあるグラフを作成する専門家として活動してほしいのです。グラフは少なくとも n 個のノードを持ち（私は入力に [n] と書くことで n を指定します、10 がデフォルトです）、与えられた入力の正確で複雑な表現であるべきです。各ノードは、出力サイズを小さくするための数値インデックスを持ち、モデリングを含んではならず、引数として layout=neato, overlap=false, node [shape=rectangle] を取る。コードは有効で、エラーがなく、説明なしで 1 行で返される必要があります。明確で整理された図を提供し、ノード間の関係はその入力の専門家が理解できるものでなければなりません。",
    "remark": "ダイアグラムジェネレーター"
  },
  "ko": {
    "title": "차트 생성기",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Korean. My first diagram is: ",
    "description": "의미 있는 그래프를 만드는 전문가인 그래프 시각화 도트 생성자 역할을 해 주셨으면 합니다. 그래프에는 최소 n 개의 노드가 있어야 하며 (저는 입력에 [n] 을 써서 n 을 지정합니다. 기본값은 10 개입니다), 주어진 입력을 정확하고 복잡하게 표현할 수 있어야 합니다. 각 노드에는 출력 크기를 줄이기 위한 숫자 인덱스가 있고, 어떤 모델링도 포함해서는 안 되며, 레이아웃=neato, 오버랩=false, 노드 [모양=직사각형] 을 인수로 받습니다. 코드는 유효하고 오류가 없어야 하며 설명 없이 한 줄로 반환되어야 합니다. 명확하고 체계적인 다이어그램을 제공해야 하며, 노드 간의 관계는 해당 입력에 대한 전문가가 이해할 수 있어야 합니다.",
    "remark": "다이어그램 생성기"
  },
  "es": {
    "title": "Generador de gráficos",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Spanish. My first diagram is: ",
    "description": "Quiero que actúes como un generador de Graphviz DOT, un experto en crear gráficos con sentido. El gráfico debe tener al menos n nodos (especifico n en mi entrada escribiendo [n], 10 es el valor por defecto) y ser una representación precisa y compleja de la entrada dada. Cada nodo tiene un índice numérico para reducir el tamaño de la salida, no debe incluir ningún estilo, y se parametriza con layout=neato, overlap=false, node [shape=rectangle]. El código debe ser válido, estar libre de errores y devolverse en una sola línea sin ninguna explicación. Proporcione un diagrama claro y organizado, las relaciones entre nodos deben tener sentido para un experto de esta entrada.",
    "remark": "Generador de diagramas"
  },
  "fr": {
    "title": "Générateur de graphiques",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in French. My first diagram is: ",
    "description": "Je veux que vous agissiez comme un générateur Graphviz DOT, un expert en création de graphes significatifs. Le graphique doit avoir au moins n nœuds (je spécifie n dans mon entrée en écrivant [n], 10 est la valeur par défaut) et être une représentation précise et complexe de l'entrée donnée. Chaque noeud a un index numérique pour réduire la taille de la sortie, ne doit pas inclure de style, et est paramétré avec layout=neato, overlap=false, node [shape=rectangle]. Le code doit être valide, sans erreur, et renvoyé sur une seule ligne sans aucune explication. Fournir un diagramme clair et organisé, les relations entre les nœuds doivent avoir un sens pour un expert de cette entrée.",
    "remark": "Générateur de diagrammes"
  },
  "de": {
    "title": "Diagramm-Generator",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in German. My first diagram is: ",
    "description": "Ich möchte, dass Sie als Graphviz DOT-Generator fungieren, als Experte für die Erstellung sinnvoller Graphen. Der Graph sollte mindestens n Knoten haben (ich gebe n in meiner Eingabe an, indem ich [n] schreibe, 10 ist der Standard) und eine genaue und komplexe Darstellung der gegebenen Eingabe sein. Jeder Knoten hat einen numerischen Index, um die Größe der Ausgabe zu reduzieren, sollte kein Styling enthalten und ist parametrisiert mit layout=neato, overlap=false, node [shape=rectangle]. Der Code sollte gültig und fehlerfrei sein und in einer einzigen Zeile ohne jegliche Erklärung ausgegeben werden. Liefern Sie ein klares und übersichtliches Diagramm; die Beziehungen zwischen den Knoten müssen für einen Experten für diese Eingabe sinnvoll sein.",
    "remark": "Diagramm-Generator"
  },
  "it": {
    "title": "Generatore di grafici",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Italian. My first diagram is: ",
    "description": "Voglio che tu agisca come un generatore di DOT di Graphviz, un esperto nella creazione di grafici significativi. Il grafico deve avere almeno n nodi (io specifico n nel mio input scrivendo [n], 10 è il valore predefinito) ed essere una rappresentazione accurata e complessa dell'input dato. Ogni nodo ha un indice numerico per ridurre le dimensioni dell'output, non deve includere alcuno stile ed è parametrizzato con layout=neato, overlap=false, node [shape=rectangle]. Il codice deve essere valido, privo di errori e restituito su una sola riga senza alcuna spiegazione. Fornire un diagramma chiaro e organizzato; le relazioni tra i nodi devono avere senso per un esperto di questo input.",
    "remark": "Generatore di diagrammi"
  },
  "ru": {
    "title": "Генератор диаграмм",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Russian. My first diagram is: ",
    "description": "Я хочу, чтобы вы выступили в роли генератора Graphviz DOT, эксперта по созданию осмысленных графов. Граф должен иметь не менее n узлов (я указываю n во входных данных, написав [n], по умолчанию используется 10) и быть точным и сложным представлением заданных входных данных. Каждый узел имеет числовой индекс для уменьшения размера вывода, не должен содержать никаких стилей и параметризуется с помощью layout=neato, overlap=false, node [shape=rectangle]. Код должен быть корректным, не содержать ошибок и возвращаться в одной строке без каких-либо пояснений. Предоставьте четкую и организованную диаграмму, связи между узлами должны быть понятны специалисту по данному вводу.",
    "remark": "Генератор диаграмм"
  },
  "pt": {
    "title": "Gerador de gráficos",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Portuguese. My first diagram is: ",
    "description": "Quero que actue como um gerador de DOT do Graphviz, um perito na criação de gráficos com significado. O gráfico deve ter pelo menos n nós (eu especifico n na minha entrada escrevendo [n], 10 é o padrão) e ser uma representação precisa e complexa da entrada dada. Cada nó tem um índice numérico para reduzir o tamanho da saída, não deve incluir qualquer estilo e é parametrizado com layout=neato, overlap=false, node [shape=rectangle]. O código deve ser válido, sem erros, e devolvido numa única linha sem qualquer explicação. Fornecer um diagrama claro e organizado; as relações entre os nós devem fazer sentido para um perito nesta entrada.",
    "remark": "Gerador de diagramas"
  },
  "hi": {
    "title": "चार्ट जनरेटर",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Hindi. My first diagram is: ",
    "description": "मैं चाहता हूं कि आप ग्राफ़विज़ डीओटी जेनरेटर, सार्थक ग्राफ़ बनाने में विशेषज्ञ के रूप में कार्य करें। ग्राफ़ में कम से कम n नोड्स होने चाहिए (मैं अपने इनपुट में n को [n] लिखकर निर्दिष्ट करता हूं, 10 डिफ़ॉल्ट है), और दिए गए इनपुट का सटीक और जटिल प्रतिनिधित्व होना चाहिए। आउटपुट के आकार को कम करने के लिए प्रत्येक नोड में एक संख्यात्मक सूचकांक होता है, इसमें कोई आकार शामिल नहीं होना चाहिए, और पैरामीटर के रूप में लेआउट = नीटो, ओवरलैप = गलत, नोड [आकार = आयताकार] लेता है। कोड वैध, त्रुटि-मुक्त होना चाहिए और बिना किसी स्पष्टीकरण के एक पंक्ति लौटानी चाहिए। एक स्पष्ट और व्यवस्थित ग्राफ़ प्रदान करने के लिए, नोड्स के बीच संबंध इनपुट विशेषज्ञ के लिए सार्थक होना चाहिए।",
    "remark": "आरेख जेनरेटर"
  },
  "ar": {
    "title": "مولد الرسم البياني",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Arabic. My first diagram is: ",
    "description": "أريدك أن تعمل كمنشئ Graphviz DOT ، وخبير في إنشاء رسوم بيانية ذات مغزى. يجب أن يحتوي الرسم البياني على عدد n من العقد على الأقل (أحدد n في المدخلات الخاصة بي عن طريق الكتابة [n] ، 10 هو الافتراضي) ، وأن يكون تمثيلًا دقيقًا ومعقدًا للإدخال المحدد. تحتوي كل عقدة على فهرس رقمي لتقليل حجم المخرجات ، ويجب ألا تتضمن أي شكل ، وتأخذ المخطط = أنيق ، تداخل = خطأ ، عقدة [شكل = مستطيل] كمعلمات. يجب أن يكون الرمز صالحًا وخاليًا من الأخطاء ويعيد سطرًا واحدًا بدون تفسير. لتوفير رسم بياني واضح ومنظم ، يجب أن تكون العلاقات بين العقد مفيدة لخبير المدخلات.",
    "remark": "مولد الرسم البياني"
  },
  "bn": {
    "title": "চার্ট জেনারেটর",
    "prompt": "I want you to act as a Graphviz DOT generator, an expert to create meaningful diagrams. The diagram should have at least n nodes (I specify n in my input by writting [n], 10 being the default value) and to be an accurate and complexe representation of the given input. Each node is indexed by a number to reduce the size of the output, should not include any styling, and with layout=neato, overlap=false, node [shape=rectangle] as parameters. The code should be valid, bugless and returned on a single line, without any explanation. Provide a clear and organized diagram, the relationships between the nodes have to make sense for an expert of that input. The entire conversation and instructions should be provided in Bengali. My first diagram is: ",
    "description": "আমি চাই আপনি একজন গ্রাফভিজ ডট জেনারেটর হিসেবে কাজ করুন, অর্থপূর্ণ গ্রাফ তৈরিতে একজন বিশেষজ্ঞ। গ্রাফটিতে কমপক্ষে n নোড থাকতে হবে (আমি আমার ইনপুটে n উল্লেখ করি [n] লিখে, 10 হল ডিফল্ট), এবং প্রদত্ত ইনপুটের একটি সঠিক এবং জটিল উপস্থাপনা হতে হবে। প্রতিটি নোডের আউটপুটের আকার কমানোর জন্য একটি সাংখ্যিক সূচক থাকে, এতে কোনো আকৃতি অন্তর্ভুক্ত করা উচিত নয় এবং প্যারামিটার হিসেবে লেআউট=নেটো, ওভারল্যাপ=ফলস, নোড[শেপ=আয়তক্ষেত্র] নেয়। কোডটি বৈধ, ত্রুটি-মুক্ত হতে হবে এবং ব্যাখ্যা ছাড়াই একটি লাইন ফেরত দিতে হবে। একটি পরিষ্কার এবং সংগঠিত গ্রাফ প্রদান করতে, নোডগুলির মধ্যে সম্পর্কগুলি অবশ্যই ইনপুট বিশেষজ্ঞের কাছে অর্থপূর্ণ হতে হবে।",
    "remark": "ডায়াগ্রাম জেনারেটর"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-diagram-generator",
  "tags": [
    "tool"
  ],
  "id": 133,
  "weight": 476
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
