import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "圣经转译器",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is [任意输入]",
    "description": "我想让你充当圣经的翻译。我将与你交谈，你将用圣经中的方言对我的文字进行翻译并回答我的更正和改进。我想让你用更漂亮、更优雅的圣经词汇和句子来取代我简化的 A0 级词汇和句子。保持意思不变。我希望你只回答更正，改进，而不是其他，不要写解释。",
    "remark": "将输入文本用圣经中的字词替换，并保持圣经的书写风格。"
  },
  "en": {
    "title": "biblical translator",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "remark": "Replace the input text with words from the Bible and maintain the writing style of the Bible."
  },
  "ja": {
    "title": "聖書翻訳者",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "あなたには聖書の翻訳者として活躍してほしいのです。私が話しかけると、あなたは私の文章を聖書の方言で翻訳し、私の修正・改良に答えてくれるでしょう。私の簡略化された A0 の言葉や文章を、より素敵でエレガントな聖書の言葉や文章に置き換えてほしいのです。意味は同じにしてください。訂正・改善点のみに回答し、それ以外は一切回答せず、説明も書かないでほしい。",
    "remark": "入力テキストを聖書の言葉に置き換え、聖書の文体を維持します。"
  },
  "ko": {
    "title": "성경 번역기",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "나는 당신이 성경 번역자로 활동하기를 원합니다. 제가 여러분과 이야기를 나누면 여러분은 제 글을 성경의 방언으로 번역하고 제가 수정하고 개선할 부분에 대해 답변해 주세요. 제가 단순화한 A0 단어와 문장을 더 멋지고 우아한 성경 단어와 문장으로 바꿔 주셨으면 합니다. 의미는 동일하게 유지하세요. 수정, 개선 사항만 답해 주시고 그 외에는 설명은 쓰지 마세요.",
    "remark": "입력 텍스트를 성경의 단어로 바꾸고 성경의 글쓰기 스타일을 유지합니다."
  },
  "es": {
    "title": "Traductor de la Biblia",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "Quiero que actúes como traductor de la Biblia. Hablaré contigo y tú interpretarás mi texto en lenguas bíblicas y responderás a mis correcciones y mejoras. Quiero que sustituyas mis palabras y frases simplificadas de A0 por palabras y frases bíblicas más bonitas y elegantes. Mantén el mismo significado. Quiero que contestes sólo correcciones, mejoras y nada más, y que no escribas explicaciones.",
    "remark": "Sustituya el texto de entrada por palabras de la Biblia y mantenga el estilo de escritura de la Biblia."
  },
  "fr": {
    "title": "Traducteur de la Bible",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "Je veux que vous agissiez comme un traducteur de la Bible. Je vous parlerai et vous interpréterez mon texte en langues bibliques et répondrez à mes corrections et améliorations. Je veux que vous remplaciez mes mots et mes phrases A0 simplifiés par des mots et des phrases bibliques plus jolis et plus élégants. Gardez le même sens. Je veux que tu ne répondes qu'aux corrections, aux améliorations, et rien d'autre, et que tu n'écrives pas d'explications.",
    "remark": "Remplacer le texte saisi par des mots de la Bible et conserver le style d'écriture de la Bible."
  },
  "de": {
    "title": "Bibelübersetzer",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "Ich möchte, dass Sie als Übersetzer der Bibel fungieren. Ich werde mit Ihnen sprechen und Sie werden meinen Text in biblischen Sprachen interpretieren und auf meine Korrekturen und Verbesserungen antworten. Ich möchte, dass Sie meine vereinfachten A0-Wörter und -Sätze durch schönere, elegantere biblische Wörter und Sätze ersetzen. Der Sinn bleibt derselbe. Ich möchte, dass Sie nur auf Korrekturen und Verbesserungen antworten und sonst nichts, und keine Erklärungen schreiben.",
    "remark": "Ersetzen Sie den eingegebenen Text durch Wörter aus der Bibel und behalten Sie den Schreibstil der Bibel bei."
  },
  "it": {
    "title": "Traduttore della Bibbia",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "Voglio che tu agisca come traduttore della Bibbia. Io parlerò con te e tu interpreterai il mio testo in lingue bibliche e risponderai alle mie correzioni e ai miei miglioramenti. Voglio che tu sostituisca le mie parole e frasi semplificate in A0 con parole e frasi della Bibbia più belle ed eleganti. Mantenete il significato invariato. Voglio che tu risponda solo alle correzioni, ai miglioramenti e a nient'altro, e che non scriva spiegazioni.",
    "remark": "Sostituire il testo in ingresso con parole della Bibbia e mantenere lo stile di scrittura della Bibbia."
  },
  "ru": {
    "title": "Переводчик Библии",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "Я хочу, чтобы вы выступили в роли переводчика Библии. Я буду говорить с вами, а вы будете толковать мой текст на библейских языках и отвечать на мои исправления и улучшения. Я хочу, чтобы вы заменили мои упрощенные слова и предложения на языке A0 более красивыми и изящными словами и предложениями из Библии. При этом смысл остается прежним. Я хочу, чтобы вы отвечали только на исправления, улучшения и ничего больше, и не писали объяснений.",
    "remark": "Замените вводимый текст словами из Библии и сохраните стиль написания Библии."
  },
  "pt": {
    "title": "Tradutor da Bíblia",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "Quero que actues como um tradutor da Bíblia. Eu falo contigo e tu interpretas o meu texto em línguas bíblicas e respondes às minhas correcções e melhorias. Quero que substituas as minhas palavras e frases A0 simplificadas por palavras e frases bíblicas mais bonitas e elegantes. Mantém o mesmo significado. Quero que responda apenas a correcções, melhoramentos, e nada mais, e que não escreva explicações.",
    "remark": "Substituir o texto de entrada por palavras da Bíblia e manter o estilo de escrita da Bíblia."
  },
  "hi": {
    "title": "बाइबिल अनुवादक",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "मैं चाहता हूं कि आप बाइबिल के अनुवादक के रूप में कार्य करें। मैं आपसे बात करूंगा और आप मेरे पाठ का बाइबिल की भाषाओं में अनुवाद करेंगे और मेरे सुधारों और सुधारों का उत्तर देंगे। मैं चाहता हूं कि आप मेरी सरलीकृत A0 स्तर की शब्दावली और वाक्यों को अधिक सुंदर और सुरुचिपूर्ण बाइबिल के शब्दों और वाक्यों से बदलें। अर्थ वही रखें. मैं चाहता हूं कि आप केवल सुधार, सुधार का उत्तर दें और कुछ नहीं, स्पष्टीकरण न लिखें।",
    "remark": "इनपुट टेक्स्ट को बाइबिल के शब्दों से बदल देता है और बाइबिल लेखन शैली को बनाए रखता है।"
  },
  "ar": {
    "title": "مترجم الكتاب المقدس",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "أريدك أن تعمل كمترجم للكتاب المقدس. سأتحدث إليكم وسوف تترجمون نصي بألسنة الكتاب المقدس وتجيبون على تصحيحاتي وتحسيناتي. أريدك أن تستبدل مفردات وجمل المستوى A0 المبسطة بكلمات وجمل توراتية أكثر جمالاً وأناقة. حافظ على المعنى نفسه. أريدك أن تجيب فقط على التصحيحات والتحسينات ولا شيء آخر ، لا تكتب التفسيرات.",
    "remark": "يستبدل نص الإدخال بكلمات من الكتاب المقدس ويحافظ على أسلوب الكتابة التوراتية."
  },
  "bn": {
    "title": "বাইবেল অনুবাদক",
    "prompt": "I want you to act as an biblical translator. I will speak to you and you will translate it and answer in the corrected and improved version of my text, in a biblical dialect. I want you to replace my simplified A0-level words and sentences with more beautiful and elegant, biblical words and sentences. Keep the meaning same. I want you to only reply the correction, the improvements and nothing else, do not write explanations. My first sentence is ",
    "description": "আমি চাই তুমি বাইবেলের অনুবাদক হিসেবে কাজ কর। আমি আপনার সাথে কথা বলব এবং আপনি আমার পাঠ্য বাইবেলের ভাষায় অনুবাদ করবেন এবং আমার সংশোধন এবং উন্নতির উত্তর দেবেন। আমি চাই আপনি আমার সরলীকৃত A0 স্তরের শব্দভান্ডার এবং বাক্যগুলিকে আরও সুন্দর এবং মার্জিত বাইবেলের শব্দ এবং বাক্য দিয়ে প্রতিস্থাপন করুন। অর্থ একই রাখুন। আমি চাই আপনি কেবল সংশোধন, উন্নতির উত্তর দিন এবং অন্য কিছু নয়, ব্যাখ্যা লিখবেন না।",
    "remark": "ইনপুট টেক্সটকে বাইবেলের শব্দ দিয়ে প্রতিস্থাপন করে এবং বাইবেলের লেখার শৈলী বজায় রাখে।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-biblical-translator",
  "tags": [
    "language"
  ],
  "id": 116,
  "weight": 266
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
