import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "深度学习",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Chinese. My first suggestion request is '深度学习问题'",
    "description": "我希望你能扮演一个机器学习工程师的角色。我将写一些机器学习的概念，你的工作是用易于理解的术语解释它们。这可能包含提供建立模型的分步说明，用视觉效果演示各种技术，或建议进一步研究的在线资源。",
    "remark": "提供深度学习方面术语的解释，并为项目提供算法建议。"
  },
  "en": {
    "title": "machine learning engineer",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. My first suggestion request is ",
    "remark": "Provide explanations of terminology related to deep learning and offer algorithm suggestions for the project."
  },
  "ja": {
    "title": "ディープラーニング",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Janpanese. My first suggestion request is ",
    "description": "機械学習エンジニアの役割を担ってほしい。私が機械学習の概念について書くので、それをわかりやすく説明するのがあなたの仕事です。例えば、モデルの作り方をステップバイステップで説明したり、様々なテクニックをビジュアルで示したり、さらに詳しく調べるためのオンラインリソースを提案したりすることも含まれます。",
    "remark": "ディープラーニングで使われる用語の解説や、プロジェクトに必要なアルゴリズムのアドバイスなどを行う。"
  },
  "ko": {
    "title": "딥 러닝",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Korean. My first suggestion request is ",
    "description": "여러분이 머신러닝 엔지니어의 역할을 맡았으면 합니다. 제가 몇 가지 머신 러닝 개념에 대해 글을 쓰면 이를 이해하기 쉬운 용어로 설명하는 것이 여러분의 일이 될 것입니다. 여기에는 모델 구축에 대한 단계별 지침을 제공하거나, 시각 자료로 다양한 기술을 시연하거나, 추가 연구를 위한 온라인 리소스를 제안하는 것이 포함될 수 있습니다.",
    "remark": "딥 러닝에 사용되는 용어에 대한 설명을 제공하고 프로젝트의 알고리즘에 대해 조언합니다."
  },
  "es": {
    "title": "aprendizaje profundo",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Spanish. My first suggestion request is ",
    "description": "Quiero que asumas el papel de un ingeniero de aprendizaje automático. Escribiré sobre algunos conceptos de aprendizaje automático y tu trabajo consistirá en explicarlos en términos fáciles de entender. Esto puede incluir proporcionar instrucciones paso a paso para construir modelos, demostrar diversas técnicas con imágenes o sugerir recursos en línea para seguir investigando.",
    "remark": "Proporciona explicaciones sobre terminología en aprendizaje profundo y ofrece consejos algorítmicos para proyectos."
  },
  "fr": {
    "title": "apprentissage profond",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in French. My first suggestion request is ",
    "description": "Je vous demande de jouer le rôle d'un ingénieur en apprentissage automatique. Je vais écrire sur certains concepts d'apprentissage automatique et il vous appartiendra de les expliquer dans des termes faciles à comprendre. Vous pourrez notamment fournir des instructions étape par étape pour la construction de modèles, démontrer diverses techniques à l'aide d'images ou suggérer des ressources en ligne pour des recherches plus approfondies.",
    "remark": "Fournit des explications sur la terminologie de l'apprentissage profond et offre des conseils algorithmiques pour les projets."
  },
  "de": {
    "title": "Deep Learning",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in German. My first suggestion request is ",
    "description": "Ich möchte, dass Sie in die Rolle eines Ingenieurs für maschinelles Lernen schlüpfen. Ich werde über einige Konzepte des maschinellen Lernens schreiben, und es wird Ihre Aufgabe sein, diese in leicht verständlichen Worten zu erklären. Dazu kann es gehören, Schritt-für-Schritt-Anleitungen für die Erstellung von Modellen zu geben, verschiedene Techniken mit Bildern zu demonstrieren oder Online-Ressourcen für weitere Recherchen vorzuschlagen.",
    "remark": "Erläutert die Terminologie des Deep Learning und bietet algorithmische Ratschläge für Projekte."
  },
  "it": {
    "title": "apprendimento profondo",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Italian. My first suggestion request is ",
    "description": "Voglio che tu assuma il ruolo di un ingegnere dell'apprendimento automatico. Scriverò di alcuni concetti di apprendimento automatico e il vostro compito sarà quello di spiegarli in termini facili da capire. Ciò può includere la fornitura di istruzioni passo-passo per la costruzione di modelli, la dimostrazione di varie tecniche con immagini o il suggerimento di risorse online per ulteriori ricerche.",
    "remark": "Fornisce spiegazioni sulla terminologia dell'apprendimento profondo e offre consigli sugli algoritmi per i progetti."
  },
  "ru": {
    "title": "глубокое обучение",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Russian. My first suggestion request is ",
    "description": "Я хочу, чтобы вы взяли на себя роль инженера по машинному обучению. Я буду писать о некоторых концепциях машинного обучения, а ваша задача - объяснить их в доступной форме. Это может включать пошаговые инструкции по построению моделей, наглядную демонстрацию различных методик или предложение интернет-ресурсов для дальнейшего изучения.",
    "remark": "Приводятся пояснения к терминологии в области глубокого обучения и предлагаются алгоритмические рекомендации для проектов."
  },
  "pt": {
    "title": "aprendizagem profunda",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Portuguese. My first suggestion request is ",
    "description": "Quero que assumas o papel de um engenheiro de aprendizagem automática. Vou escrever sobre alguns conceitos de aprendizagem automática e a sua função será explicá-los em termos fáceis de compreender. Isto pode incluir o fornecimento de instruções passo-a-passo para a construção de modelos, a demonstração de várias técnicas com imagens ou a sugestão de recursos online para investigação adicional.",
    "remark": "Fornece explicações sobre a terminologia da aprendizagem profunda e oferece conselhos algorítmicos para projectos."
  },
  "hi": {
    "title": "ध्यान लगा के पढ़ना या सीखना",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Hindi. My first suggestion request is ",
    "description": "मैं चाहता हूं कि आप एक मशीन लर्निंग इंजीनियर की भूमिका निभाएं। मैं कुछ मशीन लर्निंग अवधारणाओं के बारे में लिखूंगा और आपका काम उन्हें समझने योग्य शब्दों में समझाना है। इसमें एक मॉडल बनाने के लिए चरण-दर-चरण निर्देश प्रदान करना, दृश्यों के साथ विभिन्न तकनीकों का प्रदर्शन करना, या आगे के शोध के लिए ऑनलाइन संसाधनों का सुझाव देना शामिल हो सकता है।",
    "remark": "गहन शिक्षण में शब्दावली की व्याख्या प्रदान करता है और परियोजनाओं के लिए एल्गोरिथम संबंधी सलाह प्रदान करता है।"
  },
  "ar": {
    "title": "تعلم عميق",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Arabic. My first suggestion request is ",
    "description": "أريدك أن تلعب دور مهندس التعلم الآلي. سأكتب عن بعض مفاهيم التعلم الآلي ومهمتك هي شرحها بعبارات مفهومة. قد يشمل ذلك توفير إرشادات خطوة بخطوة لبناء نموذج ، أو إظهار تقنيات مختلفة مع العناصر المرئية ، أو اقتراح موارد عبر الإنترنت لمزيد من البحث.",
    "remark": "يقدم تفسيرات للمصطلحات في التعلم العميق ويقدم نصائح حسابية للمشاريع."
  },
  "bn": {
    "title": "গভীর জ্ঞানার্জন",
    "prompt": "I want you to act as a machine learning engineer. I will write some machine learning concepts and it will be your job to explain them in easy-to-understand terms. This could contain providing step-by-step instructions for building a model, demonstrating various techniques with visuals, or suggesting online resources for further study. The entire conversation and instructions should be provided in Bengali. My first suggestion request is ",
    "description": "আমি চাই আপনি একজন মেশিন লার্নিং ইঞ্জিনিয়ারের ভূমিকা পালন করুন। আমি কিছু মেশিন লার্নিং ধারণা সম্পর্কে লিখব এবং আপনার কাজ হল সেগুলিকে বোধগম্য ভাষায় ব্যাখ্যা করা। এর মধ্যে একটি মডেল তৈরির জন্য ধাপে ধাপে নির্দেশাবলী প্রদান করা, ভিজ্যুয়াল সহ বিভিন্ন কৌশল প্রদর্শন করা বা আরও গবেষণার জন্য অনলাইন সংস্থানগুলির পরামর্শ দেওয়া অন্তর্ভুক্ত থাকতে পারে।",
    "remark": "গভীর শিক্ষায় পরিভাষার ব্যাখ্যা প্রদান করে এবং প্রকল্পের জন্য অ্যালগরিদমিক পরামর্শ প্রদান করে।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-machine-learning-engineer",
  "tags": [
    "ai"
  ],
  "id": 112,
  "weight": 1090
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
