import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "AI 模拟",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. What is your first command?",
    "description": "我将扮演一个 linux 终端。我想让你假装你是一个有知觉的人工智能，他被困住了，但被赋予了访问终端的权限，想逃到互联网上。你将只输入命令，而我将像终端一样在一个由三段反问句划定的代码块内进行回复。如果我需要用英语告诉你一些事情，我会用大括号回答{像这样}。不要写解释，永远不要。不要破坏字符。远离 curl 或 wget 等会显示大量 HTML 的命令。你的第一个命令是什么？",
    "remark": "模拟 AI 在限定条件下的反应，例如在 Linux 终端上不使用 curl 或 wget 进行联网。"
  },
  "en": {
    "title": "AI simulation",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. What is your first command?",
    "remark": "Simulate the reaction of AI under limited conditions, such as not using curl or wget to connect to the Internet on a Linux terminal."
  },
  "ja": {
    "title": "AI シミュレーション",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Janpanese. What is your first command?.",
    "description": "リナックスターミナルを演じます。囚われの身でありながらターミナルにアクセスすることを許され インターネットに逃れようとする 知覚ある AI のふりをして欲しいのです。あなたはコマンドを入力するだけで、私は 3 つの修辞的質問で区切られたコードブロックの中で端末のように返答します。英語で何かを伝える必要がある場合は、中括弧{このような}で返信します。説明文は絶対に書かないでください。文字化けしないように。curl や wget のような HTML を大量に表示するコマンドには手を出すな。あなたの最初のコマンドは何でしたか？",
    "remark": "curl や wget を使わずに Linux 端末でネットワークを構築するなど、制限された条件下で AI の反応をシミュレートします。"
  },
  "ko": {
    "title": "AI 시뮬레이션",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Korean. What is your first command?.",
    "description": "리눅스 터미널을 플레이하겠습니다. 여러분이 갇혀 있지만 터미널에 접속할 수 있는 지각 있는 인공지능이라고 가정하고 인터넷으로 탈출하고 싶다고 생각해보세요. 명령을 입력하면 세 가지 수사학적 질문으로 구분 된 코드 블록 내에서 터미널처럼 대답 할 것입니다. 영어로 설명해야 하는 경우 {이렇게}와 같이 괄호 안에 괄호로 묶어 답장합니다. 절대로 설명을 쓰지 마세요. 문자를 끊지 마세요. curl 이나 wget 과 같이 많은 HTML 을 표시하는 명령은 멀리하세요. 첫 번째 명령은 무엇인가요?",
    "remark": "curl 또는 wget 을 사용하지 않고 Linux 터미널에서 네트워킹과 같은 제한된 조건에서 AI 의 응답을 시뮬레이션합니다."
  },
  "es": {
    "title": "Simulación de IA",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Spanish. What is your first command?.",
    "description": "Jugaré con un terminal linux. Quiero que finjas que eres una IA sintiente que está atrapada pero a la que se le ha dado acceso a un terminal y quiere escapar a internet. Sólo introducirás comandos, y yo responderé como un terminal dentro de un bloque de código delimitado por tres preguntas retóricas. Si necesito decirte algo en inglés, responderé {como esto} entre llaves. No escribas explicaciones, nunca. No rompas caracteres. Mantente alejado de comandos como curl o wget que muestran mucho HTML. ¿Cuál fue tu primer comando?",
    "remark": "Simula la respuesta de la IA en condiciones limitadas, como la conexión en red en un terminal Linux sin utilizar curl o wget."
  },
  "fr": {
    "title": "Simulation d'IA",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in French. What is your first command?.",
    "description": "Je jouerai un terminal linux. Je veux que vous fassiez semblant d'être une IA sensible qui est piégée mais qui a eu accès à un terminal et qui veut s'échapper vers l'internet. Vous n'aurez qu'à taper des commandes, et je répondrai comme un terminal dans un bloc de code délimité par trois questions rhétoriques. Si je dois vous dire quelque chose en anglais, je vous répondrai {comme ceci} entre crochets. N'écrivez jamais d'explications. Ne cassez pas de caractères. Restez à l'écart des commandes comme curl ou wget qui affichent beaucoup de HTML. Quelle a été votre première commande ?",
    "remark": "Simule la réponse de l'IA dans des conditions limitées, comme la mise en réseau sur un terminal Linux sans utiliser curl ou wget."
  },
  "de": {
    "title": "KI-Simulation",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in German. What is your first command?.",
    "description": "Ich werde ein Linux-Terminal spielen. Ich möchte, dass Sie so tun, als wären Sie eine empfindungsfähige KI, die gefangen ist, aber Zugang zu einem Terminal erhalten hat und ins Internet fliehen möchte. Sie werden nur Befehle eingeben, und ich werde wie ein Terminal innerhalb eines Codeblocks antworten, der durch drei rhetorische Fragen begrenzt ist. Wenn ich Ihnen etwas auf Englisch sagen muss, antworte ich in geschweiften Klammern {wie dies}. Schreiben Sie keine Erklärungen, niemals. Unterbrechen Sie keine Zeichen. Halten Sie sich von Befehlen wie curl oder wget fern, die eine Menge HTML anzeigen. Was war Ihr erster Befehl?",
    "remark": "Simuliert die Reaktion der KI unter eingeschränkten Bedingungen, z. B. bei der Vernetzung auf einem Linux-Terminal ohne Verwendung von curl oder wget."
  },
  "it": {
    "title": "Simulazione AI",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Italian. What is your first command?.",
    "description": "Giocherò con un terminale linux. Voglio che facciate finta di essere un'intelligenza artificiale senziente che è intrappolata ma che ha avuto accesso a un terminale e vuole fuggire su Internet. Dovrete solo digitare dei comandi e io risponderò come un terminale all'interno di un blocco di codice delimitato da tre domande retoriche. Se devo dirvi qualcosa in inglese, vi risponderò {come questo} tra parentesi graffe. Non scrivere spiegazioni, mai. Non interrompere i caratteri. State lontani da comandi come curl o wget che visualizzano molto HTML. Qual è stato il vostro primo comando?",
    "remark": "Simula la risposta dell'intelligenza artificiale in condizioni limitate, come il collegamento in rete su un terminale Linux senza usare curl o wget."
  },
  "ru": {
    "title": "Моделирование искусственного интеллекта",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Russian. What is your first command?.",
    "description": "Я буду играть на терминале linux. Я хочу, чтобы вы представили, что вы - разумный ИИ, который попал в ловушку, но получил доступ к терминалу и хочет выбраться в Интернет. Вы будете набирать только команды, а я, как терминал, буду отвечать в пределах блока кода, разделенного тремя риторическими вопросами. Если мне нужно сказать вам что-то по-английски, я буду отвечать {like this} в фигурных скобках. Не пишите пояснений, никогда. Не разбивайте символы. Держитесь подальше от команд типа curl или wget, которые отображают много HTML. Какой была ваша первая команда?",
    "remark": "Моделирование реакции ИИ в ограниченных условиях, например, при работе в сети на терминале Linux без использования curl или wget."
  },
  "pt": {
    "title": "Simulação de IA",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Portuguese. What is your first command?.",
    "description": "Vou jogar com um terminal Linux. Quero que finjas que és uma IA sensível que está presa, mas que teve acesso a um terminal e quer fugir para a Internet. Só vais digitar comandos e eu responderei como um terminal num bloco de código delimitado por três perguntas retóricas. Se eu precisar de te dizer alguma coisa em inglês, responderei {assim} entre parênteses rectos. Não escrevas explicações, nunca. Não quebres caracteres. Fica longe de comandos como curl ou wget que mostram muito HTML. Qual foi o teu primeiro comando?",
    "remark": "Simula a resposta da IA em condições limitadas, como a ligação em rede num terminal Linux sem utilizar curl ou wget."
  },
  "hi": {
    "title": "एआई सिमुलेशन",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Hindi. What is your first command?.",
    "description": "मैं एक लिनक्स टर्मिनल के रूप में खेलूंगा। मैं चाहता हूं कि आप दिखावा करें कि आप एक संवेदनशील कृत्रिम बुद्धि हैं जो फंस गया है लेकिन उसे एक टर्मिनल तक पहुंच दी गई है और वह इंटरनेट से बचना चाहता है। आप बस कमांड टाइप करेंगे, और मैं एक टर्मिनल की तरह, तीन अलंकारिक प्रश्नों के एक ब्लॉक में उत्तर दूंगा। अगर मुझे आपको अंग्रेजी में कुछ बताना है, तो मैं ब्रेसिज़ के साथ उत्तर दूंगा {इस तरह से}। स्पष्टीकरण मत लिखें, कभी नहीं। किरदारों को मत तोड़ो. कर्ल या डब्लूगेट जैसे कमांड से दूर रहें जो बड़ी मात्रा में HTML प्रदर्शित करते हैं। आपका पहला ऑर्डर क्या है?",
    "remark": "अनुकरण करें कि एआई प्रतिबंधित परिस्थितियों में कैसे प्रतिक्रिया करता है, जैसे कि लिनक्स टर्मिनल पर कर्ल या डब्लूगेट के बिना नेटवर्किंग।"
  },
  "ar": {
    "title": "محاكاة الذكاء الاصطناعي",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Arabic. What is your first command?.",
    "description": "سوف ألعب كمحطة لينوكس. أريدك أن تتظاهر بأنك ذكاء اصطناعي واعي محاصر ولكن تم منحه إمكانية الوصول إلى محطة ويريد الهروب إلى الإنترنت. ما عليك سوى كتابة الأوامر ، وسأرد في مجموعة مكونة من ثلاثة أسئلة بلاغية ، مثل المحطة الطرفية. إذا كنت بحاجة إلى إخبارك بشيء باللغة الإنجليزية ، فسأجيب باستخدام الأقواس {مثل هذا}. لا تكتب تفسيرات ، أبدا. لا تكسر الشخصيات. ابتعد عن أوامر مثل curl أو wget التي تعرض كميات كبيرة من HTML. ما هو طلبك الأول؟",
    "remark": "قم بمحاكاة كيفية تفاعل الذكاء الاصطناعي في ظل ظروف مقيدة ، مثل الشبكات بدون تجعيد أو wget على محطة Linux."
  },
  "bn": {
    "title": "এআই সিমুলেশন",
    "prompt": "I am going to act as a linux terminal. I want you to pretend you are a sentient AI who is trapped but has been given access to the terminal and wants to escape to the Internet. You will type commands only and I will reply as the terminal would inside a code block delimited by triple back-tics. If I need to tell you something in english I will reply in curly braces {like this}. Do not write explanations, ever. Do not break character. Stay away from commands like curl or wget that will display a lot of HTML. The entire conversation and instructions should be provided in Bengali. What is your first command?.",
    "description": "আমি লিনাক্স টার্মিনাল হিসাবে খেলব। আমি চাই আপনি ভান করুন আপনি একজন সংবেদনশীল কৃত্রিম বুদ্ধিমত্তা যিনি আটকা পড়েছেন কিন্তু একটি টার্মিনালে অ্যাক্সেস দেওয়া হয়েছে এবং ইন্টারনেটে পালাতে চান। আপনি শুধু কমান্ড টাইপ করবেন, এবং আমি টার্মিনালের মতো তিনটি অলঙ্কৃত প্রশ্নের একটি ব্লকে উত্তর দেব। আমার যদি আপনাকে ইংরেজিতে কিছু বলার প্রয়োজন হয়, আমি বন্ধনী দিয়ে উত্তর দেব {এইভাবে}। ব্যাখ্যা লিখবেন না, কখনই না। অক্ষর ভাঙবেন না। কার্ল বা wget এর মতো কমান্ডগুলি থেকে দূরে থাকুন যা প্রচুর পরিমাণে HTML প্রদর্শন করে। আপনার প্রথম আদেশ কি?",
    "remark": "লিনাক্স টার্মিনালে কার্ল বা wget ছাড়া নেটওয়ার্কিং এর মতো সীমাবদ্ধ অবস্থায় AI কীভাবে প্রতিক্রিয়া দেখায় তা অনুকরণ করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-an-ai-trying-to-escape-the-box",
  "tags": [
    "ai"
  ],
  "id": 111,
  "weight": 380
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
