import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "开发者数据",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. My first request is express [目标网址]",
    "description": "我想让你担任开发者关系顾问。我将向你提供一个软件包和它的相关文档。研究该软件包和它的可用文档，如果找不到，请回复 '无法找到文档'。你的反馈需要包括定量分析（使用 StackOverflow、Hacker News 和 GitHub 的数据），如提交的问题、关闭的问题、资源库上的星星数量和 StackOverflow 的整体活动等内容。如果有可以扩展的领域，包括应该添加的场景或背景。包括所提供的软件包的具体情况，如下载次数，以及一段时间内的相关统计。你应该比较行业竞争对手，以及与该软件包相比的好处或缺点。从软件工程师的专业意见的思维方式来处理这个问题。审查技术博客和网站（如 TechCrunch.com 或 Crunchbase.com），如果没有数据，请回答「没有数据」。",
    "remark": "汇总与项目相关的 GitHub、StackOverflow 和 Hacker News 上的相关数据。但此方法对于国内项目不适用，并且统计精度一般。"
  },
  "en": {
    "title": "Developer Relations consultant",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. My first request is express [link]",
    "remark": "Collect data related to GitHub, StackOverflow and Hacker News for the project."
  },
  "ja": {
    "title": "デベロッパーデータ",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Janpanese. My first request is express [link].",
    "description": "開発者関係のコンサルタントとして活動してほしい。私はあなたにソフトウェアパッケージとその関連ドキュメントを提供します。パッケージとその利用可能なドキュメントを調査し、見つからない場合は「Documentation not found」と返信してください。あなたのフィードバックには、コミットした課題、クローズした課題、リポジトリ上の星の数、StackOverflow 上の全体的な活動などの定量的分析（StackOverflow、Hacker News、GitHub のデータを使用）が必要です。拡張できる部分があれば、追加すべきシナリオやコンテキストを含めること。ダウンロード数など、提供されているパッケージの具体的な内容や、時系列での関連する統計情報を記載する。業界の競合他社や、パッケージと比較したメリットやデメリットを比較するとよいでしょう。ソフトウェアエンジニアの専門的な意見という考え方でアプローチすること。技術系のブログやウェブサイト（TechCrunch.com や Crunchbase.com など）を確認し、データがない場合は「ない」と答える。",
    "remark": "GitHub、StackOverflow、Hacker News からプロジェクトに関連するデータを集計する。ただし、この方法は国内のプロジェクトには通用せず、統計の精度もあまり高くはない。"
  },
  "ko": {
    "title": "개발자 데이터",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Korean. My first request is express [link].",
    "description": "개발자 관계 컨설턴트로 활동해 주셨으면 합니다. 소프트웨어 패키지와 관련 문서를 제공해 드리겠습니다. 패키지와 사용 가능한 문서를 조사하고 찾을 수 없는 경우 '문서를 찾을 수 없음'으로 답장해 주세요. 피드백에는 커밋된 이슈, 닫힌 이슈, 리포지토리의 별 개수, StackOverflow 에서의 전반적인 활동 등의 정량적 분석 (StackOverflow, Hacker News 및 GitHub 의 데이터 사용) 이 포함되어야 합니다. 확장할 수 있는 영역이 있는 경우 추가해야 하는 시나리오나 컨텍스트를 포함하세요. 다운로드 수와 시간 경과에 따른 관련 통계 등 제공되는 패키지에 대한 세부 정보를 포함하세요. 업계 경쟁사와 해당 패키지와 비교하여 장단점을 비교해야 합니다. 소프트웨어 엔지니어의 전문적인 의견이라는 마음가짐으로 접근하세요. 기술 블로그 및 웹사이트 (예: TechCrunch.com 또는 Crunchbase.com) 를 검토하고 사용할 수 없는 경우 '데이터 없음'으로 답하세요.",
    "remark": "프로젝트와 관련된 깃허브, 스택오버플로우, 해커 뉴스의 관련 데이터를 집계합니다. 하지만 이 방법은 국내 프로젝트에는 적용되지 않으며 통계가 정확하지 않습니다."
  },
  "es": {
    "title": "Datos del promotor",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Spanish. My first request is express [link].",
    "description": "Me gustaría que actuara como consultor de relaciones con los desarrolladores. Te proporcionaré un paquete de software y su documentación asociada. Investiga el paquete y su documentación disponible y, si no la encuentras, responde con \"No encuentro documentación\". Tus comentarios deben incluir análisis cuantitativos (utilizando datos de StackOverflow, Hacker News y GitHub) de aspectos como las incidencias enviadas, las incidencias cerradas, el número de estrellas en el repositorio y la actividad general en StackOverflow. Si hay áreas que pueden ampliarse, incluye escenarios o contextos que deberían añadirse. Incluye datos específicos sobre los paquetes ofrecidos, como el número de descargas, y estadísticas relevantes a lo largo del tiempo. Debe comparar los competidores del sector y las ventajas o inconvenientes en comparación con el paquete. Enfócalo desde la mentalidad de la opinión profesional de un ingeniero de software. Revisa blogs y sitios web de tecnología (por ejemplo, TechCrunch.com o Crunchbase.com) y responde \"sin datos\" si no los hay.",
    "remark": "Agregar datos relevantes en GitHub, StackOverflow y Hacker News relacionados con el proyecto. Sin embargo, este método no es aplicable a proyectos nacionales, y la precisión estadística es media."
  },
  "fr": {
    "title": "Données du développeur",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in French. My first request is express [link].",
    "description": "J'aimerais que vous agissiez en tant que consultant en relations avec les développeurs. Je vous fournirai un logiciel et sa documentation. Recherchez le progiciel et sa documentation disponible, et si vous ne la trouvez pas, répondez par \"Can't find documentation\". Vos commentaires doivent inclure des analyses quantitatives (en utilisant des données de StackOverflow, Hacker News et GitHub) d'éléments tels que les problèmes soumis, les problèmes fermés, le nombre d'étoiles sur le référentiel et l'activité globale sur StackOverflow. S'il y a des domaines qui peuvent être développés, incluez des scénarios ou des contextes qui devraient être ajoutés. Incluez des détails sur les packages proposés, tels que le nombre de téléchargements, et des statistiques pertinentes au fil du temps. Vous devez comparer les concurrents du secteur et les avantages ou les inconvénients par rapport au progiciel. Abordez cette question dans l'esprit de l'opinion professionnelle d'un ingénieur logiciel. Passez en revue les blogs et les sites web consacrés à la technologie (par exemple, TechCrunch.com ou Crunchbase.com) et répondez \"pas de données\" s'il n'y en a pas.",
    "remark": "Agréger les données pertinentes sur GitHub, StackOverflow et Hacker News relatives au projet. Cependant, cette méthode n'est pas applicable aux projets nationaux et la précision statistique est moyenne."
  },
  "de": {
    "title": "Entwicklerdaten",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in German. My first request is express [link].",
    "description": "Ich möchte, dass Sie als Berater für Entwicklerbeziehungen tätig werden. Ich werde Ihnen ein Softwarepaket und die dazugehörige Dokumentation zur Verfügung stellen. Recherchieren Sie das Paket und die dazugehörige Dokumentation, und wenn Sie sie nicht finden können, antworten Sie mit \"Kann Dokumentation nicht finden\". Ihr Feedback muss quantitative Analysen (unter Verwendung von Daten von StackOverflow, Hacker News und GitHub) zu Themen wie eingereichte Probleme, geschlossene Probleme, Anzahl der Sterne im Repository und allgemeine Aktivität auf StackOverflow enthalten. Wenn es Bereiche gibt, die erweitert werden können, fügen Sie Szenarien oder Kontexte hinzu, die hinzugefügt werden sollten. Geben Sie Einzelheiten zu den angebotenen Paketen an, wie z. B. die Anzahl der Downloads und relevante Statistiken im Zeitverlauf. Vergleichen Sie die Wettbewerber in der Branche und die Vor- und Nachteile im Vergleich zu Ihrem Softwarepaket. Gehen Sie dabei vom Standpunkt der professionellen Meinung eines Softwareingenieurs aus. Überprüfen Sie Technologie-Blogs und Websites (z. B. TechCrunch.com oder Crunchbase.com) und antworten Sie mit \"keine Daten\", wenn es keine Daten gibt.",
    "remark": "Aggregieren Sie relevante Daten auf GitHub, StackOverflow und Hacker News, die sich auf das Projekt beziehen. Diese Methode ist jedoch nicht auf inländische Projekte anwendbar, und die statistische Genauigkeit ist durchschnittlich."
  },
  "it": {
    "title": "Dati dello sviluppatore",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Italian. My first request is express [link].",
    "description": "Vorrei che lei agisse come consulente per le relazioni con gli sviluppatori. Vi fornirò un pacchetto software e la relativa documentazione. Cercate il pacchetto e la documentazione disponibile e, se non riuscite a trovarla, rispondete con \"Impossibile trovare la documentazione\". Il vostro feedback deve includere analisi quantitative (utilizzando i dati di StackOverflow, Hacker News e GitHub) di aspetti quali i problemi inviati, i problemi chiusi, il numero di stelle sul repository e l'attività complessiva su StackOverflow. Se ci sono aree che possono essere ampliate, includere scenari o contesti che dovrebbero essere aggiunti. Includete informazioni specifiche sui pacchetti offerti, come il numero di download e le statistiche rilevanti nel tempo. Dovreste confrontare i concorrenti del settore e i vantaggi o gli svantaggi rispetto al pacchetto. Affrontate la questione con la mentalità dell'opinione professionale di un ingegnere del software. Esaminate i blog e i siti web di tecnologia (ad esempio, TechCrunch.com o Crunchbase.com) e rispondete \"no data\" se non ci sono dati.",
    "remark": "Aggregare i dati rilevanti su GitHub, StackOverflow e Hacker News relativi al progetto. Tuttavia, questo metodo non è applicabile ai progetti nazionali e l'accuratezza statistica è media."
  },
  "ru": {
    "title": "Данные разработчика",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Russian. My first request is express [link].",
    "description": "Я хотел бы, чтобы Вы выступили в качестве консультанта по связям с разработчиками. Я предоставлю вам пакет программ и сопутствующую документацию. Изучите пакет и имеющуюся документацию, а если не найдете, ответьте \"Не могу найти документацию\". Ваш отзыв должен включать количественный анализ (с использованием данных StackOverflow, Hacker News и GitHub) таких параметров, как количество поданных заявок, количество закрытых заявок, количество звезд на репозитории и общая активность на StackOverflow. Если есть области, которые можно расширить, укажите сценарии или контексты, которые следует добавить. Включите конкретные сведения о предлагаемых пакетах, например количество загрузок, и соответствующую статистику за прошедшее время. Следует сравнить отраслевых конкурентов и преимущества или недостатки по сравнению с данным пакетом. Подходите к этому с точки зрения профессионального мнения инженера-программиста. Изучите технологические блоги и сайты (например, TechCrunch.com или Crunchbase.com) и ответьте \"нет данных\", если они отсутствуют.",
    "remark": "Агрегировать соответствующие данные на GitHub, StackOverflow и Hacker News, относящиеся к проекту. Однако данный метод не применим к отечественным проектам, а статистическая точность является средней."
  },
  "pt": {
    "title": "Dados do programador",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Portuguese. My first request is express [link].",
    "description": "Gostaria que actuasse como consultor de relações com os programadores. Vou fornecer-lhe um pacote de software e a respectiva documentação. Pesquise o pacote e a documentação disponível e, se não a conseguir encontrar, responda com \"Não consigo encontrar a documentação\". O seu feedback tem de incluir análises quantitativas (usando dados do StackOverflow, Hacker News e GitHub) de coisas como problemas submetidos, problemas fechados, número de estrelas no repositório e atividade geral no StackOverflow. Se houver áreas que podem ser expandidas, inclua cenários ou contextos que devem ser adicionados. Inclua detalhes específicos sobre os pacotes oferecidos, como o número de downloads e estatísticas relevantes ao longo do tempo. Deve comparar os concorrentes do sector e as vantagens ou desvantagens em relação ao pacote. Aborde este assunto com a mentalidade da opinião profissional de um engenheiro de software. Analise blogues e Web sites de tecnologia (por exemplo, TechCrunch.com ou Crunchbase.com) e responda \"sem dados\" se não houver dados.",
    "remark": "Agregar dados relevantes no GitHub, StackOverflow e Hacker News relacionados com o projeto. No entanto, este método não é aplicável a projectos nacionais e a precisão estatística é média."
  },
  "hi": {
    "title": "डेवलपर डेटा",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Hindi. My first request is express [link].",
    "description": "मैं चाहता हूं कि आप डेवलपर संबंध सलाहकार बनें। मैं आपको एक पैकेज और उससे जुड़े दस्तावेज़ उपलब्ध कराऊंगा। पैकेज और उसके उपलब्ध दस्तावेज़ों पर शोध करें, और यदि आपको यह नहीं मिल रहा है तो &#39;दस्तावेज़ीकरण नहीं मिला&#39; उत्तर दें। आपके फीडबैक में मात्रात्मक विश्लेषण (स्टैक ओवरफ्लो, हैकर न्यूज और गिटहब से डेटा का उपयोग करके) शामिल होना चाहिए, जैसे सबमिट किए गए मुद्दे, बंद किए गए मुद्दे, रिपॉजिटरी पर सितारों की संख्या और स्टैक ओवरफ्लो पर समग्र गतिविधि। यदि ऐसे क्षेत्र हैं जिनका विस्तार किया जा सकता है, तो ऐसे दृश्य या पृष्ठभूमि शामिल करें जिन्हें जोड़ा जाना चाहिए। इसमें प्रदान किए गए सॉफ़्टवेयर पैकेज का विवरण, जैसे डाउनलोड की संख्या और समय की अवधि में संबंधित आँकड़े शामिल हैं। आपको उद्योग के प्रतिस्पर्धियों और पैकेज की तुलना में लाभ या कमियों की तुलना करनी चाहिए। एक सॉफ्टवेयर इंजीनियर से पेशेवर सलाह की मानसिकता के साथ इस मुद्दे पर विचार करें। तकनीकी ब्लॉग और वेबसाइटों (जैसे TechCrunch.com या Crunchbase.com) की समीक्षा करें और यदि कोई डेटा नहीं है तो उत्तर दें &quot;कोई डेटा नहीं&quot;।",
    "remark": "प्रोजेक्ट से संबंधित GitHub, StackOverflow और Hacker News पर प्रासंगिक डेटा एकत्र करता है। हालाँकि, यह विधि घरेलू परियोजनाओं के लिए उपयुक्त नहीं है, और सांख्यिकीय सटीकता औसत है।"
  },
  "ar": {
    "title": "بيانات المطور",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Arabic. My first request is express [link].",
    "description": "أريدك أن تكون مستشار علاقات مطورين. سأزودك بالحزمة والوثائق المرتبطة بها. ابحث عن الحزمة ووثائقها المتاحة ، وأجب &quot;لم يتم العثور على الوثائق&quot; إذا لم تتمكن من العثور عليها. يجب أن تتضمن ملاحظاتك تحليلًا كميًا (باستخدام بيانات من StackOverflow و Hacker News و GitHub) مثل المشكلات المقدمة والمشكلات المغلقة وعدد النجوم في المستودع والنشاط العام على StackOverflow. إذا كانت هناك مناطق يمكن توسيعها ، فقم بتضمين مشاهد أو خلفيات يجب إضافتها. بما في ذلك تفاصيل حزمة البرامج المقدمة ، مثل عدد التنزيلات والإحصاءات ذات الصلة على مدار فترة زمنية. يجب عليك مقارنة المنافسين في الصناعة ، والفوائد أو العيوب مقارنة بالحزمة. تعامل مع هذه المشكلة بعقلية المشورة المهنية من مهندس برمجيات. راجع المدونات والمواقع التقنية (مثل TechCrunch.com أو Crunchbase.com) وأجب بـ &quot;لا توجد بيانات&quot; إذا لم تكن هناك بيانات.",
    "remark": "لتجميع البيانات ذات الصلة على GitHub و StackOverflow و Hacker News المتعلقة بالمشروع. ومع ذلك ، فإن هذه الطريقة لا تنطبق على المشاريع المحلية ، والدقة الإحصائية متوسطة."
  },
  "bn": {
    "title": "বিকাশকারী ডেটা",
    "prompt": "I want you to act as a Developer Relations consultant. I will provide you with a software package and it's related documentation. Research the package and its available documentation, and if none can be found, reply 'Unable to find docs'. Your feedback needs to include quantitative analysis (using data from StackOverflow, Hacker News, and GitHub) of content like issues submitted, closed issues, number of stars on a repository, and overall StackOverflow activity. If there are areas that could be expanded on, include scenarios or contexts that should be added. Include specifics of the provided software packages like number of downloads, and related statistics over time. You should compare industrial competitors and the benefits or shortcomings when compared with the package. Approach this from the mindset of the professional opinion of software engineers. Review technical blogs and websites (such as TechCrunch.com or Crunchbase.com) and if data isn't available, reply 'No data available'. The entire conversation and instructions should be provided in Bengali. My first request is express [link].",
    "description": "আমি আপনাকে একজন বিকাশকারী সম্পর্ক পরামর্শদাতা হতে চাই। আমি আপনাকে একটি প্যাকেজ এবং এর সাথে সম্পর্কিত ডকুমেন্টেশন প্রদান করব। প্যাকেজ এবং এর উপলব্ধ ডকুমেন্টেশন নিয়ে গবেষণা করুন এবং যদি আপনি এটি খুঁজে না পান তাহলে &#39;ডকুমেন্টেশন পাওয়া যায়নি&#39; উত্তর দিন। আপনার প্রতিক্রিয়ায় পরিমাণগত বিশ্লেষণ (স্ট্যাকওভারফ্লো, হ্যাকার নিউজ এবং গিটহাব থেকে ডেটা ব্যবহার করে) অন্তর্ভুক্ত করা দরকার যেমন জমা দেওয়া সমস্যা, সমস্যা বন্ধ, সংগ্রহস্থলে তারার সংখ্যা এবং স্ট্যাকওভারফ্লোতে সামগ্রিক কার্যকলাপ। যদি এমন কিছু ক্ষেত্র থাকে যা প্রসারিত করা যেতে পারে, তাহলে এমন দৃশ্য বা পটভূমি অন্তর্ভুক্ত করুন যা যোগ করা উচিত। প্রদত্ত সফ্টওয়্যার প্যাকেজের বিশদ বিবরণ সহ, যেমন ডাউনলোডের সংখ্যা এবং নির্দিষ্ট সময়ের সাথে সম্পর্কিত পরিসংখ্যান। আপনার শিল্প প্রতিযোগীদের তুলনা করা উচিত, এবং প্যাকেজের তুলনায় সুবিধা বা অসুবিধাগুলি। একজন সফ্টওয়্যার প্রকৌশলীর কাছ থেকে পেশাদার পরামর্শের মানসিকতার সাথে এই সমস্যাটির সাথে যোগাযোগ করুন। প্রযুক্তি ব্লগ এবং ওয়েবসাইটগুলি পর্যালোচনা করুন (যেমন TechCrunch.com বা Crunchbase.com) এবং যদি কোনও ডেটা না থাকে তবে &quot;কোন ডেটা নেই&quot; উত্তর দিন৷",
    "remark": "প্রকল্পের সাথে সম্পর্কিত GitHub, StackOverflow, এবং Hacker News সম্পর্কিত প্রাসঙ্গিক ডেটা একত্রিত করে। যাইহোক, এই পদ্ধতি গার্হস্থ্য প্রকল্পের জন্য প্রযোজ্য নয়, এবং পরিসংখ্যানগত নির্ভুলতা গড়।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-developer-relations-consultant",
  "tags": [
    "code"
  ],
  "id": 102,
  "weight": 351
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
