# Часто задаваемые вопросы

## Почему предложения для подсказок на английском языке?

AiShort был создан для упрощения использования ChatGPT пользователями, для которых английский не является родным языком. Однако все предложенные слова на английском языке. Это связано с тем, что ChatGPT лучше понимает английский язык по сравнению с другими языками. Даже MOSS, первая крупномасштабная китайская модель диалогового общения, признает, что ее английские ответы превосходят китайские. Поэтому рекомендуется использовать предложенные слова на английском языке. (MOSS больше не доступна)

Хотя использование предложенных слов на других языках может давать неплохие результаты, результаты могут значительно отличаться при повторном вводе одних и тех же неанглийских подсказок. Поскольку понимание ChatGPT неанглийских подсказок меняется каждый раз, рекомендуется использовать английские подсказки для продуктивных подсказок, чтобы обеспечить желаемый результат. Кроме того, ответы, генерируемые на английские подсказки, скорее всего будут на английском языке. Вы можете указать язык ответа как китайский, добавив "ответить на китайском" в конце подсказки. Если ваш родной язык отличается, замените "китайский" на свой собственный родной язык.

## Нужно ли вводить подсказку каждый раз?

В API вы можете установить подсказку в качестве "системной подсказки", чтобы вам не нужно было вводить подсказку каждый раз. ChatGPT будет следовать инструкциям, основываясь на системной подсказке.

В веб-версии ChatGPT, если вы не переключили основную подсказку, вы можете просто заключить последующее содержание ответа в кавычки, и вам не придется вводить подсказку каждый раз. Если сгенерированный ответ не соответствует требованиям подсказки, это означает, что ChatGPT забыл подсказку, и в таких случаях вам нужно повторно ввести подсказку, чтобы ориентировать его. Кроме того, каждая ссылка на разговор является уникальной, и вы можете сохранять часто используемые разговоры в закладки для последующего использования.

## Задержка поиска метода ввода

Функция поиска основана на показателях Docusaurus и имеет проблему с потерей фокуса метода ввода на стороне ПК. После сообщения об этой проблеме в Docusaurus они упомянули, что попытаются исправить ее, но до сих пор проблема остается неразрешенной с комментарием: "FWIW, в любом случае вам не следует использовать китайский язык, поскольку витрина не локализована". Поэтому я разделил компонент поиска на два типа: мобильный и ПК. Логика поиска для мобильных устройств остается неизменной, а для ПК-браузеров с порогом ширины экрана выше 768 пикселей я использовал функцию "debounce", чтобы решить проблему метода ввода. Однако это приводит к двум проблемам на стороне ПК: неанглийский ввод должен быть завершен в течение 800 миллисекунд, и обновление поиска на ПК изменяется с мгновенного на задержку в 800 миллисекунд. Если у вас есть лучшее решение, пожалуйста, предоставьте отзывы.

## Вывод неверной информации

Хотя ChatGPT очень мощный, он не безошибочный. Иногда он может выдавать неверную информацию. Например, когда мне нужно было вводить сотни фрагментов информации в AiShort, я просил ChatGPT преобразовать данные в указанный формат. Однако в процессе преобразования я заметил, что ChatGPT некорректно записал часть информации. Например, метка в тексте была "кинопитомец", но ChatGPT изменил ее на "кинокритик". В то время как это может не иметь никакого значения в самом тексте, это вызовет ошибку при использовании в коде. Поэтому при использовании ChatGPT важно проверять его вывод.

## Неэффективны ли подсказки?

Если вы занимаетесь подведением итогов, вы можете использовать GPT для уточнения и улучшения ваших первоначальных ответов, тем самым повышая точность ваших ответов. Более того, подсказки полезны не только для выполнения работы; важнее то, что они служат катализатором интеллектуальной стимуляции. Они помогают расширить кругозор, позволяют рассмотреть вопросы с разных сторон и устранить возможные ошибки, которые часто случаются в процессе размышлений.

Все подсказки, используемые в AI Short, взяты из интернета и регулярно обновляются в нашем хранилище подсказок. Хотя каждая подсказка проходит тщательное тестирование, ее эффективность может варьироваться в зависимости от индивидуальных потребностей пользователя. Если вы встретите какие-либо неточности, придумаете инновационные идеи или наткнетесь на полезные подсказки, просим вас сообщить нам об этом через [feedback](/feedback) или поделиться своими открытиями в нашем сообществе.
