# Развертывание

AI Short — проект с открытым исходным кодом, вы можете свободно изменять название и описание веб-сайта.

- Чтобы изменить название страницы, отредактируйте файл `docusaurus.config.js`.
- Чтобы изменить инструкции, перейдите в каталог `docs`.
- Чтобы изменить слова подсказки, вы можете найти их в `src/data/prompt.json`. Если вам нужно изменить только один язык, например китайский, вы можете напрямую отредактировать `src/data/prompt_zh.json`.
- В настоящее время пользовательский бэкэнд подключен к общей бэкэнд-системе. При необходимости вы можете создать свой собственный бэкэнд, а соответствующий интерфейс находится в файле `src/api.js`.

`CodeUpdateHandler.py` — это скрипт для пакетной обработки многоязыкового развертывания. После завершения модификации выполните `python CodeUpdateHandler.py`, который разделит `prompt.json` на несколько языков в соответствии с правилами и синхронизирует основной код страницы каждого языка и независимый код страницы выбранных слов подсказки.

## Развертывание

### Развертывание с помощью Vercel

Нажмите кнопку ниже, чтобы развернуть ChatGPT-Shortcut на платформе Vercel одним щелчком мыши:

[![Vercel](https://vercel.com/button)](https://vercel.com/new/clone?repository-url=https%3A%2F%2Fgithub.com%2Frockbenben%2FChatGPT-Shortcut%2Ftree%2Fmain)

С помощью Vercel вы можете быстро разместить свой проект и автоматически обрабатывать сборки и развертывания, что подходит для пользователей, у которых нет сложных требований к конфигурации сервера.

### Локальное развертывание

Убедитесь, что вы установили [Node.js](https://nodejs.org/).

```shell
# Установка
yarn

# Локальная разработка
yarn start

# Сборка: эта команда генерирует статический контент в каталоге `build`
yarn build

# Обновите `defaultLocale` в файле `docusaurus.config.js`, затем выполните сборку для нужного языка.
yarn build --locale zh
yarn build --locale en
yarn build --locale ja
yarn build --locale ko
yarn build --locale es
yarn build --locale fr
yarn build --locale de
yarn build --locale it
yarn build --locale ru
yarn build --locale pt
yarn build --locale hi
yarn build --locale ar
yarn build --locale bn

# Развертывание для нескольких языков
yarn build --locale zh && yarn build --locale en
```

### Развертывание Docker

Если вы знакомы с Docker, вы можете быстро выполнить развертывание с помощью следующей команды:

```shell
# ghcr.io
docker run -d -p 3000:3000 --name chatgpt-shortcut ghcr.io/rockbenben/chatgpt-shortcut:latest

# docker hub
docker run -d -p 3000:3000 --name chatgpt-shortcut rockben/chatgpt-shortcut:latest
```

В качестве альтернативы вы можете использовать `docker-compose`:

```yml
version: "3.8"

services:
docsify:
container_name: chatgpt-shortcut
image: ghcr.io/rockbenben/chatgpt-shortcut:latest
ports:
- "3000:3000"
restart: unless-stopped
```

## Синхронизированные обновления

Если вы развернули свой собственный проект на Vercel одним щелчком мыши, вы можете столкнуться с проблемой, когда обновления отображаются последовательно. Это возникает из-за поведения Vercel по умолчанию, когда он создает новый проект вместо того, чтобы разветвлять текущий проект, тем самым препятствуя правильному обнаружению обновлений. Рекомендуется выполнить следующие шаги для повторного развертывания:

1. Удалите предыдущий репозиторий.
2. Используйте кнопку «fork», расположенную в правом верхнем углу страницы, чтобы разветвить текущий проект.
3. На странице [Vercel New Project] (https://vercel.com/new) выберите недавно разветвленный проект из раздела Import Git Repository и приступайте к развертыванию.

### Автоматические обновления

> В случае возникновения ошибки во время выполнения Upstream Sync вручную выполните один Sync Fork.

После разветвления проекта из-за ограничений GitHub необходимо вручную включить Workflows на странице Actions вашего разветвленного проекта и активировать действие Upstream Sync. После активации обновления будут автоматически выполняться ежедневно.

![Автоматические обновления](https://img.newzone.top/2023-05-19-11-57-59.png?imageMogr2/format/webp)

![Включение автоматических обновлений](https://img.newzone.top/2023-05-19-11-59-26.png?imageMogr2/format/webp)

### Ручные обновления

Если вы хотите выполнить обновление вручную немедленно, вы можете обратиться к [документации GitHub](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/syncing-a-fork), чтобы узнать, как синхронизировать разветвленный проект с исходным кодом.

Не стесняйтесь оказать поддержку этому проекту, поставив ему звезду/подписавшись или подписавшись на автора, чтобы быть в курсе своевременных уведомлений о новых обновлениях функций.
