# よくある質問

## なぜプロンプトは英語なのですか？

AiShort は英語を母国語としない人が ChatGPT を使いやすくするために作られました。しかし、提案されるプロンプトはすべて英語です。これは、ChatGPT が他の言語に比べて英語をよりよく理解しているからです。最初の大規模な中国語対話言語モデルである MOSS でさえ、英語の応答が中国語よりも優れていることを認めています。そのため、英語のプロンプトを使用することをお勧めします。(MOSS は現在提供されていません)

英語以外のサジェストプロンプトを使用すると、それなりの結果が得られるかもしれませんが、同じ英語以外のサジェストプロンプトを再度入力すると、結果が大きく異なることがあります。英語以外のプロンプトに対する ChatGPT の理解度は毎回異なるため、生産性重視のプロンプトには英語プロンプトを使用することをお勧めします。さらに、英語プロンプトによって生成される応答は英語になる可能性が高いです。プロンプトの最後に "respond in Chinese" を追加することで、応答言語を中国語に指定できます。母国語が異なる場合は、「中国語」を母国語に置き換えてください。

## 毎回プロンプトを入力する必要がありますか？

API では、プロンプトを「システムプロンプト」として設定できますので、毎回プロンプトを入力する必要はありません。ChatGPT はシステムプロンプトに基づいた指示に従います。

Web 版の ChatGPT では、メインプロンプトを切り替えていない場合、その後の返信内容を引用符で囲むだけで、毎回プロンプトを入力する必要がなくなります。生成された返答がプロンプトの条件と一致しない場合は、ChatGPT がプロンプトを忘れていることを意味し、そのような場合はプロンプトを再入力して向きを変える必要があります。さらに、各会話リンクは一意であり、頻繁に使用する会話をブックマークとして保存し、今後使用することができます。

## 入力メソッドの検索遅延

検索機能は Docusaurus のショーケースに基づいており、PC 側で入力メソッドのフォーカスが外れる問題がある。この問題を Docusaurus に報告したところ、修正するように努力するとのことでしたが、今のところ問題は解決していません。"FWIW、ショーケースはローカライズされていないので、いずれにせよ中国語を使うべきではありません。"とのコメントもありました。そこで、検索コンポーネントをモバイルと PC の 2 種類に分類した。モバイル用の検索ロジックに変更はないが、PC ブラウジングで画面幅が 768px 以上の閾値がある場合、入力方法の問題に対処するために「デバウンス」機能を導入した。ただし、この場合、PC 側で 2 つの問題が生じます。英語以外の入力は 800 ミリ秒以内に完了する必要があり、PC の検索更新は即時から 800 ミリ秒の遅延に変わります。より良い解決策があれば、フィードバックをお願いします。

## 偽情報の出力

ChatGPT は非常に強力ですが、絶対ではありません。時には誤った情報を出力することもあります。例えば、AiShort に何百もの情報を入力する必要があったとき、ChatGPT にデータを指定されたフォーマットに変換させました。ところが、その変換の過程で、ChatGPT が一部の情報を不正確に書き込んでいることに気づきました。例えば、テキスト中のラベルが "映画評論家 "となっていたのですが、ChatGPT は "映画評論家 "に変更していました。これはテキスト自体には何の影響もないかもしれませんが、コードで使用するとエラーを引き起こします。従って、ChatGPT を使用する際には、その出力を確認することが不可欠です。

## プロンプトは効果がないのでしょうか？

もしあなたが要約作業に従事しているのであれば、GPT を活用することで、最初の回答に磨きをかけ、より精度を高めることができます。さらに、プロンプトは仕事の生産に役立つだけでなく、より重要なのは、知的刺激を与える触媒として機能することである。視野を広げることで、様々な角度から問題を考えることができ、思考過程で起こりがちな見落としに対処することができます。

AI Short が使用するプロンプトはすべてインターネットから入手したもので、プロンプトリポジトリで定期的に更新されます。各プロンプトは広範なテストを受けていますが、その効果は個々のユーザーのニーズによって異なる場合があります。不正確なプロンプトに遭遇した場合、革新的なアイデアを思いついた場合、有用なプロンプトに出くわした場合は、[feedback](/feedback)でお知らせいただくか、コミュニティ内で発見を共有してください。
