# FAQs

## Why are the suggested prompts in English?

AiShort was created to facilitate the use of ChatGPT by non-native English speakers. However, all the suggested prompts are in English. This is because ChatGPT has a better understanding of English compared to other languages. Even MOSS, the first large-scale Chinese dialogue language model, acknowledges that its English responses are superior to Chinese. Therefore, it is recommended to use English suggested prompts. (MOSS is no longer available)

Although using non-English suggested prompts may yield decent results, the outcomes can vary significantly when you input the same non-English prompts again. Since ChatGPT's understanding of non-English prompts varies each time, it is advised to use English prompts for productivity-oriented prompts to ensure the desired output. Furthermore, the responses generated by English prompts are likely to be in English. You can specify the response language as Chinese by adding "respond in Chinese" at the end of the prompt. If your native language is different, please replace "Chinese" with your own native language.

## Do I have to input the prompt every time?

In the API, you can set the prompt as a "system prompt," so you don't need to input the prompt each time. ChatGPT will follow the instructions based on the system prompt.

In the web version of ChatGPT, if you haven't switched the main prompt, you can simply enclose the subsequent reply content in quotation marks, eliminating the need to input the prompt each time. When the generated response does not align with the prompt requirements, it means ChatGPT has forgotten the prompt, and in such cases, you need to re-enter the prompt to reorient it. Additionally, each conversation link is unique, and you can save frequently used conversations as bookmarks for future use.

## Input method search delay

The search function is based on Docusaurus's showcase and has an issue with the input method losing focus on the PC side. After reporting the issue to Docusaurus, they mentioned they would try to fix it, but so far, the problem remains unresolved, with the comment, "FWIW, you should not be using Chinese anyway, since the showcase is not localized." Therefore, I have categorized the search component into two types: mobile and PC. The search logic for mobile remains unchanged, while for PC browsing with a screen width threshold above 768px, I have introduced the "debounce" function to address the input method problem. However, this introduces two issues on the PC side: non-English input needs to be completed within 800 milliseconds, and the PC search refresh changes from instant to an 800-millisecond delay. If you have a better solution, please provide feedback.

## Outputting false information

Although ChatGPT is very powerful, it is not infallible. Sometimes it may output false information. For example, when I needed to input hundreds of pieces of information into AiShort, I had ChatGPT convert the data into a specified format. However, during the conversion process, I noticed that ChatGPT had inaccurately written some of the information. For instance, a label in the text was "movie critic," but ChatGPT changed it to "film critic." While this may not have any impact in the text itself, it would cause an error when used in code. Therefore, when using ChatGPT, it is essential to review its output.

## Are the prompts ineffective?

If you are engaged in the task of summarization, you may utilize GPT to refine and enhance your initial responses, thereby elevating the precision of your answers. Moreover, prompts are not solely beneficial for work production; more importantly, they serve as catalysts for intellectual stimulation. They assist in broadening your perspective, enabling you to contemplate issues from various angles, and address potential oversights that often occur during the thought process.

All prompts utilized by AI Short are sourced from the internet and are subject to regular updates in our prompt repository. Although each prompt undergoes extensive testing, its effectiveness may vary according to individual user needs. Should you encounter any inaccuracies, conceive innovative ideas, or stumble upon useful prompts, you are encouraged to inform us through [feedback](/feedback) or share your discoveries within our community.
