# মোতায়েন

এআই শর্ট একটি ওপেন সোর্স প্রজেক্ট, আপনি অবাধে ওয়েবসাইটের নাম এবং বিবরণ পরিবর্তন করতে পারেন।

- পৃষ্ঠার নাম পরিবর্তন করতে, `docusaurus.config.js` ফাইলটি সম্পাদনা করুন।
- নির্দেশাবলী পরিবর্তন করতে, `ডক্স` ডিরেক্টরিতে যান।
- প্রম্পট শব্দগুলি পরিবর্তন করতে, আপনি সেগুলিকে `src/data/prompt.json`-এ খুঁজে পেতে পারেন। আপনি যদি শুধুমাত্র একটি ভাষা পরিবর্তন করতে চান, যেমন চীনা, আপনি সরাসরি `src/data/prompt_zh.json` সম্পাদনা করতে পারেন।
- বর্তমানে, ব্যবহারকারী ব্যাকএন্ড একটি সাধারণ ব্যাকএন্ড সিস্টেমের সাথে সংযুক্ত। প্রয়োজনে, আপনি নিজের ব্যাকএন্ড তৈরি করতে পারেন, এবং প্রাসঙ্গিক ইন্টারফেসটি `src/api.js` ফাইলে অবস্থিত।

`CodeUpdateHandler.py` হল ব্যাচ প্রসেসিং মাল্টি-ল্যাংগুয়েজ ডিপ্লয়মেন্টের জন্য একটি স্ক্রিপ্ট। পরিবর্তন সম্পূর্ণ করার পরে, `python CodeUpdateHandler.py` চালান, যা নিয়ম অনুসারে `prompt.json` কে একাধিক ভাষায় বিভক্ত করবে এবং প্রতিটি ভাষার মূল পৃষ্ঠা কোড এবং নির্বাচিত প্রম্পট শব্দের স্বাধীন পৃষ্ঠা কোড সিঙ্ক্রোনাইজ করবে। .

## স্থাপনা

### Vercel এর সাথে স্থাপন করুন

এক ক্লিকে Vercel প্ল্যাটফর্মে ChatGPT-শর্টকাট স্থাপন করতে নীচের বোতামে ক্লিক করুন:

[![Vercel](https://vercel.com/button)](https://vercel.com/new/clone?repository-url=https%3A%2F%2Fgithub.com%2Frockbenben%2FChatGPT-Shortcut% 2Free%2Fmain)

Vercel এর সাহায্যে, আপনি দ্রুত আপনার প্রকল্প হোস্ট করতে পারেন এবং স্বয়ংক্রিয়ভাবে বিল্ড এবং স্থাপনাগুলি পরিচালনা করতে পারেন, যা জটিল সার্ভার কনফিগারেশনের প্রয়োজনীয়তা নেই এমন ব্যবহারকারীদের জন্য উপযুক্ত।

### স্থানীয় স্থাপনা

নিশ্চিত করুন যে আপনি [Node.js](https://nodejs.org/) ইনস্টল করেছেন।

```shell
# Installation
yarn

# Local Development
yarn start

# Build: This command generates static content into the `build` directory
yarn build

# Update the `defaultLocale` in the `docusaurus.config.js` file, then perform a build for the desired language.
yarn build --locale zh
yarn build --locale en
yarn build --locale ja
yarn build --locale ko
yarn build --locale es
yarn build --locale fr
yarn build --locale de
yarn build --locale it
yarn build --locale ru
yarn build --locale pt
yarn build --locale hi
yarn build --locale ar
yarn build --locale bn

# Deploy for multiple languages
yarn build --locale zh && yarn build --locale en
```

### ডকার স্থাপনা

আপনি যদি ডকারের সাথে পরিচিত হন তবে আপনি নিম্নলিখিত কমান্ডের সাথে দ্রুত স্থাপন করতে পারেন:

```yml
version: "3.8"

services:
docsify:
Container_name: chatgpt-shortcut
image: ghcr.io/rockbenben/chatgpt-shortcut:latest
ports:
- "3000:3000"
restart: except-stopped
```

## সিঙ্ক্রোনাইজড আপডেট

আপনি যদি একটি একক ক্লিকে Vercel-এ আপনার নিজস্ব প্রকল্প স্থাপন করে থাকেন, তাহলে আপনি এমন একটি সমস্যার সম্মুখীন হতে পারেন যেখানে আপডেটগুলি ধারাবাহিকভাবে নির্দেশিত হয়। এটি বর্তমান প্রকল্পকে কাঁটা দেওয়ার পরিবর্তে আপনার জন্য একটি নতুন প্রকল্প তৈরি করার ভার্সেলের ডিফল্ট আচরণ থেকে উদ্ভূত হয়, যার ফলে সঠিক আপডেট সনাক্তকরণ বাধাগ্রস্ত হয়। পুনরায় স্থাপনের জন্য পরবর্তী পদক্ষেপগুলি অনুসরণ করার পরামর্শ দেওয়া হচ্ছে:

1. পূর্ববর্তী সংগ্রহস্থল সরান.
2. বর্তমান প্রকল্পটি কাঁটাচামচ করতে পৃষ্ঠার উপরের ডানদিকে অবস্থিত "ফর্ক" বোতামটি ব্যবহার করুন৷
3. [Vercel নতুন প্রজেক্ট পৃষ্ঠা](https://vercel.com/new), ইম্পোর্ট গিট রিপোজিটরি বিভাগ থেকে সম্প্রতি কাঁটাচামচ করা প্রকল্পটি নির্বাচন করুন এবং স্থাপনার সাথে এগিয়ে যান।

### স্বয়ংক্রিয় আপডেট

> আপস্ট্রিম সিঙ্ক কার্যকর করার সময় একটি ত্রুটির সম্মুখীন হলে, ম্যানুয়ালি একটি একক সিঙ্ক ফর্ক সম্পাদন করুন৷

একবার আপনি প্রকল্পটি কাঁটা হয়ে গেলে, গিটহাবের বিধিনিষেধের কারণে, আপনার ফর্ক করা প্রকল্পের অ্যাকশন পৃষ্ঠায় ওয়ার্কফ্লো ম্যানুয়ালি সক্ষম করা এবং আপস্ট্রিম সিঙ্ক অ্যাকশন সক্রিয় করা প্রয়োজন। সক্রিয় করার পরে, আপডেটগুলি প্রতিদিনের ভিত্তিতে স্বয়ংক্রিয়ভাবে কার্যকর হবে।

![স্বয়ংক্রিয় আপডেট](https://img.newzone.top/2023-05-19-11-57-59.png?imageMogr2/format/webp)

![স্বয়ংক্রিয় আপডেট সক্ষম করা হচ্ছে](https://img.newzone.top/2023-05-19-11-59-26.png?imageMogr2/format/webp)

### ম্যানুয়াল আপডেট

আপনি যদি অবিলম্বে ম্যানুয়ালি আপডেট করতে চান তবে আপনি [GitHub এর ডকুমেন্টেশন](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/syncing-a-fork) আপস্ট্রিম কোডের সাথে কাঁটাযুক্ত প্রকল্পটি কীভাবে সিঙ্ক্রোনাইজ করতে হয় তা শিখতে।

নতুন বৈশিষ্ট্য আপডেটের বিষয়ে সময়োপযোগী বিজ্ঞপ্তি সম্পর্কে অবগত থাকার জন্য এই প্রকল্পটিকে একটি তারকা/অনুসরণ করে অথবা লেখককে অনুসরণ করে সমর্থন প্রদর্শন করতে নির্দ্বিধায়।
