# 常见问题

## 为什么提示词用英文？

AiShort 是为方便非英文母语人士使用 ChatGPT 而创建的。然而，提示词却全部是英文。这是因为相较于其他语言，ChatGPT 对英文的理解更为出色。即使是中国第一个对话式大型语言模型 MOSS，也承认 MOSS 的英文回答水平比中文高。因此建议使用英文提示词。（MOSS 已不对外开放）

虽然使用非英文提示词可能会得到不错的结果，但是当你再次输入相同的非英文提示时，结果可能会大相径庭。因为 ChatGPT 对非英文的理解每次都不同，所以建议大家在输入生产力型提示词时使用英文提示词，以保证输出效果。此外，英文提示词带来的回复也很可能是英文的。你可以在提示词结尾添加 `respond in Chinese`，将回复指定为中文。如果你的母语是其他语言，请将 "Chinese" 更改为你的母语。

## 每次都要输入 Prompt？

API 中可以将提示词设为「system prompt」，这样后续就不需要输入提示词了，ChatGPT 会按照 system prompt 来执行操作。

在网页版 ChatGPT 中，如果没有切换主提示词，只需用引号将后续回复内容框选即可，这样就不需要每次都输入提示词。当回复内容不符合提示词要求时，说明 ChatGPT 已经忘记了提示词，此时需要重新输入提示词以唤醒它。另外，每个对话的链接都是唯一的，你可以将常用的对话保存为书签，以便日后使用。

## GPTs 与提示词的区别

**GPTs** 功能允许用户通过定制的输入文本指令与模型进行交互。这些指令的目的是引导模型生成与用户需求紧密相关的输出。因此，这些 **GPTs 输入指令在功能上等同于提示词**。

从应用实践来看，这些 GPTs 输入指令实质上充当了系统内置的提示词角色。它们不仅指引模型生成特定反应，也体现了用户对模型预期行为的控制与指导。实际上，社区中许多提示词都源于 **GPTs 内置指令**。

## 输入法搜索延迟

AI Short 网页版通过手动搜索实现无延迟搜索，而 Docker 或扩展版本采用自动搜索，存在 800 毫秒的延迟。

此问题源于扩展搜索功能基于 Docusaurus 的 showcase，存在 PC 端输入法焦点丢失问题。向 Docusaurus 反馈后，对方表示会尝试修复和 `FWIW, you should not be using Chinese anyway, since the showcase is not localized`。但问题始终没有解决。因此，我将搜索组件分为移动端和 PC 端两类。移动端搜索逻辑保持不变，而屏幕宽度阈值 768px 以上的 PC 端浏览引入 `debounce` 函数解决输入法问题。但这在 PC 端产生两个问题：一是非英文输入需在 800 毫秒内完成；二是 PC 端搜索刷新从即时变为 800 毫秒延迟。若你有更好的解决方案，欢迎提供反馈。

## 输出虚假信息

ChatGPT 虽然非常强大，但并不是万能的。有时它会输出虚假信息。例如，当我需要将上百条信息录入到 AiShort 中时，我让 ChatGPT 按指定格式转换数据。但是在转换过程中，我发现其中一些信息被 ChatGPT 误写。例如，在文本中一条标签是 `movie critic`，而 ChatGPT 将其更改为 `film critic`。尽管这在文本中不会造成什么影响，但放在代码中会报错。因此，在使用 ChatGPT 时，务必检查其输出内容。

## 提示词不好用？

如果你正在进行摘要总结，可利用 GPT 对原有回答进行再次优化，以提升回答的准确度。此外，提示词不仅适用于工作生产，更重要的是，它们能够激发思维，帮助你从多角度思考问题，并解决思考过程中容易忽视的问题。

AI Short 的所有提示词都来自互联网，并将定期更新提示词库。尽管每个提示词都经历了多轮测试，但其实际效果可能会因用户需求而有所不同。如你发现任何错误、拥有创新想法或发现有用的提示词，欢迎通过[反馈](/feedback)告知或在社区中分享。
