# robofab manual
# Fontlabremote howto
# usage examples
 
#FLM: Remove overlap from Remote Glyph.
 
from robofab.world import OpenFont
from robofab.tools.remote import transmitGlyph, receiveGlyph, runFontLabRemote
 
# Pick a UFO font:
f = OpenFont()
 
print "Number of contours before", len(f['A'])
 
# call FontLab to make a new font
startNewFontCode = """from robofab.world import NewFont
f = NewFont()
f.info.fullName = 'Temporary Font generated by RoboFab Remote'"""
 
print runFontLabRemote(startNewFontCode)
 
# send a glyph to FontLab,
# it will be inserted in the CurrentFont.
transmitGlyph(f['A'])
f.removeGlyph('A')
 
# send instructions to remove overlap for this glyph
overlapCode = """from robofab.world import CurrentFont
from robofab.tools.remote import transmitGlyph
f = CurrentFont()
f["A"].removeOverlap()
f.update()
transmitGlyph(f['A'])
"""
 
# send the code and catch the output
x = runFontLabRemote(overlapCode)
# interpret the output
receiveGlyph(x, f)
print "Number of contours after: ", len(f['A'])
 
# send instructions to FontLab to close the font again.
closeFontCode = """from robofab.world import CurrentFont
f = CurrentFont()
f.close(None)
"""
print runFontLabRemote(closeFontCode)
print 'done!'
