// SPDX-FileCopyrightText: 2021 Rot127 <unisono@quyllur.org>
// SPDX-License-Identifier: LGPL-3.0-only

// LLVM commit: b6f51787f6c8e77143f0aef6b58ddc7c55741d5c
// LLVM commit date: 2023-11-15 07:10:59 -0800 (ISO 8601 format)
// Date of code generation: 2024-03-16 06:22:39-05:00
//========================================
// The following code is generated.
// Do not edit. Repository of code generator:
// https://github.com/rizinorg/rz-hexagon

#ifndef HEXAGON_IL_H
#define HEXAGON_IL_H

#include <hexagon/hexagon.h>
#include <hexagon/hexagon_arch.h>
#include <rz_il/rz_il_opcodes.h>

#define WRITE_REG(pkt, op, val)                    hex_write_reg(pkt, op, val)
#define READ_REG(pkt, op, tmp_reg)                 hex_read_reg(pkt, op, tmp_reg)
#define ISA2REG(hi, var, tmp_reg)                  hex_isa_to_reg(hi, var, tmp_reg)
#define ISA2IMM(hi, var)                           hex_isa_to_imm(hi, var)
#define HEX_REGFIELD(prop, reg)                    hex_get_rf_property_val(prop, reg)
#define HEX_EXTRACT64(val, start, len)             hex_extract64(val, start, len)
#define HEX_SEXTRACT64(val, start, len)            hex_sextract64(val, start, len)
#define HEX_DEPOSIT64(val, start, len, fieldval)   hex_deposit64(val, start, len, fieldval)
#define HEX_GET_NPC(pkt)                           hex_get_npc(pkt)
#define HEX_WRITE_GLOBAL(name, val)                hex_write_global(name, val)
#define INC(val, size)                             ADD(val, UN(size, 1))
#define DEC(val, size)                             SUB(val, UN(size, 1))
#define HEX_STORE_SLOT_CANCELLED(pkt, slot)        hex_cancel_slot(pkt, slot)
#define HEX_FCIRC_ADD(bundle, RxV, offset, mu, CS) hex_fcircadd(bundle, RxV, offset, mu, CS)
#define HEX_GET_CORRESPONDING_CS(pkt, Mu)          hex_get_corresponding_cs(pkt, Mu)
#define HEX_GET_INSN_RMODE(insn)                   (insn->fround_mode)
#define HEX_D_TO_SINT(mode, fval)                  F2SINT(64, mode, fval)
#define HEX_F_TO_SINT(mode, fval)                  F2SINT(32, mode, fval)
#define HEX_D_TO_INT(mode, fval)                   F2INT(64, mode, fval)
#define HEX_F_TO_INT(mode, fval)                   F2INT(32, mode, fval)
#define HEX_SINT_TO_D(mode, fval)                  SINT2F(64, mode, fval)
#define HEX_SINT_TO_F(mode, fval)                  SINT2F(32, mode, fval)
#define HEX_INT_TO_D(mode, fval)                   INT2F(64, mode, fval)
#define HEX_INT_TO_F(mode, fval)                   INT2F(32, mode, fval)

#define HEX_IMMUTABLE_REG (~0)
#define HEX_NOT_MASKED    0

/// Immutable bits of CTR registers as in QEMU.
static const ut64 hex_ctr_immut_masks[32] = {
	[HEX_REG_CTR_REGS_C8] = 0xc13000c0, // USR
	[HEX_REG_CTR_REGS_C9] = HEX_IMMUTABLE_REG, // PC
	[HEX_REG_CTR_REGS_C11] = 0x3f, // GP
	[HEX_REG_CTR_REGS_C14] = HEX_IMMUTABLE_REG, // UPCYCLELO
	[HEX_REG_CTR_REGS_C15] = HEX_IMMUTABLE_REG, // UPCYCLEHI
	[HEX_REG_CTR_REGS_C30] = HEX_IMMUTABLE_REG, // UTIMERLO
	[HEX_REG_CTR_REGS_C31] = HEX_IMMUTABLE_REG, // UTIMERHI
};

RZ_IPI bool hex_shuffle_insns(RZ_INOUT HexPkt *p);
RZ_IPI RZ_OWN RzILOpEffect *hex_get_il_op(const ut32 addr, const bool get_pkt_op, RZ_NONNULL HexState *state);
RZ_IPI RZ_OWN RzILOpPure *hex_get_rf_property_val(const HexRegFieldProperty property, const HexRegField field);
RZ_IPI RZ_OWN RzILOpEffect *hex_get_npc(const HexPkt *pkt);
RZ_IPI RZ_OWN RzILOpEffect *hex_il_op_jump_flag_init(HexInsnPktBundle *bundle);
RZ_IPI RZ_OWN RzILOpEffect *hex_il_op_next_pkt_jmp(HexInsnPktBundle *bundle);
RZ_IPI RZ_OWN RzILOpEffect *hex_commit_packet(HexInsnPktBundle *bundle);
RZ_IPI RZ_OWN RzILOpEffect *hex_write_reg(RZ_BORROW HexInsnPktBundle *bundle, const HexOp *op, RzILOpPure *val);
RZ_IPI RZ_OWN RzILOpPure *hex_read_reg(RZ_BORROW HexPkt *pkt, const HexOp *op, bool tmp_reg);
RZ_IPI RZ_OWN RzILOpEffect *hex_cancel_slot(RZ_BORROW HexPkt *pkt, ut8 slot);
RZ_IPI void hex_il_pkt_stats_reset(HexILExecData *stats);
RZ_IPI void hex_il_pkt_stats_init(HexILExecData *stats);
RZ_IPI void hex_il_pkt_stats_fini(HexILExecData *stats);
RzILOpPure *hex_get_corresponding_cs(RZ_BORROW HexPkt *pkt, const HexOp *Mu);
RzILOpEffect *hex_il_op_a2_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_absp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_abssat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_add(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_hh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_lh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_sat_hh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_sat_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_sat_lh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_h16_sat_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_l16_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_l16_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_l16_sat_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addh_l16_sat_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addpsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addsph(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_addspl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_andir(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_andp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_aslh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_asrh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_combine_hh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_combine_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_combine_lh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_combine_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_combineii(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_combinew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_max(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_maxp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_maxu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_maxup(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_min(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_minp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_minu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_minup(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_negp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_negsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_nop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_notp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_orir(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_orp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_paddf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_paddfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_paddif(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_paddifnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_paddit(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_padditnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_paddt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_paddtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pandf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pandfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pandt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pandtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_porf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_porfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_port(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_portnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_psubf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_psubfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_psubt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_psubtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pxorf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pxorfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pxort(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_pxortnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_roundsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_satb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_sath(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_satub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_satuh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_sub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_hh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_lh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_sat_hh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_sat_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_sat_lh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_h16_sat_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_l16_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_l16_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_l16_sat_hl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subh_l16_sat_ll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_subsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svaddh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svaddhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svadduhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svavgh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svavghs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svnavgh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svsubh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svsubhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_svsubuhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_swiz(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_sxtb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_sxth(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_sxtw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_tfr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_tfrcrr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_tfrih(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_tfril(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_tfrrcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_tfrsi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vabsh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vabshsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vabsw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vabswsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vaddh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vaddhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vaddub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vaddubs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vadduhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vaddw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vaddws(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavgh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavghcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavghr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavgub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavgubr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavguh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavguhr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavguw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavguwr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavgw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavgwcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vavgwr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmpbeq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmpbgtu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmpheq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmphgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmphgtu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmpweq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmpwgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vcmpwgtu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vconj(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vmaxb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vmaxh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vmaxub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vmaxuh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vmaxuw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vmaxw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vminb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vminh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vminub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vminuh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vminuw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vminw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vnavgh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vnavghcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vnavghr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vnavgw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vnavgwcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vnavgwr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vraddub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vraddub_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vrsadub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vrsadub_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vsubh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vsubhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vsubub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vsububs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vsubuhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vsubw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_vsubws(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_xorp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a2_zxth(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_addp_c(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_andn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_andnp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_bitsplit(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_bitspliti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_boundscheck_hi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_boundscheck_lo(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpbeq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpbeqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpbgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpbgti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpbgtu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpbgtui(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpheq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmpheqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmphgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmphgti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmphgtu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cmphgtui(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_combineii(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_combineir(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_combineri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cround_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_cround_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_ext(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_modwrapu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_orn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_ornp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_paslhf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_paslhfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_paslht(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_paslhtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pasrhf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pasrhfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pasrht(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pasrhtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxtbf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxtbfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxtbt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxtbtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxthf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxthfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxtht(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_psxthtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxtbf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxtbfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxtbt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxtbtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxthf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxthfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxtht(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_pzxthtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_rcmpeq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_rcmpeqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_rcmpneq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_rcmpneqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_round_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_round_ri_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_round_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_round_rr_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_subp_c(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_tfrcpp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_tfrpcp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_tlbmatch(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpbeq_any(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpbeqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpbgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpbgti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpbgtui(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpheqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmphgti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmphgtui(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpweqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpwgti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vcmpwgtui(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrmaxh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrmaxuh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrmaxuw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrmaxw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrminh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrminuh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrminuw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a4_vrminw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a5_acs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a5_vaddhubs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a6_vcmpbeq_notany(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a6_vminub_rdp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a7_clip(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a7_croundd_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a7_croundd_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_a7_vclip(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_all8(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_andn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_any8(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_bitsclr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_bitsclri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_bitsset(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_ccombinewf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_ccombinewnewf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_ccombinewnewt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_ccombinewt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmoveif(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmoveit(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmovenewif(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmovenewit(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpeq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpeqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpeqp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpgti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpgtp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpgtu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpgtui(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_cmpgtup(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_mask(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_mux(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_muxii(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_muxir(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_muxri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_not(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_orn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_tfrpr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_tfrrp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_vitpack(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_vmux(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c2_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_addipc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_and_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_and_andn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_and_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_and_orn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_cmplte(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_cmpltei(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_cmplteu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_cmplteui(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_cmpneq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_cmpneqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_fastcorner9(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_fastcorner9_not(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_nbitsclr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_nbitsclri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_nbitsset(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_or_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_or_andn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_or_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_c4_or_orn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_d2df(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_d2sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2d(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2d_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2ud(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2ud_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2uw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2uw_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2w(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_df2w_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2d(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2d_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2df(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2ud(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2ud_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2uw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2uw_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2w(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_sf2w_chop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_ud2df(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_ud2sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_uw2df(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_uw2sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_w2df(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_conv_w2sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfadd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfclass(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfcmpeq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfcmpge(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfcmpgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfcmpuo(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfimm_n(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfimm_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfmax(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfmin(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfmpyhh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfmpylh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfmpyll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_dfsub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfadd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfclass(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfcmpeq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfcmpge(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfcmpgt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfcmpuo(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffixupd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffixupn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffixupr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffma(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffma_lib(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffma_sc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffms(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sffms_lib(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfimm_n(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfimm_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfinvsqrta(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfmax(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfmin(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfmpy(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfrecipa(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_f2_sfsub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_g4_tfrgcpp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_g4_tfrgcrr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_g4_tfrgpcp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_g4_tfrgrcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_call(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_callf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_callr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_callrf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_callrh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_callrt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_callt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jump(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumpf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumpfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumpfnewpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumpfpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumpr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprfnewpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprfpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprgtez(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprgtezpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprltez(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprltezpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprnz(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprnzpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprtnewpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprtpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprz(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumprzpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumptnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumptnewpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_jumptpt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_loop0i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_loop0r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_loop1i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_loop1r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_pause(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_ploop1si(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_ploop1sr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_ploop2si(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_ploop2sr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_ploop3si(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_ploop3sr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_rte(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_trap0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_trap1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_unpause(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeq_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqi_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpeqn1_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgt_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgti_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtn1_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtu_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpgtui_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmplt_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmplt_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmplt_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmplt_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpltu_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpltu_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpltu_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_cmpltu_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_hintjumpr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_jumpseti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_jumpsetr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_f_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_f_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_fp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_t_jumpnv_nt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_t_jumpnv_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp0_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp0_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp0_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp0_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp1_jump_nt_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp1_jump_nt_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp1_jump_t_part0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j4_tstbit0_tp1_jump_t_part1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_deallocframe(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignb_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignb_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignb_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignb_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignb_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignh_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignh_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignh_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignh_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadalignh_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw2_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw2_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw2_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw2_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw2_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw2_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw4_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw4_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw4_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw4_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw4_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbsw4_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw2_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw2_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw2_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw2_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw2_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw2_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw4_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw4_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw4_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw4_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw4_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadbzw4_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrb_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrb_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrb_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrb_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrb_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrbgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrd_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrd_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrd_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrd_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrd_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrd_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrdgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrh_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrh_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrh_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrh_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrh_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrhgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadri_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadri_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadri_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadri_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadri_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadri_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrigp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrub_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrub_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrub_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrub_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrub_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrub_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadrubgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadruh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadruh_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadruh_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadruh_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadruh_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadruh_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadruhgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadw_aq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_loadw_locked(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrbtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrdtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrhf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrhf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrhfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrhfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrht_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrht_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrhtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrhtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrif_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrif_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrifnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrifnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrit_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrit_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadritnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadritnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadrubtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruhf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruhf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruhfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruhfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruht_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruht_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruhtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l2_ploadruhtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_add_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_add_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_add_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_and_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_and_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_and_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_iadd_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_iadd_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_iadd_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_iand_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_iand_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_iand_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ior_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ior_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ior_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_isub_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_isub_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_isub_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadalignb_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadalignb_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadalignh_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadalignh_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbsw2_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbsw2_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbsw4_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbsw4_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbzw2_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbzw2_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbzw4_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadbzw4_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadd_aq(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadd_locked(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrb_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrb_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrb_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrd_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrd_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrd_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrh_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrh_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrh_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadri_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadri_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadri_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrub_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrub_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadrub_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadruh_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadruh_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_loadruh_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_or_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_or_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_or_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrbtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrdtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrhf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrhf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrhfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrhfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrht_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrht_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrhtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrhtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrif_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrif_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrifnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrifnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrit_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrit_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadritnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadritnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadrubtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruhf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruhf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruhfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruhfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruht_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruht_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruhtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_ploadruhtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_return(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_return_f(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_return_fnew_pnt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_return_fnew_pt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_return_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_return_tnew_pnt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_return_tnew_pt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_sub_memopb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_sub_memoph_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l4_sub_memopw_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_l6_memcpy(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_acci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_accii(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmaci_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmacr_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmacs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmacs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmacsc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmacsc_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpyi_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpyr_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpyrs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpyrs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpyrsc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpyrsc_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpys_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpys_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpysc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cmpysc_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cnacs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cnacs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cnacsc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_cnacsc_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_dpmpyss_acc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_dpmpyss_nac_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_dpmpyss_rnd_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_dpmpyss_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_dpmpyuu_acc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_dpmpyuu_nac_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_dpmpyuu_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_hmmpyh_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_hmmpyh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_hmmpyl_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_hmmpyl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_maci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_macsin(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_macsip(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmachs_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmachs_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmachs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmachs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacls_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacls_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacls_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacls_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacuhs_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacuhs_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacuhs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmacuhs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmaculs_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmaculs_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmaculs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmaculs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyh_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyh_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyl_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyl_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyuh_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyuh_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyuh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyuh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyul_rs0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyul_rs1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyul_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mmpyul_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mnaci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_acc_sat_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_nac_sat_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_rnd_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_sat_rnd_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_up(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_up_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpy_up_s1_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_acc_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_nac_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyd_rnd_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpysin(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpysip(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpysu_up(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_acc_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_nac_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyu_up(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_acc_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_hh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_hh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_hl_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_hl_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_lh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_lh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_ll_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_mpyud_nac_ll_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_nacci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_naccii(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_subacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vabsdiffh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vabsdiffw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vcmac_s0_sat_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vcmac_s0_sat_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vcmpy_s0_sat_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vcmpy_s0_sat_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vcmpy_s1_sat_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vcmpy_s1_sat_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vdmacs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vdmacs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vdmpyrs_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vdmpyrs_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vdmpys_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vdmpys_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2es(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2es_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2es_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2s_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2s_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2su_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmac2su_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2es_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2es_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2s_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2s_s0pack(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2s_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2s_s1pack(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2su_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vmpy2su_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vraddh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vradduh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmaci_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmaci_s0c(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmacr_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmacr_s0c(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpyi_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpyi_s0c(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpyr_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpyr_s0c(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpys_acc_s1_h(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpys_acc_s1_l(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpys_s1_h(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpys_s1_l(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpys_s1rp_h(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrcmpys_s1rp_l(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrmac_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_vrmpy_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m2_xor_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_and_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_and_andn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_and_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_and_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_cmpyi_wh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_cmpyi_whc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_cmpyr_wh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_cmpyr_whc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_mac_up_s1_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_mpyri_addi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_mpyri_addr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_mpyri_addr_u2(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_mpyrr_addi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_mpyrr_addr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_nac_up_s1_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_or_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_or_andn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_or_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_or_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_pmpyw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_pmpyw_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vpmpyh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vpmpyh_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyeh_acc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyeh_acc_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyeh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyeh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyoh_acc_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyoh_acc_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyoh_s0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_vrmpyoh_s1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_xor_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_xor_andn(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_xor_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m4_xor_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vdmacbsu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vdmpybsu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vmacbsu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vmacbuu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vmpybsu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vmpybuu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vrmacbsu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vrmacbuu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vrmpybsu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m5_vrmpybuu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m6_vabsdiffb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m6_vabsdiffub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyiw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyiw_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyiwc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyiwc_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyrw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyrw_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyrwc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_dcmpyrwc_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyiw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyiw_rnd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyiwc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyiwc_rnd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyrw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyrw_rnd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyrwc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_m7_wcmpyrwc_rnd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_r6_release_at_vi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_r6_release_st_vi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_addasl_rrri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_allocframe(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_p_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_r_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_r_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_vh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_i_vw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_p_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_r_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_vh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asl_r_vw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_p_rnd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_r_rnd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_svw_trun(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_vh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_i_vw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_p_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_r_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_svw_trun(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_vh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_asr_r_vw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_brev(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_brevp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_cabacdecbin(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_cl0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_cl0p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_cl1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_cl1p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_clb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_clbnorm(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_clbp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_clrbit_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_clrbit_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_ct0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_ct0p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_ct1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_ct1p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_deinterleave(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_extractu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_extractu_rp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_extractup(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_extractup_rp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_insert(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_insert_rp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_insertp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_insertp_rp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_interleave(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lfsp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_p_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_vh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsl_r_vw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_p_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_r_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_vh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_i_vw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_p_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_vh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_lsr_r_vw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_mask(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_packhl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_parityp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbnewf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbnewf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbnewfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbnewt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbnewt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbnewtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerbtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerdf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerdf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerdfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerdt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerdt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerdtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerff_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerff_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerffnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerft_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerft_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerftnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhnewf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhnewf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhnewfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhnewt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhnewt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhnewtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerht_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerht_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerhtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerif_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerif_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerifnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerinewf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerinewf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerinewfnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerinewt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerinewt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerinewtnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerit_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstorerit_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_pstoreritnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_setbit_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_setbit_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_shuffeb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_shuffeh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_shuffob(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_shuffoh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerb_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerb_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerb_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerb_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerb_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbnew_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbnew_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbnew_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbnew_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerbnewgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerd_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerd_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerd_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerd_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerd_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerd_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerdgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerf_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerf_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerf_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerf_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerf_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerfgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerh_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerh_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerh_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerh_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerh_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhnew_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhnew_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhnew_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhnew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhnew_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerhnewgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storeri_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storeri_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storeri_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storeri_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storeri_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storeri_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerigp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerinew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerinew_pbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerinew_pci(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerinew_pcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerinew_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerinew_pr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storerinewgp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storew_locked(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storew_rl_at_vi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_storew_rl_st_vi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_svsathb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_svsathub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_tableidxb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_tableidxd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_tableidxh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_tableidxw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_togglebit_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_togglebit_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_tstbit_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_tstbit_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_valignib(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_valignrb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vcnegh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vcrotate(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vrcnegh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vrndpackwh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vrndpackwhs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsathb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsathb_nopack(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsathub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsathub_nopack(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsatwh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsatwh_nopack(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsatwuh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsatwuh_nopack(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsplatrb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsplatrh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vspliceib(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsplicerb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsxtbh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vsxthw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vtrunehb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vtrunewh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vtrunohb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vtrunowh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vzxtbh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s2_vzxthw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_addaddi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_addi_asl_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_addi_lsr_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_andi_asl_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_andi_lsr_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_clbaddi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_clbpaddi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_clbpnorm(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_extract(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_extract_rp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_extractp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_extractp_rp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_lsli(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_ntstbit_i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_ntstbit_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_or_andi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_or_andix(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_or_ori(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_ori_asl_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_ori_lsr_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_parity(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbnewtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerbtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerdtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerff_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerff_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerffnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerffnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerffnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerft_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerft_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerftnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerftnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerftnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhnewtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerht_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerht_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerhtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerif_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerif_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerifnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerifnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerifnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewf_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewfnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewfnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewt_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewt_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewtnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerinewtnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerit_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstorerit_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstoreritnew_abs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstoreritnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_pstoreritnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_stored_locked(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_stored_rl_at_vi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_stored_rl_st_vi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirbf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirbfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirbt_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirbtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirhf_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirhfnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirht_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirhtnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeiri_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirif_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirifnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeirit_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeiritnew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerb_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerb_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerb_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerbnew_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerbnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerbnew_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerd_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerd_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerd_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerf_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerf_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerf_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerh_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerh_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerh_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerhnew_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerhnew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerhnew_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeri_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeri_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storeri_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerinew_ap(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerinew_rr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_storerinew_ur(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_subaddi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_subi_asl_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_subi_lsr_ri(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vrcrotate(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vrcrotate_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vxaddsubh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vxaddsubhr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vxaddsubw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vxsubaddh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vxsubaddhr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s4_vxsubaddw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s5_asrhub_rnd_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s5_asrhub_sat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s5_popcountp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s5_vasrhrnd(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_p(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_p_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_p_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_p_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_p_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_p_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_r(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_r_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_r_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_r_nac(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_r_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_rol_i_r_xacc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_vsplatrbp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_vtrunehb_ppp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_s6_vtrunohb_ppp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32ub_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32ub_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32ub_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_cur_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_cur_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_nt_tmp_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vl32b_tmp_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32ub_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nqpred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nqpred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nqpred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_npred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_npred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_npred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_nqpred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_nqpred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_nqpred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_qpred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_qpred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_nt_qpred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_qpred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_qpred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_qpred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_srls_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_srls_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vs32b_srls_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vabs_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vabs_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_hf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_qf16(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_qf16_mix(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_qf32(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_qf32_mix(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_sf_bf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_sf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vadd_sf_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vassign_fp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vconv_h_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vconv_hf_h(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vconv_hf_qf16(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vconv_hf_qf32(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vconv_sf_qf32(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vconv_sf_w(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vconv_w_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_b_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_bf_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_h_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_hf_b(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_hf_h(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_hf_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_hf_ub(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_hf_uh(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_sf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_ub_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vcvt_uh_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vdmpy_sf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vdmpy_sf_hf_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vfmax_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vfmax_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vfmin_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vfmin_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vfneg_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vfneg_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtbf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtbf_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtbf_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtbf_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgthf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgthf_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgthf_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgthf_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtsf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtsf_and(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtsf_or(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vgtsf_xor(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmax_bf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmax_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmax_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmin_bf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmin_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmin_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_hf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_hf_hf_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf16(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf16_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf16_mix_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf32(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf32_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf32_mix_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf32_qf16(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_qf32_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_sf_bf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_sf_bf_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_sf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_sf_hf_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vmpy_sf_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpybub_rtt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpybub_rtt_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyub_rtt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyub_rtt_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbb_rt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbb_rt_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbb_rx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbb_rx_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbub_rt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbub_rt_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbub_rx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzbub_rx_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcb_rt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcb_rt_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcb_rx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcb_rx_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcbs_rt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcbs_rt_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcbs_rx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyzcbs_rx_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyznb_rt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyznb_rt_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyznb_rx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vrmpyznb_rx_acc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_hf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_qf16(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_qf16_mix(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_qf32(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_qf32_mix(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_sf_bf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_sf_hf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_vsub_sf_sf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_zld_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_zld_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_zld_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_zld_pred_ai(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_zld_pred_pi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_zld_pred_ppu(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_v6_zextract(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_barrier(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_break(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_ciad(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_crswap0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_cswi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dccleana(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dccleanidx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dccleaninva(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dccleaninvidx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dcfetchbo(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dcinva(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dcinvidx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dckill(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dctagr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dctagw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_dczeroa(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_getimask(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_iassignr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_iassignw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_icdatar(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_icdataw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_icinva(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_icinvidx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_ickill(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_ictagr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_ictagw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_isync(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_k0lock(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_k0unlock(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_l2cleaninvidx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_l2kill(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_resume(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_setimask(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_setprio(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_start(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_stop(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_swi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_syncht(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_tfrscrr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_tfrsrcr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_tlblock(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_tlbp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_tlbr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_tlbunlock(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_tlbw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y2_wait(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_crswap1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_crswap10(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_l2fetch(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_l2tagr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_l2tagw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_nmi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_siad(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_tfrscpp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_tfrspcp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y4_trace(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_ctlbw(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2cleanidx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2fetch(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2gclean(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2gcleaninv(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2gunlock(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2invidx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2locka(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_l2unlocka(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_tlbasidi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y5_tlboc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_diag(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_diag0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_diag1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_dmlink(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_dmpause(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_dmpoll(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_dmresume(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_dmstart(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_y6_dmwait(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_dep_a2_addsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_dep_a2_subsat(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_dep_s2_packhl(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_invalid_decode(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_imported_rd_ss(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_imported_rd_memw_phys_rs_rt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_imported_rdd_sss(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_imported_sd_rs(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_imported_sdd_rss(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_imported_l2gclean_rtt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_imported_l2gcleaninv_rtt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_addi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_addrx(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_addsp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_and1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_clrf(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_clrfnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_clrt(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_clrtnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_cmpeqi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_combine0i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_combine1i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_combine2i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_combine3i(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_combinerz(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_combinezr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_dec(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_inc(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_seti(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_setin1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_sxtb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_sxth(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_tfr(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_zxtb(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sa1_zxth(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl1_loadri_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl1_loadrub_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_deallocframe(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_jumpr31(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_jumpr31_f(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_jumpr31_fnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_jumpr31_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_jumpr31_tnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_loadrb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_loadrd_sp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_loadrh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_loadri_sp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_loadruh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_return(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_return_f(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_return_fnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_return_t(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_sl2_return_tnew(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss1_storeb_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss1_storew_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_allocframe(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_storebi0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_storebi1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_stored_sp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_storeh_io(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_storew_sp(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_storewi0(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_ss2_storewi1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_undocumented_sa2_tfrsi(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_endloop01(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_endloop1(HexInsnPktBundle *bundle);
RzILOpEffect *hex_il_op_j2_endloop0(HexInsnPktBundle *bundle);
RZ_OWN RzILOpEffect *hex_fcirc_add(HexInsnPktBundle *bundle, const HexOp *RxV, RZ_BORROW RzILOpPure *offset, RZ_BORROW RzILOpPure *M, RZ_BORROW RzILOpPure *CS);
RZ_OWN RzILOpEffect *hex_trap(RZ_BORROW RzILOpPure *trap_type, RZ_BORROW RzILOpPure *imm);
RZ_OWN RzILOpEffect *hex_clz32(RZ_BORROW RzILOpPure *t);
RZ_OWN RzILOpEffect *hex_clz64(RZ_BORROW RzILOpPure *t);
RZ_OWN RzILOpEffect *hex_clo32(RZ_BORROW RzILOpPure *x);
RZ_OWN RzILOpEffect *hex_clo64(RZ_BORROW RzILOpPure *x);
RZ_OWN RzILOpEffect *hex_revbit16(RZ_BORROW RzILOpPure *t);
RZ_OWN RzILOpEffect *hex_revbit32(RZ_BORROW RzILOpPure *t);
RZ_OWN RzILOpEffect *hex_revbit64(RZ_BORROW RzILOpPure *t);
RZ_OWN RzILOpEffect *hex_fbrev(RZ_BORROW RzILOpPure *addr);
RZ_OWN RzILOpEffect *hex_conv_round(RZ_BORROW RzILOpPure *a, RZ_BORROW RzILOpPure *n);
RZ_OWN RzILOpEffect *hex_set_usr_field(HexInsnPktBundle *bundle, HexRegField field, RZ_BORROW RzILOpPure *val);
RZ_OWN RzILOpEffect *hex_get_usr_field(HexInsnPktBundle *bundle, HexRegField field);

#endif
