# Deep Learning and Deep Reinforcement Learning Theory and Programming Tutorials

We'll be covering both CPU and GPU implementations of deep learning and deep reinforcement learning algorithms

!!! tip "Packages and Languages you will Learn to Use"

    - Python
    - PyTorch
    - NumPy
    - Gym

If you would like a more visual and guided experience, feel free to take our [video course](https://www.udemy.com/practical-deep-learning-with-pytorch/?couponCode=DEEPWIZARD).

## Paths
!!! info "Work in progress"
    This open-source portion is still a work in progress, it may be sparse in explanation as traditionally all our explanation are done via video. Stay tuned while we gradually upload our tutorials and notes. Feel free to contact [Ritchie Ng](https://www.ritchieng.com/) if you would like to contribute via our [Facebook](https://www.facebook.com/DeepLearningWizard/) page.
    
    Also take note that these notes are best used as a referral. This is because we have yet to expand it comprehensively to be a stand-alone guide. Go head and take our [video course](https://www.udemy.com/practical-deep-learning-with-pytorch/?couponCode=DEEPWIZARD) that provides a much easier, proven-to-work, experience.
    
    All of our code allows you to run in a notebook for this deep learning section. Please use a `jupyter notebook` and run the examples from the start of the page to the end.
    
    Remember to `Right mouse click > Open image in new tab` if you would like to zoom into the diagrams if you find them too small.
    
!!! question "Clarifications"
    These are some clarifications we would like to highlight. 
    
    * [x] When we state **linear function**, more specifically we meant **affine function** that comprises a linear function and a constant. We did this initially to make it easier as "linear function" was easier to digest.
    * [x] For all diagrams that says **valid padding**, they refer to **no padding** such that your output size will be smaller than your input size.
    * [x] For all diagrams that says **same padding**, they refer to **zero padding** (padding your input with zeroes) such that your output size will be equal to your input size.
    
!!! bug "Errors to be corrected"
    As we are rapidly prototyping there may be some errors. For these errors stated here, they will be corrected soon.
    
    Feel free to report bugs, corrections or improvements on our [Github repository](https://github.com/ritchieng/deep-learning-wizard). 
    
    If you did not go through all the materials, you would not be familiar with these, so go through them and come back to review these changes.
    
    * [x] For all diagrams that says **dot product**, they refer to **matrix product**. 
    