# Course Progression
If you would like a smooth transition in learning deep learning concepts, you need to follow the materials in a sequential order. Some sections are still pending as I am working on them, and they will have the :hourglass_flowing_sand: icon beside them.


## 1. Practical Deep Learning with PyTorch
* [x] Matrices
* [x] Gradients
* [x] Linear Regression
* [x] Logistic Regression
* [x] Feedforward Neural Networks (FNN)
* [x] Convolutional Neural Networks (CNN)
* [x] Recurrent Neural Networks (RNN)
* [x] Long Short Term Memory Neural Networks (LSTM)
* [x] Autoencoders (AE)
* [x] Fully-connected Overcomplete Autoencoder (AE)
* [x] :hourglass_flowing_sand: Variational Autoencoders (VAE)
* [x] :hourglass_flowing_sand: Adversarial Autoencoders (AAE)
* [x] :hourglass_flowing_sand: Generative Adversarial Networks (GAN)
* [x] :hourglass_flowing_sand: Transformers

## 2. Improving Deep Learning Models with PyTorch
* [x] Derivatives, Gradients and Jacobian
* [x] Gradient Descent and Backpropagation (From Scratch FNN Regression)
* [x] Learning Rate Scheduling
* [x] Optimizers
* [x] Advanced Learning Rate Optimization
* [x] Weight Initializations and Activation Functions
* [x] :hourglass_flowing_sand: Overfitting Prevention
* [x] :hourglass_flowing_sand: Loss, Accuracy and Weight Visualizations
* [x] :hourglass_flowing_sand: Data Preprocessing for Images and Videos
* [x] :hourglass_flowing_sand: Data Preprocessing for Time Series

## 3. Deep Reinforcement Learning with PyTorch
* [x] Supervised Learning to Reinforcement Learning
* [x] Markov Decision Processes and Bellman Equations
* [x] Dynamic Programming
* [x] :hourglass_flowing_sand: Monte Carlo Approach
* [x] :hourglass_flowing_sand: Temporal-Difference
* [x] :hourglass_flowing_sand: Policy Gradient: REINFORCE
* [x] :hourglass_flowing_sand: Policy Gradient: Actor-Critic
* [x] :hourglass_flowing_sand: Policy Gradient: A2C/A3C
* [x] :hourglass_flowing_sand: Policy Gradient: ACKTR
* [x] :hourglass_flowing_sand: Policy Gradient: PPO
* [x] :hourglass_flowing_sand: Policy Gradient: DPG
* [x] :hourglass_flowing_sand: Policy Gradient: DDPG (DQN & DPG)

## 4. From Scratch with Python and PyTorch
* [x] From Scratch Logistic Regression Classification
* [x] :hourglass_flowing_sand: From Scratch FNN Classification
* [x] :hourglass_flowing_sand: From Scratch CNN Classification
* [x] :hourglass_flowing_sand: From Scratch RNN Classification
* [x] :hourglass_flowing_sand: From Scratch LSTM Classification
* [x] :hourglass_flowing_sand: From Scratch AE

## 5. Large Language Models with PyTorch
* [x] :hourglass_flowing_sand: Introduction
* [x] :hourglass_flowing_sand: What is Temperature