# About Us

We deploy a top-down approach that enables you to grasp deep learning and deep reinforcement learning theories and code easily and quickly. We have open-sourced all our materials through our [Deep Learning Wizard Tutorials](https://www.deeplearningwizard.com/deep_learning/course_progression/). For visual learners, feel free to sign up for our [video course](https://www.udemy.com/practical-deep-learning-with-pytorch/?couponCode=DEEPWIZARD) and join over 6000 deep learning wizards.

To this date, we have taught thousands of students across more than 120+ countries from students in high school to postgraduates and professionals in leading MNCs and research institutions around the world.

## Core Contributor

!!! abstract "Ritchie Ng"

    **Industry**: As the Group Head of Data & AI at Eastspring Investments, I spearhead engineering, governance, and strategy across data and machine learning in 13 countries with Assets Under Management (AUM) exceeding USD 220 billion.

    **Academia**: Serving in the capacity of a Visiting Research Scholar at NExT++ Lab, jointly setup between NUS and Tsinghua University, I focus on applied deep learning research for Asian systematic trading strategies and the development of financial Large Language Models (LLM) using multimodal and multilingual data.

    **Education**: Master's degree from Imperial College London and Bachelor's degree from NUS.

    **About**: ritchieng.live

    **Notes**: ritchieng.com

    **Guides**: deeplearningwizard.com

## Individual Supporters

!!! abstract "Alfredo Canziani"

    Alfredo is the main person who inspired Ritchie to open-source Deep Learning Wizard's materials. We are very grateful for his advice particular in the space of open-source projects, deep learning and PyTorch.
    
    He is currently working as an Assistant Professor at Courant Institute of Mathematical Sciences, under the guidance of professor Yann LeCun.
    
    Do check out his latest [mini-course on PyTorch](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse) that was held in Princeton University and was delivered with Ritchie Ng at AMMI (AIMS) Kigali, Rwanda supported by Google and Facebook.
    
!!! abstract "Marek Bardonski"

    Since graduation, Marek has been working on state-of-the-art research. He was involved in inventing the system that diagnoses problems with Ubuntu packages using Machine Learning and in improving the detection accuracy of breast cancer using Deep Learning, each time leading 40 highly skilled Machine Learning/Deep Learning engineers for over 6 months.

    NASA noticed his unique skills and asked him to manage a project aiming to improve the International Space Station rotation algorithm that would allow them to collect enough power from solar panels while preventing them from overheating. The project was successful and generated a huge ROI for NASA. Marek has been honored by multiple Harvard professors and the Director of Advanced Exploration Systems at NASA, who signed an official Letter of Recommendation.

    Since his first summer of university coursework, Marek has participated in four internships at NVIDIA HQ and Microsoft HQ. He also spent one year in NVIDIA Switzerland optimizing Deep Learning inference for self-driving cars and, by implementing very efficient Deep Learning algorithms in the GPU assembly language, improving the speed of Tesla’s cars self-driving engine inference. He's currently the Head of AI at [Sigmoidal](https://sigmoidal.io/).

!!! abstract "Jie Fu"

    Jie Fu is a happy and funny machine learning researcher (principal investigator), at Hong Kong University of Science and Technology (HKUST), with his human-friendly big AI dream.

    He worked as a postdoc with Yoshua Bengio at University of Montreal, Quebec AI Institute (Mila), funded by Microsoft Research Montreal. He was an IVADO postdoc fellow working with Chris Pal at Polytechnique Montreal, Quebec AI Institute (Mila). He obtained his PhD from National University of Singapore under the supervision of Tat-Seng Chua. He received ICLR 2021 Outstanding Paper Award.

    He is currently working towards system-2 deep learning and its adaption to various real-world tasks, including AI for Science (drug discovery in particular) and AI for Social Good that can benefit all of society. He is also broadly interested in general deep learning, reinforcement learning, and language processing.

    Check out his profile link at [bigaidream.github.io](http://bigaidream.github.io/)

## Corporate Supporters

!!! tip ""NVIDIA Inception Partner"
    <center><img src="https://res.cloudinary.com/ritchieng/image/upload/v1532596192/deeplearningwizard.com/nvidia_inception.png" style="width:200px"/></center>
    
    Deep Learning Wizard is proudly an NVIDIA Inception Partner, empowering people across the world to leverage on deep learning via open-source programming languages and frameworks to solve problems.
    
!!! warning "Amazon AWS Activate Programme Startup"
    <center><img src="https://res.cloudinary.com/ritchieng/image/upload/v1563421301/logos/aws_activate.png" style="width:200px"/></center>
    
    Deep Learning Wizard is also supported by the Amazon AWS Activate Programme, Portfolio Plus, allowing us to have the infrastructure to scale and grow.   
    
## Citation
If you have found these useful in your research, presentations, school work, projects or workshops, feel free to cite using this DOI.

[![DOI](https://zenodo.org/badge/139945544.svg)](https://zenodo.org/badge/latestdoi/139945544)