# Deep Learning Materials by Deep Learning Wizard

<img src="https://img.shields.io/badge/license-MIT-green.svg"/>

[![DOI](https://zenodo.org/badge/139945544.svg)](https://zenodo.org/badge/latestdoi/139945544)

## Start Learning Now

Please head to [www.deeplearningwizard.com](https://www.deeplearningwizard.com/) to start learning! It is mobile/tablet friendly and open-source.

## Repository Details

This repository contains all the notebooks and mkdocs markdown files of the tutorials covering machine learning, deep learning, deep reinforcement learning, data engineering, general programming, and visualizations powering the website.

Take note this is an early work in progress, do be patient as we gradually upload our guides.

## Sections and Subsections

- Deep Learning and Deep Reinforcement Learning Tutorials (Libraries: Python, PyTorch, Gym, NumPy, Matplotlib and more)
    - [Introduction](https://www.deeplearningwizard.com/deep_learning/intro/)
    - [Course Progression](https://www.deeplearningwizard.com/deep_learning/course_progression/)
    - Practical Deep Learning with PyTorch
      - [Matrices](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_matrices/)
      - [Gradients](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_gradients/)
      - [Linear Regression](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_linear_regression/)
      - [Logistic Regression](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_logistic_regression/)
      - [Feedforward Neural Network (FNN)](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_feedforward_neuralnetwork/)
      - [Convolutional Neural Network (CNN)](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_convolutional_neuralnetwork/)
      - [Recurrent Neural Network (RNN)](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_recurrent_neuralnetwork/)
      - [Long Short-Term Memory Network (LSTM)](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_lstm_neuralnetwork/)
      - [Autoencoders (AE)](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_autoencoder/)
      - [Fully Connected Overcomplete Autoencoders](https://www.deeplearningwizard.com/deep_learning/practical_pytorch/pytorch_fc_overcomplete_ae/)
    - Improving Deep Learning with PyTorch
      - [Derivative, Gradient and Jacobian](https://www.deeplearningwizard.com/deep_learning/boosting_models_pytorch/derivative_gradient_jacobian/)
      - [Forward- and Backward-propagation and Gradient Descent (From Scratch FNN Regression)](https://www.deeplearningwizard.com/deep_learning/boosting_models_pytorch/forwardpropagation_backpropagation_gradientdescent/)
      - [Learning Rate Scheduling](https://www.deeplearningwizard.com/deep_learning/boosting_models_pytorch/lr_scheduling/)
      - [Optimization Algorithms](https://www.deeplearningwizard.com/deep_learning/boosting_models_pytorch/optimizers/)
      - [Weight Initialization and Activation Functions](https://www.deeplearningwizard.com/deep_learning/boosting_models_pytorch/weight_initialization_activation_functions/)
    - Deep Reinforcement Learning with PyTorch
      - [Supervised to Reinforcement Learning](https://www.deeplearningwizard.com/deep_learning/deep_reinforcement_learning_pytorch/supervised_to_rl/)
      - [Markov Decision Processes and Bellman Equations](https://www.deeplearningwizard.com/deep_learning/deep_reinforcement_learning_pytorch/bellman_mdp/)
      - [Dynamic Programming](https://www.deeplearningwizard.com/deep_learning/deep_reinforcement_learning_pytorch/dynamic_programming_frozenlake/)
    - From Scratch Deep Learning with PyTorch/Python
      - [From Scratch Logistic Regression Classification](https://www.deeplearningwizard.com/deep_learning/fromscratch/fromscratch_logistic_regression/)
    - Compute Optimization
      - [Speed Optimization Basics Numba](https://www.deeplearningwizard.com/deep_learning/production_pytorch/speed_optimization_basics_numba/)

- Language Models (Libraries: Python, Pytorch, Ollama, LlamaIndex, CUDA, Huggingface, Apptainer)
  - [Intro](https://www.deeplearningwizard.com/language_model/intro/)
  - Containers
    - [HPC Containers with Apptainer](https://www.deeplearningwizard.com/language_model/containers/hpc_containers_apptainer/)
  - Language Models
    - [LLM Introduction & Hyperparameter Tuning](https://www.deeplearningwizard.com/language_model/llm/llm_intro_hyperparameter_tuning/)
  - Multi-Modal Language Models
    - [MMLM Introduction](https://www.deeplearningwizard.com/language_model/mmlm/mmlm_intro/)
  - Retrieval Augemented Generation (RAG)
    - [Embeddings Introduction](https://www.deeplearningwizard.com/language_model/rag/embedding/)

- Machine Learning Tutorials (Libraries: Python, cuDF RAPIDS, cuML RAPIDS, pandas, numpy, scikit-learn and more)
  - RAPIDS cuDF
    - [Intro](https://www.deeplearningwizard.com/machine_learning/intro/)
    - [GPU DataFrames](https://www.deeplearningwizard.com/machine_learning/gpu/rapids_cudf/)
    - [CPU/GPU Fractional Differencing](https://www.deeplearningwizard.com/machine_learning/gpu/gpu_fractional_differencing/)
  
- Programming Tutorials (Libraries: C++, Python, Bash and more)
  - [Intro](https://www.deeplearningwizard.com/programming/intro/)
  - [C++](https://www.deeplearningwizard.com/programming/cpp/cpp/)
  - [Bash](https://www.deeplearningwizard.com/programming/bash/bash/)
  - [Python](https://www.deeplearningwizard.com/programming/python/python/)
  - [Javascript](https://www.deeplearningwizard.com/programming/javascript/javascript/)
  - [Electron](https://www.deeplearningwizard.com/programming/electron/electron/)

- Data Engineering Tutorials (Libraries: Bash, Databricks, Delta Live Tables, Parquet, Python, Cassandra, and more)
  - Cassandra (NoSQL)
    - [Introduction](https://www.deeplearningwizard.com/data_engineering/nosql/cassandra/intro/)
    - [Apache Cassandra Cluster Setup](https://www.deeplearningwizard.com/data_engineering/nosql/cassandra/setting_up_cluster/)
    
## About Deep Learning Wizard
We deploy a top-down approach that enables you to grasp deep learning theories and code easily and quickly. We have open-sourced all our materials through our Deep Learning Wizard Wikipedia. For visual learners, feel free to sign up for our video course and join thousands of deep learning wizards.

To this date, we have taught thousands of students across more than 120+ countries.

## Contribution
We are openly calling people to contribute to this repository for errors. Feel free to create a pull request.

## Main Contributor
[Ritchie Ng](https://github.com/ritchieng)

## Editors and Supporters
- [Jie Fu, Editor (Postdoc in Montreal Institute for Learning Algorithms (MILA))](https://github.com/bigaidream)
- [Alfredo Canziani, Supporter (Assistant Prof in NYU under Yann Lecun)](https://github.com/Atcold)
- [Marek Bardonski, Supporter (Managing Partner, AIRev)](https://www.linkedin.com/in/marek-bardonski/)

## Bugs and Improvements
Feel free to report bugs and improvements via issues. Or just simply try to pull to make any improvements/corrections.

## Social Media
- [Youtube](https://www.youtube.com/channel/UCJz2MIjiCosOQCwhnsYxeEw)
- [Twitter](https://twitter.com/deeplearningwiz)
- [Facebook](https://www.facebook.com/DeepLearningWizard/)
- [Linkedin](https://www.linkedin.com/company/deeplearningwizard/)

## Citation
If you find the materials useful, like the diagrams or content, feel free to cite this repository.

[![DOI](https://zenodo.org/badge/139945544.svg)](https://zenodo.org/badge/latestdoi/139945544)
