# Contributing Guidelines

Contributions are always welcome! 

If you're interested in contributing but you're not sure what to work on, take a look at our [open issues](https://github.com/ripjar/material-datetime-picker/issues). If you have an idea already, we accept [Pull Requests](https://help.github.com/articles/about-pull-requests/). If it's a big change, please open an issue first so we can talk it through.

## Getting started

If you're new to open source, welcome! We would love to help you get started. Here's a quick guide:

* Decide what to work on, or find an [issue](https://github.com/ripjar/material-datetime-picker/issues) that you're interested in.
* Fork this project. That creates your own copy of the code so can make changes without affecting the main project.
* Clone your fork! That gets the code onto your local computer. You can do that on the command line:

```
git clone https://github.com/YOUR_USERNAME/material-datetime-picker.git
```

* Create a branch to work on. This is a kind of seperate working area for this particular contribution:

```
git checkout -b your-branch-name
```

* Write your code, documentation or whatever you are contributing!
* Commit your code to your local repository:

```
git commit -a -m "Write a short summary of your changes here!"
```

* Push your commited changes to your fork:

```
git push origin your-branch-name
```

* Open a Pull Request on the [main repo](https://github.com/ripjar/material-datetime-picker). That's when we get to see your code. Add a descriptive title and a summary of the changes you've made.

* We'll review your code and go through any changes that we'd like you to make. Please don't worry about this - it's a totally normal part of most software projects, and it's common for changes to be requested. This isn't a slight on you or your code - it's a way of keeping the project's quality high, and hopefully for you to learn something!

* Make any fixes that we've asked for, and repeat steps 6 - 9. This might happen a few times.

* When we're both happy with your pull request, we'll merge it. Congratulations!


## In short
If you've done this kind of thing before:

* Please be kind and respectful at all times. Treat your fellow contributors with empathy. If your contribution is excellent but your attitude isn't, we're not interested.
* Please make pull requests from a feature branch
* Lint with `eslint`. You can `npm run lint`.
* Follow the existing project style (we use https://github.com/airbnb/javascript)
* Use [BEM](http://getbem.com/introduction/) for CSS
* You don't need to `npm run build`. We'll do that before cutting a release.

## Where can I get help?

Right now the best way to get help is to [open an issue](https://github.com/ripjar/material-datetime-picker/issues), or ask me on Twitter [@jwhitfieldseed](https://twitter.com/jwhitfieldseeds
).