# ゼロから学ぶ C++

<div align="center">
    <img src="img/cpp.svg">
</div>

このサイトは C++ について説明した学習サイトです。
本書を通じて C++ の開発環境や構文・単体テストの書き方などが
一通り学べるようになっています。

# 対象

- C++ を初めて学ぶ人
- プログラム言語を 1 つ以上経験したことのある人

関数やクラス・オブジェクト指向に対する知識をある程度前提にします。

# C++ の特徴

C++ は [ビャーネ・ストロヴストルップ] により開発されたプログラミング言語です。
C++ には主に次のような特徴があります。

- 高パフォーマンス
- メモリ使用量が少ない
- 柔軟性がある

パフォーマンスを出しやすくするために低レベルなコードが書けるようになっている分、
不具合が混入しやすいというデメリットがあります。
しかし古くからある言語のため、エコシステムは豊富に揃っています。
他の言語に比べると標準ライブラリはやや貧弱ですが、
これは柔軟性とのトレードオフの結果です。

[ビャーネ・ストロヴストルップ]: https://ja.wikipedia.org/wiki/%E3%83%93%E3%83%A3%E3%83%BC%E3%83%8D%E3%83%BB%E3%82%B9%E3%83%88%E3%83%AD%E3%83%B4%E3%82%B9%E3%83%88%E3%83%AB%E3%83%83%E3%83%97

# C++ のバージョンについて

* C++98 (1998年制定)
* C++03 (2003年制定)
* [C++11] (2011年制定)
* [C++14] (2014年制定)
* [C++17] (2017年制定)
* [C++20] (2020年制定)

このサイトでは `C++11` を対象とします。

[C++11]: https://cpprefjp.github.io/lang/cpp11.html
[C++14]: https://cpprefjp.github.io/lang/cpp14.html
[C++17]: https://cpprefjp.github.io/lang/cpp17.html
[C++20]: https://cpprefjp.github.io/lang/cpp20.html
