# ビットフィールド

構造体のデータメンバはバイト単位でサイズが確保されますが、ビット単位でもサイズを確保することができます。
そのようなデータメンバをビットフィールドといいます。

```cpp
struct Bits {
    uint8_t a : 1;     //  1 ビット
    uint8_t b : 3;     //  3 ビット
    uint8_t c : 4;     //  4 ビット
};
```

データメンバ `a, b, c` は `uint8_t` 型の領域をそれぞれ指定したビット数で分割して利用します。
構造体のサイズをなるべく小さく抑えたいときなどに使用されます。

例えば 1 ビットのビットフィールドを用意すれば `0, 1` の 2 値を表現できるため、
`bool` の代わりとして使用することができます。

```cpp
struct Bool {
    uint8_t flag : 1;
};
```

ただし上記のような 1 ビットのビットフィールドを定義しても `Bool` のサイズは `uint8_t` 分のサイズを確保します。
すなわち `uint8_t` の残り 7 ビットは未使用な領域になります。
