# C言語形式のキャスト

C++ は C言語と互換性があるため、`(型名)`でC言語形式のキャストも利用することができます。

```cpp
double dx = 3.14;
int x = (int)dx;
```

しかし、C言語形式のキャストでは、コードからキャストの意図が汲み取りにくい上、実装者の意に反したキャストを行ったとしてもコンパイルが通るため、不具合を生み出す要因になる可能性があります。

対して、C++ のキャスト演算子は用途に合わせて種類が分かれているため、意図が明確になる上、実装者の意に反したキャストをコンパイル時に検知することが可能です。

```cpp
int x = 100;
int* px = static_cast<int*>(x); // static_castの意図に反しているためコンパイルエラー
```

キャストの意図を明確にするために、C++ のキャスト演算子を使うようにしましょう。