# 変数

C++ で変数を使用する方法について説明します。
整数値の変数を宣言するには次のようにします。

```cpp
int x = 5;
```

`int` は整数を表現する型です。
宣言時に初期化をせずにあとで値を代入することもできます。

```cpp
int x;
x = 5;
```

初期値を設定しないまま変数を使用すると不定な値が入るので注意して下さい。

```cpp
int x;

std::cout << x << std::endl;  // 不定な値が出力される
```

## const

`const` を付けると値の書き換えが禁止できます。

```cpp
const int x = 5;
x = 10;  // エラー
```

## constexpr

`constexpr` を付けると定数にできます。

```cpp
constexpr int x = 5;
```

`const` の値は実行時に決定しますが `constexpr` の値はコンパイル時に決定します。

## 型推論

変数の宣言時には明示的に型を指定しなくても `auto` を使うと
右辺の値から型を推論することができます。

```cpp
auto x = 5;  // x は int と推論
```
