CREATE TABLE Z_METADATA (Z_VERSION INTEGER PRIMARY KEY,
    Z_UUID VARCHAR(255),
    Z_PLIST BLOB);
CREATE TABLE ZCLOUDSHAREDALBUMINVITATIONRECORD ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZINVITATIONSTATE INTEGER,
    ZINVITATIONSTATELOCAL INTEGER,
    ZINVITEEEMAILKEY INTEGER,
    ZISMINE INTEGER,
    ZALBUM INTEGER,
    Z_FOK_ALBUM INTEGER,
    ZINVITEESUBSCRIPTIONDATE TIMESTAMP,
    ZALBUMGUID VARCHAR,
    ZCLOUDGUID VARCHAR,
    ZINVITEEFIRSTNAME VARCHAR,
    ZINVITEEFULLNAME VARCHAR,
    ZINVITEEHASHEDPERSONID VARCHAR,
    ZINVITEELASTNAME VARCHAR );
CREATE TABLE ZCLOUDFEEDENTRY ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZENTRYPRIORITYNUMBER INTEGER,
    ZENTRYTYPENUMBER INTEGER,
    ZENTRYDATE TIMESTAMP,
    ZENTRYALBUMGUID VARCHAR,
    ZENTRYINVITATIONRECORDGUID VARCHAR,
    ZENTRYCLOUDASSETGUID VARCHAR );
CREATE TABLE ZMOMENTLIBRARY ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER );
CREATE INDEX ZCLOUDSHAREDALBUMINVITATIONRECORD_ZALBUM_INDEX ON ZCLOUDSHAREDALBUMINVITATIONRECORD (ZALBUM);
CREATE INDEX ZCLOUDFEEDENTRY_ZENTRYDATE_INDEX ON ZCLOUDFEEDENTRY (ZENTRYDATE);
CREATE INDEX ZCLOUDFEEDENTRY_ZENTRYTYPENUMBER_INDEX ON ZCLOUDFEEDENTRY (ZENTRYTYPENUMBER);
CREATE INDEX ZCLOUDFEEDENTRY_Z_ENT_INDEX ON ZCLOUDFEEDENTRY (Z_ENT);
CREATE INDEX ZCLOUDFEEDENTRY_ZENTRYDATE_ZENTRYPRIORITYNUMBER_ZENTRYTYPENUMBER ON ZCLOUDFEEDENTRY (ZENTRYDATE,
    ZENTRYPRIORITYNUMBER,
    ZENTRYTYPENUMBER);
CREATE INDEX ZCLOUDFEEDENTRY_Z_ENT_ZENTRYDATE ON ZCLOUDFEEDENTRY (Z_ENT,
    ZENTRYDATE);
CREATE INDEX ZCLOUDFEEDENTRY_Z_PK_ZENTRYDATE ON ZCLOUDFEEDENTRY (Z_PK,
    ZENTRYDATE);
CREATE TABLE Z_MODELCACHE (Z_CONTENT BLOB);
CREATE TABLE ZASSETDESCRIPTION ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZLONGDESCRIPTION VARCHAR );
CREATE INDEX ZASSETDESCRIPTION_ZASSETATTRIBUTES_INDEX ON ZASSETDESCRIPTION (ZASSETATTRIBUTES);
CREATE TABLE ZMOMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCACHEDCOUNT INTEGER,
    ZCACHEDPHOTOSCOUNT INTEGER,
    ZCACHEDVIDEOSCOUNT INTEGER,
    ZGENERATIONTYPE INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZMEGAMOMENTLIST INTEGER,
    ZMOMENTLIBRARY INTEGER,
    ZYEARMOMENTLIST INTEGER,
    Z_FOK_MOMENTLIBRARY INTEGER,
    Z_FOK_MEGAMOMENTLIST INTEGER,
    Z_FOK_YEARMOMENTLIST INTEGER,
    ZENDDATE TIMESTAMP,
    ZREPRESENTATIVEDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTITLE VARCHAR,
    ZTITLE2 VARCHAR,
    ZTITLE3 VARCHAR,
    ZUUID VARCHAR,
    ZAPPROXIMATELOCATIONDATA BLOB,
    ZREVERSELOCATIONDATA BLOB );
CREATE TABLE ZMOMENTLIST ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZGENERATIONTYPE INTEGER,
    ZGRANULARITYLEVEL INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZSORTINDEX INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZENDDATE TIMESTAMP,
    ZREPRESENTATIVEDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTITLE VARCHAR,
    ZTITLE2 VARCHAR,
    ZTITLE3 VARCHAR,
    ZUUID VARCHAR,
    ZREVERSELOCATIONDATA BLOB );
CREATE TABLE ZPERSONREFERENCE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZPERSON INTEGER,
    ZPERSONUUID VARCHAR,
    ZPERSONDATA BLOB );
CREATE TABLE ZUNMANAGEDADJUSTMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZADJUSTMENTBASEIMAGEFORMAT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZADJUSTMENTTIMESTAMP TIMESTAMP,
    ZADJUSTMENTFORMATIDENTIFIER VARCHAR,
    ZADJUSTMENTFORMATVERSION VARCHAR,
    ZEDITORLOCALIZEDNAME VARCHAR,
    ZOTHERADJUSTMENTSFINGERPRINT VARCHAR,
    ZSIMILARTOORIGINALADJUSTMENTSFINGERPRINT VARCHAR,
    ZUUID VARCHAR );
CREATE TABLE ZCLOUDMASTERMEDIAMETADATA ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDMASTER INTEGER,
    ZDATA BLOB );
CREATE TABLE ZKEYWORD ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZTITLE VARCHAR,
    ZUUID VARCHAR );
CREATE TABLE ZPERSON ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZFULLNAME VARCHAR,
    ZPERSONUUID VARCHAR );
CREATE INDEX ZCLOUDMASTERMEDIAMETADATA_ZCLOUDMASTER_INDEX ON ZCLOUDMASTERMEDIAMETADATA (ZCLOUDMASTER);
CREATE INDEX ZKEYWORD_ZTITLE_INDEX ON ZKEYWORD (ZTITLE);
CREATE INDEX ZKEYWORD_ZUUID_INDEX ON ZKEYWORD (ZUUID);
CREATE INDEX ZMOMENT_ZENDDATE_INDEX ON ZMOMENT (ZENDDATE);
CREATE INDEX ZMOMENT_ZREPRESENTATIVEDATE_INDEX ON ZMOMENT (ZREPRESENTATIVEDATE);
CREATE INDEX ZMOMENT_ZREVERSELOCATIONDATAISVALID_INDEX ON ZMOMENT (ZREVERSELOCATIONDATAISVALID);
CREATE INDEX ZMOMENT_ZSTARTDATE_INDEX ON ZMOMENT (ZSTARTDATE);
CREATE INDEX ZMOMENT_ZTRASHEDSTATE_INDEX ON ZMOMENT (ZTRASHEDSTATE);
CREATE INDEX ZMOMENT_ZUUID_INDEX ON ZMOMENT (ZUUID);
CREATE INDEX ZMOMENT_ZMEGAMOMENTLIST_INDEX ON ZMOMENT (ZMEGAMOMENTLIST);
CREATE INDEX ZMOMENT_ZMOMENTLIBRARY_INDEX ON ZMOMENT (ZMOMENTLIBRARY);
CREATE INDEX ZMOMENT_ZYEARMOMENTLIST_INDEX ON ZMOMENT (ZYEARMOMENTLIST);
CREATE INDEX ZMOMENT_ZSTARTDATE_ZENDDATE ON ZMOMENT (ZSTARTDATE,
    ZENDDATE);
CREATE INDEX ZMOMENTLIST_ZGRANULARITYLEVEL_INDEX ON ZMOMENTLIST (ZGRANULARITYLEVEL);
CREATE INDEX ZMOMENTLIST_ZREPRESENTATIVEDATE_INDEX ON ZMOMENTLIST (ZREPRESENTATIVEDATE);
CREATE INDEX ZMOMENTLIST_ZREVERSELOCATIONDATAISVALID_INDEX ON ZMOMENTLIST (ZREVERSELOCATIONDATAISVALID);
CREATE INDEX ZMOMENTLIST_ZSORTINDEX_INDEX ON ZMOMENTLIST (ZSORTINDEX);
CREATE INDEX ZMOMENTLIST_ZTRASHEDSTATE_INDEX ON ZMOMENTLIST (ZTRASHEDSTATE);
CREATE INDEX ZMOMENTLIST_ZUUID_INDEX ON ZMOMENTLIST (ZUUID);
CREATE INDEX ZMOMENTLIST_ZGRANULARITYLEVEL_ZSORTINDEX ON ZMOMENTLIST (ZGRANULARITYLEVEL,
    ZSORTINDEX);
CREATE INDEX ZMOMENTLIST_ZREVERSELOCATIONDATAISVALID_ZGRANULARITYLEVEL ON ZMOMENTLIST (ZREVERSELOCATIONDATAISVALID,
    ZGRANULARITYLEVEL);
CREATE INDEX ZPERSONREFERENCE_ZASSETATTRIBUTES_INDEX ON ZPERSONREFERENCE (ZASSETATTRIBUTES);
CREATE INDEX ZPERSONREFERENCE_ZPERSON_INDEX ON ZPERSONREFERENCE (ZPERSON);
CREATE INDEX ZUNMANAGEDADJUSTMENT_ZASSETATTRIBUTES_INDEX ON ZUNMANAGEDADJUSTMENT (ZASSETATTRIBUTES);
CREATE TABLE Z_1KEYWORDS ( Z_1ASSETATTRIBUTES INTEGER,
    Z_25KEYWORDS INTEGER,
    PRIMARY KEY (Z_1ASSETATTRIBUTES,
    Z_25KEYWORDS) );
CREATE TABLE ZGENERICALBUM ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCACHEDCOUNT INTEGER,
    ZCACHEDPHOTOSCOUNT INTEGER,
    ZCACHEDVIDEOSCOUNT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDSERVERSTATE INTEGER,
    ZCUSTOMSORTASCENDING INTEGER,
    ZCUSTOMSORTKEY INTEGER,
    ZISPINNED INTEGER,
    ZKIND INTEGER,
    ZPENDINGITEMSCOUNT INTEGER,
    ZPENDINGITEMSTYPE INTEGER,
    ZSYNCEVENTORDERKEY INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZCUSTOMKEYASSET INTEGER,
    Z22_CUSTOMKEYASSET INTEGER,
    ZKEYASSET INTEGER,
    Z22_KEYASSET INTEGER,
    ZPARENTFOLDER INTEGER,
    ZSECONDARYKEYASSET INTEGER,
    Z22_SECONDARYKEYASSET INTEGER,
    ZTERTIARYKEYASSET INTEGER,
    Z22_TERTIARYKEYASSET INTEGER,
    ZCLOUDALBUMSUBTYPE INTEGER,
    ZCLOUDMULTIPLECONTRIBUTORSENABLED INTEGER,
    ZCLOUDMULTIPLECONTRIBUTORSENABLEDLOCAL INTEGER,
    ZCLOUDNOTIFICATIONSENABLED INTEGER,
    ZCLOUDOWNEREMAILKEY INTEGER,
    ZCLOUDPUBLICURLENABLED INTEGER,
    ZCLOUDPUBLICURLENABLEDLOCAL INTEGER,
    ZCLOUDRELATIONSHIPSTATE INTEGER,
    ZCLOUDRELATIONSHIPSTATELOCAL INTEGER,
    ZHASUNSEENCONTENT INTEGER,
    ZISOWNED INTEGER,
    ZUNSEENASSETSCOUNT INTEGER,
    ZKEYASSETFACEIDENTIFIER INTEGER,
    ZKEYASSETFACETHUMBNAILINDEX INTEGER,
    ZWALLPAPERALBUMTYPE INTEGER,
    Z_FOK_PARENTFOLDER INTEGER,
    ZENDDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTRASHEDDATE TIMESTAMP,
    ZCLOUDCREATIONDATE TIMESTAMP,
    ZCLOUDLASTCONTRIBUTIONDATE TIMESTAMP,
    ZCLOUDLASTINTERESTINGCHANGEDATE TIMESTAMP,
    ZCLOUDSUBSCRIPTIONDATE TIMESTAMP,
    ZCLOUDGUID VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZTITLE VARCHAR,
    ZUUID VARCHAR,
    ZCLOUDOWNERFIRSTNAME VARCHAR,
    ZCLOUDOWNERFULLNAME VARCHAR,
    ZCLOUDOWNERHASHEDPERSONID VARCHAR,
    ZCLOUDOWNERLASTNAME VARCHAR,
    ZCLOUDPERSONID VARCHAR,
    ZPUBLICURL VARCHAR,
    ZCUSTOMQUERYTYPE VARCHAR,
    ZCLOUDMETADATA BLOB,
    ZCUSTOMQUERYPARAMETERS BLOB );
CREATE TABLE Z_14ALBUMLISTS ( Z_14ALBUMS INTEGER,
    Z_3ALBUMLISTS INTEGER,
    Z_FOK_14ALBUMS INTEGER,
    PRIMARY KEY (Z_14ALBUMS,
    Z_3ALBUMLISTS) );
CREATE TABLE Z_15ASSETS ( Z_15ALBUMS INTEGER,
    Z_22ASSETS INTEGER,
    Z_FOK_22ASSETS INTEGER,
    PRIMARY KEY (Z_15ALBUMS,
    Z_22ASSETS) );
CREATE TABLE ZFACE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZASSET INTEGER,
    Z22_ASSET INTEGER,
    ZALBUMUUID VARCHAR,
    ZRELATIVERECTVALUE BLOB );
CREATE TABLE ZCLOUDSHAREDCOMMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZISBATCHCOMMENT INTEGER,
    ZISCAPTION INTEGER,
    ZISDELETABLE INTEGER,
    ZISLIKE INTEGER,
    ZISMYCOMMENT INTEGER,
    ZCLOUDFEEDCOMMENTENTRY INTEGER,
    ZCLOUDFEEDLIKECOMMENTENTRY INTEGER,
    ZCOMMENTEDASSET INTEGER,
    Z22_COMMENTEDASSET INTEGER,
    ZLIKEDASSET INTEGER,
    Z22_LIKEDASSET INTEGER,
    Z_FOK_LIKEDASSET INTEGER,
    Z_FOK_CLOUDFEEDCOMMENTENTRY INTEGER,
    Z_FOK_COMMENTEDASSET INTEGER,
    Z_FOK_CLOUDFEEDLIKECOMMENTENTRY INTEGER,
    ZCOMMENTCLIENTDATE TIMESTAMP,
    ZCOMMENTDATE TIMESTAMP,
    ZCLOUDGUID VARCHAR,
    ZCOMMENTTEXT VARCHAR,
    ZCOMMENTTYPE VARCHAR,
    ZCOMMENTERHASHEDPERSONID VARCHAR );
CREATE TABLE ZSEARCHDATA ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZVALID INTEGER,
    ZASSET INTEGER,
    Z22_ASSET INTEGER,
    ZDATA BLOB );
CREATE TABLE ZADJUSTMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZASSET INTEGER,
    Z22_ASSET INTEGER,
    Z_FOK_ASSET INTEGER,
    ZFILTERNAME VARCHAR,
    ZFILTERSETTINGS BLOB );
CREATE TABLE ZALBUMLIST ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZNEEDSREORDERINGNUMBER INTEGER,
    ZUUID VARCHAR );
CREATE TABLE ZSIDECARFILE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCOMPRESSEDSIZE INTEGER,
    ZINDEX INTEGER,
    ZASSET INTEGER,
    Z22_ASSET INTEGER,
    ZCAPTUREDATE TIMESTAMP,
    ZMODIFICATIONDATE TIMESTAMP,
    ZFILENAME VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE INDEX Z_1KEYWORDS_Z_25KEYWORDS_INDEX ON Z_1KEYWORDS (Z_25KEYWORDS,
    Z_1ASSETATTRIBUTES);
CREATE INDEX ZADJUSTMENT_ZASSET_INDEX ON ZADJUSTMENT (ZASSET);
CREATE INDEX ZALBUMLIST_ZIDENTIFIER_INDEX ON ZALBUMLIST (ZIDENTIFIER);
CREATE INDEX ZALBUMLIST_ZUUID_INDEX ON ZALBUMLIST (ZUUID);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDGUID_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDGUID);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDFEEDCOMMENTENTRY_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDFEEDCOMMENTENTRY);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDFEEDLIKECOMMENTENTRY_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDFEEDLIKECOMMENTENTRY);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCOMMENTEDASSET_INDEX ON ZCLOUDSHAREDCOMMENT (ZCOMMENTEDASSET);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZLIKEDASSET_INDEX ON ZCLOUDSHAREDCOMMENT (ZLIKEDASSET);
CREATE INDEX ZFACE_ZALBUMUUID_INDEX ON ZFACE (ZALBUMUUID);
CREATE INDEX ZFACE_ZIDENTIFIER_INDEX ON ZFACE (ZIDENTIFIER);
CREATE INDEX ZFACE_ZASSET_INDEX ON ZFACE (ZASSET);
CREATE INDEX ZGENERICALBUM_ZCLOUDGUID_INDEX ON ZGENERICALBUM (ZCLOUDGUID);
CREATE INDEX ZGENERICALBUM_ZCLOUDSERVERSTATE_INDEX ON ZGENERICALBUM (ZCLOUDSERVERSTATE);
CREATE INDEX ZGENERICALBUM_ZKIND_INDEX ON ZGENERICALBUM (ZKIND);
CREATE INDEX ZGENERICALBUM_ZSYNCEVENTORDERKEY_INDEX ON ZGENERICALBUM (ZSYNCEVENTORDERKEY);
CREATE INDEX ZGENERICALBUM_ZUUID_INDEX ON ZGENERICALBUM (ZUUID);
CREATE INDEX ZGENERICALBUM_ZCUSTOMKEYASSET_INDEX ON ZGENERICALBUM (ZCUSTOMKEYASSET);
CREATE INDEX ZGENERICALBUM_ZKEYASSET_INDEX ON ZGENERICALBUM (ZKEYASSET);
CREATE INDEX ZGENERICALBUM_ZPARENTFOLDER_INDEX ON ZGENERICALBUM (ZPARENTFOLDER);
CREATE INDEX ZGENERICALBUM_ZSECONDARYKEYASSET_INDEX ON ZGENERICALBUM (ZSECONDARYKEYASSET);
CREATE INDEX ZGENERICALBUM_ZTERTIARYKEYASSET_INDEX ON ZGENERICALBUM (ZTERTIARYKEYASSET);
CREATE INDEX ZGENERICALBUM_ZWALLPAPERALBUMTYPE_INDEX ON ZGENERICALBUM (ZWALLPAPERALBUMTYPE);
CREATE INDEX Z_14ALBUMLISTS_Z_3ALBUMLISTS_INDEX ON Z_14ALBUMLISTS (Z_3ALBUMLISTS,
    Z_14ALBUMS);
CREATE INDEX ZGENERICALBUM_Z_ENT_INDEX ON ZGENERICALBUM (Z_ENT);
CREATE INDEX ZGENERICALBUM_ZCLOUDLOCALSTATE_ZCLOUDSERVERSTATE ON ZGENERICALBUM (ZCLOUDLOCALSTATE,
    ZCLOUDSERVERSTATE);
CREATE INDEX Z_15ASSETS_Z_22ASSETS_INDEX ON Z_15ASSETS (Z_22ASSETS,
    Z_15ALBUMS);
CREATE INDEX ZSEARCHDATA_ZVALID_INDEX ON ZSEARCHDATA (ZVALID);
CREATE INDEX ZSEARCHDATA_ZASSET_INDEX ON ZSEARCHDATA (ZASSET);
CREATE INDEX ZSIDECARFILE_ZASSET_INDEX ON ZSIDECARFILE (ZASSET);
CREATE TABLE Z_PRIMARYKEY (Z_ENT INTEGER PRIMARY KEY,
    Z_NAME VARCHAR,
    Z_SUPER INTEGER,
    Z_MAX INTEGER);
CREATE TABLE ZGENERICASSET ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZAVALANCHEPICKTYPE INTEGER,
    ZCLOUDDOWNLOADREQUESTS INTEGER,
    ZCLOUDHASCOMMENTSBYME INTEGER,
    ZCLOUDHASCOMMENTSCONVERSATION INTEGER,
    ZCLOUDHASUNSEENCOMMENTS INTEGER,
    ZCLOUDISDELETABLE INTEGER,
    ZCLOUDISMYASSET INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDPLACEHOLDERKIND INTEGER,
    ZCOMPLETE INTEGER,
    ZFAVORITE INTEGER,
    ZHASADJUSTMENTS INTEGER,
    ZHEIGHT INTEGER,
    ZHIDDEN INTEGER,
    ZHIGHDYNAMICRANGETYPE INTEGER,
    ZKIND INTEGER,
    ZKINDSUBTYPE INTEGER,
    ZORIENTATION INTEGER,
    ZSAVEDASSETTYPE INTEGER,
    ZTHUMBNAILINDEX INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZVIDEOCPDURATIONVALUE INTEGER,
    ZVIDEOCPVISIBILITYSTATE INTEGER,
    ZVISIBILITYSTATE INTEGER,
    ZWIDTH INTEGER,
    ZADDITIONALATTRIBUTES INTEGER,
    ZCLOUDFEEDASSETSENTRY INTEGER,
    ZMASTER INTEGER,
    ZMOMENT INTEGER,
    ZSEARCHDATA INTEGER,
    Z_FOK_MOMENT INTEGER,
    Z_FOK_CLOUDFEEDASSETSENTRY INTEGER,
    ZADDEDDATE TIMESTAMP,
    ZADJUSTMENTTIMESTAMP TIMESTAMP,
    ZCLOUDBATCHPUBLISHDATE TIMESTAMP,
    ZCLOUDLASTVIEWEDCOMMENTDATE TIMESTAMP,
    ZCLOUDSERVERPUBLISHDATE TIMESTAMP,
    ZDATECREATED TIMESTAMP,
    ZDURATION FLOAT,
    ZLASTSHAREDDATE TIMESTAMP,
    ZMODIFICATIONDATE TIMESTAMP,
    ZSORTTOKEN FLOAT,
    ZTRASHEDDATE TIMESTAMP,
    ZAVALANCHEUUID VARCHAR,
    ZCLOUDASSETGUID VARCHAR,
    ZCLOUDBATCHID VARCHAR,
    ZCLOUDCOLLECTIONGUID VARCHAR,
    ZCLOUDOWNERHASHEDPERSONID VARCHAR,
    ZDIRECTORY VARCHAR,
    ZFILENAME VARCHAR,
    ZMEDIAGROUPUUID VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR,
    ZUUID VARCHAR,
    ZLOCATIONDATA BLOB,
    ZIMAGEURLDATA BLOB,
    ZTHUMBNAILURLDATA BLOB,
    ZWALLPAPEROPTIONSDATA BLOB );
CREATE INDEX ZGENERICASSET_ZADDEDDATE_INDEX ON ZGENERICASSET (ZADDEDDATE);
CREATE INDEX ZGENERICASSET_ZAVALANCHEPICKTYPE_INDEX ON ZGENERICASSET (ZAVALANCHEPICKTYPE);
CREATE INDEX ZGENERICASSET_ZAVALANCHEUUID_INDEX ON ZGENERICASSET (ZAVALANCHEUUID);
CREATE INDEX ZGENERICASSET_ZCLOUDASSETGUID_INDEX ON ZGENERICASSET (ZCLOUDASSETGUID);
CREATE INDEX ZGENERICASSET_ZCLOUDLOCALSTATE_INDEX ON ZGENERICASSET (ZCLOUDLOCALSTATE);
CREATE INDEX ZGENERICASSET_ZCLOUDPLACEHOLDERKIND_INDEX ON ZGENERICASSET (ZCLOUDPLACEHOLDERKIND);
CREATE INDEX ZGENERICASSET_ZCOMPLETE_INDEX ON ZGENERICASSET (ZCOMPLETE);
CREATE INDEX ZGENERICASSET_ZDATECREATED_INDEX ON ZGENERICASSET (ZDATECREATED);
CREATE INDEX ZGENERICASSET_ZFAVORITE_INDEX ON ZGENERICASSET (ZFAVORITE);
CREATE INDEX ZGENERICASSET_ZKIND_INDEX ON ZGENERICASSET (ZKIND);
CREATE INDEX ZGENERICASSET_ZKINDSUBTYPE_INDEX ON ZGENERICASSET (ZKINDSUBTYPE);
CREATE INDEX ZGENERICASSET_ZLASTSHAREDDATE_INDEX ON ZGENERICASSET (ZLASTSHAREDDATE);
CREATE INDEX ZGENERICASSET_ZMEDIAGROUPUUID_INDEX ON ZGENERICASSET (ZMEDIAGROUPUUID);
CREATE INDEX ZGENERICASSET_ZSAVEDASSETTYPE_INDEX ON ZGENERICASSET (ZSAVEDASSETTYPE);
CREATE INDEX ZGENERICASSET_ZSORTTOKEN_INDEX ON ZGENERICASSET (ZSORTTOKEN);
CREATE INDEX ZGENERICASSET_ZUUID_INDEX ON ZGENERICASSET (ZUUID);
CREATE INDEX ZGENERICASSET_ZVISIBILITYSTATE_INDEX ON ZGENERICASSET (ZVISIBILITYSTATE);
CREATE INDEX ZGENERICASSET_ZADDITIONALATTRIBUTES_INDEX ON ZGENERICASSET (ZADDITIONALATTRIBUTES);
CREATE INDEX ZGENERICASSET_ZCLOUDFEEDASSETSENTRY_INDEX ON ZGENERICASSET (ZCLOUDFEEDASSETSENTRY);
CREATE INDEX ZGENERICASSET_ZMASTER_INDEX ON ZGENERICASSET (ZMASTER);
CREATE INDEX ZGENERICASSET_ZMOMENT_INDEX ON ZGENERICASSET (ZMOMENT);
CREATE INDEX ZGENERICASSET_ZSEARCHDATA_INDEX ON ZGENERICASSET (ZSEARCHDATA);
CREATE INDEX ZGENERICASSET_Z_ENT_INDEX ON ZGENERICASSET (Z_ENT);
CREATE INDEX ZGENERICASSET_ZKIND_Z_ENT ON ZGENERICASSET (ZKIND,
    Z_ENT);
CREATE INDEX ZGENERICASSET_ZCLOUDASSETGUID_ZSAVEDASSETTYPE ON ZGENERICASSET (ZCLOUDASSETGUID,
    ZSAVEDASSETTYPE);
CREATE INDEX ZGENERICASSET_ZDIRECTORY_ZFILENAME ON ZGENERICASSET (ZDIRECTORY,
    ZFILENAME);
CREATE INDEX ZGENERICASSET_ZCLOUDLOCALSTATE ON ZGENERICASSET (ZCLOUDLOCALSTATE);
CREATE INDEX ZGENERICASSET_ZHIDDEN_ZVISIBILITYSTATE ON ZGENERICASSET (ZHIDDEN,
    ZVISIBILITYSTATE);
CREATE INDEX ZGENERICASSET_ZTRASHEDSTATE_ZTRASHEDDATE ON ZGENERICASSET (ZTRASHEDSTATE,
    ZTRASHEDDATE);
CREATE INDEX ZGENERICASSET_ZADDEDDATE_ZSORTTOKEN ON ZGENERICASSET (ZADDEDDATE,
    ZSORTTOKEN);
CREATE INDEX ZGENERICASSET_ZADDEDDATE_ZSORTTOKEN_ZKIND_ZSAVEDASSETTYPE_ZVISIBILITYSTATE_ZTRASHEDSTATE_ZHIDDEN_ZAVALANCHEPICKTYPE_ZCOMPLETE_Z_ENT ON ZGENERICASSET (ZADDEDDATE,
    ZSORTTOKEN,
    ZKIND,
    ZSAVEDASSETTYPE,
    ZVISIBILITYSTATE,
    ZTRASHEDSTATE,
    ZHIDDEN,
    ZAVALANCHEPICKTYPE,
    ZCOMPLETE,
    Z_ENT);
CREATE TABLE ZADDITIONALASSETATTRIBUTES ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCAMERACAPTUREDEVICE INTEGER,
    ZCLOUDAVALANCHEPICKTYPE INTEGER,
    ZCLOUDKINDSUBTYPE INTEGER,
    ZEMBEDDEDTHUMBNAILHEIGHT INTEGER,
    ZEMBEDDEDTHUMBNAILLENGTH INTEGER,
    ZEMBEDDEDTHUMBNAILOFFSET INTEGER,
    ZEMBEDDEDTHUMBNAILWIDTH INTEGER,
    ZEXTERNALUSAGEINTENT INTEGER,
    ZLOCATIONHASH INTEGER,
    ZORIGINALFILESIZE INTEGER,
    ZORIGINALHEIGHT INTEGER,
    ZORIGINALORIENTATION INTEGER,
    ZORIGINALRESOURCECHOICE INTEGER,
    ZORIGINALWIDTH INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZSHIFTEDLOCATIONISVALID INTEGER,
    ZTIMEZONEOFFSET INTEGER,
    ZUPLOADATTEMPTS INTEGER,
    ZVIDEOCPDISPLAYTIMESCALE INTEGER,
    ZVIDEOCPDISPLAYVALUE INTEGER,
    ZVIDEOCPDURATIONTIMESCALE INTEGER,
    ZASSET INTEGER,
    Z22_ASSET INTEGER,
    ZASSETDESCRIPTION INTEGER,
    ZUNMANAGEDADJUSTMENT INTEGER,
    ZLASTUPLOADATTEMPTDATE TIMESTAMP,
    ZADJUSTEDFINGERPRINT VARCHAR,
    ZCREATORBUNDLEID VARCHAR,
    ZCUSTOMCOLLECTIONNAME VARCHAR,
    ZCUSTOMCOLLECTIONUUID VARCHAR,
    ZCUSTOMMOMENTNAME VARCHAR,
    ZCUSTOMMOMENTUUID VARCHAR,
    ZEDITORBUNDLEID VARCHAR,
    ZEXIFTIMESTAMPSTRING VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZMASTERFINGERPRINT VARCHAR,
    ZORIGINALASSETSUUID VARCHAR,
    ZORIGINALCOLORSPACE VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZORIGINALPATH VARCHAR,
    ZPUBLICGLOBALUUID VARCHAR,
    ZTIMEZONENAME VARCHAR,
    ZTITLE VARCHAR,
    ZFACEREGIONS BLOB,
    ZORIGINALHASH BLOB,
    ZPLACEANNOTATIONDATA BLOB,
    ZREVERSELOCATIONDATA BLOB,
    ZSHIFTEDLOCATIONDATA BLOB );
CREATE TABLE ZCLOUDMASTER ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDSERVERSTATE INTEGER,
    ZFULLSIZEJPEGSOURCE INTEGER,
    ZORIGINALORIENTATION INTEGER,
    ZMEDIAMETADATA INTEGER,
    ZCREATIONDATE TIMESTAMP,
    ZIMPORTDATE TIMESTAMP,
    ZASSETUUID VARCHAR,
    ZCLOUDMASTERGUID VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZMEDIAMETADATATYPE VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE TABLE ZCLOUDRESOURCE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZFILESIZE INTEGER,
    ZHEIGHT INTEGER,
    ZISAVAILABLE INTEGER,
    ZISLOCALLYAVAILABLE INTEGER,
    ZPREFETCHCOUNT INTEGER,
    ZTYPE INTEGER,
    ZWIDTH INTEGER,
    ZASSET INTEGER,
    Z22_ASSET INTEGER,
    ZCLOUDMASTER INTEGER,
    ZDATECREATED TIMESTAMP,
    ZLASTONDEMANDDOWNLOADDATE TIMESTAMP,
    ZLASTPREFETCHDATE TIMESTAMP,
    ZPRUNEDAT TIMESTAMP,
    ZASSETUUID VARCHAR,
    ZFILEPATH VARCHAR,
    ZFINGERPRINT VARCHAR,
    ZITEMIDENTIFIER VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZADJUSTEDFINGERPRINT_INDEX ON ZADDITIONALASSETATTRIBUTES (ZADJUSTEDFINGERPRINT);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZCAMERACAPTUREDEVICE_INDEX ON ZADDITIONALASSETATTRIBUTES (ZCAMERACAPTUREDEVICE);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZCREATORBUNDLEID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZCREATORBUNDLEID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZLOCATIONHASH_INDEX ON ZADDITIONALASSETATTRIBUTES (ZLOCATIONHASH);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZMASTERFINGERPRINT_INDEX ON ZADDITIONALASSETATTRIBUTES (ZMASTERFINGERPRINT);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZORIGINALASSETSUUID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZORIGINALASSETSUUID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZORIGINALHASH_INDEX ON ZADDITIONALASSETATTRIBUTES (ZORIGINALHASH);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZPUBLICGLOBALUUID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZPUBLICGLOBALUUID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZREVERSELOCATIONDATAISVALID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZREVERSELOCATIONDATAISVALID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZSHIFTEDLOCATIONISVALID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZSHIFTEDLOCATIONISVALID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZUPLOADATTEMPTS_INDEX ON ZADDITIONALASSETATTRIBUTES (ZUPLOADATTEMPTS);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZASSET_INDEX ON ZADDITIONALASSETATTRIBUTES (ZASSET);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZASSETDESCRIPTION_INDEX ON ZADDITIONALASSETATTRIBUTES (ZASSETDESCRIPTION);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZUNMANAGEDADJUSTMENT_INDEX ON ZADDITIONALASSETATTRIBUTES (ZUNMANAGEDADJUSTMENT);
CREATE INDEX ZCLOUDMASTER_ZCLOUDLOCALSTATE_INDEX ON ZCLOUDMASTER (ZCLOUDLOCALSTATE);
CREATE INDEX ZCLOUDMASTER_ZCLOUDMASTERGUID_INDEX ON ZCLOUDMASTER (ZCLOUDMASTERGUID);
CREATE INDEX ZCLOUDMASTER_ZCLOUDSERVERSTATE_INDEX ON ZCLOUDMASTER (ZCLOUDSERVERSTATE);
CREATE INDEX ZCLOUDMASTER_ZMEDIAMETADATA_INDEX ON ZCLOUDMASTER (ZMEDIAMETADATA);
CREATE INDEX ZCLOUDRESOURCE_ZASSETUUID_INDEX ON ZCLOUDRESOURCE (ZASSETUUID);
CREATE INDEX ZCLOUDRESOURCE_ZDATECREATED_INDEX ON ZCLOUDRESOURCE (ZDATECREATED);
CREATE INDEX ZCLOUDRESOURCE_ZFINGERPRINT_INDEX ON ZCLOUDRESOURCE (ZFINGERPRINT);
CREATE INDEX ZCLOUDRESOURCE_ZISAVAILABLE_INDEX ON ZCLOUDRESOURCE (ZISAVAILABLE);
CREATE INDEX ZCLOUDRESOURCE_ZISLOCALLYAVAILABLE_INDEX ON ZCLOUDRESOURCE (ZISLOCALLYAVAILABLE);
CREATE INDEX ZCLOUDRESOURCE_ZLASTONDEMANDDOWNLOADDATE_INDEX ON ZCLOUDRESOURCE (ZLASTONDEMANDDOWNLOADDATE);
CREATE INDEX ZCLOUDRESOURCE_ZLASTPREFETCHDATE_INDEX ON ZCLOUDRESOURCE (ZLASTPREFETCHDATE);
CREATE INDEX ZCLOUDRESOURCE_ZPREFETCHCOUNT_INDEX ON ZCLOUDRESOURCE (ZPREFETCHCOUNT);
CREATE INDEX ZCLOUDRESOURCE_ZTYPE_INDEX ON ZCLOUDRESOURCE (ZTYPE);
CREATE INDEX ZCLOUDRESOURCE_ZASSET_INDEX ON ZCLOUDRESOURCE (ZASSET);
CREATE INDEX ZCLOUDRESOURCE_ZCLOUDMASTER_INDEX ON ZCLOUDRESOURCE (ZCLOUDMASTER);
CREATE INDEX RADAR_22158684_INDEX ON Z_15ASSETS (Z_15ALBUMS,
    Z_FOK_22ASSETS,
    Z_22ASSETS);
CREATE INDEX RADAR_10322662_INDEX ON Z_15ASSETS (Z_15ALBUMS,
    Z_22ASSETS,
    Z_FOK_22ASSETS);
CREATE INDEX RADAR_16835859_INDEX ON ZGENERICASSET (ZMOMENT,
    Z_FOK_MOMENT);
CREATE INDEX RADAR_16788878_INDEX ON ZMOMENT (ZMOMENTLIBRARY,
    Z_FOK_MOMENTLIBRARY);
