CREATE TABLE ZADDITIONALASSETATTRIBUTES ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZALLOWEDFORANALYSIS INTEGER,
    ZCAMERACAPTUREDEVICE INTEGER,
    ZCLOUDAVALANCHEPICKTYPE INTEGER,
    ZCLOUDGROUPINGSTATE INTEGER,
    ZCLOUDKINDSUBTYPE INTEGER,
    ZCLOUDRECOVERYSTATE INTEGER,
    ZCLOUDSTATERECOVERYATTEMPTSCOUNT INTEGER,
    ZEMBEDDEDTHUMBNAILHEIGHT INTEGER,
    ZEMBEDDEDTHUMBNAILLENGTH INTEGER,
    ZEMBEDDEDTHUMBNAILOFFSET INTEGER,
    ZEMBEDDEDTHUMBNAILWIDTH INTEGER,
    ZEXTERNALUSAGEINTENT INTEGER,
    ZIMPORTEDBY INTEGER,
    ZLOCATIONHASH INTEGER,
    ZORIGINALFILESIZE INTEGER,
    ZORIGINALHEIGHT INTEGER,
    ZORIGINALORIENTATION INTEGER,
    ZORIGINALRESOURCECHOICE INTEGER,
    ZORIGINALWIDTH INTEGER,
    ZPENDINGPLAYCOUNT INTEGER,
    ZPENDINGSHARECOUNT INTEGER,
    ZPENDINGVIEWCOUNT INTEGER,
    ZPLAYCOUNT INTEGER,
    ZPTPTRASHEDSTATE INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZSCENEANALYSISVERSION INTEGER,
    ZSHARECOUNT INTEGER,
    ZSHIFTEDLOCATIONISVALID INTEGER,
    ZTIMEZONEOFFSET INTEGER,
    ZUPLOADATTEMPTS INTEGER,
    ZVARIATIONSUGGESTIONSTATES INTEGER,
    ZVIDEOCPDISPLAYTIMESCALE INTEGER,
    ZVIDEOCPDISPLAYVALUE INTEGER,
    ZVIDEOCPDURATIONTIMESCALE INTEGER,
    ZVIEWCOUNT INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZASSETDESCRIPTION INTEGER,
    ZUNMANAGEDADJUSTMENT INTEGER,
    ZLASTUPLOADATTEMPTDATE TIMESTAMP,
    ZSCENEANALYSISTIMESTAMP TIMESTAMP,
    ZADJUSTEDFINGERPRINT VARCHAR,
    ZCREATORBUNDLEID VARCHAR,
    ZCUSTOMCOLLECTIONNAME VARCHAR,
    ZCUSTOMCOLLECTIONUUID VARCHAR,
    ZCUSTOMMOMENTNAME VARCHAR,
    ZCUSTOMMOMENTUUID VARCHAR,
    ZEDITORBUNDLEID VARCHAR,
    ZEXIFTIMESTAMPSTRING VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZMASTERFINGERPRINT VARCHAR,
    ZMONTAGE VARCHAR,
    ZORIGINALASSETSUUID VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZORIGINATINGASSETIDENTIFIER VARCHAR,
    ZPUBLICGLOBALUUID VARCHAR,
    ZTIMEZONENAME VARCHAR,
    ZTITLE VARCHAR,
    ZDISTANCEIDENTITY BLOB,
    ZFACEREGIONS BLOB,
    ZORIGINALHASH BLOB,
    ZPLACEANNOTATIONDATA BLOB,
    ZREVERSELOCATIONDATA BLOB,
    ZSHIFTEDLOCATIONDATA BLOB );
CREATE TABLE Z_1KEYWORDS ( Z_1ASSETATTRIBUTES INTEGER,
    Z_30KEYWORDS INTEGER,
    PRIMARY KEY (Z_1ASSETATTRIBUTES,
    Z_30KEYWORDS) );
CREATE TABLE ZADJUSTMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    Z_FOK_ASSET INTEGER,
    ZFILTERNAME VARCHAR,
    ZFILTERSETTINGS BLOB );
CREATE TABLE ZALBUMLIST ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZNEEDSREORDERINGNUMBER INTEGER,
    ZUUID VARCHAR );
CREATE TABLE ZASSETANALYSISSTATE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZANALYSISSTATE INTEGER,
    ZWORKERFLAGS INTEGER,
    ZWORKERTYPE INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZIGNOREUNTILDATE TIMESTAMP,
    ZLASTIGNOREDDATE TIMESTAMP,
    ZSORTTOKEN FLOAT,
    ZASSETUUID VARCHAR );
CREATE TABLE ZASSETDESCRIPTION ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZLONGDESCRIPTION VARCHAR );
CREATE TABLE ZCLOUDFEEDENTRY ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZENTRYPRIORITYNUMBER INTEGER,
    ZENTRYTYPENUMBER INTEGER,
    ZENTRYDATE TIMESTAMP,
    ZENTRYALBUMGUID VARCHAR,
    ZENTRYINVITATIONRECORDGUID VARCHAR,
    ZENTRYCLOUDASSETGUID VARCHAR );
CREATE TABLE ZCLOUDMASTER ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZFULLSIZEJPEGSOURCE INTEGER,
    ZORIGINALORIENTATION INTEGER,
    ZMEDIAMETADATA INTEGER,
    ZCREATIONDATE TIMESTAMP,
    ZIMPORTDATE TIMESTAMP,
    ZCLOUDMASTERGUID VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZMEDIAMETADATATYPE VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZORIGINATINGASSETIDENTIFIER VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE TABLE ZCLOUDMASTERMEDIAMETADATA ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDMASTER INTEGER,
    ZDATA BLOB );
CREATE TABLE ZCLOUDRESOURCE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZFILESIZE INTEGER,
    ZHEIGHT INTEGER,
    ZISAVAILABLE INTEGER,
    ZISLOCALLYAVAILABLE INTEGER,
    ZPREFETCHCOUNT INTEGER,
    ZTYPE INTEGER,
    ZWIDTH INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZCLOUDMASTER INTEGER,
    ZDATECREATED TIMESTAMP,
    ZLASTONDEMANDDOWNLOADDATE TIMESTAMP,
    ZLASTPREFETCHDATE TIMESTAMP,
    ZPRUNEDAT TIMESTAMP,
    ZASSETUUID VARCHAR,
    ZFILEPATH VARCHAR,
    ZFINGERPRINT VARCHAR,
    ZITEMIDENTIFIER VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE TABLE ZCLOUDSHAREDALBUMINVITATIONRECORD ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZINVITATIONSTATE INTEGER,
    ZINVITATIONSTATELOCAL INTEGER,
    ZINVITEEEMAILKEY INTEGER,
    ZISMINE INTEGER,
    ZALBUM INTEGER,
    Z_FOK_ALBUM INTEGER,
    ZINVITEESUBSCRIPTIONDATE TIMESTAMP,
    ZALBUMGUID VARCHAR,
    ZCLOUDGUID VARCHAR,
    ZINVITEEFIRSTNAME VARCHAR,
    ZINVITEEFULLNAME VARCHAR,
    ZINVITEEHASHEDPERSONID VARCHAR,
    ZINVITEELASTNAME VARCHAR );
CREATE TABLE ZCLOUDSHAREDCOMMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZISBATCHCOMMENT INTEGER,
    ZISCAPTION INTEGER,
    ZISDELETABLE INTEGER,
    ZISLIKE INTEGER,
    ZISMYCOMMENT INTEGER,
    ZCLOUDFEEDCOMMENTENTRY INTEGER,
    ZCLOUDFEEDLIKECOMMENTENTRY INTEGER,
    ZCOMMENTEDASSET INTEGER,
    Z27_COMMENTEDASSET INTEGER,
    ZLIKEDASSET INTEGER,
    Z27_LIKEDASSET INTEGER,
    Z_FOK_LIKEDASSET INTEGER,
    Z_FOK_CLOUDFEEDCOMMENTENTRY INTEGER,
    Z_FOK_COMMENTEDASSET INTEGER,
    Z_FOK_CLOUDFEEDLIKECOMMENTENTRY INTEGER,
    ZCOMMENTCLIENTDATE TIMESTAMP,
    ZCOMMENTDATE TIMESTAMP,
    ZCLOUDGUID VARCHAR,
    ZCOMMENTTEXT VARCHAR,
    ZCOMMENTTYPE VARCHAR,
    ZCOMMENTERHASHEDPERSONID VARCHAR );
CREATE TABLE ZDEFERREDREBUILDFACE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDNAMESOURCE INTEGER,
    ZCLUSTERREJECTED INTEGER,
    ZFACEALGORITHMVERSION INTEGER,
    ZHIDDEN INTEGER,
    ZMANUAL INTEGER,
    ZNAMESOURCE INTEGER,
    ZREJECTED INTEGER,
    ZREPRESENTATIVE INTEGER,
    ZCENTERX FLOAT,
    ZCENTERY FLOAT,
    ZSIZE FLOAT,
    ZASSETCLOUDGUID VARCHAR,
    ZASSETUUID VARCHAR,
    ZPERSONUUID VARCHAR );
CREATE TABLE ZDETECTEDFACE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETVISIBLE INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDNAMESOURCE INTEGER,
    ZCLUSTERSEQUENCENUMBER INTEGER,
    ZCONFIRMEDFACECROPGENERATIONSTATE INTEGER,
    ZEXPRESSIONTYPE1 INTEGER,
    ZEXPRESSIONTYPE2 INTEGER,
    ZEXPRESSIONTYPE3 INTEGER,
    ZFACEALGORITHMVERSION INTEGER,
    ZHASSMILE INTEGER,
    ZHIDDEN INTEGER,
    ZISINTRASH INTEGER,
    ZISLEFTEYECLOSED INTEGER,
    ZISRIGHTEYECLOSED INTEGER,
    ZMANUAL INTEGER,
    ZNAMESOURCE INTEGER,
    ZQUALITYMEASURE INTEGER,
    ZSOURCEHEIGHT INTEGER,
    ZSOURCEWIDTH INTEGER,
    ZTRAININGTYPE INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZFACECROP INTEGER,
    ZFACEGROUP INTEGER,
    ZFACEGROUPBEINGKEYFACE INTEGER,
    ZFACEPRINT INTEGER,
    ZPERSON INTEGER,
    ZPERSONBEINGKEYFACE INTEGER,
    ZADJUSTMENTVERSION TIMESTAMP,
    ZBLURSCORE FLOAT,
    ZCENTERX FLOAT,
    ZCENTERY FLOAT,
    ZEXPRESSIONCONFIDENCE FLOAT,
    ZEXPRESSIONSCORE1 FLOAT,
    ZEXPRESSIONSCORE2 FLOAT,
    ZEXPRESSIONSCORE3 FLOAT,
    ZLEFTEYEX FLOAT,
    ZLEFTEYEY FLOAT,
    ZMOUTHX FLOAT,
    ZMOUTHY FLOAT,
    ZPOSEPITCH FLOAT,
    ZPOSEROLL FLOAT,
    ZPOSEYAW FLOAT,
    ZRIGHTEYEX FLOAT,
    ZRIGHTEYEY FLOAT,
    ZSIZE FLOAT,
    ZMASTERIDENTIFIER VARCHAR,
    ZUUID VARCHAR );
CREATE TABLE ZDETECTEDFACEGROUP ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZPERSONBUILDERSTATE INTEGER,
    ZUNNAMEDFACECOUNT INTEGER,
    ZASSOCIATEDPERSON INTEGER,
    ZKEYFACE INTEGER,
    ZUUID VARCHAR );
CREATE TABLE ZDETECTEDFACEPRINT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZFACEPRINTVERSION INTEGER,
    ZFACE INTEGER,
    ZDATA BLOB );
CREATE TABLE ZFACECROP ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDTYPE INTEGER,
    ZSTATE INTEGER,
    ZTYPE INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZFACE INTEGER,
    ZPERSON INTEGER,
    ZINVALIDMERGECANDIDATEPERSONUUID VARCHAR,
    ZUUID VARCHAR,
    ZRESOURCEDATA BLOB );
CREATE TABLE ZGENERICALBUM ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCACHEDCOUNT INTEGER,
    ZCACHEDPHOTOSCOUNT INTEGER,
    ZCACHEDVIDEOSCOUNT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCUSTOMSORTASCENDING INTEGER,
    ZCUSTOMSORTKEY INTEGER,
    ZISPINNED INTEGER,
    ZKIND INTEGER,
    ZPENDINGITEMSCOUNT INTEGER,
    ZPENDINGITEMSTYPE INTEGER,
    ZSYNCEVENTORDERKEY INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZCUSTOMKEYASSET INTEGER,
    Z27_CUSTOMKEYASSET INTEGER,
    ZKEYASSET INTEGER,
    Z27_KEYASSET INTEGER,
    ZPARENTFOLDER INTEGER,
    ZSECONDARYKEYASSET INTEGER,
    Z27_SECONDARYKEYASSET INTEGER,
    ZTERTIARYKEYASSET INTEGER,
    Z27_TERTIARYKEYASSET INTEGER,
    ZCLOUDALBUMSUBTYPE INTEGER,
    ZCLOUDMULTIPLECONTRIBUTORSENABLED INTEGER,
    ZCLOUDMULTIPLECONTRIBUTORSENABLEDLOCAL INTEGER,
    ZCLOUDNOTIFICATIONSENABLED INTEGER,
    ZCLOUDOWNEREMAILKEY INTEGER,
    ZCLOUDOWNERISWHITELISTED INTEGER,
    ZCLOUDPUBLICURLENABLED INTEGER,
    ZCLOUDPUBLICURLENABLEDLOCAL INTEGER,
    ZCLOUDRELATIONSHIPSTATE INTEGER,
    ZCLOUDRELATIONSHIPSTATELOCAL INTEGER,
    ZHASUNSEENCONTENT INTEGER,
    ZISOWNED INTEGER,
    ZUNSEENASSETSCOUNT INTEGER,
    ZKEYASSETFACEIDENTIFIER INTEGER,
    ZKEYASSETFACETHUMBNAILINDEX INTEGER,
    ZWALLPAPERALBUMTYPE INTEGER,
    Z_FOK_PARENTFOLDER INTEGER,
    ZENDDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTRASHEDDATE TIMESTAMP,
    ZCLOUDCREATIONDATE TIMESTAMP,
    ZCLOUDLASTCONTRIBUTIONDATE TIMESTAMP,
    ZCLOUDLASTINTERESTINGCHANGEDATE TIMESTAMP,
    ZCLOUDSUBSCRIPTIONDATE TIMESTAMP,
    ZCLOUDGUID VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZTITLE VARCHAR,
    ZUUID VARCHAR,
    ZCLOUDOWNERFIRSTNAME VARCHAR,
    ZCLOUDOWNERFULLNAME VARCHAR,
    ZCLOUDOWNERHASHEDPERSONID VARCHAR,
    ZCLOUDOWNERLASTNAME VARCHAR,
    ZCLOUDPERSONID VARCHAR,
    ZPUBLICURL VARCHAR,
    ZCUSTOMQUERYTYPE VARCHAR,
    ZCLOUDMETADATA BLOB,
    ZCUSTOMQUERYPARAMETERS BLOB );
CREATE TABLE Z_19ALBUMLISTS ( Z_19ALBUMS INTEGER,
    Z_3ALBUMLISTS INTEGER,
    Z_FOK_19ALBUMS INTEGER,
    PRIMARY KEY (Z_19ALBUMS,
    Z_3ALBUMLISTS) );
CREATE TABLE Z_20ASSETS ( Z_20ALBUMS INTEGER,
    Z_27ASSETS INTEGER,
    Z_FOK_27ASSETS INTEGER,
    PRIMARY KEY (Z_20ALBUMS,
    Z_27ASSETS) );
CREATE TABLE Z_27MEMORIESBEINGEXTENDEDCURATEDASSETS ( Z_27EXTENDEDCURATEDASSETS INTEGER,
    Z_32MEMORIESBEINGEXTENDEDCURATEDASSETS INTEGER,
    PRIMARY KEY (Z_27EXTENDEDCURATEDASSETS,
    Z_32MEMORIESBEINGEXTENDEDCURATEDASSETS) );
CREATE TABLE Z_27MEMORIESBEINGREPRESENTATIVEASSETS ( Z_27REPRESENTATIVEASSETS INTEGER,
    Z_32MEMORIESBEINGREPRESENTATIVEASSETS INTEGER,
    PRIMARY KEY (Z_27REPRESENTATIVEASSETS,
    Z_32MEMORIESBEINGREPRESENTATIVEASSETS) );
CREATE TABLE Z_27MEMORIESBEINGCURATEDASSETS ( Z_27CURATEDASSETS INTEGER,
    Z_32MEMORIESBEINGCURATEDASSETS INTEGER,
    PRIMARY KEY (Z_27CURATEDASSETS,
    Z_32MEMORIESBEINGCURATEDASSETS) );
CREATE TABLE Z_27MEMORIESBEINGMOVIECURATEDASSETS ( Z_27MOVIECURATEDASSETS INTEGER,
    Z_32MEMORIESBEINGMOVIECURATEDASSETS INTEGER,
    PRIMARY KEY (Z_27MOVIECURATEDASSETS,
    Z_32MEMORIESBEINGMOVIECURATEDASSETS) );
CREATE TABLE ZKEYWORD ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZTITLE VARCHAR UNIQUE );
CREATE TABLE ZLEGACYFACE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZALBUMUUID VARCHAR,
    ZRELATIVERECTVALUE BLOB );
CREATE TABLE ZMEMORY ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCATEGORY INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZFAVORITE INTEGER,
    ZNOTIFICATIONSTATE INTEGER,
    ZPENDING INTEGER,
    ZPENDINGPLAYCOUNT INTEGER,
    ZPENDINGSHARECOUNT INTEGER,
    ZPENDINGVIEWCOUNT INTEGER,
    ZPHOTOSGRAPHVERSION INTEGER,
    ZPLAYCOUNT INTEGER,
    ZREJECTED INTEGER,
    ZSHARECOUNT INTEGER,
    ZSUBCATEGORY INTEGER,
    ZUSERCREATED INTEGER,
    ZVIEWCOUNT INTEGER,
    ZKEYASSET INTEGER,
    Z27_KEYASSET INTEGER,
    ZCREATIONDATE TIMESTAMP,
    ZLASTMOVIEPLAYEDDATE TIMESTAMP,
    ZLASTVIEWEDDATE TIMESTAMP,
    ZSCORE FLOAT,
    ZSUBTITLE VARCHAR,
    ZTITLE VARCHAR,
    ZUUID VARCHAR,
    ZMOVIEASSETSTATE BLOB,
    ZASSETLISTPREDICATE BLOB,
    ZBLACKLISTEDFEATURE BLOB,
    ZMOVIEDATA BLOB,
    ZPHOTOSGRAPHDATA BLOB );
CREATE TABLE ZMOMENTLIST ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZGENERATIONTYPE INTEGER,
    ZGRANULARITYLEVEL INTEGER,
    ZREVERSELOCATIONDATACONTAINSLOCATION INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZSORTINDEX INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZENDDATE TIMESTAMP,
    ZREPRESENTATIVEDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTITLE VARCHAR,
    ZTITLE2 VARCHAR,
    ZTITLE3 VARCHAR,
    ZUUID VARCHAR,
    ZREVERSELOCATIONDATA BLOB );
CREATE TABLE ZPERSON ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDVERIFIEDTYPE INTEGER,
    ZFACECOUNT INTEGER,
    ZINPERSONNAMINGMODEL INTEGER,
    ZKEYFACEPICKSOURCE INTEGER,
    ZMANUALORDER INTEGER,
    ZTYPE INTEGER,
    ZVERIFIEDTYPE INTEGER,
    ZASSOCIATEDFACEGROUP INTEGER,
    ZKEYFACE INTEGER,
    ZMERGETARGETPERSON INTEGER,
    ZDISPLAYNAME VARCHAR,
    ZFULLNAME VARCHAR,
    ZPERSONUUID VARCHAR,
    ZPERSONURI VARCHAR,
    ZCONTACTMATCHINGDICTIONARY BLOB );
CREATE TABLE ZPERSONREFERENCE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZPERSON INTEGER,
    ZPERSONUUID VARCHAR,
    ZPERSONDATA BLOB );
CREATE TABLE ZSCENECLASSIFICATION ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZSCENEIDENTIFIER INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZCONFIDENCE FLOAT );
CREATE TABLE ZSEARCHDATA ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZVALID INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZDATA BLOB );
CREATE TABLE ZSIDECARFILE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCOMPRESSEDSIZE INTEGER,
    ZINDEX INTEGER,
    ZPTPTRASHEDSTATE INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZCAPTUREDATE TIMESTAMP,
    ZMODIFICATIONDATE TIMESTAMP,
    ZFILENAME VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE TABLE ZUNMANAGEDADJUSTMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZADJUSTMENTBASEIMAGEFORMAT INTEGER,
    ZADJUSTMENTRENDERTYPES INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZADJUSTMENTTIMESTAMP TIMESTAMP,
    ZADJUSTMENTFORMATIDENTIFIER VARCHAR,
    ZADJUSTMENTFORMATVERSION VARCHAR,
    ZEDITORLOCALIZEDNAME VARCHAR,
    ZOTHERADJUSTMENTSFINGERPRINT VARCHAR,
    ZSIMILARTOORIGINALADJUSTMENTSFINGERPRINT VARCHAR,
    ZUUID VARCHAR );
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZASSET_INDEX ON ZADDITIONALASSETATTRIBUTES (ZASSET);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZASSETDESCRIPTION_INDEX ON ZADDITIONALASSETATTRIBUTES (ZASSETDESCRIPTION);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZUNMANAGEDADJUSTMENT_INDEX ON ZADDITIONALASSETATTRIBUTES (ZUNMANAGEDADJUSTMENT);
CREATE INDEX Z_1KEYWORDS_Z_30KEYWORDS_INDEX ON Z_1KEYWORDS (Z_30KEYWORDS,
    Z_1ASSETATTRIBUTES);
CREATE INDEX ZADJUSTMENT_ZASSET_INDEX ON ZADJUSTMENT (ZASSET);
CREATE INDEX ZASSETANALYSISSTATE_ZASSET_INDEX ON ZASSETANALYSISSTATE (ZASSET);
CREATE INDEX ZASSETDESCRIPTION_ZASSETATTRIBUTES_INDEX ON ZASSETDESCRIPTION (ZASSETATTRIBUTES);
CREATE INDEX ZCLOUDFEEDENTRY_Z_ENT_INDEX ON ZCLOUDFEEDENTRY (Z_ENT);
CREATE INDEX ZCLOUDMASTER_ZMEDIAMETADATA_INDEX ON ZCLOUDMASTER (ZMEDIAMETADATA);
CREATE INDEX ZCLOUDMASTERMEDIAMETADATA_ZCLOUDMASTER_INDEX ON ZCLOUDMASTERMEDIAMETADATA (ZCLOUDMASTER);
CREATE INDEX ZCLOUDRESOURCE_ZASSET_INDEX ON ZCLOUDRESOURCE (ZASSET);
CREATE INDEX ZCLOUDRESOURCE_ZCLOUDMASTER_INDEX ON ZCLOUDRESOURCE (ZCLOUDMASTER);
CREATE INDEX ZCLOUDSHAREDALBUMINVITATIONRECORD_ZALBUM_INDEX ON ZCLOUDSHAREDALBUMINVITATIONRECORD (ZALBUM);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDFEEDCOMMENTENTRY_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDFEEDCOMMENTENTRY);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDFEEDLIKECOMMENTENTRY_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDFEEDLIKECOMMENTENTRY);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCOMMENTEDASSET_INDEX ON ZCLOUDSHAREDCOMMENT (ZCOMMENTEDASSET);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZLIKEDASSET_INDEX ON ZCLOUDSHAREDCOMMENT (ZLIKEDASSET);
CREATE INDEX ZDETECTEDFACE_ZASSET_INDEX ON ZDETECTEDFACE (ZASSET);
CREATE INDEX ZDETECTEDFACE_ZFACECROP_INDEX ON ZDETECTEDFACE (ZFACECROP);
CREATE INDEX ZDETECTEDFACE_ZFACEGROUP_INDEX ON ZDETECTEDFACE (ZFACEGROUP);
CREATE INDEX ZDETECTEDFACE_ZFACEGROUPBEINGKEYFACE_INDEX ON ZDETECTEDFACE (ZFACEGROUPBEINGKEYFACE);
CREATE INDEX ZDETECTEDFACE_ZFACEPRINT_INDEX ON ZDETECTEDFACE (ZFACEPRINT);
CREATE INDEX ZDETECTEDFACE_ZPERSON_INDEX ON ZDETECTEDFACE (ZPERSON);
CREATE INDEX ZDETECTEDFACE_ZPERSONBEINGKEYFACE_INDEX ON ZDETECTEDFACE (ZPERSONBEINGKEYFACE);
CREATE INDEX ZDETECTEDFACEGROUP_ZASSOCIATEDPERSON_INDEX ON ZDETECTEDFACEGROUP (ZASSOCIATEDPERSON);
CREATE INDEX ZDETECTEDFACEGROUP_ZKEYFACE_INDEX ON ZDETECTEDFACEGROUP (ZKEYFACE);
CREATE INDEX ZDETECTEDFACEPRINT_ZFACE_INDEX ON ZDETECTEDFACEPRINT (ZFACE);
CREATE INDEX ZFACECROP_ZASSET_INDEX ON ZFACECROP (ZASSET);
CREATE INDEX ZFACECROP_ZFACE_INDEX ON ZFACECROP (ZFACE);
CREATE INDEX ZFACECROP_ZPERSON_INDEX ON ZFACECROP (ZPERSON);
CREATE INDEX ZGENERICALBUM_ZCUSTOMKEYASSET_INDEX ON ZGENERICALBUM (ZCUSTOMKEYASSET);
CREATE INDEX ZGENERICALBUM_ZKEYASSET_INDEX ON ZGENERICALBUM (ZKEYASSET);
CREATE INDEX ZGENERICALBUM_ZPARENTFOLDER_INDEX ON ZGENERICALBUM (ZPARENTFOLDER);
CREATE INDEX ZGENERICALBUM_ZSECONDARYKEYASSET_INDEX ON ZGENERICALBUM (ZSECONDARYKEYASSET);
CREATE INDEX ZGENERICALBUM_ZTERTIARYKEYASSET_INDEX ON ZGENERICALBUM (ZTERTIARYKEYASSET);
CREATE INDEX Z_19ALBUMLISTS_Z_3ALBUMLISTS_INDEX ON Z_19ALBUMLISTS (Z_3ALBUMLISTS,
    Z_19ALBUMS);
CREATE INDEX ZGENERICALBUM_Z_ENT_INDEX ON ZGENERICALBUM (Z_ENT);
CREATE INDEX Z_20ASSETS_Z_27ASSETS_INDEX ON Z_20ASSETS (Z_27ASSETS,
    Z_20ALBUMS);
CREATE INDEX Z_27MEMORIESBEINGEXTENDEDCURATEDASSETS_Z_32MEMORIESBEINGEXTENDEDCURATEDASSETS_INDEX ON Z_27MEMORIESBEINGEXTENDEDCURATEDASSETS (Z_32MEMORIESBEINGEXTENDEDCURATEDASSETS,
    Z_27EXTENDEDCURATEDASSETS);
CREATE INDEX Z_27MEMORIESBEINGREPRESENTATIVEASSETS_Z_32MEMORIESBEINGREPRESENTATIVEASSETS_INDEX ON Z_27MEMORIESBEINGREPRESENTATIVEASSETS (Z_32MEMORIESBEINGREPRESENTATIVEASSETS,
    Z_27REPRESENTATIVEASSETS);
CREATE INDEX Z_27MEMORIESBEINGCURATEDASSETS_Z_32MEMORIESBEINGCURATEDASSETS_INDEX ON Z_27MEMORIESBEINGCURATEDASSETS (Z_32MEMORIESBEINGCURATEDASSETS,
    Z_27CURATEDASSETS);
CREATE INDEX Z_27MEMORIESBEINGMOVIECURATEDASSETS_Z_32MEMORIESBEINGMOVIECURATEDASSETS_INDEX ON Z_27MEMORIESBEINGMOVIECURATEDASSETS (Z_32MEMORIESBEINGMOVIECURATEDASSETS,
    Z_27MOVIECURATEDASSETS);
CREATE INDEX ZLEGACYFACE_ZASSET_INDEX ON ZLEGACYFACE (ZASSET);
CREATE INDEX ZMEMORY_ZKEYASSET_INDEX ON ZMEMORY (ZKEYASSET);
CREATE INDEX ZPERSON_ZASSOCIATEDFACEGROUP_INDEX ON ZPERSON (ZASSOCIATEDFACEGROUP);
CREATE INDEX ZPERSON_ZKEYFACE_INDEX ON ZPERSON (ZKEYFACE);
CREATE INDEX ZPERSON_ZMERGETARGETPERSON_INDEX ON ZPERSON (ZMERGETARGETPERSON);
CREATE INDEX ZPERSONREFERENCE_ZASSETATTRIBUTES_INDEX ON ZPERSONREFERENCE (ZASSETATTRIBUTES);
CREATE INDEX ZPERSONREFERENCE_ZPERSON_INDEX ON ZPERSONREFERENCE (ZPERSON);
CREATE INDEX ZSCENECLASSIFICATION_ZASSETATTRIBUTES_INDEX ON ZSCENECLASSIFICATION (ZASSETATTRIBUTES);
CREATE INDEX ZSEARCHDATA_ZASSET_INDEX ON ZSEARCHDATA (ZASSET);
CREATE INDEX ZSIDECARFILE_ZASSET_INDEX ON ZSIDECARFILE (ZASSET);
CREATE INDEX ZUNMANAGEDADJUSTMENT_ZASSETATTRIBUTES_INDEX ON ZUNMANAGEDADJUSTMENT (ZASSETATTRIBUTES);
CREATE VIRTUAL TABLE Z_RT_GenericAsset_boundedByRect USING RTREE (Z_PK INTEGER PRIMARY KEY,
    ZLATITUDE_MIN FLOAT,
    ZLATITUDE_MAX FLOAT,
    ZLONGITUDE_MIN FLOAT,
    ZLONGITUDE_MAX FLOAT);
CREATE TABLE IF NOT EXISTS "Z_RT_GenericAsset_boundedByRect_node"(nodeno INTEGER PRIMARY KEY,
    data BLOB);
CREATE TABLE IF NOT EXISTS "Z_RT_GenericAsset_boundedByRect_rowid"(rowid INTEGER PRIMARY KEY,
    nodeno INTEGER);
CREATE TABLE IF NOT EXISTS "Z_RT_GenericAsset_boundedByRect_parent"(nodeno INTEGER PRIMARY KEY,
    parentnode INTEGER);
CREATE TABLE Z_METADATA (Z_VERSION INTEGER PRIMARY KEY,
    Z_UUID VARCHAR(255),
    Z_PLIST BLOB);
CREATE TABLE Z_MODELCACHE (Z_CONTENT BLOB);
CREATE TABLE Z_35MERGECANDIDATES ( Z_35MERGECANDIDATES INTEGER,
    REFLEXIVE INTEGER,
    PRIMARY KEY (Z_35MERGECANDIDATES,
    REFLEXIVE) );
CREATE TABLE Z_35INVALIDMERGECANDIDATES ( Z_35INVALIDMERGECANDIDATES INTEGER,
    REFLEXIVE INTEGER,
    PRIMARY KEY (Z_35INVALIDMERGECANDIDATES,
    REFLEXIVE) );
CREATE TABLE ZMOMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCACHEDCOUNT INTEGER,
    ZCACHEDPHOTOSCOUNT INTEGER,
    ZCACHEDVIDEOSCOUNT INTEGER,
    ZGENERATIONTYPE INTEGER,
    ZREVERSELOCATIONDATACONTAINSLOCATION INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZUSEDLOCATIONSOFINTEREST INTEGER,
    ZMEGAMOMENTLIST INTEGER,
    ZYEARMOMENTLIST INTEGER,
    Z_FOK_MEGAMOMENTLIST INTEGER,
    Z_FOK_YEARMOMENTLIST INTEGER,
    ZENDDATE TIMESTAMP,
    ZMODIFICATIONDATE TIMESTAMP,
    ZREPRESENTATIVEDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTITLE VARCHAR,
    ZTITLE2 VARCHAR,
    ZTITLE3 VARCHAR,
    ZUUID VARCHAR,
    ZAPPROXIMATELOCATIONDATA BLOB,
    ZREVERSELOCATIONDATA BLOB );
CREATE TABLE ZGENERICASSET ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZAVALANCHEPICKTYPE INTEGER,
    ZCLOUDDOWNLOADREQUESTS INTEGER,
    ZCLOUDHASCOMMENTSBYME INTEGER,
    ZCLOUDHASCOMMENTSCONVERSATION INTEGER,
    ZCLOUDHASUNSEENCOMMENTS INTEGER,
    ZCLOUDISDELETABLE INTEGER,
    ZCLOUDISMYASSET INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDPLACEHOLDERKIND INTEGER,
    ZCOMPLETE INTEGER,
    ZCUSTOMRENDEREDVALUE INTEGER,
    ZDEPTHSTATES INTEGER,
    ZFACEAREAPOINTS INTEGER,
    ZFAVORITE INTEGER,
    ZGROUPINGSTATE INTEGER,
    ZHASADJUSTMENTS INTEGER,
    ZHEIGHT INTEGER,
    ZHIDDEN INTEGER,
    ZKIND INTEGER,
    ZKINDSUBTYPE INTEGER,
    ZLOCALRESOURCESSTATE INTEGER,
    ZORIENTATION INTEGER,
    ZPLAYBACKSTYLE INTEGER,
    ZPLAYBACKVARIATION INTEGER,
    ZSAVEDASSETTYPE INTEGER,
    ZTHUMBNAILINDEX INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZVIDEOCPDURATIONVALUE INTEGER,
    ZVIDEOCPVISIBILITYSTATE INTEGER,
    ZVISIBILITYSTATE INTEGER,
    ZWIDTH INTEGER,
    ZADDITIONALATTRIBUTES INTEGER,
    ZCLOUDFEEDASSETSENTRY INTEGER,
    ZMASTER INTEGER,
    ZMOMENT INTEGER,
    ZSEARCHDATA INTEGER,
    Z_FOK_CLOUDFEEDASSETSENTRY INTEGER,
    Z_FOK_MOMENT INTEGER,
    ZADDEDDATE TIMESTAMP,
    ZADJUSTMENTTIMESTAMP TIMESTAMP,
    ZCLOUDBATCHPUBLISHDATE TIMESTAMP,
    ZCLOUDLASTVIEWEDCOMMENTDATE TIMESTAMP,
    ZCLOUDSERVERPUBLISHDATE TIMESTAMP,
    ZCURATIONSCORE FLOAT,
    ZDATECREATED TIMESTAMP,
    ZDURATION FLOAT,
    ZFACEADJUSTMENTVERSION TIMESTAMP,
    ZLASTSHAREDDATE TIMESTAMP,
    ZLATITUDE FLOAT,
    ZLONGITUDE FLOAT,
    ZMODIFICATIONDATE TIMESTAMP,
    ZSORTTOKEN FLOAT,
    ZTRASHEDDATE TIMESTAMP,
    ZAVALANCHEUUID VARCHAR,
    ZCLOUDASSETGUID VARCHAR,
    ZCLOUDBATCHID VARCHAR,
    ZCLOUDCOLLECTIONGUID VARCHAR,
    ZCLOUDOWNERHASHEDPERSONID VARCHAR,
    ZDIRECTORY VARCHAR,
    ZFILENAME VARCHAR,
    ZGROUPINGUUID VARCHAR,
    ZMEDIAGROUPUUID VARCHAR,
    ZORIGINALCOLORSPACE VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR,
    ZUUID VARCHAR,
    ZLOCATIONDATA BLOB,
    ZIMAGEURLDATA BLOB,
    ZTHUMBNAILURLDATA BLOB,
    ZWALLPAPEROPTIONSDATA BLOB );
CREATE TABLE Z_15CLUSTERREJECTEDPERSONS ( Z_15CLUSTERREJECTEDFACES INTEGER,
    Z_35CLUSTERREJECTEDPERSONS INTEGER,
    PRIMARY KEY (Z_15CLUSTERREJECTEDFACES,
    Z_35CLUSTERREJECTEDPERSONS) );
CREATE TABLE Z_15REJECTEDPERSONS ( Z_15REJECTEDFACES INTEGER,
    Z_35REJECTEDPERSONS INTEGER,
    PRIMARY KEY (Z_15REJECTEDFACES,
    Z_35REJECTEDPERSONS) );
CREATE TABLE Z_15REJECTEDPERSONSNEEDINGFACECROPS ( Z_15REJECTEDFACESNEEDINGFACECROPS INTEGER,
    Z_35REJECTEDPERSONSNEEDINGFACECROPS INTEGER,
    PRIMARY KEY (Z_15REJECTEDFACESNEEDINGFACECROPS,
    Z_35REJECTEDPERSONSNEEDINGFACECROPS) );
CREATE INDEX Z_15CLUSTERREJECTEDPERSONS_Z_35CLUSTERREJECTEDPERSONS_INDEX ON Z_15CLUSTERREJECTEDPERSONS (Z_35CLUSTERREJECTEDPERSONS,
    Z_15CLUSTERREJECTEDFACES);
CREATE INDEX Z_15REJECTEDPERSONS_Z_35REJECTEDPERSONS_INDEX ON Z_15REJECTEDPERSONS (Z_35REJECTEDPERSONS,
    Z_15REJECTEDFACES);
CREATE INDEX Z_15REJECTEDPERSONSNEEDINGFACECROPS_Z_35REJECTEDPERSONSNEEDINGFACECROPS_INDEX ON Z_15REJECTEDPERSONSNEEDINGFACECROPS (Z_35REJECTEDPERSONSNEEDINGFACECROPS,
    Z_15REJECTEDFACESNEEDINGFACECROPS);
CREATE INDEX ZGENERICASSET_ZADDITIONALATTRIBUTES_INDEX ON ZGENERICASSET (ZADDITIONALATTRIBUTES);
CREATE INDEX ZGENERICASSET_ZCLOUDFEEDASSETSENTRY_INDEX ON ZGENERICASSET (ZCLOUDFEEDASSETSENTRY);
CREATE INDEX ZGENERICASSET_ZMASTER_INDEX ON ZGENERICASSET (ZMASTER);
CREATE INDEX ZGENERICASSET_ZMOMENT_INDEX ON ZGENERICASSET (ZMOMENT);
CREATE INDEX ZGENERICASSET_ZSEARCHDATA_INDEX ON ZGENERICASSET (ZSEARCHDATA);
CREATE INDEX ZGENERICASSET_Z_ENT_INDEX ON ZGENERICASSET (Z_ENT);
CREATE INDEX ZMOMENT_ZMEGAMOMENTLIST_INDEX ON ZMOMENT (ZMEGAMOMENTLIST);
CREATE INDEX ZMOMENT_ZYEARMOMENTLIST_INDEX ON ZMOMENT (ZYEARMOMENTLIST);
CREATE INDEX Z_35MERGECANDIDATES_REFLEXIVE_INDEX ON Z_35MERGECANDIDATES (REFLEXIVE,
    Z_35MERGECANDIDATES);
CREATE INDEX Z_35INVALIDMERGECANDIDATES_REFLEXIVE_INDEX ON Z_35INVALIDMERGECANDIDATES (REFLEXIVE,
    Z_35INVALIDMERGECANDIDATES);
CREATE TABLE Z_PRIMARYKEY (Z_ENT INTEGER PRIMARY KEY,
    Z_NAME VARCHAR,
    Z_SUPER INTEGER,
    Z_MAX INTEGER);
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_INSERT_INCREMENT AFTER INSERT ON ZGENERICASSET FOR EACH ROW WHEN NEW.ZTRASHEDSTATE == 0 AND NEW.ZVISIBILITYSTATE == 0 AND NEW.ZHIDDEN == 0 BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = IFNULL(ZASSETVISIBLE,0) + 1 WHERE NEW.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_UPDATE_INCREMENT AFTER UPDATE OF ZTRASHEDSTATE,
    ZVISIBILITYSTATE,
    ZHIDDEN ON ZGENERICASSET FOR EACH ROW WHEN (NEW.ZTRASHEDSTATE == 0 AND NEW.ZVISIBILITYSTATE == 0 AND NEW.ZHIDDEN == 0) AND (NEW.ZTRASHEDSTATE != OLD.ZTRASHEDSTATE OR NEW.ZVISIBILITYSTATE != OLD.ZVISIBILITYSTATE OR NEW.ZHIDDEN != OLD.ZHIDDEN) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = IFNULL(ZASSETVISIBLE,0) + 1 WHERE NEW.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_UPDATE_DECREMENT AFTER UPDATE OF ZTRASHEDSTATE,
    ZVISIBILITYSTATE,
    ZHIDDEN ON ZGENERICASSET FOR EACH ROW WHEN (OLD.ZTRASHEDSTATE == 0 AND OLD.ZVISIBILITYSTATE == 0 AND OLD.ZHIDDEN == 0) AND (NEW.ZTRASHEDSTATE != OLD.ZTRASHEDSTATE OR NEW.ZVISIBILITYSTATE != OLD.ZVISIBILITYSTATE OR NEW.ZHIDDEN != OLD.ZHIDDEN) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = MAX(0,IFNULL(ZASSETVISIBLE,0) - 1) WHERE OLD.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_DELETE_DECREMENT AFTER DELETE ON ZGENERICASSET FOR EACH ROW WHEN OLD.ZTRASHEDSTATE == 0 AND OLD.ZVISIBILITYSTATE == 0 AND OLD.ZHIDDEN == 0 BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = MAX(0,IFNULL(ZASSETVISIBLE,0) - 1) WHERE OLD.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = OLD.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_ZDETECTEDFACE_INSERT_INCREMENT AFTER INSERT ON ZDETECTEDFACE FOR EACH ROW BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = (SELECT COUNT(Z_PK) FROM ZGENERICASSET WHERE (Z_PK = NEW.ZASSET) AND (ZTRASHEDSTATE == 0 AND ZVISIBILITYSTATE == 0 AND ZHIDDEN == 0)) WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE Z_PK = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_ZASSET_UPDATE_TO_NULL AFTER UPDATE OF ZASSET ON ZDETECTEDFACE WHEN (NEW.ZASSET IS NULL AND OLD.ZASSET IS NOT NULL) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = 0 WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE Z_PK = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_ZASSET_UPDATE_INCREMENT AFTER UPDATE OF ZASSET ON ZDETECTEDFACE WHEN ((NEW.ZASSET IS NOT NULL AND OLD.ZASSET IS NULL) OR (NEW.ZASSET != OLD.ZASSET)) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = (SELECT COUNT(Z_PK) FROM ZGENERICASSET WHERE Z_PK = NEW.ZASSET AND (ZTRASHEDSTATE == 0 AND ZVISIBILITYSTATE == 0 AND ZHIDDEN == 0)) WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE Z_PK = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_INSERT_INCREMENT AFTER INSERT ON ZDETECTEDFACE FOR EACH ROW WHEN NEW.ZHIDDEN == 0 AND NEW.ZASSETVISIBLE == 1 BEGIN UPDATE ZPERSON SET ZFACECOUNT = IFNULL(ZFACECOUNT,0) + 1 WHERE NEW.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_UPDATE_INCREMENT AFTER UPDATE OF ZHIDDEN,
    ZASSETVISIBLE ON ZDETECTEDFACE FOR EACH ROW WHEN (NEW.ZHIDDEN == 0 AND NEW.ZASSETVISIBLE == 1) AND (NEW.ZHIDDEN != OLD.ZHIDDEN OR NEW.ZASSETVISIBLE != OLD.ZASSETVISIBLE) AND (NEW.ZPERSON == OLD.ZPERSON) BEGIN UPDATE ZPERSON SET ZFACECOUNT = IFNULL(ZFACECOUNT,0) + 1 WHERE NEW.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_UPDATE_DECREMENT AFTER UPDATE OF ZHIDDEN,
    ZASSETVISIBLE ON ZDETECTEDFACE FOR EACH ROW WHEN (OLD.ZHIDDEN == 0 AND OLD.ZASSETVISIBLE == 1) AND (NEW.ZHIDDEN != OLD.ZHIDDEN OR NEW.ZASSETVISIBLE != OLD.ZASSETVISIBLE) AND (OLD.ZPERSON == NEW.ZPERSON) BEGIN UPDATE ZPERSON SET ZFACECOUNT = MAX(0,IFNULL(ZFACECOUNT,0) - 1) WHERE OLD.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_DELETE_DECREMENT AFTER DELETE ON ZDETECTEDFACE FOR EACH ROW WHEN OLD.ZHIDDEN == 0 AND OLD.ZASSETVISIBLE == 1 BEGIN UPDATE ZPERSON SET ZFACECOUNT = MAX(0,IFNULL(ZFACECOUNT,0) - 1) WHERE OLD.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = OLD.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_ZPERSON_INSERT_INCREMENT AFTER INSERT ON ZPERSON FOR EACH ROW BEGIN UPDATE ZPERSON SET ZFACECOUNT = (SELECT COUNT(Z_PK) FROM ZDETECTEDFACE WHERE (ZPERSON = NEW.Z_PK) AND (ZHIDDEN == 0 AND ZASSETVISIBLE == 1)) WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_ZPERSON_UPDATE_INCREMENT AFTER UPDATE OF ZPERSON ON ZDETECTEDFACE WHEN (NEW.ZHIDDEN == 0 AND NEW.ZASSETVISIBLE == 1) AND ((NEW.ZPERSON IS NOT NULL AND OLD.ZPERSON IS NULL) OR (NEW.ZPERSON != OLD.ZPERSON)) BEGIN UPDATE ZPERSON SET ZFACECOUNT = IFNULL(ZFACECOUNT,0) + 1 WHERE Z_PK = NEW.ZPERSON; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_ZPERSON_UPDATE_DECREMENT AFTER UPDATE OF ZPERSON ON ZDETECTEDFACE WHEN (OLD.ZHIDDEN == 0 AND OLD.ZASSETVISIBLE == 1) AND ((OLD.ZPERSON IS NOT NULL AND NEW.ZPERSON IS NULL) OR (NEW.ZPERSON != OLD.ZPERSON)) BEGIN UPDATE ZPERSON SET ZFACECOUNT = MAX(0,IFNULL(ZFACECOUNT,0) - 1) WHERE Z_PK = OLD.ZPERSON; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = OLD.ZPERSON; END;
CREATE INDEX Z_AdditionalAssetAttributes_adjustedFingerPrint ON ZADDITIONALASSETATTRIBUTES (ZADJUSTEDFINGERPRINT COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_allowedForAnalysis ON ZADDITIONALASSETATTRIBUTES (ZALLOWEDFORANALYSIS COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_cameraCaptureDevice ON ZADDITIONALASSETATTRIBUTES (ZCAMERACAPTUREDEVICE COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_creatorBundleID ON ZADDITIONALASSETATTRIBUTES (ZCREATORBUNDLEID COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_locationHash ON ZADDITIONALASSETATTRIBUTES (ZLOCATIONHASH COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_masterFingerPrint ON ZADDITIONALASSETATTRIBUTES (ZMASTERFINGERPRINT COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_originalAssetsUUID ON ZADDITIONALASSETATTRIBUTES (ZORIGINALASSETSUUID COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_originalHash ON ZADDITIONALASSETATTRIBUTES (ZORIGINALHASH COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_publicGlobalUUID ON ZADDITIONALASSETATTRIBUTES (ZPUBLICGLOBALUUID COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_reverseLocationDataIsValid ON ZADDITIONALASSETATTRIBUTES (ZREVERSELOCATIONDATAISVALID COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_shiftedLocationIsValid ON ZADDITIONALASSETATTRIBUTES (ZSHIFTEDLOCATIONISVALID COLLATE BINARY ASC);
CREATE INDEX Z_AdditionalAssetAttributes_uploadAttempts ON ZADDITIONALASSETATTRIBUTES (ZUPLOADATTEMPTS COLLATE BINARY ASC);
CREATE INDEX Z_AlbumList_identifier ON ZALBUMLIST (ZIDENTIFIER COLLATE BINARY ASC);
CREATE INDEX Z_AlbumList_uuid ON ZALBUMLIST (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_AssetAnalysisState_analysisState_workerType_asset ON ZASSETANALYSISSTATE (ZANALYSISSTATE COLLATE BINARY ASC,
    ZWORKERTYPE COLLATE BINARY ASC,
    ZASSET COLLATE BINARY ASC);
CREATE INDEX Z_AssetAnalysisState_sortToken ON ZASSETANALYSISSTATE (ZSORTTOKEN COLLATE BINARY ASC);
CREATE INDEX Z_AssetAnalysisState_workerType ON ZASSETANALYSISSTATE (ZWORKERTYPE COLLATE BINARY ASC);
CREATE INDEX Z_AssetAnalysisState_workerType_sortToken ON ZASSETANALYSISSTATE (ZWORKERTYPE COLLATE BINARY ASC,
    ZSORTTOKEN COLLATE BINARY ASC);
CREATE INDEX Z_CloudFeedEntry_entity_entryDate ON ZCLOUDFEEDENTRY (Z_ENT COLLATE BINARY ASC,
    ZENTRYDATE COLLATE BINARY ASC);
CREATE INDEX Z_CloudFeedEntry_entryDate ON ZCLOUDFEEDENTRY (ZENTRYDATE COLLATE BINARY ASC);
CREATE INDEX Z_CloudFeedEntry_entryDate_entryPriorityNumber_entryTypeNumber ON ZCLOUDFEEDENTRY (ZENTRYDATE COLLATE BINARY ASC,
    ZENTRYPRIORITYNUMBER COLLATE BINARY ASC,
    ZENTRYTYPENUMBER COLLATE BINARY ASC);
CREATE INDEX Z_CloudFeedEntry_entryTypeNumber ON ZCLOUDFEEDENTRY (ZENTRYTYPENUMBER COLLATE BINARY ASC);
CREATE INDEX Z_CloudMaster_cloudLocalState ON ZCLOUDMASTER (ZCLOUDLOCALSTATE COLLATE BINARY ASC);
CREATE INDEX Z_CloudMaster_cloudMasterGUID ON ZCLOUDMASTER (ZCLOUDMASTERGUID COLLATE BINARY ASC);
CREATE INDEX Z_CloudResource_assetUuid ON ZCLOUDRESOURCE (ZASSETUUID COLLATE BINARY ASC);
CREATE INDEX Z_CloudResource_dateCreated ON ZCLOUDRESOURCE (ZDATECREATED COLLATE BINARY ASC);
CREATE INDEX Z_CloudResource_isAvailable ON ZCLOUDRESOURCE (ZISAVAILABLE COLLATE BINARY ASC);
CREATE INDEX Z_CloudResource_isLocallyAvailable ON ZCLOUDRESOURCE (ZISLOCALLYAVAILABLE COLLATE BINARY ASC);
CREATE INDEX Z_CloudResource_type ON ZCLOUDRESOURCE (ZTYPE COLLATE BINARY ASC);
CREATE INDEX Z_CloudResource_type_isLocallyAvailable_isAvailable_dateCreated_lastOnDemandDownloadDate_lastPrefetchDate ON ZCLOUDRESOURCE (ZTYPE COLLATE BINARY ASC,
    ZISLOCALLYAVAILABLE COLLATE BINARY ASC,
    ZISAVAILABLE COLLATE BINARY ASC,
    ZDATECREATED COLLATE BINARY ASC,
    ZLASTONDEMANDDOWNLOADDATE COLLATE BINARY ASC,
    ZLASTPREFETCHDATE COLLATE BINARY ASC);
CREATE INDEX Z_CloudSharedComment_cloudGUID ON ZCLOUDSHAREDCOMMENT (ZCLOUDGUID COLLATE BINARY ASC);
CREATE INDEX Z_DeferredRebuildFace_assetCloudGUID ON ZDEFERREDREBUILDFACE (ZASSETCLOUDGUID COLLATE BINARY ASC);
CREATE INDEX Z_DetectedFace_cloudLocalState ON ZDETECTEDFACE (ZCLOUDLOCALSTATE COLLATE BINARY ASC);
CREATE INDEX Z_DetectedFace_clusterSequenceNumber ON ZDETECTEDFACE (ZCLUSTERSEQUENCENUMBER COLLATE BINARY ASC);
CREATE INDEX Z_DetectedFace_uuid ON ZDETECTEDFACE (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_DetectedFaceGroup_personBuilderState ON ZDETECTEDFACEGROUP (ZPERSONBUILDERSTATE COLLATE BINARY ASC);
CREATE INDEX Z_FaceCrop_cloudLocalState ON ZFACECROP (ZCLOUDLOCALSTATE COLLATE BINARY ASC);
CREATE INDEX Z_FaceCrop_uuid ON ZFACECROP (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_GenericAlbum_cloudGUID ON ZGENERICALBUM (ZCLOUDGUID COLLATE BINARY ASC);
CREATE INDEX Z_GenericAlbum_cloudLocalState ON ZGENERICALBUM (ZCLOUDLOCALSTATE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAlbum_kind ON ZGENERICALBUM (ZKIND COLLATE BINARY ASC);
CREATE INDEX Z_GenericAlbum_syncEventOrderKey ON ZGENERICALBUM (ZSYNCEVENTORDERKEY COLLATE BINARY ASC);
CREATE INDEX Z_GenericAlbum_uuid ON ZGENERICALBUM (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_WallpaperAlbum_wallpaperAlbumType ON ZGENERICALBUM (ZWALLPAPERALBUMTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_addedDate ON ZGENERICASSET (ZADDEDDATE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_addedDate_sortToken ON ZGENERICASSET (ZADDEDDATE COLLATE BINARY ASC,
    ZSORTTOKEN COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_addedDate_sortToken_kind_savedAssetType_visibilityState_trashedState_hidden_avalanchePickType_complete_entity ON ZGENERICASSET (ZADDEDDATE COLLATE BINARY ASC,
    ZSORTTOKEN COLLATE BINARY ASC,
    ZKIND COLLATE BINARY ASC,
    ZSAVEDASSETTYPE COLLATE BINARY ASC,
    ZVISIBILITYSTATE COLLATE BINARY ASC,
    ZTRASHEDSTATE COLLATE BINARY ASC,
    ZHIDDEN COLLATE BINARY ASC,
    ZAVALANCHEPICKTYPE COLLATE BINARY ASC,
    ZCOMPLETE COLLATE BINARY ASC,
    Z_ENT COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_avalanchePickType ON ZGENERICASSET (ZAVALANCHEPICKTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_avalancheUUID ON ZGENERICASSET (ZAVALANCHEUUID COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_cloudAssetGUID ON ZGENERICASSET (ZCLOUDASSETGUID COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_cloudAssetGUID_savedAssetType ON ZGENERICASSET (ZCLOUDASSETGUID COLLATE BINARY ASC,
    ZSAVEDASSETTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_cloudLocalState_dateCreated ON ZGENERICASSET (ZCLOUDLOCALSTATE COLLATE BINARY ASC,
    ZDATECREATED COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_cloudPlaceholderKind ON ZGENERICASSET (ZCLOUDPLACEHOLDERKIND COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_complete ON ZGENERICASSET (ZCOMPLETE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_customRenderedValue ON ZGENERICASSET (ZCUSTOMRENDEREDVALUE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_dateCreated ON ZGENERICASSET (ZDATECREATED COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_depthStates ON ZGENERICASSET (ZDEPTHSTATES COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_directory_filename ON ZGENERICASSET (ZDIRECTORY COLLATE BINARY ASC,
    ZFILENAME COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_favorite ON ZGENERICASSET (ZFAVORITE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_favorite_dateCreated_addedDate_filename_visibilityState_complete_trashedState_hidden_savedAssetType_avalanchePickType ON ZGENERICASSET (ZFAVORITE COLLATE BINARY ASC,
    ZDATECREATED COLLATE BINARY ASC,
    ZADDEDDATE COLLATE BINARY ASC,
    ZFILENAME COLLATE BINARY ASC,
    ZVISIBILITYSTATE COLLATE BINARY ASC,
    ZCOMPLETE COLLATE BINARY ASC,
    ZTRASHEDSTATE COLLATE BINARY ASC,
    ZHIDDEN COLLATE BINARY ASC,
    ZSAVEDASSETTYPE COLLATE BINARY ASC,
    ZAVALANCHEPICKTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_groupingUUID ON ZGENERICASSET (ZGROUPINGUUID COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_hidden_visibilityState ON ZGENERICASSET (ZHIDDEN COLLATE BINARY ASC,
    ZVISIBILITYSTATE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_kind ON ZGENERICASSET (ZKIND COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_kindSubtype ON ZGENERICASSET (ZKINDSUBTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_kindSubtype_dateCreated_addedDate_filename ON ZGENERICASSET (ZKINDSUBTYPE COLLATE BINARY ASC,
    ZDATECREATED COLLATE BINARY ASC,
    ZADDEDDATE COLLATE BINARY ASC,
    ZFILENAME COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_kind_entity ON ZGENERICASSET (ZKIND COLLATE BINARY ASC,
    Z_ENT COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_kind_trashedState_cloudLocalState_savedAssetType ON ZGENERICASSET (ZKIND COLLATE BINARY ASC,
    ZTRASHEDSTATE COLLATE BINARY ASC,
    ZCLOUDLOCALSTATE COLLATE BINARY ASC,
    ZSAVEDASSETTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_lastSharedDate ON ZGENERICASSET (ZLASTSHAREDDATE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_latitude_longitude_trashedState_hidden_avalanchePickType_savedAssetType ON ZGENERICASSET (ZLATITUDE COLLATE BINARY ASC,
    ZLONGITUDE COLLATE BINARY ASC,
    ZTRASHEDSTATE COLLATE BINARY ASC,
    ZHIDDEN COLLATE BINARY ASC,
    ZAVALANCHEPICKTYPE COLLATE BINARY ASC,
    ZSAVEDASSETTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_mediaGroupUUID ON ZGENERICASSET (ZMEDIAGROUPUUID COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_playbackStyle ON ZGENERICASSET (ZPLAYBACKSTYLE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_playbackStyle_dateCreated_addedDate_filename_visibilityState_complete_trashedState_hidden_savedAssetType_avalanchePickType ON ZGENERICASSET (ZPLAYBACKSTYLE COLLATE BINARY ASC,
    ZDATECREATED COLLATE BINARY ASC,
    ZADDEDDATE COLLATE BINARY ASC,
    ZFILENAME COLLATE BINARY ASC,
    ZVISIBILITYSTATE COLLATE BINARY ASC,
    ZCOMPLETE COLLATE BINARY ASC,
    ZTRASHEDSTATE COLLATE BINARY ASC,
    ZHIDDEN COLLATE BINARY ASC,
    ZSAVEDASSETTYPE COLLATE BINARY ASC,
    ZAVALANCHEPICKTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_playbackVariation ON ZGENERICASSET (ZPLAYBACKVARIATION COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_savedAssetType ON ZGENERICASSET (ZSAVEDASSETTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_sortToken ON ZGENERICASSET (ZSORTTOKEN COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_thumbnailIndex ON ZGENERICASSET (ZTHUMBNAILINDEX COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_trashedState_cloudLocalState_savedAssetType ON ZGENERICASSET (ZTRASHEDSTATE COLLATE BINARY ASC,
    ZCLOUDLOCALSTATE COLLATE BINARY ASC,
    ZSAVEDASSETTYPE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_trashedState_trashedDate ON ZGENERICASSET (ZTRASHEDSTATE COLLATE BINARY ASC,
    ZTRASHEDDATE COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_uniformTypeIdentifier ON ZGENERICASSET (ZUNIFORMTYPEIDENTIFIER COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_uuid ON ZGENERICASSET (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_GenericAsset_visibilityState ON ZGENERICASSET (ZVISIBILITYSTATE COLLATE BINARY ASC);
CREATE INDEX Z_Keyword_title ON ZKEYWORD (ZTITLE COLLATE BINARY ASC);
CREATE INDEX Z_LegacyFace_albumUUID ON ZLEGACYFACE (ZALBUMUUID COLLATE BINARY ASC);
CREATE INDEX Z_LegacyFace_identifier ON ZLEGACYFACE (ZIDENTIFIER COLLATE BINARY ASC);
CREATE INDEX Z_Memory_cloudLocalState ON ZMEMORY (ZCLOUDLOCALSTATE COLLATE BINARY ASC);
CREATE INDEX Z_Memory_lastMoviePlayedDate ON ZMEMORY (ZLASTMOVIEPLAYEDDATE COLLATE BINARY ASC);
CREATE INDEX Z_Memory_lastViewedDate ON ZMEMORY (ZLASTVIEWEDDATE COLLATE BINARY ASC);
CREATE INDEX Z_Memory_pending ON ZMEMORY (ZPENDING COLLATE BINARY ASC);
CREATE INDEX Z_Memory_uuid ON ZMEMORY (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_Moment_endDate ON ZMOMENT (ZENDDATE COLLATE BINARY ASC);
CREATE INDEX Z_Moment_representativeDate ON ZMOMENT (ZREPRESENTATIVEDATE COLLATE BINARY ASC);
CREATE INDEX Z_Moment_reverseLocationDataIsValid ON ZMOMENT (ZREVERSELOCATIONDATAISVALID COLLATE BINARY ASC);
CREATE INDEX Z_Moment_startDate ON ZMOMENT (ZSTARTDATE COLLATE BINARY ASC);
CREATE INDEX Z_Moment_startDate_endDate ON ZMOMENT (ZSTARTDATE COLLATE BINARY ASC,
    ZENDDATE COLLATE BINARY ASC);
CREATE INDEX Z_Moment_trashedState ON ZMOMENT (ZTRASHEDSTATE COLLATE BINARY ASC);
CREATE INDEX Z_Moment_uuid ON ZMOMENT (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_granularityLevel ON ZMOMENTLIST (ZGRANULARITYLEVEL COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_granularityLevel_sortIndex ON ZMOMENTLIST (ZGRANULARITYLEVEL COLLATE BINARY ASC,
    ZSORTINDEX COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_representativeDate ON ZMOMENTLIST (ZREPRESENTATIVEDATE COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_reverseLocationDataIsValid ON ZMOMENTLIST (ZREVERSELOCATIONDATAISVALID COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_reverseLocationDataIsValid_granularityLevel ON ZMOMENTLIST (ZREVERSELOCATIONDATAISVALID COLLATE BINARY ASC,
    ZGRANULARITYLEVEL COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_sortIndex ON ZMOMENTLIST (ZSORTINDEX COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_trashedState ON ZMOMENTLIST (ZTRASHEDSTATE COLLATE BINARY ASC);
CREATE INDEX Z_MomentList_uuid ON ZMOMENTLIST (ZUUID COLLATE BINARY ASC);
CREATE INDEX Z_Person_cloudLocalState ON ZPERSON (ZCLOUDLOCALSTATE COLLATE BINARY ASC);
CREATE INDEX Z_Person_faceCount ON ZPERSON (ZFACECOUNT COLLATE BINARY ASC);
CREATE INDEX Z_Person_manualOrder ON ZPERSON (ZMANUALORDER COLLATE BINARY ASC);
CREATE INDEX Z_Person_personUUID ON ZPERSON (ZPERSONUUID COLLATE BINARY ASC);
CREATE INDEX Z_Person_personUri ON ZPERSON (ZPERSONURI COLLATE BINARY ASC);
CREATE INDEX Z_Person_type ON ZPERSON (ZTYPE COLLATE BINARY ASC);
CREATE INDEX Z_Person_verifiedType ON ZPERSON (ZVERIFIEDTYPE COLLATE BINARY ASC);
CREATE INDEX Z_Person_verifiedType_faceCount_type ON ZPERSON (ZVERIFIEDTYPE COLLATE BINARY ASC,
    ZFACECOUNT COLLATE BINARY ASC,
    ZTYPE COLLATE BINARY ASC);
CREATE INDEX Z_SearchData_valid ON ZSEARCHDATA (ZVALID COLLATE BINARY ASC);
CREATE INDEX RADAR_22158684_INDEX ON Z_20ASSETS (Z_20ALBUMS,
    Z_FOK_27ASSETS,
    Z_27ASSETS);
CREATE INDEX RADAR_10322662_INDEX ON Z_20ASSETS (Z_20ALBUMS,
    Z_27ASSETS,
    Z_FOK_27ASSETS);
CREATE INDEX RADAR_16835859_INDEX ON ZGENERICASSET (ZMOMENT,
    Z_FOK_MOMENT);
