CREATE TABLE ZADDITIONALASSETATTRIBUTES ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZALLOWEDFORANALYSIS INTEGER,
    ZCAMERACAPTUREDEVICE INTEGER,
    ZCLOUDAVALANCHEPICKTYPE INTEGER,
    ZCLOUDKINDSUBTYPE INTEGER,
    ZEMBEDDEDTHUMBNAILHEIGHT INTEGER,
    ZEMBEDDEDTHUMBNAILLENGTH INTEGER,
    ZEMBEDDEDTHUMBNAILOFFSET INTEGER,
    ZEMBEDDEDTHUMBNAILWIDTH INTEGER,
    ZEXTERNALUSAGEINTENT INTEGER,
    ZLOCATIONHASH INTEGER,
    ZORIGINALFILESIZE INTEGER,
    ZORIGINALHEIGHT INTEGER,
    ZORIGINALORIENTATION INTEGER,
    ZORIGINALRESOURCECHOICE INTEGER,
    ZORIGINALWIDTH INTEGER,
    ZPENDINGPLAYCOUNT INTEGER,
    ZPENDINGSHARECOUNT INTEGER,
    ZPENDINGVIEWCOUNT INTEGER,
    ZPLAYCOUNT INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZSCENEANALYSISVERSION INTEGER,
    ZSHARECOUNT INTEGER,
    ZSHIFTEDLOCATIONISVALID INTEGER,
    ZTIMEZONEOFFSET INTEGER,
    ZUPLOADATTEMPTS INTEGER,
    ZVIDEOCPDISPLAYTIMESCALE INTEGER,
    ZVIDEOCPDISPLAYVALUE INTEGER,
    ZVIDEOCPDURATIONTIMESCALE INTEGER,
    ZVIEWCOUNT INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZASSETDESCRIPTION INTEGER,
    ZUNMANAGEDADJUSTMENT INTEGER,
    ZLASTUPLOADATTEMPTDATE TIMESTAMP,
    ZSCENEANALYSISTIMESTAMP TIMESTAMP,
    ZADJUSTEDFINGERPRINT VARCHAR,
    ZCREATORBUNDLEID VARCHAR,
    ZCUSTOMCOLLECTIONNAME VARCHAR,
    ZCUSTOMCOLLECTIONUUID VARCHAR,
    ZCUSTOMMOMENTNAME VARCHAR,
    ZCUSTOMMOMENTUUID VARCHAR,
    ZEDITORBUNDLEID VARCHAR,
    ZEXIFTIMESTAMPSTRING VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZMASTERFINGERPRINT VARCHAR,
    ZMONTAGE VARCHAR,
    ZORIGINALASSETSUUID VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZORIGINATINGASSETIDENTIFIER VARCHAR,
    ZPUBLICGLOBALUUID VARCHAR,
    ZTIMEZONENAME VARCHAR,
    ZTITLE VARCHAR,
    ZDISTANCEIDENTITY BLOB,
    ZFACEREGIONS BLOB,
    ZORIGINALHASH BLOB,
    ZPLACEANNOTATIONDATA BLOB,
    ZREVERSELOCATIONDATA BLOB,
    ZSHIFTEDLOCATIONDATA BLOB );
CREATE TABLE Z_1KEYWORDS ( Z_1ASSETATTRIBUTES INTEGER,
    Z_30KEYWORDS INTEGER,
    PRIMARY KEY (Z_1ASSETATTRIBUTES,
    Z_30KEYWORDS) );
CREATE TABLE ZADJUSTMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    Z_FOK_ASSET INTEGER,
    ZFILTERNAME VARCHAR,
    ZFILTERSETTINGS BLOB );
CREATE TABLE ZALBUMLIST ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZNEEDSREORDERINGNUMBER INTEGER,
    ZUUID VARCHAR );
CREATE TABLE ZASSETANALYSISSTATE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZANALYSISSTATE INTEGER,
    ZWORKERFLAGS INTEGER,
    ZWORKERTYPE INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZIGNOREUNTILDATE TIMESTAMP,
    ZLASTIGNOREDDATE TIMESTAMP,
    ZSORTTOKEN FLOAT,
    ZASSETUUID VARCHAR );
CREATE TABLE ZASSETDESCRIPTION ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZLONGDESCRIPTION VARCHAR );
CREATE TABLE ZCLOUDFEEDENTRY ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZENTRYPRIORITYNUMBER INTEGER,
    ZENTRYTYPENUMBER INTEGER,
    ZENTRYDATE TIMESTAMP,
    ZENTRYALBUMGUID VARCHAR,
    ZENTRYINVITATIONRECORDGUID VARCHAR,
    ZENTRYCLOUDASSETGUID VARCHAR );
CREATE TABLE ZCLOUDMASTER ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZFULLSIZEJPEGSOURCE INTEGER,
    ZORIGINALORIENTATION INTEGER,
    ZMEDIAMETADATA INTEGER,
    ZCREATIONDATE TIMESTAMP,
    ZIMPORTDATE TIMESTAMP,
    ZCLOUDMASTERGUID VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZMEDIAMETADATATYPE VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZORIGINATINGASSETIDENTIFIER VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE TABLE ZCLOUDMASTERMEDIAMETADATA ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDMASTER INTEGER,
    ZDATA BLOB );
CREATE TABLE ZCLOUDRESOURCE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZFILESIZE INTEGER,
    ZHEIGHT INTEGER,
    ZISAVAILABLE INTEGER,
    ZISLOCALLYAVAILABLE INTEGER,
    ZPREFETCHCOUNT INTEGER,
    ZTYPE INTEGER,
    ZWIDTH INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZCLOUDMASTER INTEGER,
    ZDATECREATED TIMESTAMP,
    ZLASTONDEMANDDOWNLOADDATE TIMESTAMP,
    ZLASTPREFETCHDATE TIMESTAMP,
    ZPRUNEDAT TIMESTAMP,
    ZASSETUUID VARCHAR,
    ZFILEPATH VARCHAR,
    ZFINGERPRINT VARCHAR,
    ZITEMIDENTIFIER VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE TABLE ZCLOUDSHAREDALBUMINVITATIONRECORD ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZINVITATIONSTATE INTEGER,
    ZINVITATIONSTATELOCAL INTEGER,
    ZINVITEEEMAILKEY INTEGER,
    ZISMINE INTEGER,
    ZALBUM INTEGER,
    Z_FOK_ALBUM INTEGER,
    ZINVITEESUBSCRIPTIONDATE TIMESTAMP,
    ZALBUMGUID VARCHAR,
    ZCLOUDGUID VARCHAR,
    ZINVITEEFIRSTNAME VARCHAR,
    ZINVITEEFULLNAME VARCHAR,
    ZINVITEEHASHEDPERSONID VARCHAR,
    ZINVITEELASTNAME VARCHAR );
CREATE TABLE ZCLOUDSHAREDCOMMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZISBATCHCOMMENT INTEGER,
    ZISCAPTION INTEGER,
    ZISDELETABLE INTEGER,
    ZISLIKE INTEGER,
    ZISMYCOMMENT INTEGER,
    ZCLOUDFEEDCOMMENTENTRY INTEGER,
    ZCLOUDFEEDLIKECOMMENTENTRY INTEGER,
    ZCOMMENTEDASSET INTEGER,
    Z27_COMMENTEDASSET INTEGER,
    ZLIKEDASSET INTEGER,
    Z27_LIKEDASSET INTEGER,
    Z_FOK_LIKEDASSET INTEGER,
    Z_FOK_CLOUDFEEDCOMMENTENTRY INTEGER,
    Z_FOK_COMMENTEDASSET INTEGER,
    Z_FOK_CLOUDFEEDLIKECOMMENTENTRY INTEGER,
    ZCOMMENTCLIENTDATE TIMESTAMP,
    ZCOMMENTDATE TIMESTAMP,
    ZCLOUDGUID VARCHAR,
    ZCOMMENTTEXT VARCHAR,
    ZCOMMENTTYPE VARCHAR,
    ZCOMMENTERHASHEDPERSONID VARCHAR );
CREATE TABLE ZDEFERREDREBUILDFACE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZFACEALGORITHMVERSION INTEGER,
    ZHIDDEN INTEGER,
    ZMANUAL INTEGER,
    ZNAMESOURCEAUTO INTEGER,
    ZREJECTED INTEGER,
    ZREPRESENTATIVE INTEGER,
    ZCENTERX FLOAT,
    ZCENTERY FLOAT,
    ZSIZE FLOAT,
    ZASSETCLOUDGUID VARCHAR,
    ZASSETUUID VARCHAR,
    ZPERSONUUID VARCHAR );
CREATE TABLE ZDETECTEDFACE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETVISIBLE INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLUSTERSEQUENCENUMBER INTEGER,
    ZCONFIRMEDFACECROPGENERATIONSTATE INTEGER,
    ZEXPRESSIONTYPE1 INTEGER,
    ZEXPRESSIONTYPE2 INTEGER,
    ZEXPRESSIONTYPE3 INTEGER,
    ZFACEALGORITHMVERSION INTEGER,
    ZHASSMILE INTEGER,
    ZHIDDEN INTEGER,
    ZISINTRASH INTEGER,
    ZISLEFTEYECLOSED INTEGER,
    ZISRIGHTEYECLOSED INTEGER,
    ZMANUAL INTEGER,
    ZNAMESOURCE INTEGER,
    ZQUALITYMEASURE INTEGER,
    ZSOURCEHEIGHT INTEGER,
    ZSOURCEWIDTH INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZFACECROP INTEGER,
    ZFACEGROUP INTEGER,
    ZFACEGROUPBEINGKEYFACE INTEGER,
    ZFACEPRINT INTEGER,
    ZPERSON INTEGER,
    ZPERSONBEINGKEYFACE INTEGER,
    ZADJUSTMENTVERSION TIMESTAMP,
    ZBLURSCORE FLOAT,
    ZCENTERX FLOAT,
    ZCENTERY FLOAT,
    ZEXPRESSIONCONFIDENCE FLOAT,
    ZEXPRESSIONSCORE1 FLOAT,
    ZEXPRESSIONSCORE2 FLOAT,
    ZEXPRESSIONSCORE3 FLOAT,
    ZLEFTEYEX FLOAT,
    ZLEFTEYEY FLOAT,
    ZMOUTHX FLOAT,
    ZMOUTHY FLOAT,
    ZPOSEPITCH FLOAT,
    ZPOSEROLL FLOAT,
    ZPOSEYAW FLOAT,
    ZRIGHTEYEX FLOAT,
    ZRIGHTEYEY FLOAT,
    ZSIZE FLOAT,
    ZMASTERIDENTIFIER VARCHAR,
    ZUUID VARCHAR );
CREATE TABLE Z_15REJECTEDPERSONS ( Z_15REJECTEDFACES INTEGER,
    Z_36REJECTEDPERSONS INTEGER,
    PRIMARY KEY (Z_15REJECTEDFACES,
    Z_36REJECTEDPERSONS) );
CREATE TABLE Z_15REJECTEDPERSONSNEEDINGFACECROPS ( Z_15REJECTEDFACESNEEDINGFACECROPS INTEGER,
    Z_36REJECTEDPERSONSNEEDINGFACECROPS INTEGER,
    PRIMARY KEY (Z_15REJECTEDFACESNEEDINGFACECROPS,
    Z_36REJECTEDPERSONSNEEDINGFACECROPS) );
CREATE TABLE ZDETECTEDFACEGROUP ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZPERSONBUILDERSTATE INTEGER,
    ZUNNAMEDFACECOUNT INTEGER,
    ZASSOCIATEDPERSON INTEGER,
    ZKEYFACE INTEGER,
    ZUUID VARCHAR );
CREATE TABLE ZDETECTEDFACEPRINT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZFACEPRINTVERSION INTEGER,
    ZFACE INTEGER,
    ZDATA BLOB );
CREATE TABLE ZFACECROP ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZSTATE INTEGER,
    ZTYPE INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZFACE INTEGER,
    ZPERSON INTEGER,
    ZUUID VARCHAR,
    ZRESOURCEDATA BLOB );
CREATE TABLE ZGENERICALBUM ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCACHEDCOUNT INTEGER,
    ZCACHEDPHOTOSCOUNT INTEGER,
    ZCACHEDVIDEOSCOUNT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCUSTOMSORTASCENDING INTEGER,
    ZCUSTOMSORTKEY INTEGER,
    ZISPINNED INTEGER,
    ZKIND INTEGER,
    ZPENDINGITEMSCOUNT INTEGER,
    ZPENDINGITEMSTYPE INTEGER,
    ZSYNCEVENTORDERKEY INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZCUSTOMKEYASSET INTEGER,
    Z27_CUSTOMKEYASSET INTEGER,
    ZKEYASSET INTEGER,
    Z27_KEYASSET INTEGER,
    ZPARENTFOLDER INTEGER,
    ZSECONDARYKEYASSET INTEGER,
    Z27_SECONDARYKEYASSET INTEGER,
    ZTERTIARYKEYASSET INTEGER,
    Z27_TERTIARYKEYASSET INTEGER,
    ZCLOUDALBUMSUBTYPE INTEGER,
    ZCLOUDMULTIPLECONTRIBUTORSENABLED INTEGER,
    ZCLOUDMULTIPLECONTRIBUTORSENABLEDLOCAL INTEGER,
    ZCLOUDNOTIFICATIONSENABLED INTEGER,
    ZCLOUDOWNEREMAILKEY INTEGER,
    ZCLOUDOWNERISWHITELISTED INTEGER,
    ZCLOUDPUBLICURLENABLED INTEGER,
    ZCLOUDPUBLICURLENABLEDLOCAL INTEGER,
    ZCLOUDRELATIONSHIPSTATE INTEGER,
    ZCLOUDRELATIONSHIPSTATELOCAL INTEGER,
    ZHASUNSEENCONTENT INTEGER,
    ZISOWNED INTEGER,
    ZUNSEENASSETSCOUNT INTEGER,
    ZKEYASSETFACEIDENTIFIER INTEGER,
    ZKEYASSETFACETHUMBNAILINDEX INTEGER,
    ZWALLPAPERALBUMTYPE INTEGER,
    Z_FOK_PARENTFOLDER INTEGER,
    ZENDDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTRASHEDDATE TIMESTAMP,
    ZCLOUDCREATIONDATE TIMESTAMP,
    ZCLOUDLASTCONTRIBUTIONDATE TIMESTAMP,
    ZCLOUDLASTINTERESTINGCHANGEDATE TIMESTAMP,
    ZCLOUDSUBSCRIPTIONDATE TIMESTAMP,
    ZCLOUDGUID VARCHAR,
    ZIMPORTSESSIONID VARCHAR,
    ZTITLE VARCHAR,
    ZUUID VARCHAR,
    ZCLOUDOWNERFIRSTNAME VARCHAR,
    ZCLOUDOWNERFULLNAME VARCHAR,
    ZCLOUDOWNERHASHEDPERSONID VARCHAR,
    ZCLOUDOWNERLASTNAME VARCHAR,
    ZCLOUDPERSONID VARCHAR,
    ZPUBLICURL VARCHAR,
    ZCUSTOMQUERYTYPE VARCHAR,
    ZCLOUDMETADATA BLOB,
    ZCUSTOMQUERYPARAMETERS BLOB );
CREATE TABLE Z_19ALBUMLISTS ( Z_19ALBUMS INTEGER,
    Z_3ALBUMLISTS INTEGER,
    Z_FOK_19ALBUMS INTEGER,
    PRIMARY KEY (Z_19ALBUMS,
    Z_3ALBUMLISTS) );
CREATE TABLE Z_20ASSETS ( Z_20ALBUMS INTEGER,
    Z_27ASSETS INTEGER,
    Z_FOK_27ASSETS INTEGER,
    PRIMARY KEY (Z_20ALBUMS,
    Z_27ASSETS) );
CREATE TABLE ZGENERICASSET ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZAVALANCHEPICKTYPE INTEGER,
    ZCLOUDDOWNLOADREQUESTS INTEGER,
    ZCLOUDHASCOMMENTSBYME INTEGER,
    ZCLOUDHASCOMMENTSCONVERSATION INTEGER,
    ZCLOUDHASUNSEENCOMMENTS INTEGER,
    ZCLOUDISDELETABLE INTEGER,
    ZCLOUDISMYASSET INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZCLOUDPLACEHOLDERKIND INTEGER,
    ZCOMPLETE INTEGER,
    ZCUSTOMRENDEREDVALUE INTEGER,
    ZFACEAREAPOINTS INTEGER,
    ZFAVORITE INTEGER,
    ZHASADJUSTMENTS INTEGER,
    ZHEIGHT INTEGER,
    ZHIDDEN INTEGER,
    ZKIND INTEGER,
    ZKINDSUBTYPE INTEGER,
    ZLOCALRESOURCESSTATE INTEGER,
    ZORIENTATION INTEGER,
    ZSAVEDASSETTYPE INTEGER,
    ZTHUMBNAILINDEX INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZVIDEOCPDURATIONVALUE INTEGER,
    ZVIDEOCPVISIBILITYSTATE INTEGER,
    ZVISIBILITYSTATE INTEGER,
    ZWIDTH INTEGER,
    ZADDITIONALATTRIBUTES INTEGER,
    ZCLOUDFEEDASSETSENTRY INTEGER,
    ZMASTER INTEGER,
    ZMOMENT INTEGER,
    ZSEARCHDATA INTEGER,
    Z_FOK_CLOUDFEEDASSETSENTRY INTEGER,
    Z_FOK_MOMENT INTEGER,
    ZADDEDDATE TIMESTAMP,
    ZADJUSTMENTTIMESTAMP TIMESTAMP,
    ZCLOUDBATCHPUBLISHDATE TIMESTAMP,
    ZCLOUDLASTVIEWEDCOMMENTDATE TIMESTAMP,
    ZCLOUDSERVERPUBLISHDATE TIMESTAMP,
    ZCURATIONSCORE FLOAT,
    ZDATECREATED TIMESTAMP,
    ZDURATION FLOAT,
    ZFACEADJUSTMENTVERSION TIMESTAMP,
    ZLASTSHAREDDATE TIMESTAMP,
    ZLATITUDE FLOAT,
    ZLONGITUDE FLOAT,
    ZMODIFICATIONDATE TIMESTAMP,
    ZSORTTOKEN FLOAT,
    ZTRASHEDDATE TIMESTAMP,
    ZAVALANCHEUUID VARCHAR,
    ZCLOUDASSETGUID VARCHAR,
    ZCLOUDBATCHID VARCHAR,
    ZCLOUDCOLLECTIONGUID VARCHAR,
    ZCLOUDOWNERHASHEDPERSONID VARCHAR,
    ZDIRECTORY VARCHAR,
    ZFILENAME VARCHAR,
    ZGROUPINGUUID VARCHAR,
    ZMEDIAGROUPUUID VARCHAR,
    ZORIGINALCOLORSPACE VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR,
    ZUUID VARCHAR,
    ZLOCATIONDATA BLOB,
    ZIMAGEURLDATA BLOB,
    ZTHUMBNAILURLDATA BLOB,
    ZWALLPAPEROPTIONSDATA BLOB );
CREATE TABLE Z_27MEMORIESBEINGREPRESENTATIVEASSETS ( Z_27REPRESENTATIVEASSETS INTEGER,
    Z_32MEMORIESBEINGREPRESENTATIVEASSETS INTEGER,
    PRIMARY KEY (Z_27REPRESENTATIVEASSETS,
    Z_32MEMORIESBEINGREPRESENTATIVEASSETS) );
CREATE TABLE Z_27MEMORIESBEINGCURATEDASSETS ( Z_27CURATEDASSETS INTEGER,
    Z_32MEMORIESBEINGCURATEDASSETS INTEGER,
    PRIMARY KEY (Z_27CURATEDASSETS,
    Z_32MEMORIESBEINGCURATEDASSETS) );
CREATE TABLE Z_27MEMORIESBEINGMOVIECURATEDASSETS ( Z_27MOVIECURATEDASSETS INTEGER,
    Z_32MEMORIESBEINGMOVIECURATEDASSETS INTEGER,
    PRIMARY KEY (Z_27MOVIECURATEDASSETS,
    Z_32MEMORIESBEINGMOVIECURATEDASSETS) );
CREATE TABLE ZKEYWORD ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZTITLE VARCHAR UNIQUE );
CREATE TABLE ZLEGACYFACE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZALBUMUUID VARCHAR,
    ZRELATIVERECTVALUE BLOB );
CREATE TABLE ZMEMORY ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCATEGORY INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZFAVORITE INTEGER,
    ZPENDING INTEGER,
    ZPHOTOSGRAPHVERSION INTEGER,
    ZREJECTED INTEGER,
    ZSUBCATEGORY INTEGER,
    ZUSERCREATED INTEGER,
    ZKEYASSET INTEGER,
    Z27_KEYASSET INTEGER,
    ZCREATIONDATE TIMESTAMP,
    ZLASTMOVIEPLAYEDDATE TIMESTAMP,
    ZLASTVIEWEDDATE TIMESTAMP,
    ZSCORE FLOAT,
    ZSUBTITLE VARCHAR,
    ZTITLE VARCHAR,
    ZUUID VARCHAR,
    ZMOVIEASSETSTATE BLOB,
    ZASSETLISTPREDICATE BLOB,
    ZMOVIEDATA BLOB,
    ZPHOTOSGRAPHDATA BLOB );
CREATE TABLE ZMOMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCACHEDCOUNT INTEGER,
    ZCACHEDPHOTOSCOUNT INTEGER,
    ZCACHEDVIDEOSCOUNT INTEGER,
    ZGENERATIONTYPE INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZMEGAMOMENTLIST INTEGER,
    ZMOMENTLIBRARY INTEGER,
    ZYEARMOMENTLIST INTEGER,
    Z_FOK_MOMENTLIBRARY INTEGER,
    Z_FOK_MEGAMOMENTLIST INTEGER,
    Z_FOK_YEARMOMENTLIST INTEGER,
    ZENDDATE TIMESTAMP,
    ZMODIFICATIONDATE TIMESTAMP,
    ZREPRESENTATIVEDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTITLE VARCHAR,
    ZTITLE2 VARCHAR,
    ZTITLE3 VARCHAR,
    ZUUID VARCHAR,
    ZAPPROXIMATELOCATIONDATA BLOB,
    ZREVERSELOCATIONDATA BLOB );
CREATE TABLE ZMOMENTLIBRARY ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER );
CREATE TABLE ZMOMENTLIST ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZGENERATIONTYPE INTEGER,
    ZGRANULARITYLEVEL INTEGER,
    ZREVERSELOCATIONDATAISVALID INTEGER,
    ZSORTINDEX INTEGER,
    ZTRASHEDSTATE INTEGER,
    ZENDDATE TIMESTAMP,
    ZREPRESENTATIVEDATE TIMESTAMP,
    ZSTARTDATE TIMESTAMP,
    ZTITLE VARCHAR,
    ZTITLE2 VARCHAR,
    ZTITLE3 VARCHAR,
    ZUUID VARCHAR,
    ZREVERSELOCATIONDATA BLOB );
CREATE TABLE ZPERSON ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCLOUDLOCALSTATE INTEGER,
    ZFACECOUNT INTEGER,
    ZINPERSONNAMINGMODEL INTEGER,
    ZMANUALORDER INTEGER,
    ZTYPE INTEGER,
    ZVERIFIED INTEGER,
    ZASSOCIATEDFACEGROUP INTEGER,
    ZKEYFACE INTEGER,
    ZDISPLAYNAME VARCHAR,
    ZFULLNAME VARCHAR,
    ZPERSONUUID VARCHAR,
    ZPERSONURI VARCHAR,
    ZCONTACTMATCHINGDICTIONARY BLOB );
CREATE TABLE ZPERSONREFERENCE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZPERSON INTEGER,
    ZPERSONUUID VARCHAR,
    ZPERSONDATA BLOB );
CREATE TABLE ZSCENECLASSIFICATION ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZSCENEIDENTIFIER INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZCONFIDENCE FLOAT );
CREATE TABLE ZSEARCHDATA ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZVALID INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZDATA BLOB );
CREATE TABLE ZSIDECARFILE ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCOMPRESSEDSIZE INTEGER,
    ZINDEX INTEGER,
    ZASSET INTEGER,
    Z27_ASSET INTEGER,
    ZCAPTUREDATE TIMESTAMP,
    ZMODIFICATIONDATE TIMESTAMP,
    ZFILENAME VARCHAR,
    ZORIGINALFILENAME VARCHAR,
    ZUNIFORMTYPEIDENTIFIER VARCHAR );
CREATE TABLE ZUNMANAGEDADJUSTMENT ( Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZADJUSTMENTBASEIMAGEFORMAT INTEGER,
    ZASSETATTRIBUTES INTEGER,
    ZADJUSTMENTTIMESTAMP TIMESTAMP,
    ZADJUSTMENTFORMATIDENTIFIER VARCHAR,
    ZADJUSTMENTFORMATVERSION VARCHAR,
    ZEDITORLOCALIZEDNAME VARCHAR,
    ZOTHERADJUSTMENTSFINGERPRINT VARCHAR,
    ZSIMILARTOORIGINALADJUSTMENTSFINGERPRINT VARCHAR,
    ZUUID VARCHAR );
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZADJUSTEDFINGERPRINT_INDEX ON ZADDITIONALASSETATTRIBUTES (ZADJUSTEDFINGERPRINT);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZALLOWEDFORANALYSIS_INDEX ON ZADDITIONALASSETATTRIBUTES (ZALLOWEDFORANALYSIS);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZCAMERACAPTUREDEVICE_INDEX ON ZADDITIONALASSETATTRIBUTES (ZCAMERACAPTUREDEVICE);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZCREATORBUNDLEID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZCREATORBUNDLEID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZLOCATIONHASH_INDEX ON ZADDITIONALASSETATTRIBUTES (ZLOCATIONHASH);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZMASTERFINGERPRINT_INDEX ON ZADDITIONALASSETATTRIBUTES (ZMASTERFINGERPRINT);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZORIGINALASSETSUUID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZORIGINALASSETSUUID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZORIGINALHASH_INDEX ON ZADDITIONALASSETATTRIBUTES (ZORIGINALHASH);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZPUBLICGLOBALUUID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZPUBLICGLOBALUUID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZREVERSELOCATIONDATAISVALID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZREVERSELOCATIONDATAISVALID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZSHIFTEDLOCATIONISVALID_INDEX ON ZADDITIONALASSETATTRIBUTES (ZSHIFTEDLOCATIONISVALID);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZUPLOADATTEMPTS_INDEX ON ZADDITIONALASSETATTRIBUTES (ZUPLOADATTEMPTS);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZASSET_INDEX ON ZADDITIONALASSETATTRIBUTES (ZASSET);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZASSETDESCRIPTION_INDEX ON ZADDITIONALASSETATTRIBUTES (ZASSETDESCRIPTION);
CREATE INDEX ZADDITIONALASSETATTRIBUTES_ZUNMANAGEDADJUSTMENT_INDEX ON ZADDITIONALASSETATTRIBUTES (ZUNMANAGEDADJUSTMENT);
CREATE INDEX Z_1KEYWORDS_Z_30KEYWORDS_INDEX ON Z_1KEYWORDS (Z_30KEYWORDS,
    Z_1ASSETATTRIBUTES);
CREATE INDEX ZADJUSTMENT_ZASSET_INDEX ON ZADJUSTMENT (ZASSET);
CREATE INDEX ZALBUMLIST_ZIDENTIFIER_INDEX ON ZALBUMLIST (ZIDENTIFIER);
CREATE INDEX ZALBUMLIST_ZUUID_INDEX ON ZALBUMLIST (ZUUID);
CREATE INDEX ZASSETANALYSISSTATE_ZSORTTOKEN_INDEX ON ZASSETANALYSISSTATE (ZSORTTOKEN);
CREATE INDEX ZASSETANALYSISSTATE_ZWORKERTYPE_INDEX ON ZASSETANALYSISSTATE (ZWORKERTYPE);
CREATE INDEX ZASSETANALYSISSTATE_ZASSET_INDEX ON ZASSETANALYSISSTATE (ZASSET);
CREATE INDEX ZASSETANALYSISSTATE_ZWORKERTYPE_ZSORTTOKEN ON ZASSETANALYSISSTATE (ZWORKERTYPE,
    ZSORTTOKEN);
CREATE INDEX ZASSETANALYSISSTATE_ZANALYSISSTATE_ZWORKERTYPE_ZASSET ON ZASSETANALYSISSTATE (ZANALYSISSTATE,
    ZWORKERTYPE,
    ZASSET);
CREATE INDEX ZASSETDESCRIPTION_ZASSETATTRIBUTES_INDEX ON ZASSETDESCRIPTION (ZASSETATTRIBUTES);
CREATE INDEX ZCLOUDFEEDENTRY_ZENTRYDATE_INDEX ON ZCLOUDFEEDENTRY (ZENTRYDATE);
CREATE INDEX ZCLOUDFEEDENTRY_ZENTRYTYPENUMBER_INDEX ON ZCLOUDFEEDENTRY (ZENTRYTYPENUMBER);
CREATE INDEX ZCLOUDFEEDENTRY_Z_ENT_INDEX ON ZCLOUDFEEDENTRY (Z_ENT);
CREATE INDEX ZCLOUDFEEDENTRY_ZENTRYDATE_ZENTRYPRIORITYNUMBER_ZENTRYTYPENUMBER ON ZCLOUDFEEDENTRY (ZENTRYDATE,
    ZENTRYPRIORITYNUMBER,
    ZENTRYTYPENUMBER);
CREATE INDEX ZCLOUDFEEDENTRY_Z_ENT_ZENTRYDATE ON ZCLOUDFEEDENTRY (Z_ENT,
    ZENTRYDATE);
CREATE INDEX ZCLOUDMASTER_ZCLOUDLOCALSTATE_INDEX ON ZCLOUDMASTER (ZCLOUDLOCALSTATE);
CREATE INDEX ZCLOUDMASTER_ZCLOUDMASTERGUID_INDEX ON ZCLOUDMASTER (ZCLOUDMASTERGUID);
CREATE INDEX ZCLOUDMASTER_ZMEDIAMETADATA_INDEX ON ZCLOUDMASTER (ZMEDIAMETADATA);
CREATE INDEX ZCLOUDMASTERMEDIAMETADATA_ZCLOUDMASTER_INDEX ON ZCLOUDMASTERMEDIAMETADATA (ZCLOUDMASTER);
CREATE INDEX ZCLOUDRESOURCE_ZASSETUUID_INDEX ON ZCLOUDRESOURCE (ZASSETUUID);
CREATE INDEX ZCLOUDRESOURCE_ZDATECREATED_INDEX ON ZCLOUDRESOURCE (ZDATECREATED);
CREATE INDEX ZCLOUDRESOURCE_ZFINGERPRINT_INDEX ON ZCLOUDRESOURCE (ZFINGERPRINT);
CREATE INDEX ZCLOUDRESOURCE_ZISAVAILABLE_INDEX ON ZCLOUDRESOURCE (ZISAVAILABLE);
CREATE INDEX ZCLOUDRESOURCE_ZISLOCALLYAVAILABLE_INDEX ON ZCLOUDRESOURCE (ZISLOCALLYAVAILABLE);
CREATE INDEX ZCLOUDRESOURCE_ZLASTONDEMANDDOWNLOADDATE_INDEX ON ZCLOUDRESOURCE (ZLASTONDEMANDDOWNLOADDATE);
CREATE INDEX ZCLOUDRESOURCE_ZLASTPREFETCHDATE_INDEX ON ZCLOUDRESOURCE (ZLASTPREFETCHDATE);
CREATE INDEX ZCLOUDRESOURCE_ZPREFETCHCOUNT_INDEX ON ZCLOUDRESOURCE (ZPREFETCHCOUNT);
CREATE INDEX ZCLOUDRESOURCE_ZTYPE_INDEX ON ZCLOUDRESOURCE (ZTYPE);
CREATE INDEX ZCLOUDRESOURCE_ZASSET_INDEX ON ZCLOUDRESOURCE (ZASSET);
CREATE INDEX ZCLOUDRESOURCE_ZCLOUDMASTER_INDEX ON ZCLOUDRESOURCE (ZCLOUDMASTER);
CREATE INDEX ZCLOUDRESOURCE_ZTYPE_ZISLOCALLYAVAILABLE_ZDATECREATED ON ZCLOUDRESOURCE (ZTYPE,
    ZISLOCALLYAVAILABLE,
    ZDATECREATED);
CREATE INDEX ZCLOUDSHAREDALBUMINVITATIONRECORD_ZALBUM_INDEX ON ZCLOUDSHAREDALBUMINVITATIONRECORD (ZALBUM);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDGUID_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDGUID);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDFEEDCOMMENTENTRY_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDFEEDCOMMENTENTRY);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCLOUDFEEDLIKECOMMENTENTRY_INDEX ON ZCLOUDSHAREDCOMMENT (ZCLOUDFEEDLIKECOMMENTENTRY);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZCOMMENTEDASSET_INDEX ON ZCLOUDSHAREDCOMMENT (ZCOMMENTEDASSET);
CREATE INDEX ZCLOUDSHAREDCOMMENT_ZLIKEDASSET_INDEX ON ZCLOUDSHAREDCOMMENT (ZLIKEDASSET);
CREATE INDEX ZDEFERREDREBUILDFACE_ZASSETCLOUDGUID_INDEX ON ZDEFERREDREBUILDFACE (ZASSETCLOUDGUID);
CREATE INDEX ZDETECTEDFACE_ZCLOUDLOCALSTATE_INDEX ON ZDETECTEDFACE (ZCLOUDLOCALSTATE);
CREATE INDEX ZDETECTEDFACE_ZCLUSTERSEQUENCENUMBER_INDEX ON ZDETECTEDFACE (ZCLUSTERSEQUENCENUMBER);
CREATE INDEX ZDETECTEDFACE_ZUUID_INDEX ON ZDETECTEDFACE (ZUUID);
CREATE INDEX ZDETECTEDFACE_ZASSET_INDEX ON ZDETECTEDFACE (ZASSET);
CREATE INDEX ZDETECTEDFACE_ZFACECROP_INDEX ON ZDETECTEDFACE (ZFACECROP);
CREATE INDEX ZDETECTEDFACE_ZFACEGROUP_INDEX ON ZDETECTEDFACE (ZFACEGROUP);
CREATE INDEX ZDETECTEDFACE_ZFACEGROUPBEINGKEYFACE_INDEX ON ZDETECTEDFACE (ZFACEGROUPBEINGKEYFACE);
CREATE INDEX ZDETECTEDFACE_ZFACEPRINT_INDEX ON ZDETECTEDFACE (ZFACEPRINT);
CREATE INDEX ZDETECTEDFACE_ZPERSON_INDEX ON ZDETECTEDFACE (ZPERSON);
CREATE INDEX ZDETECTEDFACE_ZPERSONBEINGKEYFACE_INDEX ON ZDETECTEDFACE (ZPERSONBEINGKEYFACE);
CREATE INDEX Z_15REJECTEDPERSONS_Z_36REJECTEDPERSONS_INDEX ON Z_15REJECTEDPERSONS (Z_36REJECTEDPERSONS,
    Z_15REJECTEDFACES);
CREATE INDEX Z_15REJECTEDPERSONSNEEDINGFACECROPS_Z_36REJECTEDPERSONSNEEDINGFACECROPS_INDEX ON Z_15REJECTEDPERSONSNEEDINGFACECROPS (Z_36REJECTEDPERSONSNEEDINGFACECROPS,
    Z_15REJECTEDFACESNEEDINGFACECROPS);
CREATE INDEX ZDETECTEDFACEGROUP_ZPERSONBUILDERSTATE_INDEX ON ZDETECTEDFACEGROUP (ZPERSONBUILDERSTATE);
CREATE INDEX ZDETECTEDFACEGROUP_ZASSOCIATEDPERSON_INDEX ON ZDETECTEDFACEGROUP (ZASSOCIATEDPERSON);
CREATE INDEX ZDETECTEDFACEGROUP_ZKEYFACE_INDEX ON ZDETECTEDFACEGROUP (ZKEYFACE);
CREATE INDEX ZDETECTEDFACEPRINT_ZFACE_INDEX ON ZDETECTEDFACEPRINT (ZFACE);
CREATE INDEX ZFACECROP_ZCLOUDLOCALSTATE_INDEX ON ZFACECROP (ZCLOUDLOCALSTATE);
CREATE INDEX ZFACECROP_ZUUID_INDEX ON ZFACECROP (ZUUID);
CREATE INDEX ZFACECROP_ZASSET_INDEX ON ZFACECROP (ZASSET);
CREATE INDEX ZFACECROP_ZFACE_INDEX ON ZFACECROP (ZFACE);
CREATE INDEX ZFACECROP_ZPERSON_INDEX ON ZFACECROP (ZPERSON);
CREATE INDEX ZGENERICALBUM_ZCLOUDGUID_INDEX ON ZGENERICALBUM (ZCLOUDGUID);
CREATE INDEX ZGENERICALBUM_ZCLOUDLOCALSTATE_INDEX ON ZGENERICALBUM (ZCLOUDLOCALSTATE);
CREATE INDEX ZGENERICALBUM_ZKIND_INDEX ON ZGENERICALBUM (ZKIND);
CREATE INDEX ZGENERICALBUM_ZSYNCEVENTORDERKEY_INDEX ON ZGENERICALBUM (ZSYNCEVENTORDERKEY);
CREATE INDEX ZGENERICALBUM_ZUUID_INDEX ON ZGENERICALBUM (ZUUID);
CREATE INDEX ZGENERICALBUM_ZCUSTOMKEYASSET_INDEX ON ZGENERICALBUM (ZCUSTOMKEYASSET);
CREATE INDEX ZGENERICALBUM_ZKEYASSET_INDEX ON ZGENERICALBUM (ZKEYASSET);
CREATE INDEX ZGENERICALBUM_ZPARENTFOLDER_INDEX ON ZGENERICALBUM (ZPARENTFOLDER);
CREATE INDEX ZGENERICALBUM_ZSECONDARYKEYASSET_INDEX ON ZGENERICALBUM (ZSECONDARYKEYASSET);
CREATE INDEX ZGENERICALBUM_ZTERTIARYKEYASSET_INDEX ON ZGENERICALBUM (ZTERTIARYKEYASSET);
CREATE INDEX ZGENERICALBUM_ZWALLPAPERALBUMTYPE_INDEX ON ZGENERICALBUM (ZWALLPAPERALBUMTYPE);
CREATE INDEX Z_19ALBUMLISTS_Z_3ALBUMLISTS_INDEX ON Z_19ALBUMLISTS (Z_3ALBUMLISTS,
    Z_19ALBUMS);
CREATE INDEX ZGENERICALBUM_Z_ENT_INDEX ON ZGENERICALBUM (Z_ENT);
CREATE INDEX Z_20ASSETS_Z_27ASSETS_INDEX ON Z_20ASSETS (Z_27ASSETS,
    Z_20ALBUMS);
CREATE INDEX ZGENERICASSET_ZADDEDDATE_INDEX ON ZGENERICASSET (ZADDEDDATE);
CREATE INDEX ZGENERICASSET_ZAVALANCHEPICKTYPE_INDEX ON ZGENERICASSET (ZAVALANCHEPICKTYPE);
CREATE INDEX ZGENERICASSET_ZAVALANCHEUUID_INDEX ON ZGENERICASSET (ZAVALANCHEUUID);
CREATE INDEX ZGENERICASSET_ZCLOUDASSETGUID_INDEX ON ZGENERICASSET (ZCLOUDASSETGUID);
CREATE INDEX ZGENERICASSET_ZCLOUDLOCALSTATE_INDEX ON ZGENERICASSET (ZCLOUDLOCALSTATE);
CREATE INDEX ZGENERICASSET_ZCLOUDPLACEHOLDERKIND_INDEX ON ZGENERICASSET (ZCLOUDPLACEHOLDERKIND);
CREATE INDEX ZGENERICASSET_ZCOMPLETE_INDEX ON ZGENERICASSET (ZCOMPLETE);
CREATE INDEX ZGENERICASSET_ZCUSTOMRENDEREDVALUE_INDEX ON ZGENERICASSET (ZCUSTOMRENDEREDVALUE);
CREATE INDEX ZGENERICASSET_ZDATECREATED_INDEX ON ZGENERICASSET (ZDATECREATED);
CREATE INDEX ZGENERICASSET_ZFAVORITE_INDEX ON ZGENERICASSET (ZFAVORITE);
CREATE INDEX ZGENERICASSET_ZKIND_INDEX ON ZGENERICASSET (ZKIND);
CREATE INDEX ZGENERICASSET_ZKINDSUBTYPE_INDEX ON ZGENERICASSET (ZKINDSUBTYPE);
CREATE INDEX ZGENERICASSET_ZLASTSHAREDDATE_INDEX ON ZGENERICASSET (ZLASTSHAREDDATE);
CREATE INDEX ZGENERICASSET_ZMEDIAGROUPUUID_INDEX ON ZGENERICASSET (ZMEDIAGROUPUUID);
CREATE INDEX ZGENERICASSET_ZSAVEDASSETTYPE_INDEX ON ZGENERICASSET (ZSAVEDASSETTYPE);
CREATE INDEX ZGENERICASSET_ZSORTTOKEN_INDEX ON ZGENERICASSET (ZSORTTOKEN);
CREATE INDEX ZGENERICASSET_ZTHUMBNAILINDEX_INDEX ON ZGENERICASSET (ZTHUMBNAILINDEX);
CREATE INDEX ZGENERICASSET_ZUUID_INDEX ON ZGENERICASSET (ZUUID);
CREATE INDEX ZGENERICASSET_ZVISIBILITYSTATE_INDEX ON ZGENERICASSET (ZVISIBILITYSTATE);
CREATE INDEX ZGENERICASSET_ZADDITIONALATTRIBUTES_INDEX ON ZGENERICASSET (ZADDITIONALATTRIBUTES);
CREATE INDEX ZGENERICASSET_ZCLOUDFEEDASSETSENTRY_INDEX ON ZGENERICASSET (ZCLOUDFEEDASSETSENTRY);
CREATE INDEX ZGENERICASSET_ZMASTER_INDEX ON ZGENERICASSET (ZMASTER);
CREATE INDEX ZGENERICASSET_ZMOMENT_INDEX ON ZGENERICASSET (ZMOMENT);
CREATE INDEX ZGENERICASSET_ZSEARCHDATA_INDEX ON ZGENERICASSET (ZSEARCHDATA);
CREATE INDEX Z_27MEMORIESBEINGREPRESENTATIVEASSETS_Z_32MEMORIESBEINGREPRESENTATIVEASSETS_INDEX ON Z_27MEMORIESBEINGREPRESENTATIVEASSETS (Z_32MEMORIESBEINGREPRESENTATIVEASSETS,
    Z_27REPRESENTATIVEASSETS);
CREATE INDEX Z_27MEMORIESBEINGCURATEDASSETS_Z_32MEMORIESBEINGCURATEDASSETS_INDEX ON Z_27MEMORIESBEINGCURATEDASSETS (Z_32MEMORIESBEINGCURATEDASSETS,
    Z_27CURATEDASSETS);
CREATE INDEX Z_27MEMORIESBEINGMOVIECURATEDASSETS_Z_32MEMORIESBEINGMOVIECURATEDASSETS_INDEX ON Z_27MEMORIESBEINGMOVIECURATEDASSETS (Z_32MEMORIESBEINGMOVIECURATEDASSETS,
    Z_27MOVIECURATEDASSETS);
CREATE INDEX ZGENERICASSET_Z_ENT_INDEX ON ZGENERICASSET (Z_ENT);
CREATE INDEX ZGENERICASSET_ZKIND_Z_ENT ON ZGENERICASSET (ZKIND,
    Z_ENT);
CREATE INDEX ZGENERICASSET_ZCLOUDASSETGUID_ZSAVEDASSETTYPE ON ZGENERICASSET (ZCLOUDASSETGUID,
    ZSAVEDASSETTYPE);
CREATE INDEX ZGENERICASSET_ZDIRECTORY_ZFILENAME ON ZGENERICASSET (ZDIRECTORY,
    ZFILENAME);
CREATE INDEX ZGENERICASSET_ZCLOUDLOCALSTATE ON ZGENERICASSET (ZCLOUDLOCALSTATE);
CREATE INDEX ZGENERICASSET_ZHIDDEN_ZVISIBILITYSTATE ON ZGENERICASSET (ZHIDDEN,
    ZVISIBILITYSTATE);
CREATE INDEX ZGENERICASSET_ZTRASHEDSTATE_ZTRASHEDDATE ON ZGENERICASSET (ZTRASHEDSTATE,
    ZTRASHEDDATE);
CREATE INDEX ZGENERICASSET_ZADDEDDATE_ZSORTTOKEN ON ZGENERICASSET (ZADDEDDATE,
    ZSORTTOKEN);
CREATE INDEX ZGENERICASSET_ZADDEDDATE_ZSORTTOKEN_ZKIND_ZSAVEDASSETTYPE_ZVISIBILITYSTATE_ZTRASHEDSTATE_ZHIDDEN_ZAVALANCHEPICKTYPE_ZCOMPLETE_Z_ENT ON ZGENERICASSET (ZADDEDDATE,
    ZSORTTOKEN,
    ZKIND,
    ZSAVEDASSETTYPE,
    ZVISIBILITYSTATE,
    ZTRASHEDSTATE,
    ZHIDDEN,
    ZAVALANCHEPICKTYPE,
    ZCOMPLETE,
    Z_ENT);
CREATE INDEX ZGENERICASSET_ZTRASHEDSTATE_ZCLOUDLOCALSTATE_ZSAVEDASSETTYPE ON ZGENERICASSET (ZTRASHEDSTATE,
    ZCLOUDLOCALSTATE,
    ZSAVEDASSETTYPE);
CREATE INDEX ZGENERICASSET_ZKIND_ZTRASHEDSTATE_ZCLOUDLOCALSTATE_ZSAVEDASSETTYPE ON ZGENERICASSET (ZKIND,
    ZTRASHEDSTATE,
    ZCLOUDLOCALSTATE,
    ZSAVEDASSETTYPE);
CREATE INDEX ZKEYWORD_ZTITLE_INDEX ON ZKEYWORD (ZTITLE);
CREATE INDEX ZLEGACYFACE_ZALBUMUUID_INDEX ON ZLEGACYFACE (ZALBUMUUID);
CREATE INDEX ZLEGACYFACE_ZIDENTIFIER_INDEX ON ZLEGACYFACE (ZIDENTIFIER);
CREATE INDEX ZLEGACYFACE_ZASSET_INDEX ON ZLEGACYFACE (ZASSET);
CREATE INDEX ZMEMORY_ZCLOUDLOCALSTATE_INDEX ON ZMEMORY (ZCLOUDLOCALSTATE);
CREATE INDEX ZMEMORY_ZLASTMOVIEPLAYEDDATE_INDEX ON ZMEMORY (ZLASTMOVIEPLAYEDDATE);
CREATE INDEX ZMEMORY_ZLASTVIEWEDDATE_INDEX ON ZMEMORY (ZLASTVIEWEDDATE);
CREATE INDEX ZMEMORY_ZPENDING_INDEX ON ZMEMORY (ZPENDING);
CREATE INDEX ZMEMORY_ZUUID_INDEX ON ZMEMORY (ZUUID);
CREATE INDEX ZMEMORY_ZKEYASSET_INDEX ON ZMEMORY (ZKEYASSET);
CREATE INDEX ZMOMENT_ZENDDATE_INDEX ON ZMOMENT (ZENDDATE);
CREATE INDEX ZMOMENT_ZREPRESENTATIVEDATE_INDEX ON ZMOMENT (ZREPRESENTATIVEDATE);
CREATE INDEX ZMOMENT_ZREVERSELOCATIONDATAISVALID_INDEX ON ZMOMENT (ZREVERSELOCATIONDATAISVALID);
CREATE INDEX ZMOMENT_ZSTARTDATE_INDEX ON ZMOMENT (ZSTARTDATE);
CREATE INDEX ZMOMENT_ZTRASHEDSTATE_INDEX ON ZMOMENT (ZTRASHEDSTATE);
CREATE INDEX ZMOMENT_ZUUID_INDEX ON ZMOMENT (ZUUID);
CREATE INDEX ZMOMENT_ZMEGAMOMENTLIST_INDEX ON ZMOMENT (ZMEGAMOMENTLIST);
CREATE INDEX ZMOMENT_ZMOMENTLIBRARY_INDEX ON ZMOMENT (ZMOMENTLIBRARY);
CREATE INDEX ZMOMENT_ZYEARMOMENTLIST_INDEX ON ZMOMENT (ZYEARMOMENTLIST);
CREATE INDEX ZMOMENT_ZSTARTDATE_ZENDDATE ON ZMOMENT (ZSTARTDATE,
    ZENDDATE);
CREATE INDEX ZMOMENTLIST_ZGRANULARITYLEVEL_INDEX ON ZMOMENTLIST (ZGRANULARITYLEVEL);
CREATE INDEX ZMOMENTLIST_ZREPRESENTATIVEDATE_INDEX ON ZMOMENTLIST (ZREPRESENTATIVEDATE);
CREATE INDEX ZMOMENTLIST_ZREVERSELOCATIONDATAISVALID_INDEX ON ZMOMENTLIST (ZREVERSELOCATIONDATAISVALID);
CREATE INDEX ZMOMENTLIST_ZSORTINDEX_INDEX ON ZMOMENTLIST (ZSORTINDEX);
CREATE INDEX ZMOMENTLIST_ZTRASHEDSTATE_INDEX ON ZMOMENTLIST (ZTRASHEDSTATE);
CREATE INDEX ZMOMENTLIST_ZUUID_INDEX ON ZMOMENTLIST (ZUUID);
CREATE INDEX ZMOMENTLIST_ZGRANULARITYLEVEL_ZSORTINDEX ON ZMOMENTLIST (ZGRANULARITYLEVEL,
    ZSORTINDEX);
CREATE INDEX ZMOMENTLIST_ZREVERSELOCATIONDATAISVALID_ZGRANULARITYLEVEL ON ZMOMENTLIST (ZREVERSELOCATIONDATAISVALID,
    ZGRANULARITYLEVEL);
CREATE INDEX ZPERSON_ZCLOUDLOCALSTATE_INDEX ON ZPERSON (ZCLOUDLOCALSTATE);
CREATE INDEX ZPERSON_ZFACECOUNT_INDEX ON ZPERSON (ZFACECOUNT);
CREATE INDEX ZPERSON_ZMANUALORDER_INDEX ON ZPERSON (ZMANUALORDER);
CREATE INDEX ZPERSON_ZPERSONUUID_INDEX ON ZPERSON (ZPERSONUUID);
CREATE INDEX ZPERSON_ZPERSONURI_INDEX ON ZPERSON (ZPERSONURI);
CREATE INDEX ZPERSON_ZTYPE_INDEX ON ZPERSON (ZTYPE);
CREATE INDEX ZPERSON_ZASSOCIATEDFACEGROUP_INDEX ON ZPERSON (ZASSOCIATEDFACEGROUP);
CREATE INDEX ZPERSON_ZKEYFACE_INDEX ON ZPERSON (ZKEYFACE);
CREATE INDEX ZPERSON_ZVERIFIED_ZFACECOUNT_ZTYPE ON ZPERSON (ZVERIFIED,
    ZFACECOUNT,
    ZTYPE);
CREATE INDEX ZPERSONREFERENCE_ZASSETATTRIBUTES_INDEX ON ZPERSONREFERENCE (ZASSETATTRIBUTES);
CREATE INDEX ZPERSONREFERENCE_ZPERSON_INDEX ON ZPERSONREFERENCE (ZPERSON);
CREATE INDEX ZSCENECLASSIFICATION_ZASSETATTRIBUTES_INDEX ON ZSCENECLASSIFICATION (ZASSETATTRIBUTES);
CREATE INDEX ZSEARCHDATA_ZVALID_INDEX ON ZSEARCHDATA (ZVALID);
CREATE INDEX ZSEARCHDATA_ZASSET_INDEX ON ZSEARCHDATA (ZASSET);
CREATE INDEX ZSIDECARFILE_ZASSET_INDEX ON ZSIDECARFILE (ZASSET);
CREATE INDEX ZUNMANAGEDADJUSTMENT_ZASSETATTRIBUTES_INDEX ON ZUNMANAGEDADJUSTMENT (ZASSETATTRIBUTES);
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_INSERT_INCREMENT AFTER INSERT ON ZGENERICASSET FOR EACH ROW WHEN NEW.ZTRASHEDSTATE == 0 AND NEW.ZVISIBILITYSTATE == 0 AND NEW.ZHIDDEN == 0 BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = IFNULL(ZASSETVISIBLE,0) + 1 WHERE NEW.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_UPDATE_INCREMENT AFTER UPDATE OF ZTRASHEDSTATE,
    ZVISIBILITYSTATE,
    ZHIDDEN ON ZGENERICASSET FOR EACH ROW WHEN (NEW.ZTRASHEDSTATE == 0 AND NEW.ZVISIBILITYSTATE == 0 AND NEW.ZHIDDEN == 0) AND (NEW.ZTRASHEDSTATE != OLD.ZTRASHEDSTATE OR NEW.ZVISIBILITYSTATE != OLD.ZVISIBILITYSTATE OR NEW.ZHIDDEN != OLD.ZHIDDEN) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = IFNULL(ZASSETVISIBLE,0) + 1 WHERE NEW.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_UPDATE_DECREMENT AFTER UPDATE OF ZTRASHEDSTATE,
    ZVISIBILITYSTATE,
    ZHIDDEN ON ZGENERICASSET FOR EACH ROW WHEN (OLD.ZTRASHEDSTATE == 0 AND OLD.ZVISIBILITYSTATE == 0 AND OLD.ZHIDDEN == 0) AND (NEW.ZTRASHEDSTATE != OLD.ZTRASHEDSTATE OR NEW.ZVISIBILITYSTATE != OLD.ZVISIBILITYSTATE OR NEW.ZHIDDEN != OLD.ZHIDDEN) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = MAX(0,IFNULL(ZASSETVISIBLE,0) - 1) WHERE OLD.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_DELETE_DECREMENT AFTER DELETE ON ZGENERICASSET FOR EACH ROW WHEN OLD.ZTRASHEDSTATE == 0 AND OLD.ZVISIBILITYSTATE == 0 AND OLD.ZHIDDEN == 0 BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = MAX(0,IFNULL(ZASSETVISIBLE,0) - 1) WHERE OLD.Z_PK = ZASSET; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE ZASSET = OLD.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_ZDETECTEDFACE_INSERT_INCREMENT AFTER INSERT ON ZDETECTEDFACE FOR EACH ROW BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = (SELECT COUNT(Z_PK) FROM ZGENERICASSET WHERE (Z_PK = NEW.ZASSET) AND (ZTRASHEDSTATE == 0 AND ZVISIBILITYSTATE == 0 AND ZHIDDEN == 0)) WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE Z_PK = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_ZASSET_UPDATE_TO_NULL AFTER UPDATE OF ZASSET ON ZDETECTEDFACE WHEN (NEW.ZASSET IS NULL AND OLD.ZASSET IS NOT NULL) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = 0 WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE Z_PK = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZDETECTEDFACE_ZASSETVISIBLE_ZGENERICASSET_ZASSET_UPDATE_INCREMENT AFTER UPDATE OF ZASSET ON ZDETECTEDFACE WHEN ((NEW.ZASSET IS NOT NULL AND OLD.ZASSET IS NULL) OR (NEW.ZASSET != OLD.ZASSET)) BEGIN UPDATE ZDETECTEDFACE SET ZASSETVISIBLE = (SELECT COUNT(Z_PK) FROM ZGENERICASSET WHERE Z_PK = NEW.ZASSET AND (ZTRASHEDSTATE == 0 AND ZVISIBILITYSTATE == 0 AND ZHIDDEN == 0)) WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZDETECTEDFACE',
    Z_ENT,
    Z_PK,
    'ZASSETVISIBLE',
    ZASSETVISIBLE) FROM ZDETECTEDFACE WHERE Z_PK = NEW.Z_PK; END;
CREATE VIRTUAL TABLE Z_RT_GenericAsset_boundedByRect USING RTREE (Z_PK INTEGER PRIMARY KEY,
    ZLATITUDE_MIN FLOAT,
    ZLATITUDE_MAX FLOAT,
    ZLONGITUDE_MIN FLOAT,
    ZLONGITUDE_MAX FLOAT);
CREATE TABLE IF NOT EXISTS "Z_RT_GenericAsset_boundedByRect_node"(nodeno INTEGER PRIMARY KEY,
    data BLOB);
CREATE TABLE IF NOT EXISTS "Z_RT_GenericAsset_boundedByRect_rowid"(rowid INTEGER PRIMARY KEY,
    nodeno INTEGER);
CREATE TABLE IF NOT EXISTS "Z_RT_GenericAsset_boundedByRect_parent"(nodeno INTEGER PRIMARY KEY,
    parentnode INTEGER);
CREATE TRIGGER Z_RT_GenericAsset_boundedByRect_INSERT AFTER INSERT ON ZGENERICASSET FOR EACH ROW BEGIN INSERT OR REPLACE INTO Z_RT_GenericAsset_boundedByRect (Z_PK,
    ZLATITUDE_MIN,
    ZLATITUDE_MAX,
    ZLONGITUDE_MIN,
    ZLONGITUDE_MAX) VALUES (NEW.Z_PK,
    NEW.ZLATITUDE ,NEW.ZLATITUDE,
    NEW.ZLONGITUDE,
    NEW.ZLONGITUDE) ; END;
CREATE TRIGGER Z_RT_GenericAsset_boundedByRect_UPDATE AFTER UPDATE ON ZGENERICASSET FOR EACH ROW BEGIN DELETE FROM Z_RT_GenericAsset_boundedByRect WHERE Z_PK = NEW.Z_PK ; INSERT INTO Z_RT_GenericAsset_boundedByRect (Z_PK,
    ZLATITUDE_MIN,
    ZLATITUDE_MAX,
    ZLONGITUDE_MIN,
    ZLONGITUDE_MAX) VALUES (NEW.Z_PK,
    NEW.ZLATITUDE ,NEW.ZLATITUDE,
    NEW.ZLONGITUDE,
    NEW.ZLONGITUDE) ; END;
CREATE TRIGGER Z_RT_GenericAsset_boundedByRect_DELETE AFTER DELETE ON ZGENERICASSET FOR EACH ROW BEGIN DELETE FROM Z_RT_GenericAsset_boundedByRect WHERE Z_PK = OLD.Z_PK ; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_INSERT_INCREMENT AFTER INSERT ON ZDETECTEDFACE FOR EACH ROW WHEN NEW.ZHIDDEN == 0 AND NEW.ZASSETVISIBLE == 1 BEGIN UPDATE ZPERSON SET ZFACECOUNT = IFNULL(ZFACECOUNT,0) + 1 WHERE NEW.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_UPDATE_INCREMENT AFTER UPDATE OF ZHIDDEN,
    ZASSETVISIBLE ON ZDETECTEDFACE FOR EACH ROW WHEN (NEW.ZHIDDEN == 0 AND NEW.ZASSETVISIBLE == 1) AND (NEW.ZHIDDEN != OLD.ZHIDDEN OR NEW.ZASSETVISIBLE != OLD.ZASSETVISIBLE) AND (NEW.ZPERSON == OLD.ZPERSON) BEGIN UPDATE ZPERSON SET ZFACECOUNT = IFNULL(ZFACECOUNT,0) + 1 WHERE NEW.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_UPDATE_DECREMENT AFTER UPDATE OF ZHIDDEN,
    ZASSETVISIBLE ON ZDETECTEDFACE FOR EACH ROW WHEN (OLD.ZHIDDEN == 0 AND OLD.ZASSETVISIBLE == 1) AND (NEW.ZHIDDEN != OLD.ZHIDDEN OR NEW.ZASSETVISIBLE != OLD.ZASSETVISIBLE) AND (OLD.ZPERSON == NEW.ZPERSON) BEGIN UPDATE ZPERSON SET ZFACECOUNT = MAX(0,IFNULL(ZFACECOUNT,0) - 1) WHERE OLD.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_DELETE_DECREMENT AFTER DELETE ON ZDETECTEDFACE FOR EACH ROW WHEN OLD.ZHIDDEN == 0 AND OLD.ZASSETVISIBLE == 1 BEGIN UPDATE ZPERSON SET ZFACECOUNT = MAX(0,IFNULL(ZFACECOUNT,0) - 1) WHERE OLD.ZPERSON = Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = OLD.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_ZPERSON_INSERT_INCREMENT AFTER INSERT ON ZPERSON FOR EACH ROW BEGIN UPDATE ZPERSON SET ZFACECOUNT = (SELECT COUNT(Z_PK) FROM ZDETECTEDFACE WHERE (ZPERSON = NEW.Z_PK) AND (ZHIDDEN == 0 AND ZASSETVISIBLE == 1)) WHERE Z_PK = NEW.Z_PK; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.Z_PK; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_ZPERSON_UPDATE_INCREMENT AFTER UPDATE OF ZPERSON ON ZDETECTEDFACE WHEN (NEW.ZHIDDEN == 0 AND NEW.ZASSETVISIBLE == 1) AND ((NEW.ZPERSON IS NOT NULL AND OLD.ZPERSON IS NULL) OR (NEW.ZPERSON != OLD.ZPERSON)) BEGIN UPDATE ZPERSON SET ZFACECOUNT = IFNULL(ZFACECOUNT,0) + 1 WHERE Z_PK = NEW.ZPERSON; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = NEW.ZPERSON; END;
CREATE TRIGGER ZT_ZPERSON_ZFACECOUNT_ZDETECTEDFACE_ZPERSON_UPDATE_DECREMENT AFTER UPDATE OF ZPERSON ON ZDETECTEDFACE WHEN (OLD.ZHIDDEN == 0 AND OLD.ZASSETVISIBLE == 1) AND ((OLD.ZPERSON IS NOT NULL AND NEW.ZPERSON IS NULL) OR (NEW.ZPERSON != OLD.ZPERSON)) BEGIN UPDATE ZPERSON SET ZFACECOUNT = MAX(0,IFNULL(ZFACECOUNT,0) - 1) WHERE Z_PK = OLD.ZPERSON; SELECT NSCoreDataTriggerUpdateAffectedObjectValue('ZPERSON',
    Z_ENT,
    Z_PK,
    'ZFACECOUNT',
    ZFACECOUNT) FROM ZPERSON WHERE Z_PK = OLD.ZPERSON; END;
CREATE TABLE Z_PRIMARYKEY (Z_ENT INTEGER PRIMARY KEY,
    Z_NAME VARCHAR,
    Z_SUPER INTEGER,
    Z_MAX INTEGER);
CREATE TABLE Z_METADATA (Z_VERSION INTEGER PRIMARY KEY,
    Z_UUID VARCHAR(255),
    Z_PLIST BLOB);
CREATE TABLE Z_MODELCACHE (Z_CONTENT BLOB);
CREATE INDEX RADAR_10322662_INDEX ON Z_20ASSETS (Z_20ALBUMS,
    Z_27ASSETS,
    Z_FOK_27ASSETS);
CREATE INDEX RADAR_16788878_INDEX ON ZMOMENT (ZMOMENTLIBRARY,
    Z_FOK_MOMENTLIBRARY);
CREATE INDEX RADAR_16835859_INDEX ON ZGENERICASSET (ZMOMENT,
    Z_FOK_MOMENT);
CREATE INDEX RADAR_22158684_INDEX ON Z_20ASSETS (Z_20ALBUMS,
    Z_FOK_27ASSETS,
    Z_27ASSETS);
