CREATE TABLE ZNEXTID (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCOUNTER INTEGER );
CREATE TABLE ZNOTE (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCONTAINSCJK INTEGER,
    ZCONTENTTYPE INTEGER,
    ZDELETEDFLAG INTEGER,
    ZEXTERNALFLAGS INTEGER,
    ZEXTERNALSEQUENCENUMBER INTEGER,
    ZEXTERNALSERVERINTID INTEGER,
    ZINTEGERID INTEGER,
    ZISBOOKKEEPINGENTRY INTEGER,
    ZBODY INTEGER,
    ZSTORE INTEGER,
    ZCREATIONDATE TIMESTAMP,
    ZMODIFICATIONDATE TIMESTAMP,
    ZAUTHOR VARCHAR,
    ZGUID VARCHAR,
    ZSERVERID VARCHAR,
    ZSUMMARY VARCHAR,
    ZTITLE VARCHAR );
CREATE TABLE ZNOTEATTACHMENT (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZNOTE INTEGER,
    ZCONTENTID VARCHAR,
    ZFILENAME VARCHAR,
    ZMIMETYPE VARCHAR );
CREATE TABLE ZNOTEBODY (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZOWNER INTEGER,
    ZCONTENT VARCHAR,
    ZEXTERNALCONTENTREF VARCHAR,
    ZEXTERNALREPRESENTATION BLOB );
CREATE TABLE ZNOTECHANGE (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCHANGETYPE INTEGER,
    ZSTORE INTEGER,
    ZNOTEINTEGERIDS BLOB,
    ZNOTESERVERIDS BLOB,
    ZNOTESERVERINTIDS BLOB );
CREATE TABLE ZPROPERTY (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZPROPERTYKEY VARCHAR,
    ZPROPERTYVALUE BLOB );
CREATE TABLE ZSTORE (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZACCOUNT INTEGER,
    ZEXTERNALIDENTIFIER VARCHAR,
    ZNAME VARCHAR,
    ZSYNCANCHOR VARCHAR );
CREATE INDEX ZNOTE_ZINTEGERID_INDEX ON ZNOTE (ZINTEGERID);
CREATE INDEX ZNOTE_ZBODY_INDEX ON ZNOTE (ZBODY);
CREATE INDEX ZNOTE_ZSTORE_INDEX ON ZNOTE (ZSTORE);
CREATE INDEX ZNOTEATTACHMENT_ZNOTE_INDEX ON ZNOTEATTACHMENT (ZNOTE);
CREATE INDEX ZNOTEBODY_ZOWNER_INDEX ON ZNOTEBODY (ZOWNER);
CREATE INDEX ZNOTECHANGE_ZSTORE_INDEX ON ZNOTECHANGE (ZSTORE);
CREATE INDEX ZSTORE_ZACCOUNT_INDEX ON ZSTORE (ZACCOUNT);
CREATE TABLE Z_PRIMARYKEY (
    Z_ENT INTEGER PRIMARY KEY,
    Z_NAME VARCHAR,
    Z_SUPER INTEGER,
    Z_MAX INTEGER);
CREATE TABLE Z_METADATA (
    Z_VERSION INTEGER PRIMARY KEY,
    Z_UUID VARCHAR(255),
    Z_PLIST BLOB);
CREATE TABLE Z_MODELCACHE (
    Z_CONTENT BLOB);
CREATE TABLE ZACCOUNT (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZDIDCHOOSETOMIGRATE INTEGER,
    ZTYPE INTEGER,
    ZDEFAULTSTORE INTEGER,
    ZACCOUNTIDENTIFIER VARCHAR,
    ZCONSTRAINTSPATH VARCHAR,
    ZNAME VARCHAR );
CREATE INDEX ZACCOUNT_ZDEFAULTSTORE_INDEX ON ZACCOUNT (ZDEFAULTSTORE);
