CREATE TABLE ZICAUTHOR (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZSTATUS INTEGER,
    ZGROUP INTEGER,
    ZPERSON INTEGER );
CREATE TABLE ZICCLOUDSTATE (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCURRENTLOCALVERSION INTEGER,
    ZINCLOUD INTEGER,
    ZLATESTVERSIONSYNCEDTOCLOUD INTEGER,
    ZCLOUDSYNCINGOBJECT INTEGER,
    Z3_CLOUDSYNCINGOBJECT INTEGER,
    ZLOCALVERSIONDATE TIMESTAMP );
CREATE TABLE Z_4PREVIEWIMAGES (
    Z_4ATTACHMENTS INTEGER,
    Z_5PREVIEWIMAGES INTEGER,
    PRIMARY KEY (Z_4ATTACHMENTS, Z_5PREVIEWIMAGES) );
CREATE TABLE Z_12NOTES (
    Z_12FOLDERS INTEGER,
    Z_9NOTES INTEGER,
    PRIMARY KEY (Z_12FOLDERS, Z_9NOTES) );
CREATE TABLE ZICDDEVICE (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZSHARINGEXTENSIONDEVICE INTEGER,
    ZPERSON INTEGER,
    ZIDENTIFIER VARCHAR,
    ZNAME VARCHAR );
CREATE TABLE ZICGROUP (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZSHARETIMESTAMP INTEGER,
    ZNOTES INTEGER,
    ZIDENTIFIER VARCHAR );
CREATE TABLE ZICLOCATION (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZPLACEUPDATED INTEGER,
    ZATTACHMENT INTEGER,
    ZLATITUDE FLOAT,
    ZLONGITUDE FLOAT,
    ZPLACEMARK BLOB );
CREATE TABLE ZICNOTECHANGE (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCHANGETYPE INTEGER,
    ZFOLDER INTEGER,
    ZLEGACYNOTEINTEGERIDS BLOB,
    ZNOTEIDENTIFIERS BLOB );
CREATE TABLE ZICNOTEDATA (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZNOTE INTEGER,
    ZDATA BLOB );
CREATE TABLE ZICPERSON (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZIDENTIFIER VARCHAR,
    ZNAME VARCHAR,
    ZPUBLICCLOUDKITRECORDNAME VARCHAR );
CREATE TABLE ZICSEARCHINDEXTRANSACTION (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZLASTTRANSACTIONID INTEGER,
    ZIDENTIFIER VARCHAR );
CREATE TABLE ZICSERVERCHANGETOKEN (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZACCOUNT INTEGER,
    ZZONENAME VARCHAR,
    ZCKSERVERCHANGETOKEN BLOB );
CREATE TABLE ZNEXTID (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCOUNTER INTEGER );
CREATE INDEX ZICAUTHOR_ZGROUP_INDEX ON ZICAUTHOR (ZGROUP);
CREATE INDEX ZICAUTHOR_ZPERSON_INDEX ON ZICAUTHOR (ZPERSON);
CREATE INDEX ZICCLOUDSTATE_ZCLOUDSYNCINGOBJECT_INDEX ON ZICCLOUDSTATE (ZCLOUDSYNCINGOBJECT);
CREATE INDEX Z_4PREVIEWIMAGES_Z_5PREVIEWIMAGES_INDEX ON Z_4PREVIEWIMAGES (Z_5PREVIEWIMAGES,
    Z_4ATTACHMENTS);
CREATE INDEX Z_12NOTES_Z_9NOTES_INDEX ON Z_12NOTES (Z_9NOTES,
    Z_12FOLDERS);
CREATE INDEX ZICDDEVICE_ZPERSON_INDEX ON ZICDDEVICE (ZPERSON);
CREATE INDEX ZICGROUP_ZNOTES_INDEX ON ZICGROUP (ZNOTES);
CREATE INDEX ZICLOCATION_ZATTACHMENT_INDEX ON ZICLOCATION (ZATTACHMENT);
CREATE INDEX ZICLOCATION_Z_ENT_INDEX ON ZICLOCATION (Z_ENT);
CREATE INDEX ZICNOTECHANGE_ZFOLDER_INDEX ON ZICNOTECHANGE (ZFOLDER);
CREATE INDEX ZICNOTEDATA_ZNOTE_INDEX ON ZICNOTEDATA (ZNOTE);
CREATE INDEX ZICSERVERCHANGETOKEN_ZACCOUNT_INDEX ON ZICSERVERCHANGETOKEN (ZACCOUNT);
CREATE TABLE Z_PRIMARYKEY (
    Z_ENT INTEGER PRIMARY KEY,
    Z_NAME VARCHAR,
    Z_SUPER INTEGER,
    Z_MAX INTEGER);
CREATE TABLE Z_METADATA (
    Z_VERSION INTEGER PRIMARY KEY,
    Z_UUID VARCHAR(255),
    Z_PLIST BLOB);
CREATE TABLE Z_MODELCACHE (
    Z_CONTENT BLOB);
CREATE TABLE ZICCLOUDSYNCINGOBJECT (
    Z_PK INTEGER PRIMARY KEY,
    Z_ENT INTEGER,
    Z_OPT INTEGER,
    ZCRYPTOITERATIONCOUNT INTEGER,
    ZISPASSWORDPROTECTED INTEGER,
    ZMARKEDFORDELETION INTEGER,
    ZNEEDSINITIALFETCHFROMCLOUD INTEGER,
    ZNEEDSTOBEFETCHEDFROMCLOUD INTEGER,
    ZCLOUDSTATE INTEGER,
    ZCHECKEDFORLOCATION INTEGER,
    ZFILESIZE INTEGER,
    ZORIENTATION INTEGER,
    ZSECTION INTEGER,
    ZLOCATION INTEGER,
    ZMEDIA INTEGER,
    ZNOTE INTEGER,
    ZSCALEWHENDRAWING INTEGER,
    ZVERSION INTEGER,
    ZVERSIONOUTOFDATE INTEGER,
    ZSTATE INTEGER,
    ZACCOUNT INTEGER,
    ZTYPE INTEGER,
    ZACCOUNT1 INTEGER,
    ZATTACHMENTVIEWTYPE INTEGER,
    ZINTEGERID INTEGER,
    ZLEGACYNOTEINTEGERID INTEGER,
    ZLEGACYNOTEWASPLAINTEXT INTEGER,
    ZNOTEHASCHANGES INTEGER,
    ZTYPE1 INTEGER,
    ZACCOUNT2 INTEGER,
    ZGROUP INTEGER,
    ZNOTEDATA INTEGER,
    ZISHIDDENNOTECONTAINER INTEGER,
    ZSORTORDER INTEGER,
    ZOWNER INTEGER,
    ZACCOUNTTYPE INTEGER,
    ZDIDCHOOSETOMIGRATE INTEGER,
    ZDIDFINISHMIGRATION INTEGER,
    ZDIDMIGRATEONMAC INTEGER,
    ZFOLDERTYPE INTEGER,
    ZIMPORTEDFROMLEGACY INTEGER,
    ZACCOUNT3 INTEGER,
    ZPARENT INTEGER,
    ZDURATION FLOAT,
    ZMODIFICATIONDATE TIMESTAMP,
    ZORIGINX FLOAT,
    ZORIGINY FLOAT,
    ZPREVIEWUPDATEDATE TIMESTAMP,
    ZSIZEHEIGHT FLOAT,
    ZSIZEWIDTH FLOAT,
    ZHEIGHT FLOAT,
    ZMODIFIEDDATE TIMESTAMP,
    ZSCALE FLOAT,
    ZWIDTH FLOAT,
    ZSTATEMODIFICATIONDATE TIMESTAMP,
    ZMODIFICATIONDATEATIMPORT TIMESTAMP,
    ZCREATIONDATE TIMESTAMP,
    ZFOLDERSMODIFICATIONDATE TIMESTAMP,
    ZLEGACYMODIFICATIONDATEATIMPORT TIMESTAMP,
    ZMODIFICATIONDATE1 TIMESTAMP,
    ZDATEFORLASTTITLEMODIFICATION TIMESTAMP,
    ZPARENTMODIFICATIONDATE TIMESTAMP,
    ZIDENTIFIER VARCHAR UNIQUE,
    ZPASSWORDHINT VARCHAR,
    ZSUMMARY VARCHAR,
    ZTITLE VARCHAR,
    ZTYPEUTI VARCHAR,
    ZURLSTRING VARCHAR,
    ZDEVICEIDENTIFIER VARCHAR,
    ZCONTENTHASHATIMPORT VARCHAR,
    ZFILENAME VARCHAR,
    ZLEGACYCONTENTHASHATIMPORT VARCHAR,
    ZLEGACYIMPORTDEVICEIDENTIFIER VARCHAR,
    ZLEGACYMANAGEDOBJECTIDURIREPRESENTATION VARCHAR,
    ZSNIPPET VARCHAR,
    ZTHUMBNAILATTACHMENTIDENTIFIER VARCHAR,
    ZTITLE1 VARCHAR,
    ZACCOUNTNAMEFORACCOUNTLISTSORTING VARCHAR,
    ZNESTEDTITLEFORSORTING VARCHAR,
    ZNAME VARCHAR,
    ZUSERRECORDNAME VARCHAR,
    ZTITLE2 VARCHAR,
    ZSERVERRECORD BLOB,
    ZREMOTEFILEURL BLOB,
    ZASSETCRYPTOINITIALIZATIONVECTOR BLOB,
    ZASSETCRYPTOTAG BLOB,
    ZCRYPTOINITIALIZATIONVECTOR BLOB,
    ZCRYPTOSALT BLOB,
    ZCRYPTOTAG BLOB,
    ZCRYPTOWRAPPEDKEY BLOB,
    ZENCRYPTEDVALUESJSON BLOB,
    ZUNAPPLIEDENCRYPTEDRECORD BLOB,
    ZMERGEABLEDATA BLOB,
    ZCRYPTOMETADATAINITIALIZATIONVECTOR BLOB,
    ZCRYPTOMETADATATAG BLOB,
    ZENCRYPTEDMETADATA BLOB,
    ZMETADATA BLOB,
    ZCRYPTOVERIFIER BLOB );
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZCLOUDSTATE_INDEX ON ZICCLOUDSYNCINGOBJECT (ZCLOUDSTATE);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZLOCATION_INDEX ON ZICCLOUDSYNCINGOBJECT (ZLOCATION);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZMEDIA_INDEX ON ZICCLOUDSYNCINGOBJECT (ZMEDIA);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZNOTE_INDEX ON ZICCLOUDSYNCINGOBJECT (ZNOTE);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZACCOUNT_INDEX ON ZICCLOUDSYNCINGOBJECT (ZACCOUNT);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZACCOUNT1_INDEX ON ZICCLOUDSYNCINGOBJECT (ZACCOUNT1);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZACCOUNT2_INDEX ON ZICCLOUDSYNCINGOBJECT (ZACCOUNT2);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZGROUP_INDEX ON ZICCLOUDSYNCINGOBJECT (ZGROUP);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZNOTEDATA_INDEX ON ZICCLOUDSYNCINGOBJECT (ZNOTEDATA);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZOWNER_INDEX ON ZICCLOUDSYNCINGOBJECT (ZOWNER);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZACCOUNT3_INDEX ON ZICCLOUDSYNCINGOBJECT (ZACCOUNT3);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_ZPARENT_INDEX ON ZICCLOUDSYNCINGOBJECT (ZPARENT);
CREATE INDEX ZICCLOUDSYNCINGOBJECT_Z_ENT_INDEX ON ZICCLOUDSYNCINGOBJECT (Z_ENT);
