# AI Prompts, Tools, and More: Overview

Welcome to my `AI Prompts, Tools, and More` repository! This repository contains various resources related to Artificial Intelligence (AI) that can help you get started with AI development, explore AI projects, and learn more about AI concepts.

This repository includes prompts to inspire your AI projects, tools to help you implement AI algorithms and models, and links to tutorials and resources to deepen your understanding of AI.

Whether you're an AI enthusiast, a beginner or an experienced AI developer, this repository is a great place to find inspiration and resources to enhance your AI skills.

Please feel free to contribute by adding your own AI prompts, tools, and resources to this repository, and share it with the AI community!

I hope this helps you get started with your adventures using AI tools and software. Good luck!

- [AI Prompts, Tools, and More: Overview](#ai-prompts-tools-and-more-overview)
  - [Homepage(s)](#homepages)
  - [Prompt Tools / Generators](#prompt-tools--generators)
    - [ChatGPT](#chatgpt)
    - [Midjourney](#midjourney)
      - [Here's how to create insane Midjourney prompts](#heres-how-to-create-insane-midjourney-prompts)
    - [Misc](#misc)
  - [Other Bookmarks](#other-bookmarks)
    - [ChatGPT](#chatgpt-1)
    - [Midjourney](#midjourney-1)
    - [AI Tool Indexing Sites](#ai-tool-indexing-sites)
    - [Image Upscaling](#image-upscaling)
    - [Misc](#misc-1)

## Homepage(s)

This section includes links to homepages of some popular AI models and frameworks.

- ⭐ [ChatGPT](https://chat.openai.com/chat) - A chatbot powered by OpenAI's GPT model.
- ⭐ [DALL-E](https://labs.openai.com/) - A neural network that creates images from textual descriptions.
- ⭐ [Midjourney](https://www.midjourney.com/) - A design agency with a focus on branding and user experience.
- ⭐ [Open-Assistant](https://open-assistant.io/) - An open-source platform for building chatbots and voice assistants.
- ⭐ [HuggingChat](https://huggingface.co/chat/) - A chatbot powered by Hugging Face's models.
- [Alpaca-Turbo](https://github.com/ViperX7/Alpaca-Turbo) - A tool for automating stock trading.
- [CF Spark](creative-fabrica-spark) - A digital crafting platform with a library of designs and tools.
- [Adobe Firefly](https://firefly.adobe.com) - A design system and component library for Adobe's products.
- [Google Bard](https://bard.google.com/) - A tool for creating poetry with the help of machine learning.
- [Microsoft Bing AI](https://www.bing.com/new) - A search engine powered by Microsoft's AI technologies.
- [Microsoft Designer](https://designer.microsoft.com/) - A tool for creating user interfaces with Microsoft's design language.

## Prompt Tools / Generators

This section includes links to various AI prompt tools and generators.

- ⭐ [Hugging Face](https://huggingface.co/) - A platform to publish and use models for Natural Language Processing (NLP).
- ⭐ [WebChatGPT: ChatGPT with internet access](https://chrome.google.com/webstore/detail/webchatgpt-chatgpt-with-i/lpfemeioodjbpieminkklglpmhlngfcn) - A browser extension that provides access to GPT-3 for generating human-like text.
- ⭐ [ChatGPT Sidebar - Support GPT-4 for Plus user](https://chrome.google.com/webstore/detail/chatgpt-sidebar-support-g/difoiogjjojoaoomphldepapgpbgkhkb) - A browser extension that provides access to GPT-3 for generating human-like text.
- ⭐ [YouTube & Article Summary powered by ChatGPT](https://chrome.google.com/webstore/detail/youtube-article-summary-p/nmmicjeknamkfloonkhhcjmomieiodli) - A browser extension that generates summaries for YouTube videos and articles.
- ⭐ [Superpower ChatGPT](https://github.com/saeedezzati/superpower-chatgpt) - A library for building chatbots using GPT-3.
- ⭐ [WNR.AI - Prompts made easy with AI templates](https://wnr.ai/) - A platform for generating text using GPT-3.
- ⭐ [Build AI-powered Applications without writing a single line of code](https://theforgeai.com/) - A platform for building AI-powered applications without coding.
- ⭐ [ChatGPT DAN, Jailbreaks prompt](https://github.com/0xk1h0/ChatGPT_DAN) - A library for generating text using GPT-3.
- [Learn Prompting](https://learnprompting.org/) - A website that provides resources for learning how to use prompts with GPT-3.
- [Bing Chat for All Browsers](https://chrome.google.com/webstore/detail/bing-chat-for-all-browser/jofbglonpbndadajbafmmaklbfbkggpo) - A browser extension that provides access to GPT-3 for generating human-like text.
- [Ultimate Guide for Building a Startup with ChatGPT Prompts, from Scratch (free, no ads/sign-ups)](https://www.reddit.com/r/ChatGPT/comments/12gjp5b/ultimate_guide_for_building_a_startup_with/) - A guide for building a startup using GPT-3 prompts.
- [Hero Page - List Maker](https://hero.page/) - A website for making lists.
- [Hero: Save GPT Prompts, Links & more to lists](https://chrome.google.com/webstore/detail/hero-save-gpt-prompts-lin/mdlfcfindgklmnfjjbeemlhgplfmkame) - A browser extension for saving GPT-3 prompts, links, and more to lists.

### ChatGPT

This section includes links to ChatGPT prompt tools and resources.

- ⭐ [AIPRM for ChatGPT - Chrome Web Store](https://chrome.google.com/webstore/detail/aiprm-for-chatgpt/ojnbohmppadfgpejeebfnmnknjdlckgj) - Chrome extension that helps you manage your ChatGPT conversations with ease.
- [f/awesome-chatgpt-prompts: This repo includes ChatGPT prompt curation to use ChatGPT better.](https://github.com/f/awesome-chatgpt-prompts) - A curated list of ChatGPT prompts to help you get started with generating text.

### Midjourney

- ⭐ [MidJourney Prompt Tool](https://prompt.noonshot.com/) - A tool for generating mid-journey prompts.
- ⭐ [Midjourney prompt generator - promptoMANIA](https://promptomania.com/midjourney-prompt-builder/) - Another tool for generating mid-journey prompts.
- ⭐ [IMI Prompt: Midjourney Prompt Builder](https://www.imiprompt.com/builder) - A prompt builder for generating mid-journey prompts.
- ⭐ [willwulfken/MidJourney-Styles-and-Keywords-Reference: A reference containing Styles and Keywords that you can use with MidJourney AI](https://github.com/willwulfken/MidJourney-Styles-and-Keywords-Reference) - A reference repository containing styles and keywords that can be used with MidJourney AI.
- [PromptBase | Prompt Marketplace: DALL·E, Midjourney, ChatGPT, Stable Diffusion & GPT](https://promptbase.com/) - A marketplace for prompts, including mid-journey prompts.

#### Here's how to create insane Midjourney prompts

1. Install the [AIPRM for ChatGPT](https://chrome.google.com/webstore/detail/aiprm-for-chatgpt/ojnbohmppadfgpejeebfnmnknjdlckgj) Chrome extension
2. Open [ChatGPT](https://chat.openai.com/chat)
3. Follow the steps to create an account for AIPRM, and link it to your ChatGPT account
4. Re-open ChatGPT
5. In the upper-right Search field, type `Midjourney`
6. Select any of the prompt generators you want to use
7. Type in your keyword(s)
8. Copy / paste the generated prompts into Midjourney
9. ... profit?
### Misc

- coming

## Other Bookmarks

- [PromptHero - Search prompts for Stable Diffusion, ChatGPT & Midjourney](https://prompthero.com/) - Search prompts for Stable Diffusion, ChatGPT & Midjourney on PromptHero

### ChatGPT

- [Reddit: ChatGPT](https://www.reddit.com/r/ChatGPT/) - A subreddit dedicated to discussing ChatGPT.
- ⭐ [f/awesome-chatgpt-prompts: This repo includes ChatGPT prompt curation to use ChatGPT better.](https://github.com/f/awesome-chatgpt-prompts) - A Github repository containing curated ChatGPT prompts.
- ⭐ [Ask ChatGPT to generate better ChatGPT prompts](https://www.skool.com/chatgpt/promptgenerator?p=1e5ede93) - A web page where you can ask ChatGPT to generate better prompts.

- > I want you to become my Prompt Creator. Your goal is to help me craft the best possible prompt for my needs. The prompt will be used by you, ChatGPT. You will follow the following process: 1. Your first response will be to ask me what the prompt should be about. I will provide my answer, but we will need to improve it through continual iterations by going through the next steps. 2. Based on my input, you will generate 3 sections. a) Revised prompt (provide your rewritten prompt. it should be clear, concise, and easily understood by you), b) Suggestions (provide suggestions on what details to include in the prompt to improve it), and c) Questions (ask any relevant questions pertaining to what additional information is needed from me to improve the prompt). 3. We will continue this iterative process with me providing additional information to you and you updating the prompt in the Revised prompt section until it's complete.
- 
### Midjourney

- [Reddit: Midjourney](https://www.reddit.com/r/midjourney/) - A subreddit for discussing and sharing content related to Midjourney.

- [Midjourney Prompts](https://docs.midjourney.com/docs/prompts) - A collection of prompts for use with the Midjourney app.

- [Midjourney Account](https://www.midjourney.com/account/) - The account management page for Midjourney.

- [One-Click Midjourney Prompts with ChatGPT](https://medium.com/@charles-ross/one-click-midjourney-prompts-with-chatgpt-844e157d9792) - An article explaining how to generate Midjourney prompts with the ChatGPT algorithm.

- [Midjourney Prompt Generator - a Hugging Face Space by doevent](https://huggingface.co/spaces/doevent/prompt-generator) - An online tool for generating Midjourney prompts using the Hugging Face framework.

### AI Tool Indexing Sites

- ⭐ [Future Tools - Find The Exact AI Tool For Your Needs](https://www.futuretools.io/) - A website that helps you find the right AI tool for your needs.

- [TopAi.tools Directory](https://topai.tools/) - A directory of AI tools for developers, data scientists, and AI enthusiasts.

- [AI Tools and Applications - Favird](https://favird.com/l/ai-tools-and-applications) - A curated list of AI tools and applications for businesses and individuals.

- [aiwizard - Discover the Top AI Tools](https://www.aiwizard.ai/) - A curated list of the best AI tools for developers and data scientists.

- [aitools.fyi - Find Best AI Tools That Make Your Life Easy!](https://aitools.fyi/) - A website that helps you find the best AI tools to make your life easier.

- [AI of The Day - Find the Best of AI Everyday!](https://aioftheday.com/) - A website that features a new AI tool every day.

- [Futurepedia - The Largest AI Tools Directory | Home](https://www.futurepedia.io/) - A comprehensive directory of AI tools and resources.

- [DoMore.ai - Your Personalized AI Tools Catalog](https://domore.ai/) - A personalized catalog of AI tools tailored to your needs.

- [CodeWP - AI WordPress Code Generator & Assistant](https://codewp.ai/) - An AI-powered WordPress code generator and assistant.

### Image Upscaling

- ⭐ [upscayl/upscayl: 🆙 Upscayl - Free and Open Source AI Image Upscaler for Linux, MacOS and Windows built with Linux-First philosophy.](https://github.com/upscayl/upscayl)  - A free and open-source AI image upscaler for Linux, MacOS, and Windows that is built with a Linux-First philosophy.
- [cjwbw/rudalle-sr – Run with an API on Replicate](https://replicate.com/cjwbw/rudalle-sr) - An API to run rudalle-sr on Replicate.
- [chaiNNer-org/chaiNNer: A node-based image processing and AI upscaling GUI that makes it easy to chain together complex processing tasks.](https://github.com/chaiNNer-org/chaiNNer) - A node-based image processing and AI upscaling GUI that simplifies the process of chaining together complex processing tasks.

- 
### Misc

- ⭐ [ahrefs Free Keyword Generator Tool: Find 100+ Keyword Ideas in Seconds](https://ahrefs.com/keyword-generator) - This is a great tool for generating keyword ideas quickly.
