import React from 'react';

interface Props {
  className?: string;
}

export const LogoIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      xmlns="http://www.w3.org/2000/svg"
      width="251"
      height="380"
      fill="none"
      viewBox="0 0 251 380"
    >
      <path
        fill="url(#paint0_linear_208_37)"
        d="M234.793 126.275c-5.687-7.285-12.144-13.003-18.276-17.404.6-1.26 1.104-2.411 1.502-3.441 3.867-10.016 8.018-30.233-7.66-53.092-7.14-10.41-18.247-21.035-33.96-32.485C155.265 4.453 145.244 0 131.717 0a47.377 47.377 0 00-39.305 20.927C74.841 47.038 16.616 135.123 5.068 172.266c-2.991 9.616-12.088 38.876 5.224 64.924 8.158 12.274 18.98 19.049 29.189 22.888l-.563.954c-8.33 14.114-16.942 28.707-23.238 45.757-5.41 14.677-3.275 31.135 5.708 44.022 9.148 13.121 22.198 19.052 38.977 23.926C72.392 378.23 82.437 380 90.214 380c15.719-.002 26.49-6.512 32.747-11.962 9.272-8.074 21.931-24.262 46.645-56.748 4.557-5.99 8.767-11.525 12.165-15.904 12.016-15.484 53.71-75.906 63.599-100.849 9.145-23.049 5.288-47.929-10.577-68.262z"
      ></path>
      <path
        fill="#fff"
        d="M125.347 41.753c1.684 0 46.881 28.634 42.108 40.987-4.772 12.35-55.022 82.812-55.022 82.812l48.284-34.529 12.352 5.333c12.352 5.335 28.354 18.809 21.895 35.092-6.455 16.283-42.389 70.462-56.987 89.269-14.596 18.808-43.79 58.393-52.495 65.969-2.337 2.037-32.767-6.296-31.722-9.132 7.468-20.224 20.774-38.591 32.003-59.924 9.138-17.363 37.056-64.004 37.056-64.004l7.018-13.194s-19.353 14.52-29.758 22.457c-13.613 10.386-15.16 12.633-30.88 10.388-15.72-2.246-35.652.841-25.264-32.564 10.387-33.408 81.412-138.96 81.412-138.96z"
      ></path>
      <defs>
        <linearGradient
          id="paint0_linear_208_37"
          x1="208.198"
          x2="-64.065"
          y1="0"
          y2="272.479"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FB7185"></stop>
          <stop offset="0.375" stopColor="#D946EF"></stop>
          <stop offset="1" stopColor="#6366F1"></stop>
        </linearGradient>
      </defs>
    </svg>
  );
};
