/*
    Resuminator, Web App and the Website for Resuminator
    Copyright (C) 2021 Resuminator Authors

    This file is part of Resuminator.

    Resuminator is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Resuminator is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Resuminator.  If not, see <https://www.gnu.org/licenses/>.
*/

import { Button } from "@chakra-ui/button";
import {
  Modal,
  ModalBody,
  ModalCloseButton,
  ModalContent,
  ModalFooter,
  ModalHeader,
  ModalOverlay
} from "@chakra-ui/modal";
import { ButtonProps } from "@chakra-ui/react";
import { ThemingProps } from "@chakra-ui/system";
import React from "react";

interface Props {
  title: string;
  buttonText: string;
  color?: ThemingProps["colorScheme"];
  onClose?: () => void;
  onClick?: () => void;
  isOpen?: boolean;
  actionButtonProps?: ButtonProps;
}

const ActionModal: React.FC<Props> = ({
  title,
  onClose,
  isOpen,
  onClick,
  buttonText,
  color = "red",
  actionButtonProps,
  children
}) => {
  return (
    <Modal isOpen={isOpen} onClose={onClose}>
      <ModalOverlay />
      <ModalContent>
        <ModalHeader>{title}</ModalHeader>
        <ModalCloseButton />
        <ModalBody>{children}</ModalBody>

        <ModalFooter>
          <Button
            colorScheme={color}
            mr={3}
            onClick={onClick}
            {...actionButtonProps}
          >
            {buttonText}
          </Button>
          <Button mr={3} onClick={onClose}>
            Close
          </Button>
        </ModalFooter>
      </ModalContent>
    </Modal>
  );
};

export default ActionModal;
