export interface Device {
  id: string;
  height: number;
  width: number;
  name: string;
  userAgent: string;
  type: string;
  dpr: number;
  isTouchCapable: boolean;
  isMobileCapable: boolean;
  capabilities: string[];
  isCustom?: boolean;
}

/*
Ids range:
  10000 - 19999: Apple devices
  20000 - 29999: Google devices
  30000 - 39999: Samsung devices
  40000 - 49999: Microsoft devices
  50000 - 59999: Other mobile devices
  90000 - 99999: Other desktop devices

And `uuid` as id for custom devices
*/

export const defaultDevices: Device[] = [
  {
    id: '10001',
    name: 'iPhone 4',
    width: 320,
    height: 480,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_2 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10002',
    name: 'iPhone 5/SE',
    width: 320,
    height: 568,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10003',
    name: 'iPhone SE',
    width: 375,
    height: 667,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10004',
    name: 'iPhone 6/7/8',
    width: 375,
    height: 667,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10005',
    name: 'iPhone 6/7/8 Plus',
    width: 414,
    height: 736,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10006',
    name: 'iPhone X',
    width: 375,
    height: 812,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10007',
    name: 'iPhone XR',
    width: 414,
    height: 896,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10008',
    name: 'iPhone 12 Pro',
    width: 390,
    height: 844,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10009',
    name: 'iPhone 13 Pro Max',
    width: 428,
    height: 926,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10010',
    name: 'iPhone 14 Pro Max',
    width: 430,
    height: 932,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10011',
    name: 'iPad Air',
    width: 820,
    height: 1180,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPad; CPU OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/87.0.4280.77 Mobile/15E148 Safari/604.1',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10012',
    name: 'iPad Mini',
    width: 768,
    height: 1024,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPad; CPU OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/87.0.4280.77 Mobile/15E148 Safari/604.1',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10013',
    name: 'iPad',
    width: 768,
    height: 1024,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) Version/11.0 Mobile/15A5341f Safari/604.1',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10014',
    name: 'iPad Pro',
    width: 1024,
    height: 1366,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) Version/11.0 Mobile/15A5341f Safari/604.1',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10015',
    name: 'MacBook Pro',
    width: 1440,
    height: 900,
    dpr: 2,
    capabilities: [],
    userAgent:
      'Mozilla/5.0 (Macintosh; Intel Mac OS X 13_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36',
    type: 'notebook',
    isTouchCapable: false,
    isMobileCapable: false,
  },
  {
    id: '10016',
    name: 'iPhone 14',
    dpr: 3,
    width: 390,
    height: 844,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10017',
    name: 'iPhone 14 Plus',
    width: 428,
    height: 926,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10018',
    name: 'iPhone 14 Pro',
    width: 393,
    height: 852,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10019',
    name: 'iPhone 15',
    width: 393,
    height: 852,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.0 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10020',
    name: 'iPhone 15 Plus',
    width: 430,
    height: 932,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.0 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '10021',
    name: 'iPhone 15 Pro',
    width: 393,
    height: 852,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPhone; CPU iPhone OS 17_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.0 Mobile/15E148 Safari/604.1',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20001',
    name: 'Nexus 4',
    width: 384,
    height: 640,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 4.4.2; Nexus 4 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20002',
    name: 'Nexus 5',
    width: 360,
    height: 640,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20003',
    name: 'Nexus 5X',
    width: 412,
    height: 732,
    dpr: 2.625,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.0.0; Nexus 5X Build/OPR4.170623.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20004',
    name: 'Nexus 6',
    width: 412,
    height: 732,
    dpr: 3.5,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 7.1.1; Nexus 6 Build/N6F26U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20005',
    name: 'Nexus 6P',
    width: 412,
    height: 732,
    dpr: 3.5,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.0.0; Nexus 6P Build/OPP3.170518.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20006',
    name: 'Nexus 7',
    width: 600,
    height: 960,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 7 Build/MOB30X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20007',
    name: 'Nexus 10',
    width: 800,
    height: 1280,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 10 Build/MOB31T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20008',
    name: 'Pixel 2',
    width: 411,
    height: 731,
    dpr: 2.625,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.0; Pixel 2 Build/OPD3.170816.012) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20009',
    name: 'Pixel 2 XL',
    width: 411,
    height: 823,
    dpr: 3.5,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.0.0; Pixel 2 XL Build/OPD1.170816.004) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20010',
    name: 'Pixel 3',
    width: 393,
    height: 786,
    dpr: 2.75,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 9; Pixel 3 Build/PQ1A.181105.017.A1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.158 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20011',
    name: 'Pixel 3 XL',
    width: 393,
    height: 786,
    dpr: 2.75,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 11; Pixel 3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.181 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20012',
    name: 'Pixel 4',
    width: 353,
    height: 745,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 10; Pixel 4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20013',
    name: 'Pixel 5',
    width: 393,
    height: 851,
    dpr: 2.75,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 11; Pixel 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.91 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20014',
    name: 'Nest Hub Max',
    width: 1280,
    height: 800,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (X11; Linux aarch64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.188 Safari/537.36 CrKey/1.54.250320',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20015',
    name: 'Nest Hub',
    width: 1024,
    height: 600,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.109 Safari/537.36 CrKey/1.54.248666',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '20016',
    name: 'Pixel 7',
    width: 412,
    height: 915,
    dpr: 2.625,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 13; Pixel 7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.120 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30001',
    name: 'Samsung Galaxy S8+',
    width: 360,
    height: 740,
    dpr: 4,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.0.0; SM-G955U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30002',
    name: 'Samsung Galaxy S20 Ultra',
    width: 412,
    height: 915,
    dpr: 3.5,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 10; SM-G981B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.162 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30003',
    name: 'Galaxy Fold',
    width: 280,
    height: 653,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 9.0; SAMSUNG SM-F900U Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30004',
    name: 'Galaxy S21',
    width: 360,
    height: 800,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 9.0; SAMSUNG SM-G991 Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30005',
    name: 'Galaxy S21 Plus',
    width: 384,
    height: 854,
    dpr: 2.8125,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 9.0; SAMSUNG SM-G996 Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30006',
    name: 'Galaxy S21 Ultra',
    width: 412,
    height: 915,
    dpr: 2.625,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 9.0; SAMSUNG SM-G998 Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30007',
    name: 'Galaxy S20',
    width: 360,
    height: 800,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 9.0; SAMSUNG SM-G981 Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30008',
    name: 'Galaxy S20 Plus',
    width: 384,
    height: 854,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 9.0; SAMSUNG SM-G986 Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30009',
    name: 'Samsung Galaxy A51/71',
    width: 412,
    height: 914,
    dpr: 2.625,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.0.0; SM-G955U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30010',
    name: 'Galaxy S III',
    width: 360,
    height: 640,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; U; Android 4.0; en-us; GT-I9300 Build/IMM76D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30011',
    name: 'Galaxy S5',
    width: 360,
    height: 640,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30012',
    name: 'Galaxy S8',
    width: 360,
    height: 740,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 7.0; SM-G950U Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.84 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30013',
    name: 'Galaxy S9+',
    width: 320,
    height: 658,
    dpr: 4.5,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.0.0; SM-G965U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.111 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30014',
    name: 'Galaxy Tab S4',
    width: 712,
    height: 1138,
    dpr: 2.25,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 8.1.0; SM-T837A) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.80 Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30015',
    name: 'Galaxy Note II',
    width: 360,
    height: 640,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; U; Android 4.1; en-us; GT-N7100 Build/JRO03C) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30016',
    name: 'Galaxy Note 3',
    width: 360,
    height: 640,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30017',
    name: 'Samsung S21 FE',
    width: 360,
    height: 800,
    dpr: 420,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 13; SAMSUNG SM-G990B) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/20.0 Chrome/106.0.5249.126 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '30018',
    name: 'Galaxy Z Fold 5',
    width: 344,
    height: 882,
    dpr: 1,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 13; SM-F946B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.5735.131 Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '40001',
    name: 'Nokia Lumia 520',
    width: 320,
    height: 533,
    dpr: 1.5,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (compatible; MSIE 10.0; Windows Phone 8.0; Trident/6.0; IEMobile/10.0; ARM; Touch; NOKIA; Lumia 520)',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '40002',
    name: 'Microsoft Lumia 550',
    width: 640,
    height: 360,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 550) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Mobile Safari/537.36 Edge/14.14263',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '40003',
    name: 'Microsoft Lumia 950',
    width: 360,
    height: 640,
    dpr: 4,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 950) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Mobile Safari/537.36 Edge/14.14263',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '40004',
    name: 'Surface Pro 7',
    width: 912,
    height: 1368,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (iPad; CPU OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/87.0.4280.77 Mobile/15E148 Safari/604.1',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '40005',
    name: 'Surface Duo',
    width: 540,
    height: 720,
    dpr: 2.5,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 11.0; Surface Duo) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '50001',
    name: 'BlackBerry Z30',
    width: 360,
    height: 640,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (BB10; Touch) AppleWebKit/537.10+ (KHTML, like Gecko) Version/10.0.9.2372 Mobile Safari/537.10+',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '50002',
    name: 'LG Optimus L70',
    width: 384,
    height: 640,
    dpr: 1.25,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; U; Android 4.4.2; en-us; LGMS323 Build/KOT49I.MS32310c) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '50003',
    name: 'Nokia N9',
    width: 480,
    height: 854,
    dpr: 1,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (MeeGo; NokiaN9) AppleWebKit/534.13 (KHTML, like Gecko) NokiaBrowser/8.5.0 Mobile Safari/534.13',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '50004',
    name: 'JioPhone 2',
    width: 240,
    height: 320,
    dpr: 1,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Mobile; LYF/F300B/LYF-F300B-001-01-15-130718-i;Android; rv:48.0) Gecko/48.0 Firefox/48.0 KAIOS/2.5',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '50005',
    name: 'Kindle Fire HDX',
    width: 800,
    height: 1280,
    dpr: 2,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; U; en-us; KFAPWI Build/JDQ39) AppleWebKit/535.19 (KHTML, like Gecko) Silk/3.13 Safari/535.19 Silk-Accelerated=true',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '50006',
    name: 'Blackberry PlayBook',
    width: 600,
    height: 1024,
    dpr: 1,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (PlayBook; U; RIM Tablet OS 2.1.0; en-US) AppleWebKit/536.2+ (KHTML like Gecko) Version/7.2.1.0 Safari/536.2+',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '50007',
    name: 'Moto G4',
    width: 360,
    height: 640,
    dpr: 3,
    capabilities: ['touch', 'mobile'],
    userAgent:
      'Mozilla/5.0 (Linux; Android 6.0.1; Moto G (4)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36',
    type: 'phone',
    isTouchCapable: true,
    isMobileCapable: true,
  },
  {
    id: '90001',
    name: 'laptopWithTouch',
    width: 950,
    height: 1280,
    dpr: 1,
    capabilities: ['touch'],
    userAgent:
      'Mozilla/5.0 (Macintosh; Intel Mac OS X 13_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36',
    type: 'notebook',
    isTouchCapable: true,
    isMobileCapable: false,
  },
  {
    id: '90002',
    name: 'laptopWithHiDPIScreen',
    width: 900,
    height: 1440,
    dpr: 2,
    capabilities: [],
    userAgent:
      'Mozilla/5.0 (Macintosh; Intel Mac OS X 13_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36',
    type: 'notebook',
    isTouchCapable: false,
    isMobileCapable: false,
  },
  {
    id: '90003',
    name: 'laptopWithMDPIScreen',
    width: 800,
    height: 1280,
    dpr: 1,
    capabilities: [],
    userAgent:
      'Mozilla/5.0 (Macintosh; Intel Mac OS X 13_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36',
    type: 'notebook',
    isTouchCapable: false,
    isMobileCapable: false,
  },
  {
    id: '90004',
    name: 'Asus Zenbook Fold',
    width: 853,
    height: 1280,
    dpr: 2,
    capabilities: ['touch', 'tablet'],
    userAgent:
      'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36',
    type: 'tablet',
    isTouchCapable: true,
    isMobileCapable: false,
  },
];

const customDevices: () => Device[] = () => {
  return typeof window !== 'undefined'
    ? window.electron.store.get('deviceManager.customDevices')
    : [];
};

type DeviceMap = { [key: string]: Device };

export const getDevicesMap = (): DeviceMap => {
  return [...defaultDevices, ...customDevices()].reduce(
    (map: DeviceMap, device) => {
      map[device.id] = device;
      return map;
    },
    {}
  );
};
