<div align="center">
  <img src="https://responsively.app/assets/img/logo.png" alt="Responsively Logo" width="150">
  <h1>Responsively App <a href="https://github.com/responsively-org/responsively-app/releases/latest" target="_blank"><img alt="GitHub release" src="https://img.shields.io/github/v/release/responsively-org/responsively-app"></a></h1>
  <strong>A must-have dev tool for web developers for quicker responsive web development. 🚀</strong>
  <h6>Save time by becoming 5x faster!</h6>
</div>
<br>

<p align="center">
  <a href="https://twitter.com/ResponsivelyApp" target="_blank">
    <img src="https://img.shields.io/twitter/follow/responsivelyApp?color=26A0ED&label=Follow&logo=twitter&logoColor=white&style=flat" alt="Twitter">
  </a>

  <a href="#contributors-" target="_blank">
    <img src="https://img.shields.io/github/all-contributors/responsively-org/responsively-app?style=flat" alt="contributors">
  </a>



  <a href="https://responsively.app/join-discord" target="_blank">
    <img src="https://img.shields.io/badge/Join%20-Discord-blue?logo=discord&logoColor=white" alt="Discord">
  </a>

  <a href="https://xscode.com/manojvivek/responsively-app" target="_blank">
    <img src="https://img.shields.io/badge/Available%20on-xs%3Acode-blue?style=?style=flat&logo=appveyor&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAMAAACdt4HsAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAZQTFRF////////VXz1bAAAAAJ0Uk5T/wDltzBKAAAAlUlEQVR42uzXSwqAMAwE0Mn9L+3Ggtgkk35QwcnSJo9S+yGwM9DCooCbgn4YrJ4CIPUcQF7/XSBbx2TEz4sAZ2q1RAECBAiYBlCtvwN+KiYAlG7UDGj59MViT9hOwEqAhYCtAsUZvL6I6W8c2wcbd+LIWSCHSTeSAAECngN4xxIDSK9f4B9t377Wd7H5Nt7/Xz8eAgwAvesLRjYYPuUAAAAASUVORK5CYII=" alt="XS:Code">
  </a>

  <a href="https://github.com/responsively-org/responsively-app/issues" target="_blank">
    <img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome">
  </a>

   <a href="https://opencollective.com/responsively" target="_blank">
    <img alt="Open Collective backers and sponsors" src="https://img.shields.io/opencollective/all/responsively">
  </a>
</p>

<p align="center">
  <a href="https://www.producthunt.com/posts/responsively?utm_source=badge-top-post-badge&utm_medium=badge&utm_souce=badge-responsively" target="_blank">
    <img src="https://api.producthunt.com/widgets/embed-image/v1/top-post-badge.svg?post_id=200375&theme=light&period=daily" alt="ProductHunt">
  </a>
</p>

<p align="center">
  Download Now (free!): <a href="https://responsively.app/download" target="_blank">
    responsively.app
  </a>
</p>
<br>

## Responsively App

> A modified browser built using [Electron](https://www.electronjs.org/) that helps in responsive web development.
> <br>

![Quick Demo](https://responsively.app/assets/img/responsively-app.gif)

## Features

1. Mirrored User-interactions across all devices.
2. Customizable preview layout to suit all your needs.
3. One handy elements inspector for all devices in preview.
4. 30+ built-in device profiles with the option to add custom devices.
5. One-click screenshots on all your devices.
6. Hot reloading is supported for developers.

Please visit the website to learn more about the application - https://responsively.app

## Download

The application is available for Mac, Windows and Linux platforms. Please <a href="https://responsively.app/download" target="_blank">download it from responsively.app</a>

Alternatively, MacOS users can use [`brew`](https://formulae.brew.sh/cask/responsively) <a href="https://formulae.brew.sh/cask/responsively" target="_blank"> <img src="https://badgen.net/homebrew/cask/dy/responsively" alt="Homebrew installs"></a>

```bash
brew install --cask responsively
```

Also, Windows users can use [`chocolatey`](https://chocolatey.org/packages/responsively/) <a href="https://chocolatey.org/packages/responsively/" target="_blank"> <img src="https://img.shields.io/chocolatey/dt/responsively" alt="Chocolatey installs"></a>

```bash
choco install responsively
```

or [`winget`](https://github.com/microsoft/winget-cli):

```bash
winget install ResponsivelyApp
```

Linux users using an RPM Package Manager can use `rpm`

```bash
sudo rpm -i https://github.com/responsively-org/responsively-app/releases/download/v[VERSION]/Responsively-App-[VERSION].x86_64.rpm
```

otherwise, download an AppImage from [the releases page](https://github.com/responsively-org/responsively-app/releases)

Follow us on Twitter for future updates - [![Twitter Follow](https://img.shields.io/twitter/follow/ResponsivelyApp?style=social)](https://twitter.com/ResponsivelyApp)

## Browser Extension

Install the handy browser extension to easily send links from your browser to the app and preview instantly.

- [Download for Chrome](https://chrome.google.com/webstore/detail/responsively-helper/jhphiidjkooiaollfiknkokgodbaddcj) <a href="https://chrome.google.com/webstore/detail/responsively-helper/jhphiidjkooiaollfiknkokgodbaddcj" target="_blank"><img alt="Chrome Web Store" src="https://img.shields.io/chrome-web-store/users/jhphiidjkooiaollfiknkokgodbaddcj?color=blue"></a>
- [Download for Firefox](https://addons.mozilla.org/en-US/firefox/addon/responsively-helper/) <a href="https://addons.mozilla.org/en-US/firefox/addon/responsively-helper/" target="_blank"><img alt="Mozilla Add-on" src="https://img.shields.io/amo/users/responsively-helper"></a>
- [Download for Edge](https://microsoftedge.microsoft.com/addons/detail/responsively-helper/ooiejjgflcgkbbehheengalibfehaojn) <a href="https://microsoftedge.microsoft.com/addons/detail/responsively-helper/ooiejjgflcgkbbehheengalibfehaojn" target="_blank"><img alt="Edge Add-on" src="https://img.shields.io/badge/dynamic/json?label=users&query=%24.activeInstallCount&url=https%3A%2F%2Fmicrosoftedge.microsoft.com%2Faddons%2Fgetproductdetailsbycrxid%2Fooiejjgflcgkbbehheengalibfehaojn"></a>

## Issues

If you face any problems while using the application, please open an issue here - https://github.com/responsively-org/responsively-app/issues

## Roadmap

Here is the roadmap of the desktop app - https://github.com/responsively-org/responsively-app/projects/
## Gold sponsors 🥇

<p>&nbsp;</p>

<p align="center" >
  <a href="https://www.syncfusion.com/?utm_source=responsivelyapp&utm_medium=cpc&utm_campaign=responsivelyapp_esee_ban" target="_blank">
    <img src="https://responsively.app/assets/img/logos/syncfusion.png" height="120px" alt="Syncfusion"></a>&nbsp;&nbsp;&nbsp;&nbsp;
  <a href="https://www.browserstack.com/?utm_medium=partnered&utm_source=responsively" target="_blank" style="margin-left: 10px;">
    <img src="https://responsively.app/_next/static/media/browserStack.b67d4227.svg" width="250px" height="120px" alt="BrowserStack">
  </a>&nbsp;&nbsp;&nbsp;&nbsp;
  <a href="https://opencollective.com/responsively" target="_blank">
    <img src="https://user-images.githubusercontent.com/1283424/142834528-4cd5b8eb-eeae-4437-b749-d09c96dde160.png" height="120px" alt="Sponsor to add your company logo here">
  </a>
</p>

[Become a sponsor and have your company logo here](https://opencollective.com/responsively)

## Contribute

To get started with contributing your awesome ideas to Responsively, follow the [comprehensive guide here](https://github.com/responsively-org/responsively-app/blob/main/CONTRIBUTING.md)!

## Get in touch

Come say hi to us on [Discord](https://responsively.app/join-discord)! :wave:

## Contributors ✨

Thanks go to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="20%"><a href="http://twitter.com/vivek_jonam"><img src="https://avatars1.githubusercontent.com/u/1283424?v=4?s=100" width="100px;" alt="Manoj Vivek"/><br /><sub><b>Manoj Vivek</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=manojVivek" title="Code">💻</a> <a href="https://github.com/responsively-org/responsively-app/commits?author=manojVivek" title="Tests">⚠️</a> <a href="#projectManagement-manojVivek" title="Project Management">📆</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/esprush"><img src="https://avatars0.githubusercontent.com/u/26249498?v=4?s=100" width="100px;" alt="Suresh P"/><br /><sub><b>Suresh P</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=esprush" title="Code">💻</a> <a href="https://github.com/responsively-org/responsively-app/commits?author=esprush" title="Tests">⚠️</a> <a href="#projectManagement-esprush" title="Project Management">📆</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/sprabowo"><img src="https://avatars2.githubusercontent.com/u/11748183?v=4?s=100" width="100px;" alt="Sigit Prabowo"/><br /><sub><b>Sigit Prabowo</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=sprabowo" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/leon0707"><img src="https://avatars1.githubusercontent.com/u/523684?v=4?s=100" width="100px;" alt="Leon Feng"/><br /><sub><b>Leon Feng</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=leon0707" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/kishoreio"><img src="https://avatars2.githubusercontent.com/u/30261988?v=4?s=100" width="100px;" alt="Kishore S"/><br /><sub><b>Kishore S</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=kishoreio" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://jjavierdguezas.github.io"><img src="https://avatars2.githubusercontent.com/u/13673443?v=4?s=100" width="100px;" alt="José Javier Rodríguez Zas"/><br /><sub><b>José Javier Rodríguez Zas</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=jjavierdguezas" title="Code">💻</a> <a href="https://github.com/responsively-org/responsively-app/commits?author=jjavierdguezas" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/romanakash"><img src="https://avatars1.githubusercontent.com/u/40427975?v=4?s=100" width="100px;" alt="Roman Akash"/><br /><sub><b>Roman Akash</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=romanakash" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/RomainFrancony"><img src="https://avatars3.githubusercontent.com/u/22396965?v=4?s=100" width="100px;" alt="Romain Francony"/><br /><sub><b>Romain Francony</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=RomainFrancony" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/AARYAN-MAHENDRA"><img src="https://avatars1.githubusercontent.com/u/64866670?v=4?s=100" width="100px;" alt="AARYAN-MAHENDRA"/><br /><sub><b>AARYAN-MAHENDRA</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=AARYAN-MAHENDRA" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/Nothing-Works"><img src="https://avatars3.githubusercontent.com/u/18606648?v=4?s=100" width="100px;" alt="Andy"/><br /><sub><b>Andy</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Nothing-Works" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/Kidcredo"><img src="https://avatars0.githubusercontent.com/u/15522605?v=4?s=100" width="100px;" alt="Ryan Pais"/><br /><sub><b>Ryan Pais</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Kidcredo" title="Code">💻</a> <a href="https://github.com/responsively-org/responsively-app/commits?author=Kidcredo" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="20%"><a href="https://grafikart.fr"><img src="https://avatars1.githubusercontent.com/u/395137?v=4?s=100" width="100px;" alt="Jonathan"/><br /><sub><b>Jonathan</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Grafikart" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/heygema"><img src="https://avatars1.githubusercontent.com/u/10743728?v=4?s=100" width="100px;" alt="Gema Anggada ✌︎"/><br /><sub><b>Gema Anggada ✌︎</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=heygema" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/jonathanurias96"><img src="https://avatars2.githubusercontent.com/u/57416786?v=4?s=100" width="100px;" alt="jonathanurias96"/><br /><sub><b>jonathanurias96</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=jonathanurias96" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://falecci.dev"><img src="https://avatars2.githubusercontent.com/u/17703824?v=4?s=100" width="100px;" alt="Federico Alecci"/><br /><sub><b>Federico Alecci</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=falecci" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://linkedin.com/in/muminjon-abduraimov/"><img src="https://avatars1.githubusercontent.com/u/24930020?v=4?s=100" width="100px;" alt="Abduraimov Muminjon"/><br /><sub><b>Abduraimov Muminjon</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=MuminjonGuru" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="20%"><a href="https://www.vlazaro.es/"><img src="https://avatars1.githubusercontent.com/u/38981659?v=4?s=100" width="100px;" alt="Víctor Lázaro"/><br /><sub><b>Víctor Lázaro</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=vlazaroes" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/kvnam"><img src="https://avatars0.githubusercontent.com/u/3608742?v=4?s=100" width="100px;" alt="Kavita Nambissan"/><br /><sub><b>Kavita Nambissan</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=kvnam" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://twitter.com/PrashantPalikhe"><img src="https://avatars0.githubusercontent.com/u/2657709?v=4?s=100" width="100px;" alt="Prashant Palikhe"/><br /><sub><b>Prashant Palikhe</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=prashantpalikhe" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/jaunesarmiento"><img src="https://avatars1.githubusercontent.com/u/1166928?v=4?s=100" width="100px;" alt="Jaune Sarmiento"/><br /><sub><b>Jaune Sarmiento</b></sub></a><br /><a href="#content-jaunesarmiento" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/diego-vieira"><img src="https://avatars2.githubusercontent.com/u/930792?v=4?s=100" width="100px;" alt="Diego Vieira"/><br /><sub><b>Diego Vieira</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=diego-vieira" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/pajaydev"><img src="https://avatars0.githubusercontent.com/u/21375014?v=4?s=100" width="100px;" alt="Ajaykumar"/><br /><sub><b>Ajaykumar</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=pajaydev" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/kirubakarthikeyan"><img src="https://avatars0.githubusercontent.com/u/38885946?v=4?s=100" width="100px;" alt="Kiruba Karan"/><br /><sub><b>Kiruba Karan</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=kirubakarthikeyan" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/sebasrodriguez"><img src="https://avatars1.githubusercontent.com/u/1605931?v=4?s=100" width="100px;" alt="Sebastián Rodríguez"/><br /><sub><b>Sebastián Rodríguez</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=sebasrodriguez" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/karthick3018"><img src="https://avatars1.githubusercontent.com/u/47154512?v=4?s=100" width="100px;" alt="Karthick Raja"/><br /><sub><b>Karthick Raja</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=karthick3018" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/jzabala"><img src="https://avatars0.githubusercontent.com/u/1315054?v=4?s=100" width="100px;" alt="Johnny Zabala"/><br /><sub><b>Johnny Zabala</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=jzabala" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://rossmoody.com"><img src="https://avatars0.githubusercontent.com/u/29072694?v=4?s=100" width="100px;" alt="Ross Moody"/><br /><sub><b>Ross Moody</b></sub></a><br /><a href="#design-rossmoody" title="Design">🎨</a></td>
      <td align="center" valign="top" width="20%"><a href="https://shokri.me"><img src="https://avatars1.githubusercontent.com/u/13661520?v=4?s=100" width="100px;" alt="Mehrdad Shokri"/><br /><sub><b>Mehrdad Shokri</b></sub></a><br /><a href="#infra-mehrdad-shokri" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/abakermi"><img src="https://avatars1.githubusercontent.com/u/60294727?v=4?s=100" width="100px;" alt="Abdelhak Akermi"/><br /><sub><b>Abdelhak Akermi</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=abakermi" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/crperezt"><img src="https://avatars0.githubusercontent.com/u/20329014?v=4?s=100" width="100px;" alt="Carlos Perez"/><br /><sub><b>Carlos Perez</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=crperezt" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/JayArya"><img src="https://avatars0.githubusercontent.com/u/42388314?v=4?s=100" width="100px;" alt="Jayant Arya"/><br /><sub><b>Jayant Arya</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=JayArya" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/JohnRawlins"><img src="https://avatars3.githubusercontent.com/u/42707277?v=4?s=100" width="100px;" alt="John Rawlins"/><br /><sub><b>John Rawlins</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=JohnRawlins" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/lepasq"><img src="https://avatars3.githubusercontent.com/u/53230128?v=4?s=100" width="100px;" alt="lepasq"/><br /><sub><b>lepasq</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=lepasq" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/mrfelfel"><img src="https://avatars0.githubusercontent.com/u/19575588?v=4?s=100" width="100px;" alt="mrfelfel"/><br /><sub><b>mrfelfel</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=mrfelfel" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://twitter.com/gorogoroumaru"><img src="https://avatars3.githubusercontent.com/u/30716350?v=4?s=100" width="100px;" alt="gorogoroumaru"/><br /><sub><b>gorogoroumaru</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=gorogoroumaru" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="http://ruisaraiva.dev"><img src="https://avatars2.githubusercontent.com/u/7356098?v=4?s=100" width="100px;" alt="Rui Saraiva"/><br /><sub><b>Rui Saraiva</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=ruisaraiva19" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://www.bakirci.nl"><img src="https://avatars2.githubusercontent.com/u/9880089?v=4?s=100" width="100px;" alt="Mehmet Bakirci"/><br /><sub><b>Mehmet Bakirci</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=MBakirci" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/JLambertazzo"><img src="https://avatars0.githubusercontent.com/u/42924425?v=4?s=100" width="100px;" alt="Julien Bertazzo Lambert"/><br /><sub><b>Julien Bertazzo Lambert</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=JLambertazzo" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://dbwriteups.wordpress.com"><img src="https://avatars3.githubusercontent.com/u/4656109?v=4?s=100" width="100px;" alt="Dinesh Balaji"/><br /><sub><b>Dinesh Balaji</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=sidthesloth92" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/med1001"><img src="https://avatars3.githubusercontent.com/u/26111211?v=4?s=100" width="100px;" alt="MedBMoussa"/><br /><sub><b>MedBMoussa</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=med1001" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="http://www.lucie.dev"><img src="https://avatars.githubusercontent.com/u/46979603?v=4?s=100" width="100px;" alt="Lucie Vrsovska"/><br /><sub><b>Lucie Vrsovska</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=lucievr" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/jcabak"><img src="https://avatars.githubusercontent.com/u/1818155?v=4?s=100" width="100px;" alt="Jakub Cabak"/><br /><sub><b>Jakub Cabak</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=jcabak" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/durgakiran"><img src="https://avatars.githubusercontent.com/u/17452039?v=4?s=100" width="100px;" alt="Palakurthi Durga Kiran Kumar"/><br /><sub><b>Palakurthi Durga Kiran Kumar</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=durgakiran" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/karllabrador"><img src="https://avatars.githubusercontent.com/u/58193703?v=4?s=100" width="100px;" alt="Karl Labrador"/><br /><sub><b>Karl Labrador</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=karllabrador" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://rishikc.com"><img src="https://avatars.githubusercontent.com/u/26366288?v=4?s=100" width="100px;" alt="Rishi Kumar Chawda"/><br /><sub><b>Rishi Kumar Chawda</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=rishichawda" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/crocarneiro"><img src="https://avatars.githubusercontent.com/u/10589421?v=4?s=100" width="100px;" alt="Carlos Rafael de Oliveira Carneiro"/><br /><sub><b>Carlos Rafael de Oliveira Carneiro</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=crocarneiro" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://zachos.tech"><img src="https://avatars.githubusercontent.com/u/50255197?v=4?s=100" width="100px;" alt="Zach Hoskins"/><br /><sub><b>Zach Hoskins</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=zachOS-tech" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/kiwan97"><img src="https://avatars.githubusercontent.com/u/25267859?v=4?s=100" width="100px;" alt="KIWAN KIM"/><br /><sub><b>KIWAN KIM</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=kiwan97" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/agaertner"><img src="https://avatars.githubusercontent.com/u/13819164?v=4?s=100" width="100px;" alt="Andreas"/><br /><sub><b>Andreas</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=agaertner" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://www.linkedin.com/in/panu-valtanen-446ba9108/"><img src="https://avatars.githubusercontent.com/u/28947061?v=4?s=100" width="100px;" alt="Panu Valtanen"/><br /><sub><b>Panu Valtanen</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=p4nu" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="http://www.d19.ca"><img src="https://avatars.githubusercontent.com/u/8153796?v=4?s=100" width="100px;" alt="Dustin Dauncey"/><br /><sub><b>Dustin Dauncey</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=d19dotca" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/heagan01"><img src="https://avatars.githubusercontent.com/u/54394590?v=4?s=100" width="100px;" alt="heagan01"/><br /><sub><b>heagan01</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=heagan01" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/Th0masCat"><img src="https://avatars.githubusercontent.com/u/74812563?v=4?s=100" width="100px;" alt="Sahil Jangra"/><br /><sub><b>Sahil Jangra</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Th0masCat" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/nopdotcom"><img src="https://avatars.githubusercontent.com/u/1357866?v=4?s=100" width="100px;" alt="Jay Carlson"/><br /><sub><b>Jay Carlson</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=nopdotcom" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://mikadifo.com"><img src="https://avatars.githubusercontent.com/u/51935560?v=4?s=100" width="100px;" alt="Michael Padilla"/><br /><sub><b>Michael Padilla</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Mikadifo" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://narrowcode.xyz"><img src="https://avatars.githubusercontent.com/u/6213380?v=4?s=100" width="100px;" alt="Andreas Steinkellner"/><br /><sub><b>Andreas Steinkellner</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=NarrowCode" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://niknia.dev"><img src="https://avatars.githubusercontent.com/u/40159649?v=4?s=100" width="100px;" alt="aniknia"/><br /><sub><b>aniknia</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=aniknia" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/WayneRocha"><img src="https://avatars.githubusercontent.com/u/62760711?v=4?s=100" width="100px;" alt="Wayne Rocha"/><br /><sub><b>Wayne Rocha</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=WayneRocha" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/crbon"><img src="https://avatars.githubusercontent.com/u/2604330?v=4?s=100" width="100px;" alt="crbon"/><br /><sub><b>crbon</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=crbon" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://linktr.ee/themohammadsa"><img src="https://avatars.githubusercontent.com/u/59393936?v=4?s=100" width="100px;" alt="Mohammad S"/><br /><sub><b>Mohammad S</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=themohammadsa" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/ReshadSadik"><img src="https://avatars.githubusercontent.com/u/66641469?v=4?s=100" width="100px;" alt="Reshad Sadik"/><br /><sub><b>Reshad Sadik</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=ReshadSadik" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/PeterKwesiAnsah"><img src="https://avatars.githubusercontent.com/u/31078314?v=4?s=100" width="100px;" alt="Kwesi Ansah"/><br /><sub><b>Kwesi Ansah</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=PeterKwesiAnsah" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/monalisamsteccentric"><img src="https://avatars.githubusercontent.com/u/65477771?v=4?s=100" width="100px;" alt="Monalisa Sahoo"/><br /><sub><b>Monalisa Sahoo</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=monalisamsteccentric" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/codewithmitesh"><img src="https://avatars.githubusercontent.com/u/85953650?v=4?s=100" width="100px;" alt="Mitesh Tank"/><br /><sub><b>Mitesh Tank</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=codewithmitesh" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/Ryan0204"><img src="https://avatars.githubusercontent.com/u/82715592?v=4?s=100" width="100px;" alt="Ryan"/><br /><sub><b>Ryan</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Ryan0204" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://www.jibran.me"><img src="https://avatars.githubusercontent.com/u/70596906?v=4?s=100" width="100px;" alt="jayway"/><br /><sub><b>jayway</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=jibranabsarulislam" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://www.xicre.com"><img src="https://avatars.githubusercontent.com/u/3981106?v=4?s=100" width="100px;" alt="Alex Fernandez"/><br /><sub><b>Alex Fernandez</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=afermon" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/Danial-Gharib"><img src="https://avatars.githubusercontent.com/u/90343552?v=4?s=100" width="100px;" alt="Danial Gharib"/><br /><sub><b>Danial Gharib</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Danial-Gharib" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://www.twitter.com/s3lf"><img src="https://avatars.githubusercontent.com/u/1087128?v=4?s=100" width="100px;" alt="Alexander Menk"/><br /><sub><b>Alexander Menk</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=amenk" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="20%"><a href="http://tunahangediz.com"><img src="https://avatars.githubusercontent.com/u/75015671?v=4?s=100" width="100px;" alt="Tunahan Gediz"/><br /><sub><b>Tunahan Gediz</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=tunahangediz" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://refer.codes/jeff"><img src="https://avatars.githubusercontent.com/u/272795?v=4?s=100" width="100px;" alt="Jeff Bowen"/><br /><sub><b>Jeff Bowen</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=jeffbowen" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/ParamBirje"><img src="https://avatars.githubusercontent.com/u/87022870?v=4?s=100" width="100px;" alt="Param Birje"/><br /><sub><b>Param Birje</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=ParamBirje" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/prajjwalyd"><img src="https://avatars.githubusercontent.com/u/111794524?v=4?s=100" width="100px;" alt="Prajjwal Yadav"/><br /><sub><b>Prajjwal Yadav</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=prajjwalyd" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/lyncasterc"><img src="https://avatars.githubusercontent.com/u/49458912?v=4?s=100" width="100px;" alt="Steven Cabrera"/><br /><sub><b>Steven Cabrera</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=lyncasterc" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/negar-75"><img src="https://avatars.githubusercontent.com/u/113235504?v=4?s=100" width="100px;" alt="negar nasiri"/><br /><sub><b>negar nasiri</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=negar-75" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/gauravsingh94"><img src="https://avatars.githubusercontent.com/u/99260988?v=4?s=100" width="100px;" alt="Gaurav Singh"/><br /><sub><b>Gaurav Singh</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=gauravsingh94" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/NishidhJain"><img src="https://avatars.githubusercontent.com/u/61869195?v=4?s=100" width="100px;" alt="Nishidh Jain"/><br /><sub><b>Nishidh Jain</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=NishidhJain" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/mishrasamiksha"><img src="https://avatars.githubusercontent.com/u/38784342?v=4?s=100" width="100px;" alt="Samiksha Mishra"/><br /><sub><b>Samiksha Mishra</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=mishrasamiksha" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="20%"><a href="http://www.astuanax.com"><img src="https://avatars.githubusercontent.com/u/1730624?v=4?s=100" width="100px;" alt="Len Dierickx"/><br /><sub><b>Len Dierickx</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=astuanax" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/surajbobade"><img src="https://avatars.githubusercontent.com/u/102910293?v=4?s=100" width="100px;" alt="Suraj Bobade"/><br /><sub><b>Suraj Bobade</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=surajbobade" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://sagarhedaoo.com/"><img src="https://avatars.githubusercontent.com/u/10000167?v=4?s=100" width="100px;" alt="Sagar Hedaoo"/><br /><sub><b>Sagar Hedaoo</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=sagarhedaoo" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://www.violeta.dev"><img src="https://avatars.githubusercontent.com/u/36138541?v=4?s=100" width="100px;" alt="V"/><br /><sub><b>V</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=violetadev" title="Code">💻</a> <a href="https://github.com/responsively-org/responsively-app/commits?author=violetadev" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/minowau"><img src="https://avatars.githubusercontent.com/u/139740712?v=4?s=100" width="100px;" alt="Prabhas Jupalli"/><br /><sub><b>Prabhas Jupalli</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=minowau" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://devpulkit.in"><img src="https://avatars.githubusercontent.com/u/65671483?v=4?s=100" width="100px;" alt="Pulkit"/><br /><sub><b>Pulkit</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Pulkitxm" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/brandonyee-cs"><img src="https://avatars.githubusercontent.com/u/139765638?v=4?s=100" width="100px;" alt="Brandon Yee"/><br /><sub><b>Brandon Yee</b></sub></a><br /><a href="#content-brandonyee-cs" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/wp043"><img src="https://avatars.githubusercontent.com/u/110360465?v=4?s=100" width="100px;" alt="Wendy Pan"/><br /><sub><b>Wendy Pan</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=wp043" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/pranavithape"><img src="https://avatars.githubusercontent.com/u/170559714?v=4?s=100" width="100px;" alt="Pranav Ithape"/><br /><sub><b>Pranav Ithape</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=pranavithape" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/Sukrit-Prakash"><img src="https://avatars.githubusercontent.com/u/136228545?v=4?s=100" width="100px;" alt="SUKRIT PRAKASH SINGH"/><br /><sub><b>SUKRIT PRAKASH SINGH</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=Sukrit-Prakash" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/aryan262"><img src="https://avatars.githubusercontent.com/u/97938438?v=4?s=100" width="100px;" alt="Aryan Panchal"/><br /><sub><b>Aryan Panchal</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=aryan262" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/samranahm"><img src="https://avatars.githubusercontent.com/u/149153498?v=4?s=100" width="100px;" alt="Samran Ahmed"/><br /><sub><b>Samran Ahmed</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=samranahm" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="20%"><a href="https://github.com/Asatyam"><img src="https://avatars.githubusercontent.com/u/95954551?v=4?s=100" width="100px;" alt="SatyamAgrawal"/><br /><sub><b>SatyamAgrawal</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=asatyam" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="https://github.com/saiTharunDusa"><img src="https://avatars.githubusercontent.com/u/169873642?v=4?s=100" width="100px;" alt="Sai Tharun Dusa"/><br /><sub><b>Sai Tharun Dusa</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=saiTharunDusa" title="Code">💻</a></td>
      <td align="center" valign="top" width="20%"><a href="http://happymvp.com"><img src="https://avatars.githubusercontent.com/u/179954458?v=4?s=100" width="100px;" alt="Pavlo"/><br /><sub><b>Pavlo</b></sub></a><br /><a href="https://github.com/responsively-org/responsively-app/commits?author=happymvp" title="Code">💻</a> <a href="https://github.com/responsively-org/responsively-app/commits?author=happymvp" title="Tests">⚠️</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind are welcome!
