<div align="center">

<h1>Resemi Admin</h1>

</div>

**English** | [中文](./README.zh-CN.md)

## Introduction

Resemi Admin is a free and open-source middle and back-end template. Using the latest `NextJS 12`,`React 18`,`TypeScript` and other mainstream technology development.


## Preparation
- [Semi Design](https://semi.design/) - A modern, comprehensive, flexible design system and UI library.
- [Next.js](https://nextjs.org/) - The React Framework
- [React](https://reactjs.org/) - A JavaScript library for building user interfaces.
- [Recoil](https://recoiljs.org/) - A state management library for React
- [TypeScript](https://www.typescriptlang.org/) - TypeScript is JavaScript with syntax for types.
- [WindiCSS](https://windicss.org/) - Next generation utility-first CSS framework.


## Usage

```bash
# Get the project code
git clone https://github.com/resemi/resemi-admin.git

# installation dependencies
cd resemi-admin && pnpm install

# run
pnpm dev

# build
pnpm build
```


## Use Gitpod

[![Open in Gitpod](https://gitpod.io/button/open-in-gitpod.svg)](https://gitpod.io/#https://github.com/resemi/resemi-admin)


## How to contribute

Welcome to join us! [Raise an Issue](https://github.com/resemi/resemi-admin/issues/new/choose) Or submit a Pull Request。

**Pull Request:**

1. Fork code!
2. Create your own branch: `git checkout -b feat/xxxx`
3. Submit your changes: `git commit -am 'feat(function): add xxxxx'`
4. Push your branch: `git push origin feat/xxxx`
5. Submit `pull request`


## Git Contribution submission specification

> reference [Angular](https://github.com/conventional-changelog/conventional-changelog/tree/master/packages/conventional-changelog-angular)

- `feat` Add new features
- `fix` Fix the problem/bug
- `style` The code style is related and does not affect the running result
- `perf` Optimization/Performance improvement
- `refactor` Refactor code
- `revert` Undo edit
- `test` Test related
- `docs` Documentation/Notes
- `chore` Dependency update/scaffolding configuration modification etc.
- `ci` Continuous integration
- `types` Type definition file changes


## Change Log

[CHANGELOG](./CHANGELOG.md)


## License

[MIT](./LICENSE)