// Generated by ReScript, PLEASE EDIT WITH CARE

import * as Arg from "rescript/lib/es6/arg.js";
import * as Caml from "rescript/lib/es6/caml.js";
import * as Char from "rescript/lib/es6/char.js";
import * as List from "rescript/lib/es6/list.js";
import * as Misc from "./misc.js";
import * as $$Array from "rescript/lib/es6/array.js";
import * as Curry from "rescript/lib/es6/curry.js";
import * as Printf from "./printf.js";
import * as $$String from "rescript/lib/es6/string.js";
import * as Caml_array from "rescript/lib/es6/caml_array.js";
import * as Pervasives from "rescript/lib/es6/pervasives.js";
import * as Caml_string from "rescript/lib/es6/caml_string.js";
import * as Caml_exceptions from "rescript/lib/es6/caml_exceptions.js";

function number(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Comment_start */0 :
          return 1;
      case /* Comment_not_end */1 :
          return 2;
      case /* Partial_application */2 :
          return 5;
      case /* Statement_type */3 :
          return 10;
      case /* Unused_match */4 :
          return 11;
      case /* Unused_pat */5 :
          return 12;
      case /* Illegal_backslash */6 :
          return 14;
      case /* Unerasable_optional_argument */7 :
          return 16;
      case /* Unused_argument */8 :
          return 20;
      case /* Nonreturning_statement */9 :
          return 21;
      case /* Useless_record_with */10 :
          return 23;
      case /* All_clauses_guarded */11 :
          return 8;
      case /* Wildcard_arg_to_constant_constr */12 :
          return 28;
      case /* Eol_in_string */13 :
          return 29;
      case /* Unused_rec_flag */14 :
          return 39;
      case /* Expect_tailcall */15 :
          return 51;
      case /* Fragile_literal_pattern */16 :
          return 52;
      case /* Unreachable_case */17 :
          return 56;
      case /* Assignment_to_non_mutable_value */18 :
          return 59;
      case /* Constraint_on_gadt */19 :
          return 62;
      
    }
  } else {
    switch (x.TAG | 0) {
      case /* Deprecated */0 :
          return 3;
      case /* Fragile_match */1 :
          return 4;
      case /* Labels_omitted */2 :
          return 6;
      case /* Method_override */3 :
          return 7;
      case /* Partial_match */4 :
          return 8;
      case /* Non_closed_record_pattern */5 :
          return 9;
      case /* Instance_variable_override */6 :
          return 13;
      case /* Implicit_public_methods */7 :
          return 15;
      case /* Undeclared_virtual_method */8 :
          return 17;
      case /* Not_principal */9 :
          return 18;
      case /* Without_principality */10 :
          return 19;
      case /* Preprocessor */11 :
          return 22;
      case /* Bad_module_name */12 :
          return 24;
      case /* Unused_var */13 :
          return 26;
      case /* Unused_var_strict */14 :
          return 27;
      case /* Duplicate_definitions */15 :
          return 30;
      case /* Multiple_definition */16 :
          return 31;
      case /* Unused_value_declaration */17 :
          return 32;
      case /* Unused_open */18 :
          return 33;
      case /* Unused_type_declaration */19 :
          return 34;
      case /* Unused_for_index */20 :
          return 35;
      case /* Unused_ancestor */21 :
          return 36;
      case /* Unused_constructor */22 :
          return 37;
      case /* Unused_extension */23 :
          return 38;
      case /* Name_out_of_scope */24 :
          return 40;
      case /* Ambiguous_name */25 :
          return 41;
      case /* Disambiguated_name */26 :
          return 42;
      case /* Nonoptional_label */27 :
          return 43;
      case /* Open_shadow_identifier */28 :
          return 44;
      case /* Open_shadow_label_constructor */29 :
          return 45;
      case /* Bad_env_variable */30 :
          return 46;
      case /* Attribute_payload */31 :
          return 47;
      case /* Eliminated_optional_arguments */32 :
          return 48;
      case /* No_cmi_file */33 :
          return 49;
      case /* Bad_docstring */34 :
          return 50;
      case /* Misplaced_attribute */35 :
          return 53;
      case /* Duplicated_attribute */36 :
          return 54;
      case /* Inlining_impossible */37 :
          return 55;
      case /* Ambiguous_pattern */38 :
          return 57;
      case /* No_cmx_file */39 :
          return 58;
      case /* Unused_module */40 :
          return 60;
      case /* Unboxable_type_in_prim_decl */41 :
          return 61;
      
    }
  }
}

function letter(x) {
  switch (x) {
    case 97 :
        var loop = function (i) {
          if (i === 0) {
            return /* [] */0;
          } else {
            return {
                    hd: i,
                    tl: loop(i - 1 | 0)
                  };
          }
        };
        return loop(62);
    case 99 :
        return {
                hd: 1,
                tl: {
                  hd: 2,
                  tl: /* [] */0
                }
              };
    case 100 :
        return {
                hd: 3,
                tl: /* [] */0
              };
    case 101 :
        return {
                hd: 4,
                tl: /* [] */0
              };
    case 102 :
        return {
                hd: 5,
                tl: /* [] */0
              };
    case 107 :
        return {
                hd: 32,
                tl: {
                  hd: 33,
                  tl: {
                    hd: 34,
                    tl: {
                      hd: 35,
                      tl: {
                        hd: 36,
                        tl: {
                          hd: 37,
                          tl: {
                            hd: 38,
                            tl: {
                              hd: 39,
                              tl: /* [] */0
                            }
                          }
                        }
                      }
                    }
                  }
                }
              };
    case 108 :
        return {
                hd: 6,
                tl: /* [] */0
              };
    case 109 :
        return {
                hd: 7,
                tl: /* [] */0
              };
    case 112 :
        return {
                hd: 8,
                tl: /* [] */0
              };
    case 114 :
        return {
                hd: 9,
                tl: /* [] */0
              };
    case 115 :
        return {
                hd: 10,
                tl: /* [] */0
              };
    case 117 :
        return {
                hd: 11,
                tl: {
                  hd: 12,
                  tl: /* [] */0
                }
              };
    case 118 :
        return {
                hd: 13,
                tl: /* [] */0
              };
    case 98 :
    case 103 :
    case 104 :
    case 105 :
    case 106 :
    case 110 :
    case 111 :
    case 113 :
    case 116 :
    case 119 :
        return /* [] */0;
    case 120 :
        return {
                hd: 14,
                tl: {
                  hd: 15,
                  tl: {
                    hd: 16,
                    tl: {
                      hd: 17,
                      tl: {
                        hd: 18,
                        tl: {
                          hd: 19,
                          tl: {
                            hd: 20,
                            tl: {
                              hd: 21,
                              tl: {
                                hd: 22,
                                tl: {
                                  hd: 23,
                                  tl: {
                                    hd: 24,
                                    tl: {
                                      hd: 30,
                                      tl: /* [] */0
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              };
    case 121 :
        return {
                hd: 26,
                tl: /* [] */0
              };
    case 122 :
        return {
                hd: 27,
                tl: /* [] */0
              };
    default:
      throw {
            RE_EXN_ID: "Assert_failure",
            _1: [
              "warnings.res",
              204,
              9
            ],
            Error: new Error()
          };
  }
}

var current = {
  contents: {
    active: Caml_array.make(63, true),
    error: Caml_array.make(63, false)
  }
};

var disabled = {
  contents: false
};

function without_warnings(f) {
  return Misc.protect_refs({
              hd: /* R */{
                _0: disabled,
                _1: true
              },
              tl: /* [] */0
            }, f);
}

function backup(param) {
  return current.contents;
}

function restore(x) {
  current.contents = x;
  
}

function is_active(x) {
  if (disabled.contents) {
    return false;
  } else {
    return Caml_array.get(current.contents.active, number(x));
  }
}

function is_error(x) {
  if (disabled.contents) {
    return false;
  } else {
    return Caml_array.get(current.contents.error, number(x));
  }
}

function mk_lazy(f) {
  var state = current.contents;
  return {
          LAZY_DONE: false,
          VAL: (function () {
              var prev = current.contents;
              current.contents = state;
              try {
                var r = Curry._1(f, undefined);
                current.contents = prev;
                return r;
              }
              catch (exn){
                current.contents = prev;
                throw exn;
              }
            })
        };
}

function parse_opt(error, active, flags, s) {
  var set = function (i) {
    return Caml_array.set(flags, i, true);
  };
  var clear = function (i) {
    return Caml_array.set(flags, i, false);
  };
  var set_all = function (i) {
    Caml_array.set(active, i, true);
    return Caml_array.set(error, i, true);
  };
  var get_num = function (_n, _i) {
    while(true) {
      var i = _i;
      var n = _n;
      if (i >= s.length) {
        return [
                i,
                n
              ];
      }
      var match = Caml_string.get(s, i);
      if (match > 57 || match < 48) {
        return [
                i,
                n
              ];
      }
      _i = i + 1 | 0;
      _n = (Math.imul(10, n) + Caml_string.get(s, i) | 0) - /* '0' */48 | 0;
      continue ;
    };
  };
  var get_range = function (i) {
    var match = get_num(0, i);
    var n1 = match[1];
    var i$1 = match[0];
    if (!((i$1 + 2 | 0) < s.length && Caml_string.get(s, i$1) === /* '.' */46 && Caml_string.get(s, i$1 + 1 | 0) === /* '.' */46)) {
      return [
              i$1,
              n1,
              n1
            ];
    }
    var match$1 = get_num(0, i$1 + 2 | 0);
    var n2 = match$1[1];
    if (n2 < n1) {
      throw {
            RE_EXN_ID: Arg.Bad,
            _1: "Ill-formed list of warnings",
            Error: new Error()
          };
    }
    return [
            match$1[0],
            n1,
            n2
          ];
  };
  var loop = function (_i) {
    while(true) {
      var i = _i;
      if (i >= s.length) {
        return ;
      }
      var match = Caml_string.get(s, i);
      if (match >= 65) {
        if (match >= 97) {
          if (match >= 123) {
            throw {
                  RE_EXN_ID: Arg.Bad,
                  _1: "Ill-formed list of warnings",
                  Error: new Error()
                };
          }
          List.iter(clear, letter(Caml_string.get(s, i)));
          _i = i + 1 | 0;
          continue ;
        }
        if (match >= 91) {
          throw {
                RE_EXN_ID: Arg.Bad,
                _1: "Ill-formed list of warnings",
                Error: new Error()
              };
        }
        List.iter(set, letter(Char.lowercase_ascii(Caml_string.get(s, i))));
        _i = i + 1 | 0;
        continue ;
      }
      if (match >= 46) {
        if (match >= 64) {
          return loop_letter_num(set_all, i + 1 | 0);
        }
        throw {
              RE_EXN_ID: Arg.Bad,
              _1: "Ill-formed list of warnings",
              Error: new Error()
            };
      }
      if (match >= 43) {
        switch (match) {
          case 43 :
              return loop_letter_num(set, i + 1 | 0);
          case 44 :
              throw {
                    RE_EXN_ID: Arg.Bad,
                    _1: "Ill-formed list of warnings",
                    Error: new Error()
                  };
          case 45 :
              return loop_letter_num(clear, i + 1 | 0);
          
        }
      } else {
        throw {
              RE_EXN_ID: Arg.Bad,
              _1: "Ill-formed list of warnings",
              Error: new Error()
            };
      }
    };
  };
  var loop_letter_num = function (myset, i) {
    if (i >= s.length) {
      throw {
            RE_EXN_ID: Arg.Bad,
            _1: "Ill-formed list of warnings",
            Error: new Error()
          };
    }
    var match = Caml_string.get(s, i);
    if (match >= 65) {
      if (match >= 97) {
        if (match >= 123) {
          throw {
                RE_EXN_ID: Arg.Bad,
                _1: "Ill-formed list of warnings",
                Error: new Error()
              };
        }
        List.iter(myset, letter(Caml_string.get(s, i)));
        return loop(i + 1 | 0);
      }
      if (match >= 91) {
        throw {
              RE_EXN_ID: Arg.Bad,
              _1: "Ill-formed list of warnings",
              Error: new Error()
            };
      }
      List.iter(myset, letter(Char.lowercase_ascii(Caml_string.get(s, i))));
      return loop(i + 1 | 0);
    }
    if (match > 57 || match < 48) {
      throw {
            RE_EXN_ID: Arg.Bad,
            _1: "Ill-formed list of warnings",
            Error: new Error()
          };
    }
    var match$1 = get_range(i);
    for(var n = match$1[1] ,n_finish = Caml.caml_int_min(match$1[2], 62); n <= n_finish; ++n){
      Curry._1(myset, n);
    }
    return loop(match$1[0]);
  };
  return loop(0);
}

function parse_options(errflag, s) {
  var error = $$Array.copy(current.contents.error);
  var active = $$Array.copy(current.contents.active);
  parse_opt(error, active, errflag ? error : active, s);
  current.contents = {
    active: active,
    error: error
  };
  
}

var defaults_w = "+a-4-6-7-9-27-29-32..42-44-45-48-50-60";

var defaults_warn_error = "-a+31";

parse_options(false, defaults_w);

parse_options(true, defaults_warn_error);

function message(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Comment_start */0 :
          return "this is the start of a comment.";
      case /* Comment_not_end */1 :
          return "this is not the end of a comment.";
      case /* Partial_application */2 :
          return "this function application is partial,\nmaybe some arguments are missing.";
      case /* Statement_type */3 :
          return "this expression should have type unit.";
      case /* Unused_match */4 :
          return "this match case is unused.";
      case /* Unused_pat */5 :
          return "this sub-pattern is unused.";
      case /* Illegal_backslash */6 :
          return "illegal backslash escape in string.";
      case /* Unerasable_optional_argument */7 :
          return "this optional argument cannot be erased.";
      case /* Unused_argument */8 :
          return "this argument will not be used by the function.";
      case /* Nonreturning_statement */9 :
          return "this statement never returns (or has an unsound type.)";
      case /* Useless_record_with */10 :
          return "all the fields are explicitly listed in this record:\nthe 'with' clause is useless.";
      case /* All_clauses_guarded */11 :
          return "this pattern-matching is not exhaustive.\nAll clauses in this pattern-matching are guarded.";
      case /* Wildcard_arg_to_constant_constr */12 :
          return "wildcard pattern given as argument to a constant constructor";
      case /* Eol_in_string */13 :
          return "unescaped end-of-line in a string constant (non-portable code)";
      case /* Unused_rec_flag */14 :
          return "unused rec flag.";
      case /* Expect_tailcall */15 :
          return Printf.sprintf("expected tailcall");
      case /* Fragile_literal_pattern */16 :
          return Printf.sprintf("Code should not depend on the actual values of\nthis constructor's arguments. They are only for information\nand may change in future versions. (See manual section 8.5)");
      case /* Unreachable_case */17 :
          return "this match case is unreachable.\nConsider replacing it with a refutation case '<pat> -> .'";
      case /* Assignment_to_non_mutable_value */18 :
          return "A potential assignment to a non-mutable value was detected \nin this source file.  Such assignments may generate incorrect code \nwhen using Flambda.";
      case /* Constraint_on_gadt */19 :
          return "Type constraints do not apply to GADT cases of variant types.";
      
    }
  } else {
    switch (x.TAG | 0) {
      case /* Deprecated */0 :
          return "deprecated: " + Misc.normalise_eol(x._0);
      case /* Fragile_match */1 :
          var s = x._0;
          if (s === "") {
            return "this pattern-matching is fragile.";
          } else {
            return "this pattern-matching is fragile.\nIt will remain exhaustive when constructors are added to type " + (s + ".");
          }
      case /* Labels_omitted */2 :
          var ls = x._0;
          if (ls) {
            if (ls.tl) {
              return "labels " + ($$String.concat(", ", ls) + " were omitted in the application of this function.");
            } else {
              return "label " + (ls.hd + " was omitted in the application of this function.");
            }
          }
          throw {
                RE_EXN_ID: "Assert_failure",
                _1: [
                  "warnings.res",
                  360,
                  30
                ],
                Error: new Error()
              };
      case /* Method_override */3 :
          var match = x._0;
          if (match) {
            var slist = match.tl;
            var lab = match.hd;
            if (slist) {
              return $$String.concat(" ", {
                          hd: "the following methods are overridden by the class",
                          tl: {
                            hd: lab,
                            tl: {
                              hd: ":\n ",
                              tl: slist
                            }
                          }
                        });
            } else {
              return "the method " + (lab + " is overridden.");
            }
          }
          throw {
                RE_EXN_ID: "Assert_failure",
                _1: [
                  "warnings.res",
                  371,
                  31
                ],
                Error: new Error()
              };
      case /* Partial_match */4 :
          var s$1 = x._0;
          if (s$1 === "") {
            return "this pattern-matching is not exhaustive.";
          } else {
            return "this pattern-matching is not exhaustive.\nHere is an example of a case that is not matched:\n" + s$1;
          }
      case /* Non_closed_record_pattern */5 :
          return "the following labels are not bound in this record pattern:\n" + (x._0 + "\nEither bind these labels explicitly or add '; _' to the pattern.");
      case /* Instance_variable_override */6 :
          var match$1 = x._0;
          if (match$1) {
            var slist$1 = match$1.tl;
            var lab$1 = match$1.hd;
            if (slist$1) {
              return $$String.concat(" ", {
                          hd: "the following instance variables are overridden by the class",
                          tl: {
                            hd: lab$1,
                            tl: {
                              hd: ":\n ",
                              tl: slist$1
                            }
                          }
                        }) + "\nThe behaviour changed in ocaml 3.10 (previous behaviour was hiding.)";
            } else {
              return "the instance variable " + (lab$1 + " is overridden.\nThe behaviour changed in ocaml 3.10 (previous behaviour was hiding.)");
            }
          }
          throw {
                RE_EXN_ID: "Assert_failure",
                _1: [
                  "warnings.res",
                  393,
                  42
                ],
                Error: new Error()
              };
      case /* Implicit_public_methods */7 :
          return "the following private methods were made public implicitly:\n " + ($$String.concat(" ", x._0) + ".");
      case /* Undeclared_virtual_method */8 :
          return "the virtual method " + (x._0 + " is not declared.");
      case /* Not_principal */9 :
          return x._0 + " is not principal.";
      case /* Without_principality */10 :
          return x._0 + " without principality.";
      case /* Preprocessor */11 :
          return x._0;
      case /* Bad_module_name */12 :
          return "bad source file name: \"" + (x._0 + "\" is not a valid module name.");
      case /* Unused_var */13 :
      case /* Unused_var_strict */14 :
          return "unused variable " + (x._0 + ".");
      case /* Duplicate_definitions */15 :
          return Curry._4(Printf.sprintf("the %s %s is defined in both types %s and %s."), x._0, x._1, x._2, x._3);
      case /* Multiple_definition */16 :
          return Curry._3(Printf.sprintf("files %s and %s both define a module named %s"), x._1, x._2, x._0);
      case /* Unused_value_declaration */17 :
          return "unused value " + (x._0 + ".");
      case /* Unused_open */18 :
          return "unused open " + (x._0 + ".");
      case /* Unused_type_declaration */19 :
          return "unused type " + (x._0 + ".");
      case /* Unused_for_index */20 :
          return "unused for-loop index " + (x._0 + ".");
      case /* Unused_ancestor */21 :
          return "unused ancestor variable " + (x._0 + ".");
      case /* Unused_constructor */22 :
          var s$2 = x._0;
          if (x._1) {
            return "constructor " + (s$2 + " is never used to build values.\n(However, this constructor appears in patterns.)");
          } else if (x._2) {
            return "constructor " + (s$2 + " is never used to build values.\nIts type is exported as a private type.");
          } else {
            return "unused constructor " + (s$2 + ".");
          }
      case /* Unused_extension */23 :
          var kind = x._1 ? "exception" : "extension constructor";
          var name = kind + (" " + x._0);
          if (x._2) {
            return name + " is never used to build values.\n(However, this constructor appears in patterns.)";
          } else if (x._3) {
            return name + " is never used to build values.\nIt is exported or rebound as a private extension.";
          } else {
            return "unused " + name;
          }
      case /* Name_out_of_scope */24 :
          var slist$2 = x._1;
          var ty = x._0;
          if (slist$2 && !slist$2.tl && !x._2) {
            return slist$2.hd + (" was selected from type " + (ty + ".\nIt is not visible in the current scope, and will not \nbe selected if the type becomes unknown."));
          }
          if (x._2) {
            return "this record of type " + (ty + (" contains fields that are \nnot visible in the current scope: " + ($$String.concat(" ", slist$2) + ".\nThey will not be selected if the type becomes unknown.")));
          }
          throw {
                RE_EXN_ID: "Assert_failure",
                _1: [
                  "warnings.res",
                  457,
                  38
                ],
                Error: new Error()
              };
          break;
      case /* Ambiguous_name */25 :
          var _slist = x._0;
          if (_slist && !_slist.tl && !x._2) {
            return _slist.hd + (" belongs to several types: " + ($$String.concat(" ", x._1) + "\nThe first one was selected. Please disambiguate if this is wrong."));
          }
          if (x._2) {
            return "these field labels belong to several types: " + ($$String.concat(" ", x._1) + "\nThe first one was selected. Please disambiguate if this is wrong.");
          }
          throw {
                RE_EXN_ID: "Assert_failure",
                _1: [
                  "warnings.res",
                  473,
                  35
                ],
                Error: new Error()
              };
          break;
      case /* Disambiguated_name */26 :
          return "this use of " + (x._0 + " relies on type-directed disambiguation,\nit will not compile with OCaml 4.00 or earlier.");
      case /* Nonoptional_label */27 :
          return "the label " + (x._0 + " is not optional.");
      case /* Open_shadow_identifier */28 :
          return Curry._2(Printf.sprintf("this open statement shadows the %s identifier %s (which is later used)"), x._0, x._1);
      case /* Open_shadow_label_constructor */29 :
          return Curry._2(Printf.sprintf("this open statement shadows the %s %s (which is later used)"), x._0, x._1);
      case /* Bad_env_variable */30 :
          return Curry._2(Printf.sprintf("illegal environment variable %s : %s"), x._0, x._1);
      case /* Attribute_payload */31 :
          return Curry._2(Printf.sprintf("illegal payload for attribute '%s'.\n%s"), x._0, x._1);
      case /* Eliminated_optional_arguments */32 :
          var sl = x._0;
          return Curry._2(Printf.sprintf("implicit elimination of optional argument%s %s"), List.length(sl) === 1 ? "" : "s", $$String.concat(", ", sl));
      case /* No_cmi_file */33 :
          var msg = x._1;
          var name$1 = x._0;
          if (msg !== undefined) {
            return Curry._2(Printf.sprintf("no valid cmi file was found in path for module %s. %s"), name$1, msg);
          } else {
            return "no cmi file was found in path for module " + name$1;
          }
      case /* Bad_docstring */34 :
          if (x._0) {
            return "unattached documentation comment (ignored)";
          } else {
            return "ambiguous documentation comment";
          }
      case /* Misplaced_attribute */35 :
          return Curry._1(Printf.sprintf("the %S attribute cannot appear in this context"), x._0);
      case /* Duplicated_attribute */36 :
          return Curry._1(Printf.sprintf("the %S attribute is used more than once on this expression"), x._0);
      case /* Inlining_impossible */37 :
          return Curry._1(Printf.sprintf("Cannot inline: %s"), x._0);
      case /* Ambiguous_pattern */38 :
          var vars = List.sort($$String.compare, x._0);
          var tmp;
          if (vars) {
            tmp = vars.tl ? "variables " + $$String.concat(",", vars) : "variable " + vars.hd;
          } else {
            throw {
                  RE_EXN_ID: "Assert_failure",
                  _1: [
                    "warnings.res",
                    535,
                    18
                  ],
                  Error: new Error()
                };
          }
          return Curry._1(Printf.sprintf("Ambiguous or-pattern variables under guard;\n%s may match different arguments. (See manual section 8.5)"), tmp);
      case /* No_cmx_file */39 :
          return Curry._1(Printf.sprintf("no cmx file was found in path for module %s, and its interface was not compiled with -opaque"), x._0);
      case /* Unused_module */40 :
          return "unused module " + (x._0 + ".");
      case /* Unboxable_type_in_prim_decl */41 :
          var t = x._0;
          return Curry._2(Printf.sprintf("This primitive declaration uses type %s, which is unannotated and\nunboxable. The representation of such types may change in future\nversions. You should annotate the declaration of %s with [@@boxed]\nor [@@unboxed]."), t, t);
      
    }
  }
}

function sub_locs(x) {
  if (typeof x === "number" || x.TAG !== /* Deprecated */0) {
    return /* [] */0;
  } else {
    return {
            hd: [
              x._1,
              "Definition"
            ],
            tl: {
              hd: [
                x._2,
                "Expected signature"
              ],
              tl: /* [] */0
            }
          };
  }
}

var nerrors = {
  contents: 0
};

function report(w) {
  if (is_active(w)) {
    if (is_error(w)) {
      nerrors.contents = nerrors.contents + 1 | 0;
    }
    return {
            NAME: "Active",
            VAL: {
              number: number(w),
              message: message(w),
              is_error: is_error(w),
              sub_locs: sub_locs(w)
            }
          };
  } else {
    return "Inactive";
  }
}

var Errors = /* @__PURE__ */Caml_exceptions.create("Warnings.Errors");

function reset_fatal(param) {
  nerrors.contents = 0;
  
}

function check_fatal(param) {
  if (nerrors.contents <= 0) {
    return ;
  }
  nerrors.contents = 0;
  throw {
        RE_EXN_ID: Errors,
        Error: new Error()
      };
}

var descriptions = {
  hd: [
    1,
    "Suspicious-looking start-of-comment mark."
  ],
  tl: {
    hd: [
      2,
      "Suspicious-looking end-of-comment mark."
    ],
    tl: {
      hd: [
        3,
        "Deprecated feature."
      ],
      tl: {
        hd: [
          4,
          "Fragile pattern matching: matching that will remain complete even\n    if additional constructors are added to one of the variant types\n    matched."
        ],
        tl: {
          hd: [
            5,
            "Partially applied function: expression whose result has function\n    type and is ignored."
          ],
          tl: {
            hd: [
              6,
              "Label omitted in function application."
            ],
            tl: {
              hd: [
                7,
                "Method overridden."
              ],
              tl: {
                hd: [
                  8,
                  "Partial match: missing cases in pattern-matching."
                ],
                tl: {
                  hd: [
                    9,
                    "Missing fields in a record pattern."
                  ],
                  tl: {
                    hd: [
                      10,
                      "Expression on the left-hand side of a sequence that doesn't have type\n    \"unit\" (and that is not a function, see warning number 5)."
                    ],
                    tl: {
                      hd: [
                        11,
                        "Redundant case in a pattern matching (unused match case)."
                      ],
                      tl: {
                        hd: [
                          12,
                          "Redundant sub-pattern in a pattern-matching."
                        ],
                        tl: {
                          hd: [
                            13,
                            "Instance variable overridden."
                          ],
                          tl: {
                            hd: [
                              14,
                              "Illegal backslash escape in a string constant."
                            ],
                            tl: {
                              hd: [
                                15,
                                "Private method made public implicitly."
                              ],
                              tl: {
                                hd: [
                                  16,
                                  "Unerasable optional argument."
                                ],
                                tl: {
                                  hd: [
                                    17,
                                    "Undeclared virtual method."
                                  ],
                                  tl: {
                                    hd: [
                                      18,
                                      "Non-principal type."
                                    ],
                                    tl: {
                                      hd: [
                                        19,
                                        "Type without principality."
                                      ],
                                      tl: {
                                        hd: [
                                          20,
                                          "Unused function argument."
                                        ],
                                        tl: {
                                          hd: [
                                            21,
                                            "Non-returning statement."
                                          ],
                                          tl: {
                                            hd: [
                                              22,
                                              "Preprocessor warning."
                                            ],
                                            tl: {
                                              hd: [
                                                23,
                                                "Useless record \"with\" clause."
                                              ],
                                              tl: {
                                                hd: [
                                                  24,
                                                  "Bad module name: the source file name is not a valid OCaml module name."
                                                ],
                                                tl: {
                                                  hd: [
                                                    25,
                                                    "Deprecated: now part of warning 8."
                                                  ],
                                                  tl: {
                                                    hd: [
                                                      26,
                                                      "Suspicious unused variable: unused variable that is bound\n    with \"let\" or \"as\", and doesn't start with an underscore (\"_\")\n    character."
                                                    ],
                                                    tl: {
                                                      hd: [
                                                        27,
                                                        "Innocuous unused variable: unused variable that is not bound with\n    \"let\" nor \"as\", and doesn't start with an underscore (\"_\")\n    character."
                                                      ],
                                                      tl: {
                                                        hd: [
                                                          28,
                                                          "Wildcard pattern given as argument to a constant constructor."
                                                        ],
                                                        tl: {
                                                          hd: [
                                                            29,
                                                            "Unescaped end-of-line in a string constant (non-portable code)."
                                                          ],
                                                          tl: {
                                                            hd: [
                                                              30,
                                                              "Two labels or constructors of the same name are defined in two\n    mutually recursive types."
                                                            ],
                                                            tl: {
                                                              hd: [
                                                                31,
                                                                "A module is linked twice in the same executable."
                                                              ],
                                                              tl: {
                                                                hd: [
                                                                  32,
                                                                  "Unused value declaration."
                                                                ],
                                                                tl: {
                                                                  hd: [
                                                                    33,
                                                                    "Unused open statement."
                                                                  ],
                                                                  tl: {
                                                                    hd: [
                                                                      34,
                                                                      "Unused type declaration."
                                                                    ],
                                                                    tl: {
                                                                      hd: [
                                                                        35,
                                                                        "Unused for-loop index."
                                                                      ],
                                                                      tl: {
                                                                        hd: [
                                                                          36,
                                                                          "Unused ancestor variable."
                                                                        ],
                                                                        tl: {
                                                                          hd: [
                                                                            37,
                                                                            "Unused constructor."
                                                                          ],
                                                                          tl: {
                                                                            hd: [
                                                                              38,
                                                                              "Unused extension constructor."
                                                                            ],
                                                                            tl: {
                                                                              hd: [
                                                                                39,
                                                                                "Unused rec flag."
                                                                              ],
                                                                              tl: {
                                                                                hd: [
                                                                                  40,
                                                                                  "Constructor or label name used out of scope."
                                                                                ],
                                                                                tl: {
                                                                                  hd: [
                                                                                    41,
                                                                                    "Ambiguous constructor or label name."
                                                                                  ],
                                                                                  tl: {
                                                                                    hd: [
                                                                                      42,
                                                                                      "Disambiguated constructor or label name (compatibility warning)."
                                                                                    ],
                                                                                    tl: {
                                                                                      hd: [
                                                                                        43,
                                                                                        "Nonoptional label applied as optional."
                                                                                      ],
                                                                                      tl: {
                                                                                        hd: [
                                                                                          44,
                                                                                          "Open statement shadows an already defined identifier."
                                                                                        ],
                                                                                        tl: {
                                                                                          hd: [
                                                                                            45,
                                                                                            "Open statement shadows an already defined label or constructor."
                                                                                          ],
                                                                                          tl: {
                                                                                            hd: [
                                                                                              46,
                                                                                              "Error in environment variable."
                                                                                            ],
                                                                                            tl: {
                                                                                              hd: [
                                                                                                47,
                                                                                                "Illegal attribute payload."
                                                                                              ],
                                                                                              tl: {
                                                                                                hd: [
                                                                                                  48,
                                                                                                  "Implicit elimination of optional arguments."
                                                                                                ],
                                                                                                tl: {
                                                                                                  hd: [
                                                                                                    49,
                                                                                                    "Absent cmi file when looking up module alias."
                                                                                                  ],
                                                                                                  tl: {
                                                                                                    hd: [
                                                                                                      50,
                                                                                                      "Unexpected documentation comment."
                                                                                                    ],
                                                                                                    tl: {
                                                                                                      hd: [
                                                                                                        51,
                                                                                                        "Warning on non-tail calls if @tailcall present."
                                                                                                      ],
                                                                                                      tl: {
                                                                                                        hd: [
                                                                                                          52,
                                                                                                          "Fragile constant pattern."
                                                                                                        ],
                                                                                                        tl: {
                                                                                                          hd: [
                                                                                                            53,
                                                                                                            "Attribute cannot appear in this context"
                                                                                                          ],
                                                                                                          tl: {
                                                                                                            hd: [
                                                                                                              54,
                                                                                                              "Attribute used more than once on an expression"
                                                                                                            ],
                                                                                                            tl: {
                                                                                                              hd: [
                                                                                                                55,
                                                                                                                "Inlining impossible"
                                                                                                              ],
                                                                                                              tl: {
                                                                                                                hd: [
                                                                                                                  56,
                                                                                                                  "Unreachable case in a pattern-matching (based on type information)."
                                                                                                                ],
                                                                                                                tl: {
                                                                                                                  hd: [
                                                                                                                    57,
                                                                                                                    "Ambiguous or-pattern variables under guard"
                                                                                                                  ],
                                                                                                                  tl: {
                                                                                                                    hd: [
                                                                                                                      58,
                                                                                                                      "Missing cmx file"
                                                                                                                    ],
                                                                                                                    tl: {
                                                                                                                      hd: [
                                                                                                                        59,
                                                                                                                        "Assignment to non-mutable value"
                                                                                                                      ],
                                                                                                                      tl: {
                                                                                                                        hd: [
                                                                                                                          60,
                                                                                                                          "Unused module declaration"
                                                                                                                        ],
                                                                                                                        tl: {
                                                                                                                          hd: [
                                                                                                                            61,
                                                                                                                            "Unboxable type in primitive declaration"
                                                                                                                          ],
                                                                                                                          tl: {
                                                                                                                            hd: [
                                                                                                                              62,
                                                                                                                              "Type constraint on GADT type declaration"
                                                                                                                            ],
                                                                                                                            tl: /* [] */0
                                                                                                                          }
                                                                                                                        }
                                                                                                                      }
                                                                                                                    }
                                                                                                                  }
                                                                                                                }
                                                                                                              }
                                                                                                            }
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    }
                                                                                                  }
                                                                                                }
                                                                                              }
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};

function help_warnings(param) {
  List.iter((function (param) {
          return Curry._2(Printf.printf("%3i %s\n"), param[0], param[1]);
        }), descriptions);
  console.log("  A all warnings");
  for(var i = /* 'b' */98; i <= /* 'z' */122; ++i){
    var c = Char.chr(i);
    var l = letter(c);
    if (l) {
      if (l.tl) {
        Curry._2(Printf.printf("  %c warnings %s.\n"), Char.uppercase_ascii(c), $$String.concat(", ", List.map((function (prim) {
                        return String(prim);
                      }), l)));
      } else {
        Curry._2(Printf.printf("  %c Alias for warning %i.\n"), Char.uppercase_ascii(c), l.hd);
      }
    }
    
  }
  return Pervasives.exit(0);
}

var last_warning_number = 62;

export {
  number ,
  last_warning_number ,
  letter ,
  current ,
  disabled ,
  without_warnings ,
  backup ,
  restore ,
  is_active ,
  is_error ,
  mk_lazy ,
  parse_opt ,
  parse_options ,
  defaults_w ,
  defaults_warn_error ,
  message ,
  sub_locs ,
  nerrors ,
  report ,
  Errors ,
  reset_fatal ,
  check_fatal ,
  descriptions ,
  help_warnings ,
  
}
/*  Not a pure module */
