// Generated by ReScript, PLEASE EDIT WITH CARE

import * as Res_token from "./res_token.js";

function toString(x) {
  if (typeof x !== "number") {
    return "an expression after the operator \"" + (Res_token.toString(x._0) + "\"");
  }
  switch (x) {
    case /* OpenDescription */0 :
        return "an open description";
    case /* ModuleLongIdent */1 :
        return "a module path";
    case /* Ternary */2 :
        return "a ternary expression";
    case /* Es6ArrowExpr */3 :
        return "an es6 arrow function";
    case /* Jsx */4 :
        return "a jsx expression";
    case /* JsxAttribute */5 :
        return "a jsx attribute";
    case /* JsxChild */6 :
        return "jsx child";
    case /* ExprOperand */7 :
        return "a basic expression";
    case /* ExprUnary */8 :
        return "a unary expression";
    case /* ExprSetField */9 :
        return "a record field mutation";
    case /* ExprBlock */10 :
        return "a block with expressions";
    case /* ExprCall */11 :
        return "a function application";
    case /* ExprList */12 :
        return "multiple expressions";
    case /* ExprArrayAccess */13 :
        return "an array access expression";
    case /* ExprArrayMutation */14 :
        return "an array mutation";
    case /* ExprIf */15 :
        return "an if expression";
    case /* ExprFor */16 :
        return "a for expression";
    case /* IfCondition */17 :
        return "the condition of an if expression";
    case /* IfBranch */18 :
        return "the true-branch of an if expression";
    case /* ElseBranch */19 :
        return "the else-branch of an if expression";
    case /* External */21 :
        return "an external";
    case /* PatternMatching */22 :
        return "the cases of a pattern match";
    case /* PatternMatchCase */23 :
        return "a pattern match case";
    case /* LetBinding */24 :
        return "a let binding";
    case /* PatternList */25 :
        return "multiple patterns";
    case /* PatternOcamlList */26 :
        return "a list pattern";
    case /* PatternRecord */27 :
        return "a record pattern";
    case /* TypeDef */28 :
        return "a type definition";
    case /* TypeConstrName */29 :
        return "a type-constructor name";
    case /* TypeParams */30 :
        return "type parameters";
    case /* TypeParam */31 :
        return "a type parameter";
    case /* PackageConstraint */32 :
        return "a package constraint";
    case /* TypeRepresentation */33 :
        return "a type representation";
    case /* RecordDecl */34 :
        return "a record declaration";
    case /* ConstructorDeclaration */35 :
        return "a constructor declaration";
    case /* ParameterList */36 :
        return "parameters";
    case /* StringFieldDeclarations */37 :
        return "string field declarations";
    case /* FieldDeclarations */38 :
        return "field declarations";
    case /* TypExprList */39 :
        return "list of types";
    case /* FunctorArgs */40 :
        return "functor arguments";
    case /* ModExprList */41 :
        return "list of module expressions";
    case /* TypeParameters */42 :
        return "list of type parameters";
    case /* RecordRows */43 :
        return "rows of a record";
    case /* RecordRowsStringKey */44 :
        return "rows of a record with string keys";
    case /* ArgumentList */45 :
        return "arguments";
    case /* Signature */46 :
        return "signature";
    case /* Specification */47 :
        return "specification";
    case /* Structure */48 :
        return "structure";
    case /* Implementation */49 :
        return "implementation";
    case /* Attribute */50 :
        return "an attribute";
    case /* TypeConstraint */51 :
        return "constraints on a type";
    case /* TypeExpression */20 :
    case /* AtomicTypExpr */52 :
        return "a type";
    case /* ListExpr */53 :
        return "an ocaml list expr";
    case /* JsFfiImport */54 :
        return "js ffi import";
    case /* Pattern */55 :
        return "pattern";
    case /* AttributePayload */56 :
        return "an attribute payload";
    case /* TagNames */57 :
        return "tag names";
    
  }
}

function isSignatureItemStart(x) {
  if (typeof x !== "number") {
    return false;
  }
  if (x < 10) {
    return x > 8 || x < 1;
  }
  if (x === 27) {
    return true;
  }
  if (x < 59) {
    return false;
  }
  switch (x) {
    case /* Private */61 :
    case /* Mutable */62 :
    case /* Constraint */63 :
    case /* Of */66 :
    case /* Land */67 :
    case /* Lor */68 :
    case /* Band */69 :
    case /* BangEqual */70 :
    case /* BangEqualEqual */71 :
    case /* LessEqual */72 :
    case /* GreaterEqual */73 :
    case /* ColonEqual */74 :
    case /* Percent */77 :
    case /* List */79 :
    case /* Backtick */80 :
    case /* BarGreater */81 :
    case /* Try */82 :
    case /* Import */83 :
        return false;
    case /* External */59 :
    case /* Typ */60 :
    case /* Include */64 :
    case /* Module */65 :
    case /* At */75 :
    case /* AtAt */76 :
    case /* PercentPercent */78 :
    case /* Export */84 :
        return true;
    
  }
}

function isAtomicPatternStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Underscore */12 :
      case /* Lparen */18 :
      case /* Lbracket */20 :
      case /* Lbrace */22 :
      case /* Exception */27 :
      case /* Lazy */47 :
      case /* Percent */77 :
      case /* List */79 :
      case /* Backtick */80 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Codepoint */0 :
      case /* Int */1 :
      case /* String */3 :
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isAtomicExprStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* True */1 :
      case /* False */2 :
      case /* Lparen */18 :
      case /* Lbracket */20 :
      case /* Lbrace */22 :
      case /* LessThan */42 :
      case /* Hash */44 :
      case /* Module */65 :
      case /* Percent */77 :
      case /* List */79 :
      case /* Backtick */80 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Codepoint */0 :
      case /* Int */1 :
      case /* Float */2 :
      case /* String */3 :
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isAtomicTypExprStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Underscore */12 :
      case /* SingleQuote */13 :
      case /* Lparen */18 :
      case /* Lbrace */22 :
      case /* Percent */77 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isExprStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* True */1 :
      case /* False */2 :
      case /* Bang */7 :
      case /* Underscore */12 :
      case /* Lparen */18 :
      case /* Lbracket */20 :
      case /* Lbrace */22 :
      case /* Minus */34 :
      case /* MinusDot */35 :
      case /* Plus */36 :
      case /* PlusDot */37 :
      case /* LessThan */42 :
      case /* Hash */44 :
      case /* Assert */46 :
      case /* Lazy */47 :
      case /* If */50 :
      case /* For */52 :
      case /* While */54 :
      case /* Switch */55 :
      case /* Module */65 :
      case /* At */75 :
      case /* Percent */77 :
      case /* List */79 :
      case /* Backtick */80 :
      case /* Try */82 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Codepoint */0 :
      case /* Int */1 :
      case /* Float */2 :
      case /* String */3 :
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isJsxAttributeStart(x) {
  if (typeof x === "number") {
    if (x === /* Question */49) {
      return true;
    } else {
      return false;
    }
  } else if (x.TAG === /* Lident */4) {
    return true;
  } else {
    return false;
  }
}

function isStructureItemStart(x) {
  if (typeof x === "number") {
    if (x >= 10) {
      if (x === 27) {
        return true;
      }
      if (x >= 59) {
        switch (x) {
          case /* Private */61 :
          case /* Mutable */62 :
          case /* Constraint */63 :
          case /* Of */66 :
          case /* Land */67 :
          case /* Lor */68 :
          case /* Band */69 :
          case /* BangEqual */70 :
          case /* BangEqualEqual */71 :
          case /* LessEqual */72 :
          case /* GreaterEqual */73 :
          case /* ColonEqual */74 :
          case /* Percent */77 :
          case /* List */79 :
          case /* Backtick */80 :
          case /* BarGreater */81 :
          case /* Try */82 :
              break;
          case /* External */59 :
          case /* Typ */60 :
          case /* Include */64 :
          case /* Module */65 :
          case /* At */75 :
          case /* AtAt */76 :
          case /* PercentPercent */78 :
          case /* Import */83 :
          case /* Export */84 :
              return true;
          
        }
      }
      
    } else if (x > 8 || x < 1) {
      return true;
    }
    
  }
  if (isExprStart(x)) {
    return true;
  } else {
    return false;
  }
}

function isPatternStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* True */1 :
      case /* False */2 :
      case /* Underscore */12 :
      case /* Lparen */18 :
      case /* Lbracket */20 :
      case /* Lbrace */22 :
      case /* Exception */27 :
      case /* Minus */34 :
      case /* Plus */36 :
      case /* Hash */44 :
      case /* Lazy */47 :
      case /* Module */65 :
      case /* At */75 :
      case /* Percent */77 :
      case /* List */79 :
      case /* Backtick */80 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Codepoint */0 :
      case /* Int */1 :
      case /* Float */2 :
      case /* String */3 :
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isParameterStart(x) {
  if (typeof x === "number") {
    if (x > 48 || x < 4) {
      if (x === 60) {
        return true;
      }
      
    } else if (x > 47 || x < 5) {
      return true;
    }
    
  }
  if (isPatternStart(x)) {
    return true;
  } else {
    return false;
  }
}

function isStringFieldDeclStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* DotDotDot */6 :
      case /* At */75 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* String */3 :
      case /* Lident */4 :
          return true;
      default:
        return false;
    }
  }
}

function isFieldDeclStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Mutable */62 :
      case /* At */75 :
          return true;
      default:
        if (Res_token.isKeyword(x)) {
          return true;
        } else {
          return false;
        }
    }
  } else {
    switch (x.TAG | 0) {
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        if (Res_token.isKeyword(x)) {
          return true;
        } else {
          return false;
        }
    }
  }
}

function isRecordDeclStart(x) {
  if (typeof x !== "number") {
    if (x.TAG === /* Lident */4) {
      return true;
    } else {
      return false;
    }
  }
  switch (x) {
    case /* Mutable */62 :
    case /* At */75 :
        return true;
    default:
      return false;
  }
}

function isTypExprStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Underscore */12 :
      case /* SingleQuote */13 :
      case /* Lparen */18 :
      case /* Lbracket */20 :
      case /* Lbrace */22 :
      case /* Module */65 :
      case /* At */75 :
      case /* Percent */77 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isTypeParameterStart(x) {
  if (typeof x === "number") {
    if (x !== 4 && x !== 48 && !isTypExprStart(x)) {
      return false;
    } else {
      return true;
    }
  } else if (isTypExprStart(x)) {
    return true;
  } else {
    return false;
  }
}

function isTypeParamStart(x) {
  if (typeof x === "number") {
    if (x > 34 || x < 12) {
      return x === 36;
    } else {
      return x > 33 || x < 14;
    }
  } else {
    return false;
  }
}

function isFunctorArgStart(x) {
  if (typeof x !== "number") {
    if (x.TAG === /* Uident */5) {
      return true;
    } else {
      return false;
    }
  }
  switch (x) {
    case /* Underscore */12 :
    case /* Lparen */18 :
    case /* Lbrace */22 :
    case /* At */75 :
    case /* Percent */77 :
        return true;
    default:
      return false;
  }
}

function isModExprStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Lparen */18 :
      case /* Lbrace */22 :
      case /* At */75 :
      case /* Percent */77 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Lident */4 :
          if (x._0 === "unpack") {
            return true;
          } else {
            return false;
          }
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isRecordRowStart(x) {
  if (typeof x === "number") {
    if (x === /* DotDotDot */6 || Res_token.isKeyword(x)) {
      return true;
    } else {
      return false;
    }
  }
  switch (x.TAG | 0) {
    case /* Lident */4 :
    case /* Uident */5 :
        return true;
    default:
      if (Res_token.isKeyword(x)) {
        return true;
      } else {
        return false;
      }
  }
}

function isRecordRowStringKeyStart(x) {
  if (typeof x === "number" || x.TAG !== /* String */3) {
    return false;
  } else {
    return true;
  }
}

function isArgumentStart(x) {
  if (typeof x === "number") {
    if (x > 12 || x < 4) {
      if (x === 48) {
        return true;
      }
      
    } else if (x > 11 || x < 5) {
      return true;
    }
    
  }
  if (isExprStart(x)) {
    return true;
  } else {
    return false;
  }
}

function isPatternMatchStart(x) {
  if (x === 17 || isPatternStart(x)) {
    return true;
  } else {
    return false;
  }
}

function isPatternOcamlListStart(x) {
  if (x === 6 || isPatternStart(x)) {
    return true;
  } else {
    return false;
  }
}

function isPatternRecordItemStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* DotDotDot */6 :
      case /* Underscore */12 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isAttributeStart(x) {
  return x === 75;
}

function isJsFfiImportStart(x) {
  if (typeof x === "number") {
    if (x === /* At */75) {
      return true;
    } else {
      return false;
    }
  } else if (x.TAG === /* Lident */4) {
    return true;
  } else {
    return false;
  }
}

function isBlockExprStart(x) {
  if (typeof x === "number") {
    switch (x) {
      case /* Open */0 :
      case /* True */1 :
      case /* False */2 :
      case /* Bang */7 :
      case /* Let */9 :
      case /* Underscore */12 :
      case /* Lparen */18 :
      case /* Lbracket */20 :
      case /* Lbrace */22 :
      case /* Exception */27 :
      case /* Forwardslash */29 :
      case /* Minus */34 :
      case /* MinusDot */35 :
      case /* Plus */36 :
      case /* PlusDot */37 :
      case /* LessThan */42 :
      case /* Hash */44 :
      case /* Assert */46 :
      case /* Lazy */47 :
      case /* If */50 :
      case /* For */52 :
      case /* While */54 :
      case /* Switch */55 :
      case /* Module */65 :
      case /* At */75 :
      case /* Percent */77 :
      case /* List */79 :
      case /* Backtick */80 :
      case /* Try */82 :
          return true;
      default:
        return false;
    }
  } else {
    switch (x.TAG | 0) {
      case /* Codepoint */0 :
      case /* Int */1 :
      case /* Float */2 :
      case /* String */3 :
      case /* Lident */4 :
      case /* Uident */5 :
          return true;
      default:
        return false;
    }
  }
}

function isListElement(grammar, token) {
  if (typeof grammar !== "number") {
    return false;
  }
  switch (grammar) {
    case /* JsxAttribute */5 :
        return isJsxAttributeStart(token);
    case /* PatternMatching */22 :
        return isPatternMatchStart(token);
    case /* PatternList */25 :
        if (token === /* DotDotDot */6) {
          return true;
        } else {
          return isPatternStart(token);
        }
    case /* PatternOcamlList */26 :
        return isPatternOcamlListStart(token);
    case /* PatternRecord */27 :
        return isPatternRecordItemStart(token);
    case /* TypeParams */30 :
        return isTypeParamStart(token);
    case /* PackageConstraint */32 :
        return token === /* And */10;
    case /* RecordDecl */34 :
        return isRecordDeclStart(token);
    case /* ConstructorDeclaration */35 :
        return token === /* Bar */17;
    case /* ParameterList */36 :
        return isParameterStart(token);
    case /* StringFieldDeclarations */37 :
        return isStringFieldDeclStart(token);
    case /* FieldDeclarations */38 :
        return isFieldDeclStart(token);
    case /* TypExprList */39 :
        if (isTypExprStart(token)) {
          return true;
        } else {
          return token === /* LessThan */42;
        }
    case /* FunctorArgs */40 :
        return isFunctorArgStart(token);
    case /* ModExprList */41 :
        return isModExprStart(token);
    case /* TypeParameters */42 :
        return isTypeParameterStart(token);
    case /* RecordRows */43 :
        return isRecordRowStart(token);
    case /* RecordRowsStringKey */44 :
        return isRecordRowStringKeyStart(token);
    case /* ArgumentList */45 :
        return isArgumentStart(token);
    case /* Signature */46 :
    case /* Specification */47 :
        return isSignatureItemStart(token);
    case /* Structure */48 :
    case /* Implementation */49 :
        return isStructureItemStart(token);
    case /* Attribute */50 :
        return token === 75;
    case /* TypeConstraint */51 :
        return token === /* Constraint */63;
    case /* ExprList */12 :
    case /* ListExpr */53 :
        if (token === /* DotDotDot */6) {
          return true;
        } else {
          return isExprStart(token);
        }
    case /* JsFfiImport */54 :
        return isJsFfiImportStart(token);
    case /* OpenDescription */0 :
    case /* ModuleLongIdent */1 :
    case /* Ternary */2 :
    case /* Es6ArrowExpr */3 :
    case /* Jsx */4 :
    case /* JsxChild */6 :
    case /* ExprOperand */7 :
    case /* ExprUnary */8 :
    case /* ExprSetField */9 :
    case /* ExprBlock */10 :
    case /* ExprCall */11 :
    case /* ExprArrayAccess */13 :
    case /* ExprArrayMutation */14 :
    case /* ExprIf */15 :
    case /* ExprFor */16 :
    case /* IfCondition */17 :
    case /* IfBranch */18 :
    case /* ElseBranch */19 :
    case /* TypeExpression */20 :
    case /* External */21 :
    case /* PatternMatchCase */23 :
    case /* LetBinding */24 :
    case /* TypeDef */28 :
    case /* TypeConstrName */29 :
    case /* TypeParam */31 :
    case /* TypeRepresentation */33 :
    case /* AtomicTypExpr */52 :
    case /* Pattern */55 :
        return false;
    case /* AttributePayload */56 :
        return token === /* Lparen */18;
    case /* TagNames */57 :
        return token === /* Hash */44;
    
  }
}

function isListTerminator(grammar, token) {
  var exit = 0;
  if (typeof grammar === "number") {
    var exit$1 = 0;
    switch (grammar) {
      case /* JsxAttribute */5 :
          if (typeof token === "number") {
            if (token === 29) {
              return true;
            }
            if (token === 41) {
              return true;
            }
            exit = 2;
          } else {
            exit = 2;
          }
          break;
      case /* ExprList */12 :
          if (typeof token === "number") {
            switch (token) {
              case /* Lbracket */20 :
              case /* Lbrace */22 :
              case /* Rbrace */23 :
              case /* Colon */24 :
              case /* Comma */25 :
              case /* Eof */26 :
              case /* Exception */27 :
              case /* Backslash */28 :
                  exit = 2;
                  break;
              case /* Rparen */19 :
              case /* Rbracket */21 :
              case /* Forwardslash */29 :
                  return true;
              default:
                exit = 2;
            }
          } else {
            exit = 2;
          }
          break;
      case /* ParameterList */36 :
          if (typeof token === "number") {
            if (token === 22) {
              return true;
            }
            if (token === 57) {
              return true;
            }
            exit = 2;
          } else {
            exit = 2;
          }
          break;
      case /* TypExprList */39 :
          if (typeof token === "number") {
            if (token >= 20) {
              if (token === 29) {
                return true;
              }
              if (token === 41) {
                return true;
              }
              exit = 2;
            } else {
              if (token === 14) {
                return true;
              }
              if (token >= 19) {
                return true;
              }
              exit = 2;
            }
          } else {
            exit = 2;
          }
          break;
      case /* TypeParams */30 :
      case /* ModExprList */41 :
      case /* ArgumentList */45 :
      case /* ListExpr */53 :
          exit$1 = 4;
          break;
      case /* ExprBlock */10 :
      case /* StringFieldDeclarations */37 :
      case /* JsFfiImport */54 :
          exit$1 = 3;
          break;
      case /* OpenDescription */0 :
      case /* ModuleLongIdent */1 :
      case /* Ternary */2 :
      case /* Es6ArrowExpr */3 :
      case /* Jsx */4 :
      case /* JsxChild */6 :
      case /* ExprOperand */7 :
      case /* ExprUnary */8 :
      case /* ExprSetField */9 :
      case /* ExprCall */11 :
      case /* ExprArrayAccess */13 :
      case /* ExprArrayMutation */14 :
      case /* ExprIf */15 :
      case /* ExprFor */16 :
      case /* IfCondition */17 :
      case /* IfBranch */18 :
      case /* ElseBranch */19 :
      case /* TypeExpression */20 :
      case /* External */21 :
      case /* PatternMatching */22 :
      case /* PatternMatchCase */23 :
      case /* LetBinding */24 :
      case /* PatternList */25 :
      case /* PatternOcamlList */26 :
      case /* PatternRecord */27 :
      case /* TypeDef */28 :
      case /* TypeConstrName */29 :
      case /* TypeParam */31 :
      case /* PackageConstraint */32 :
      case /* TypeRepresentation */33 :
      case /* RecordDecl */34 :
      case /* ConstructorDeclaration */35 :
      case /* FieldDeclarations */38 :
      case /* FunctorArgs */40 :
      case /* TypeParameters */42 :
      case /* RecordRows */43 :
      case /* RecordRowsStringKey */44 :
      case /* Signature */46 :
      case /* Specification */47 :
      case /* Structure */48 :
      case /* Implementation */49 :
      case /* Attribute */50 :
      case /* TypeConstraint */51 :
      case /* AtomicTypExpr */52 :
      case /* Pattern */55 :
          exit = 2;
          break;
      case /* AttributePayload */56 :
          if (token === 19) {
            return true;
          }
          exit = 2;
          break;
      case /* TagNames */57 :
          if (token === 21) {
            return true;
          }
          exit = 2;
          break;
      
    }
    switch (exit$1) {
      case 3 :
          if (token === 23) {
            return true;
          }
          exit = 2;
          break;
      case 4 :
          if (token === 19) {
            return true;
          }
          exit = 2;
          break;
      
    }
  } else {
    exit = 2;
  }
  if (exit === 2) {
    if (token === 26) {
      return true;
    }
    if (typeof grammar !== "number") {
      return false;
    }
    if (grammar < 25) {
      return false;
    }
    switch (grammar) {
      case /* PatternList */25 :
      case /* PatternOcamlList */26 :
      case /* PatternRecord */27 :
          break;
      case /* PackageConstraint */32 :
          return token !== /* And */10;
      case /* ConstructorDeclaration */35 :
          return token !== /* Bar */17;
      case /* Signature */46 :
      case /* Structure */48 :
          return token === 23;
      case /* Attribute */50 :
          return token !== /* At */75;
      case /* TypeConstraint */51 :
          return token !== /* Constraint */63;
      case /* TypeDef */28 :
      case /* TypeConstrName */29 :
      case /* TypeParams */30 :
      case /* TypeParam */31 :
      case /* TypeRepresentation */33 :
      case /* RecordDecl */34 :
      case /* ParameterList */36 :
      case /* StringFieldDeclarations */37 :
      case /* FieldDeclarations */38 :
      case /* TypExprList */39 :
      case /* FunctorArgs */40 :
      case /* ModExprList */41 :
      case /* TypeParameters */42 :
      case /* RecordRows */43 :
      case /* RecordRowsStringKey */44 :
      case /* ArgumentList */45 :
      case /* Specification */47 :
      case /* Implementation */49 :
      case /* AtomicTypExpr */52 :
      case /* ListExpr */53 :
      case /* JsFfiImport */54 :
      case /* Pattern */55 :
      case /* AttributePayload */56 :
      case /* TagNames */57 :
          return false;
      
    }
  }
  if (typeof token !== "number") {
    return false;
  }
  if (token >= 30) {
    if (token !== 53) {
      return token === 57;
    } else {
      return true;
    }
  }
  if (token === 14) {
    return true;
  }
  if (token < 19) {
    return false;
  }
  switch (token) {
    case /* Lbracket */20 :
    case /* Lbrace */22 :
    case /* Rbrace */23 :
    case /* Colon */24 :
    case /* Comma */25 :
    case /* Eof */26 :
    case /* Exception */27 :
    case /* Backslash */28 :
        return false;
    case /* Rparen */19 :
    case /* Rbracket */21 :
    case /* Forwardslash */29 :
        return true;
    
  }
}

function isPartOfList(grammar, token) {
  if (isListElement(grammar, token)) {
    return true;
  } else {
    return isListTerminator(grammar, token);
  }
}

var Token;

var isJsxChildStart = isAtomicExprStart;

export {
  Token ,
  toString ,
  isSignatureItemStart ,
  isAtomicPatternStart ,
  isAtomicExprStart ,
  isAtomicTypExprStart ,
  isExprStart ,
  isJsxAttributeStart ,
  isStructureItemStart ,
  isPatternStart ,
  isParameterStart ,
  isStringFieldDeclStart ,
  isFieldDeclStart ,
  isRecordDeclStart ,
  isTypExprStart ,
  isTypeParameterStart ,
  isTypeParamStart ,
  isFunctorArgStart ,
  isModExprStart ,
  isRecordRowStart ,
  isRecordRowStringKeyStart ,
  isArgumentStart ,
  isPatternMatchStart ,
  isPatternOcamlListStart ,
  isPatternRecordItemStart ,
  isAttributeStart ,
  isJsFfiImportStart ,
  isJsxChildStart ,
  isBlockExprStart ,
  isListElement ,
  isListTerminator ,
  isPartOfList ,
  
}
/* Res_token Not a pure module */
