// Generated by ReScript, PLEASE EDIT WITH CARE

import * as Curry from "rescript/lib/es6/curry.js";
import * as Format from "./format.js";
import * as Lexing from "rescript/lib/es6/lexing.js";
import * as $$String from "rescript/lib/es6/string.js";

function styleToString(s) {
  if (s) {
    return "MultiLine";
  } else {
    return "SingleLine";
  }
}

function loc(t) {
  return t.loc;
}

function txt(t) {
  return t.txt;
}

function prevTokEndPos(t) {
  return t.prevTokEndPos;
}

function setPrevTokEndPos(t, pos) {
  t.prevTokEndPos = pos;
  
}

function isSingleLineComment(t) {
  var match = t.style;
  if (match) {
    return false;
  } else {
    return true;
  }
}

function toString(t) {
  return Curry._4(Format.sprintf("(txt: %s\nstyle: %s\nlines: %d-%d)"), t.txt, t.style ? "MultiLine" : "SingleLine", t.loc.loc_start.pos_lnum, t.loc.loc_end.pos_lnum);
}

function makeSingleLineComment(loc, txt) {
  return {
          txt: txt,
          style: /* SingleLine */0,
          loc: loc,
          prevTokEndPos: Lexing.dummy_pos
        };
}

function makeMultiLineComment(loc, txt) {
  return {
          txt: txt,
          style: /* MultiLine */1,
          loc: loc,
          prevTokEndPos: Lexing.dummy_pos
        };
}

function fromOcamlComment(loc, txt, prevTokEndPos) {
  return {
          txt: txt,
          style: /* MultiLine */1,
          loc: loc,
          prevTokEndPos: prevTokEndPos
        };
}

function trimSpaces(s) {
  var len = s.length;
  if (len === 0) {
    return s;
  }
  if (!(s[0] === " " || s[len - 1 | 0] === " ")) {
    return s;
  }
  var i = 0;
  while(i < len && s[i] === " ") {
    i = i + 1 | 0;
  };
  var j = len - 1 | 0;
  while(j >= i && s[j] === " ") {
    j = j - 1 | 0;
  };
  if (j >= i) {
    return $$String.sub(s, i, (j - i | 0) + 1 | 0);
  } else {
    return "";
  }
}

export {
  styleToString ,
  loc ,
  txt ,
  prevTokEndPos ,
  setPrevTokEndPos ,
  isSingleLineComment ,
  toString ,
  makeSingleLineComment ,
  makeMultiLineComment ,
  fromOcamlComment ,
  trimSpaces ,
  
}
/* Format Not a pure module */
