// Generated by ReScript, PLEASE EDIT WITH CARE

import * as List from "rescript/lib/es6/list.js";
import * as Misc from "./misc.js";
import * as $$String from "rescript/lib/es6/string.js";
import * as Caml_js_exceptions from "rescript/lib/es6/caml_js_exceptions.js";

function flat(_accu, _x) {
  while(true) {
    var x = _x;
    var accu = _accu;
    switch (x.TAG | 0) {
      case /* Lident */0 :
          return {
                  hd: x._0,
                  tl: accu
                };
      case /* Ldot */1 :
          _x = x._0;
          _accu = {
            hd: x._1,
            tl: accu
          };
          continue ;
      case /* Lapply */2 :
          return Misc.fatal_error("Longident.flat");
      
    }
  };
}

function flatten(lid) {
  return flat(/* [] */0, lid);
}

function last(x) {
  switch (x.TAG | 0) {
    case /* Lident */0 :
        return x._0;
    case /* Ldot */1 :
        return x._1;
    case /* Lapply */2 :
        return Misc.fatal_error("Longident.last");
    
  }
}

function split_at_dots(s, pos) {
  try {
    var dot = $$String.index_from(s, pos, /* '.' */46);
    return {
            hd: $$String.sub(s, pos, dot - pos | 0),
            tl: split_at_dots(s, dot + 1 | 0)
          };
  }
  catch (raw_exn){
    var exn = Caml_js_exceptions.internalToOCamlException(raw_exn);
    if (exn.RE_EXN_ID === "Not_found") {
      return {
              hd: $$String.sub(s, pos, s.length - pos | 0),
              tl: /* [] */0
            };
    }
    throw exn;
  }
}

function unflatten(l) {
  if (l) {
    return List.fold_left((function (p, s) {
                  return {
                          TAG: /* Ldot */1,
                          _0: p,
                          _1: s
                        };
                }), {
                TAG: /* Lident */0,
                _0: l.hd
              }, l.tl);
  }
  
}

function parse(s) {
  var v = unflatten(split_at_dots(s, 0));
  if (v !== undefined) {
    return v;
  } else {
    return {
            TAG: /* Lident */0,
            _0: ""
          };
  }
}

export {
  flat ,
  flatten ,
  last ,
  split_at_dots ,
  unflatten ,
  parse ,
  
}
/* Misc Not a pure module */
