// Generated by ReScript, PLEASE EDIT WITH CARE

import * as Sys from "rescript/lib/es6/sys.js";
import * as Curry from "rescript/lib/es6/curry.js";
import * as Printf from "./printf.js";
import * as $$String from "rescript/lib/es6/string.js";
import * as Caml_sys from "rescript/lib/es6/caml_sys.js";
import * as Caml_string from "rescript/lib/es6/caml_string.js";
import * as Caml_js_exceptions from "rescript/lib/es6/caml_js_exceptions.js";

var standard_library_default = "/usr/local/lib/ocaml";

var standard_library;

try {
  standard_library = Caml_sys.caml_sys_getenv("OCAMLLIB");
}
catch (raw_exn){
  var exn = Caml_js_exceptions.internalToOCamlException(raw_exn);
  if (exn.RE_EXN_ID === "Not_found") {
    try {
      standard_library = Caml_sys.caml_sys_getenv("CAMLLIB");
    }
    catch (raw_exn$1){
      var exn$1 = Caml_js_exceptions.internalToOCamlException(raw_exn$1);
      if (exn$1.RE_EXN_ID === "Not_found") {
        standard_library = standard_library_default;
      } else {
        throw exn$1;
      }
    }
  } else {
    throw exn;
  }
}

var standard_runtime = "/usr/local/bin/ocamlrun";

var ccomp_type = "cc";

var c_compiler = "gcc";

var ocamlc_cflags = "-O2 -fno-strict-aliasing -fwrapv ";

var ocamlc_cppflags = "-D_FILE_OFFSET_BITS=64 -D_REENTRANT";

var ocamlopt_cflags = "-O2 -fno-strict-aliasing -fwrapv";

var ocamlopt_cppflags = "-D_FILE_OFFSET_BITS=64 -D_REENTRANT";

var bytecomp_c_libraries = "-lpthread                  ";

var bytecomp_c_compiler = "gcc -O2 -fno-strict-aliasing -fwrapv  -D_FILE_OFFSET_BITS=64 -D_REENTRANT";

var native_c_compiler = "gcc -O2 -fno-strict-aliasing -fwrapv -D_FILE_OFFSET_BITS=64 -D_REENTRANT";

var native_c_libraries = "";

var native_pack_linker = "ld -r -arch x86_64 -o ";

var ranlib = "ranlib";

var cc_profile = "-pg";

var match;

if (Sys.os_type === "Win32") {
  try {
    var flexlink = Caml_sys.caml_sys_getenv("OCAML_FLEXLINK");
    var f = function (i) {
      var c = Caml_string.get(flexlink, i);
      if (c === /* '/' */47) {
        return /* '\\' */92;
      } else {
        return c;
      }
    };
    var flexlink$1 = $$String.init(flexlink.length, f) + " ";
    match = [
      flexlink$1,
      flexlink$1 + " -exe",
      flexlink$1 + " -maindll"
    ];
  }
  catch (raw_exn$2){
    var exn$2 = Caml_js_exceptions.internalToOCamlException(raw_exn$2);
    if (exn$2.RE_EXN_ID === "Not_found") {
      match = [
        "gcc -shared -flat_namespace -undefined suppress                    -Wl,-no_compact_unwind",
        "gcc -O2 -fno-strict-aliasing -fwrapv -Wall -Werror -D_FILE_OFFSET_BITS=64 -D_REENTRANT -DCAML_NAME_SPACE   -Wl,-no_compact_unwind",
        "gcc -shared -flat_namespace -undefined suppress                    -Wl,-no_compact_unwind"
      ];
    } else {
      throw exn$2;
    }
  }
} else {
  match = [
    "gcc -shared -flat_namespace -undefined suppress                    -Wl,-no_compact_unwind",
    "gcc -O2 -fno-strict-aliasing -fwrapv -Wall -Werror -D_FILE_OFFSET_BITS=64 -D_REENTRANT -DCAML_NAME_SPACE   -Wl,-no_compact_unwind",
    "gcc -shared -flat_namespace -undefined suppress                    -Wl,-no_compact_unwind"
  ];
}

var exec_magic_number = "Caml1999X011";

var cmi_magic_number = "Caml1999I022";

var cmo_magic_number = "Caml1999O022";

var cma_magic_number = "Caml1999A022";

var cmx_magic_number = "Caml1999Y022";

var cmxa_magic_number = "Caml1999Z022";

var ast_impl_magic_number = "Caml1999M022";

var ast_intf_magic_number = "Caml1999N022";

var cmxs_magic_number = "Caml1999D022";

var cmt_magic_number = "Caml1999T022";

var load_path = {
  contents: /* [] */0
};

var interface_suffix = {
  contents: ".mli"
};

var architecture = "amd64";

var model = "default";

var system = "macosx";

var asm = "clang -arch x86_64 -Wno-trigraphs -c";

var ext_exe = "";

var ext_obj = ".o";

var ext_asm = ".s";

var ext_lib = ".a";

var ext_dll = ".so";

var host = "x86_64-apple-darwin21.4.0";

var target = "x86_64-apple-darwin21.4.0";

var default_executable_name;

switch (Sys.os_type) {
  case "Unix" :
      default_executable_name = "a.out";
      break;
  case "Cygwin" :
  case "Win32" :
      default_executable_name = "camlprog.exe";
      break;
  default:
    default_executable_name = "camlprog";
}

function print_config(oc) {
  var p = function (name, valu) {
    return Curry._3(Printf.fprintf(oc), "%s: %s\n", name, valu);
  };
  var p_int = function (name, valu) {
    return Curry._3(Printf.fprintf(oc), "%s: %d\n", name, valu);
  };
  var p_bool = function (name, valu) {
    return Curry._3(Printf.fprintf(oc), "%s: %B\n", name, valu);
  };
  p("version", Sys.ocaml_version);
  p("standard_library_default", standard_library_default);
  p("standard_library", standard_library);
  p("standard_runtime", standard_runtime);
  p("ccomp_type", ccomp_type);
  p("c_compiler", c_compiler);
  p("ocamlc_cflags", ocamlc_cflags);
  p("ocamlc_cppflags", ocamlc_cppflags);
  p("ocamlopt_cflags", ocamlopt_cflags);
  p("ocamlopt_cppflags", ocamlopt_cppflags);
  p("bytecomp_c_compiler", bytecomp_c_compiler);
  p("native_c_compiler", native_c_compiler);
  p("bytecomp_c_libraries", bytecomp_c_libraries);
  p("native_c_libraries", native_c_libraries);
  p("native_pack_linker", native_pack_linker);
  p("ranlib", ranlib);
  p("cc_profile", cc_profile);
  p("architecture", architecture);
  p("model", model);
  p_int("int_size", Sys.int_size);
  p_int("word_size", Sys.word_size);
  p("system", system);
  p("asm", asm);
  p_bool("asm_cfi_supported", true);
  p_bool("with_frame_pointers", false);
  p("ext_exe", ext_exe);
  p("ext_obj", ext_obj);
  p("ext_asm", ext_asm);
  p("ext_lib", ext_lib);
  p("ext_dll", ext_dll);
  p("os_type", Sys.os_type);
  p("default_executable_name", default_executable_name);
  p_bool("systhread_supported", true);
  p("host", host);
  p("target", target);
  p_bool("profiling", true);
  p_bool("flambda", false);
  p_bool("spacetime", false);
  p_bool("safe_string", false);
  p_bool("default_safe_string", true);
  p_bool("flat_float_array", true);
  p_bool("afl_instrument", false);
  p_bool("windows_unicode", false);
  p("exec_magic_number", exec_magic_number);
  p("cmi_magic_number", cmi_magic_number);
  p("cmo_magic_number", cmo_magic_number);
  p("cma_magic_number", cma_magic_number);
  p("cmx_magic_number", cmx_magic_number);
  p("cmxa_magic_number", cmxa_magic_number);
  p("ast_impl_magic_number", ast_impl_magic_number);
  p("ast_intf_magic_number", ast_intf_magic_number);
  p("cmxs_magic_number", cmxs_magic_number);
  return p("cmt_magic_number", cmt_magic_number);
}

var version = Sys.ocaml_version;

var c_output_obj = "-o ";

var ar = "ar";

var mkdll = match[0];

var mkexe = match[1];

var mkmaindll = match[2];

var profiling = true;

var flambda = false;

var safe_string = false;

var default_safe_string = true;

var windows_unicode = false;

var flat_float_array = true;

var afl_instrument = false;

var max_tag = 245;

var lazy_tag = 246;

var max_young_wosize = 256;

var stack_threshold = 256;

var stack_safety_margin = 60;

var asm_cfi_supported = true;

var with_frame_pointers = false;

var spacetime = false;

var enable_call_counts = true;

var libunwind_available = false;

var libunwind_link_flags = "";

var profinfo = false;

var profinfo_width = 0;

var systhread_supported = true;

var flexdll_dirs = /* [] */0;

export {
  version ,
  standard_library_default ,
  standard_library ,
  standard_runtime ,
  ccomp_type ,
  c_compiler ,
  c_output_obj ,
  ocamlc_cflags ,
  ocamlc_cppflags ,
  ocamlopt_cflags ,
  ocamlopt_cppflags ,
  bytecomp_c_libraries ,
  bytecomp_c_compiler ,
  native_c_compiler ,
  native_c_libraries ,
  native_pack_linker ,
  ranlib ,
  ar ,
  cc_profile ,
  mkdll ,
  mkexe ,
  mkmaindll ,
  profiling ,
  flambda ,
  safe_string ,
  default_safe_string ,
  windows_unicode ,
  flat_float_array ,
  afl_instrument ,
  exec_magic_number ,
  cmi_magic_number ,
  cmo_magic_number ,
  cma_magic_number ,
  cmx_magic_number ,
  cmxa_magic_number ,
  ast_impl_magic_number ,
  ast_intf_magic_number ,
  cmxs_magic_number ,
  cmt_magic_number ,
  load_path ,
  interface_suffix ,
  max_tag ,
  lazy_tag ,
  max_young_wosize ,
  stack_threshold ,
  stack_safety_margin ,
  architecture ,
  model ,
  system ,
  asm ,
  asm_cfi_supported ,
  with_frame_pointers ,
  spacetime ,
  enable_call_counts ,
  libunwind_available ,
  libunwind_link_flags ,
  profinfo ,
  profinfo_width ,
  ext_exe ,
  ext_obj ,
  ext_asm ,
  ext_lib ,
  ext_dll ,
  host ,
  target ,
  default_executable_name ,
  systhread_supported ,
  flexdll_dirs ,
  print_config ,
  
}
/* standard_library Not a pure module */
