-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.1.7
-- Date : 2020-10-10 11:12:01
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1602297831', '127.0.0.1', '172', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';

-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', 'ABOUT US', '', '0', '/storage/images/20201010/about.jpg', '1', '1', '1', '1001', 'single', '', '', 'Welcome to use the most professional PHP website content management system - Dreamweaving Content Management System, which wi', '', '<p>\r\n	Welcome to use the most professional PHP website content management system - Dreamweaving Content Management System, which will be your first choice for easy station building. Adopt the core template of XML namespace style: All templates are saved in file form, which provides great convenience for user design template and website upgrade and transfer. Robust template tags provide strong support for webmaster DIY&#39;s own website. Efficient tag caching mechanism: It allows the same tags to be cached. When HTML is generated, it is helpful to improve the response speed of the system and reduce the resources consumed by the system. Model and module concepts coexist: DedeCMS promotes some interactive modules to supplement the system to meet the needs of users as far as possible when the model can not meet all the needs of users. Numerous application support: provide users with an integrated solution to various types of website construction. In this version, add modules such as classification, library, yellow pages, circle, question and answer, to supplement some users&#39;special requirements. Facing the future transition: The formation of dream weaving team provides a solid foundation for the development of dream weaving CMS. In the future vision of dream weaving team, it will have greater flexibility and stable performance in the future.</p><p>\r\n	DedeCMS Applications：</p><p>\r\n	DedeCMS is most suitable for the following areas:</p><p>\r\n	Enterprise websites, whether large-scale or small and medium-sized enterprises, use the network to transmit information, to a certain extent, to improve the efficiency and competitiveness of enterprises;</p><p>\r\n	Government organs, through the establishment of government portals, are conducive to the integration of various information and resources, and to the strengthening of contacts and communication between the government and the public, so that the government can work faster, more convenient and more effectively;</p><p>\r\n	Educational institutions, through the introduction of network information, make information transmission between educational institutions and within educational institutions and among educators, and comprehensively enhance the level of educational websites;</p><p>\r\n	Media organizations, the new media such as the Internet, have strongly impacted the traditional media. In this process of evolution, various media organizations should have a process of re-recognition and re-development of their core and establish a digital technology platform to meet the needs of the digital age.</p><p>\r\n	Industry websites, for different industries, strengthen the internal information division to reflect the characteristics of the industry. The websites contain dynamic information, products, markets, technology, talents and other information of the industry, establish an authoritative image of industry information, and provide practical business opportunities for product supply chain management in the industry.</p><p>\r\n	Individual webmasters, with interest as the leading factor, set up websites with novel themes and rich content. Through information exchange of common interests, you can form your own unique user circle, generate personal needs and serve them.</p><p>\r\n	- Fee-paying websites, content-charging websites, users can provide online product sales, or content fees, simple and clear profit model, to ensure that you get the greatest return with the smallest investment;</p>', '            ', 'true', '1602293064');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', 'NEWS', '', '0', '', '2', '1', '2', '1002', '', '', '', '', '', '  ', '  ', 'true', '1602146000');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', 'SERVICE', '', '0', '', '3', '1', '3', '1003', 'single', '', '', 'Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and ', '', '<p>Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and technology co., LTD. Through the product included in the warranty card to you the following service commitment, and in accordance with the commitment to provide you with the service maintenance services.</p><p>These service commitment is only applicable to October 1, 2016 (including) after sales brand AOC monitor standard.</p><p>If you choose to buy the AOC displays extension function modules or other factory computer mainframe, its commitment to the warranty please refer to the corresponding product warranty card.</p><p>All promised content will be subject to product attached warranty card.</p><p>Three packs of services is as follows:</p><p>&nbsp;</p><p>Within 7 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to return, exchange or repair.</p><p>Within 15 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose a replacement or repair.</p><p>, within 1 year from the date of sold goods appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to repair.</p><p>The following is not within the warranty scope:</p><p>&nbsp;</p><p>More than 3 packets of period of validity.</p><p>No effective 3 packets of prooves and invoice.</p><p>Content on the invoice does not accord with physical commodities logo or altered.</p><p>Not according to product instructions for use, maintenance, maintenance and damage (artificial damage).</p><p>The AOC authorized repairer open damage (repairing) without permission.</p><p>The AOC in mainland China (excluding Hong Kong, Macao and Taiwan) sell the goods.</p><p><br/></p>', '    ', 'true', '1602208444');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', 'CASE', '', '0', '', '4', '1', '4', '1004', 'img', '', '', '', '', '  ', '  ', 'true', '1602146013');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', 'Photo', '', '0', '', '5', '1', '5', '1005', 'img', '', '', '', '', '  ', '  ', 'true', '1602146019');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', 'CONTACT', '', '0', '', '6', '1', '6', '1006', 'single', '', '', 'Company: Dedecms Enterprise website system phpContact: DedecmsTel: 020-88888888Phone: 13899999999E-mail: Service@163.comAddre', '', '<p>\r\n	Company: Dedecms Enterprise website system php</p><p>\r\n	Contact: Dedecms&nbsp;</p><p>\r\n	Tel: 020-88888888</p><p>\r\n	Phone: 13899999999</p><p>\r\n	E-mail: Service@163.com</p><p>\r\n	Address: Guangdong Province, China TianHe District, GuangZhou Num 888</p>', '        ', 'true', '1602293122');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', 'CULTURE', '', '1', '', '1,7', '2', '1', '10011001', 'single', '', '', 'Increasing the use of the function of the dynamic list, so as to adapt to the needs of different usersThe function of refinin', '', '<p>\r\n	Increasing the use of the function of the dynamic list, so as to adapt to the needs of different users</p><p>\r\n	The function of refining the list to create</p><p>\r\n	Increased channel plate template for the default home page, to facilitate the application of a higher level</p><p>\r\n	Increased the article according to the release date for the function of the archive</p><p>\r\n	Increased call Discuz, PHPWIND, VBB, PHPBB BBS plate code of the latest posts</p><p>\r\n	Added optional dynamic homepage</p><p>\r\n	Increased can be obtained directly from the system configuration</p><p>\r\n	Increased the function of mobile</p><p>\r\n	Can increase the loop tag, free access to any table of contents</p><p>\r\n	To strengthen the function of data backup</p>', '        ', 'true', '1602293076');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', 'COURSE', '', '1', '', '1,8', '2', '2', '10011002', 'single', '', '', 'System is composed of multiple material, every matter has one or more attributes, each attribute has the value of the state h', '', '<p>\r\n	System is composed of multiple material, every matter has one or more attributes, each attribute has the value of the state have a plenty of variables,</p><p>\r\n	Some attributes are divided into more child, each child has a state attribute values, popular says, the attribute value is the state of the material; Rules are various attributes how to interact with each other,</p><p>\r\n	Divided into the same properties of interaction and the interaction of different properties, the rules is the process of the incident, with the cause and effect,</p><p>\r\n	Premise condition, the trigger condition, purpose to describe rules, rules of changes in the material (system).</p>', '        ', 'true', '1602293083');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', 'Company new', '', '2', '', '2,9', '2', '1', '10021001', '', '', '', '', '', '  ', '  ', 'true', '1602146046');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', 'Industry news', '', '2', '', '2,10', '2', '2', '10021002', '', '', '', '', '', '  ', '  ', 'true', '1602146052');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', 'Technological innovation', '', '2', '', '2,11', '2', '3', '10021003', '', '', '', '', '', '  ', '  ', 'true', '1602146061');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', 'service a', '', '3', '', '3,12', '2', '1', '10031001', 'single', '', '', 'Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and ', '', '<p>\r\n	Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and technology co., LTD. Through the product included in the warranty card to you the following service commitment, and in accordance with the commitment to provide you with the service maintenance services.</p><p>\r\n	These service commitment is only applicable to October 1, 2016 (including) after sales brand AOC monitor standard.</p><p>\r\n	If you choose to buy the AOC displays extension function modules or other factory computer mainframe, its commitment to the warranty please refer to the corresponding product warranty card.</p><p>\r\n	All promised content will be subject to product attached warranty card.</p><p>\r\n	Three packs of services is as follows:</p><p>\r\n	&nbsp;</p><p>\r\n	Within 7 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to return, exchange or repair.</p><p>\r\n	Within 15 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose a replacement or repair.</p><p>\r\n	, within 1 year from the date of sold goods appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to repair.</p><p>\r\n	The following is not within the warranty scope:</p><p>\r\n	&nbsp;</p><p>\r\n	More than 3 packets of period of validity.</p><p>\r\n	No effective 3 packets of prooves and invoice.</p><p>\r\n	Content on the invoice does not accord with physical commodities logo or altered.</p><p>\r\n	Not according to product instructions for use, maintenance, maintenance and damage (artificial damage).</p><p>\r\n	The AOC authorized repairer open damage (repairing) without permission.</p><p>\r\n	The AOC in mainland China (excluding Hong Kong, Macao and Taiwan) sell the goods.</p>', '      ', 'true', '1602293099');
INSERT INTO `rrz_article_nodes` VALUES ('13', '0', 'service b', '', '3', '', '3,13', '2', '2', '10031002', 'single', '', '', 'Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and ', '', '<p>\r\n	Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and technology co., LTD. Through the product included in the warranty card to you the following service commitment, and in accordance with the commitment to provide you with the service maintenance services.</p><p>\r\n	These service commitment is only applicable to October 1, 2016 (including) after sales brand AOC monitor standard.</p><p>\r\n	If you choose to buy the AOC displays extension function modules or other factory computer mainframe, its commitment to the warranty please refer to the corresponding product warranty card.</p><p>\r\n	All promised content will be subject to product attached warranty card.</p><p>\r\n	Three packs of services is as follows:</p><p>\r\n	&nbsp;</p><p>\r\n	Within 7 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to return, exchange or repair.</p><p>\r\n	Within 15 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose a replacement or repair.</p><p>\r\n	, within 1 year from the date of sold goods appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to repair.</p><p>\r\n	The following is not within the warranty scope:</p><p>\r\n	&nbsp;</p><p>\r\n	More than 3 packets of period of validity.</p><p>\r\n	No effective 3 packets of prooves and invoice.</p><p>\r\n	Content on the invoice does not accord with physical commodities logo or altered.</p><p>\r\n	Not according to product instructions for use, maintenance, maintenance and damage (artificial damage).</p><p>\r\n	The AOC authorized repairer open damage (repairing) without permission.</p><p>\r\n	The AOC in mainland China (excluding Hong Kong, Macao and Taiwan) sell the goods.</p>', '      ', 'true', '1602293106');
INSERT INTO `rrz_article_nodes` VALUES ('14', '0', 'service c', '', '3', '', '3,14', '2', '3', '10031003', 'single', '', '', 'Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and ', '', '<p>\r\n	Thank you buy AOC product, we would like to thank you! In order to let you better use this product, Edmund wuhan science and technology co., LTD. Through the product included in the warranty card to you the following service commitment, and in accordance with the commitment to provide you with the service maintenance services.</p><p>\r\n	These service commitment is only applicable to October 1, 2016 (including) after sales brand AOC monitor standard.</p><p>\r\n	If you choose to buy the AOC displays extension function modules or other factory computer mainframe, its commitment to the warranty please refer to the corresponding product warranty card.</p><p>\r\n	All promised content will be subject to product attached warranty card.</p><p>\r\n	Three packs of services is as follows:</p><p>\r\n	&nbsp;</p><p>\r\n	Within 7 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to return, exchange or repair.</p><p>\r\n	Within 15 days from the date of sold goods, appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose a replacement or repair.</p><p>\r\n	, within 1 year from the date of sold goods appear in the table of the microcomputer commodity performance failures listed failure, consumers can choose to repair.</p><p>\r\n	The following is not within the warranty scope:</p><p>\r\n	&nbsp;</p><p>\r\n	More than 3 packets of period of validity.</p><p>\r\n	No effective 3 packets of prooves and invoice.</p><p>\r\n	Content on the invoice does not accord with physical commodities logo or altered.</p><p>\r\n	Not according to product instructions for use, maintenance, maintenance and damage (artificial damage).</p><p>\r\n	The AOC authorized repairer open damage (repairing) without permission.</p><p>\r\n	The AOC in mainland China (excluding Hong Kong, Macao and Taiwan) sell the goods.</p>', '      ', 'true', '1602293112');
INSERT INTO `rrz_article_nodes` VALUES ('15', '0', 'Customer case', '', '4', '', '4,15', '2', '1', '10041001', 'img', '', '', '', '', '  ', '  ', 'true', '1602146088');
INSERT INTO `rrz_article_nodes` VALUES ('16', '0', 'Classic case', '', '4', '', '4,16', '2', '2', '10041002', 'img', '', '', '', '', '  ', '  ', 'true', '1602146094');
INSERT INTO `rrz_article_nodes` VALUES ('17', '0', 'Photo A', '', '5', '', '5,17', '2', '1', '10051001', 'img', '', '', '', '', '  ', '  ', 'true', '1602146100');
INSERT INTO `rrz_article_nodes` VALUES ('18', '0', 'Photo B', '', '5', '', '5,18', '2', '2', '10051002', 'img', '', '', '', '', '  ', '  ', 'true', '1602146106');
INSERT INTO `rrz_article_nodes` VALUES ('19', '0', 'Photo C', '', '5', '', '5,19', '2', '3', '10051003', 'img', '', '', '', '', '  ', '  ', 'true', '1602146111');
INSERT INTO `rrz_article_nodes` VALUES ('20', '0', 'Photo D', '', '5', '', '5,20', '2', '4', '10051004', 'img', '', '', '', '', '  ', '  ', 'true', '1602146116');
INSERT INTO `rrz_article_nodes` VALUES ('21', '0', 'FEEDBACK', '', '6', '', '6,21', '2', '1', '10061001', 'liuyan', '', '', '  ', '', '    ', '    ', 'true', '1602212575');
INSERT INTO `rrz_article_nodes` VALUES ('22', '0', 'ADDRESS', '', '6', '', '6,22', '2', '2', '10061002', 'single', '', '', 'Company: Dedecms Enterprise website system phpContact: DedecmsTel: 020-88888888Phone: 13899999999E-mail: Service@163.comAddre', '', '<p>\r\n	Company: Dedecms Enterprise website system php</p><p>\r\n	Contact: Dedecms&nbsp;</p><p>\r\n	Tel: 020-88888888</p><p>\r\n	Phone: 13899999999</p><p>\r\n	E-mail: Service@163.com</p><p>\r\n	Address: Guangdong Province, China TianHe District, GuangZhou Num 888</p>', '        ', 'true', '1602293133');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '9', 'Nokia says shipping new Lumia smartphones this week', '', '', '<div>\r\n	HELSINKI (Reuters) - Finnish phone maker Nokia said its new Lumia smartphones, key to the company&#39;s hopes for recovery, will begin to appear in some European markets this week.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Nokia late on Monday said its high-end Lumia 820 and 920 phones, which will run on Microsoft&#39;s Windows Phone 8 software, will this week reach first operators and retail outlets in France and Britain and later in Russia and Germany as well as other select markets.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	In the United States, AT&amp;T will start selling the devices in early November. Verizon Wireless will begin selling Lumia 822 and T-Mobile will offer Lumia 810, Nokia said.</div>\r\n', '', '', '', '1602293490', '1602293490', 'true', '', 'HELSINKI (Reuters) - Finnish phone maker Nokia said its new Lumia smartphones, key to the companys hopes for recovery, will begin to appear in some European markets this week. Nokia late on Monday said its high-end Lumia 820 and 920 phones,', 'Nokia,says,shipping,new,Lumia,', '133', '1602293490', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('2', '9', 'Fusce ac sapien metus, nec pellentesque nisi', '', '', '<div>\r\n	Duis convallis mauris a sapien tempor blandit. Morbi commodo, velit non hendrerit porta, tellus enim commodo massa, vitae tempor dolor tortor in enim. In id libero purus, eleifend varius lacus. Phasellus elementum pellentesque hendrerit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Duis convallis mauris a sapien tempor blandit. Morbi commodo, velit non hendrerit porta, tellus enim commodo massa, vitae tempor dolor tortor in enim. In id libero purus, eleifend varius lacus. Phasellus elementum pellentesque hendrerit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.Duis convallis mauris a sapien tempor blandit. Morbi commodo, velit non hendrerit porta, tellus enim commodo massa, vitae tempor dolor tortor in enim. In id libero purus, eleifend varius lacus. Phasellus elementum pellentesque hendrerit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Duis convallis mauris a sapien tempor blandit. Morbi commodo, velit non hendrerit porta, tellus enim commodo massa, vitae tempor dolor tortor in enim. In id libero purus, eleifend varius lacus. Phasellus elementum pellentesque hendrerit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</div>\r\n', '', '', '', '1602293490', '1602293490', 'true', '', 'Duis convallis mauris a sapien tempor blandit. Morbi commodo, velit non hendrerit porta, tellus enim commodo massa, vitae tempor dolor tortor in enim. In id libero purus, eleifend varius lacus. Phasellus elementum pellentesque hendrerit. Cu', 'Fusce,sapien,metus,nec,pellent', '182', '1602293490', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('3', '9', 'Donec ac aliquam neque', '', '', '<div>\r\n	Pellentesque quis lacus arcu, ac porttitor nisi. Nulla lacus leo, tincidunt at blandit sed, faucibus nec magna. Quisque aliquet ipsum elementum ipsum euismod dictum. Cras elementum molestie quam eget placerat. Mauris lacinia, dolor nec ornare adipiscing, orci orci tempus massa, a aliquam magna massa sed metus.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Pellentesque quis lacus arcu, ac porttitor nisi. Nulla lacus leo, tincidunt at blandit sed, faucibus nec magna. Quisque aliquet ipsum elementum ipsum euismod dictum. Cras elementum molestie quam eget placerat. Mauris lacinia, dolor nec ornare adipiscing, orci orci tempus massa, a aliquam magna massa sed metus.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Pellentesque quis lacus arcu, ac porttitor nisi. Nulla lacus leo, tincidunt at blandit sed, faucibus nec magna. Quisque aliquet ipsum elementum ipsum euismod dictum. Cras elementum molestie quam eget placerat. Mauris lacinia, dolor nec ornare adipiscing, orci orci tempus massa, a aliquam magna massa sed metus.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Pellentesque quis lacus arcu, ac porttitor nisi. Nulla lacus leo, tincidunt at blandit sed, faucibus nec magna. Quisque aliquet ipsum elementum ipsum euismod dictum. Cras elementum molestie quam eget placerat. Mauris lacinia, dolor nec ornare adipiscing, orci orci tempus massa, a aliquam magna massa sed metus.Pellentesque quis lacus arcu, ac porttitor nisi. Nulla lacus leo, tincidunt at blandit sed, faucibus nec magna. Quisque aliquet ipsum elementum ipsum euismod dictum. Cras elementum molestie quam eget placerat. Mauris lacinia, dolor nec ornare adipiscing, orci orci tempus massa, a aliquam magna massa sed metus.</div>\r\n', '', '', '', '1602293490', '1602293490', 'true', '', 'Pellentesque quis lacus arcu, ac porttitor nisi. Nulla lacus leo, tincidunt at blandit sed, faucibus nec magna. Quisque aliquet ipsum elementum ipsum euismod dictum. Cras elementum molestie quam eget placerat. Mauris lacinia, dolor nec orna', 'Donec,aliquam,neque,Pellentesq', '153', '1602293490', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('4', '9', 'Google unveils another phone, larger Nexus tablet', '', '', '<div>\r\n	SAN FRANCISCO (AP) — Google is cramming a few more gadgets on to already crowded holiday shopping lists.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The devices announced Monday include the latest in Google&#39;s line of Nexus smartphones and a larger version of the 7-inch Nexus 7 tablet, which the company began selling in July. It&#39;s also adding cellular capabilities to the Nexus 7 and doubling the capacity of existing models.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The Nexus 4 smartphone is being made by LG Electronics Inc. and features a minor update to Google&#39;s Android operating system, which now powers more than 500 million devices worldwide. A more comprehensive makeover, known as Key Lime Pie, is expected next year. The version of Android affected by these changes is known as Jelly Bean.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The larger Nexus tablet is being made by Samsung Electronics Co.and features a display screen that measures about 10 inches diagonally, about the same size as Apple Inc.&#39;s top-selling iPad.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	With these additions to its product lineup, Google joins a procession of companies selling a gamut of sleek and powerful computing devices in different shapes and sizes. Some are smartphones and others are tablet computers, but they all aim to cater to people&#39;s growing interest to have easily portable devices that can be used to connect to the Internet, take pictures, watch video, play games and read books, magazines and newspapers.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Google&#39;s Nexus devices will be competing with gadgets from such companies as Apple Inc.,Amazon.com Inc., Barnes &amp; Noble Inc., Samsung and Microsoft Corp. Microsoft released a new tablet called Surface last week and launched new software for phones on Monday.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The array of phones and tablets hitting the market underscores how much mobile computing is shaking up the technology industry. The shift has undercut sales of desktop and laptop computers, decreasing the amount of revenue that Microsoft gets from licensing Windows and hurting companies such as Hewlett-Packard Co. and Dell Inc. that make the machines.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Although Android has ensured that Google&#39;s search engine and other services play a prominent role in mobile computing, Google also is experiencing some short-term pain because the advertising rates on phones and tablets so far haven&#39;t been as high as the prices on desktops and laptops. Advertising accounts for most of Google&#39;s revenue.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Google&#39;s introduction of a larger tablet comes less than a week after Apple announced it&#39;s making a smaller, less expensive iPad, with a 7.9-inch display, to compete with the Nexus 7 and Amazon.com Inc.&#39;s Kindle Fire. The iPad Mini will be available in stores Friday.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Some analysts have questioned whether consumers will balk at the iPad Mini&#39;s $329 price for a device with 16 gigabytes of storage. Google is widening the price difference between the iPad Mini and its smaller tablet by cutting $50 off the price of a comparable, 16-gigabyte Nexus 7, to $199. The 8-gigabyte version, which had sold for $199, will be discontinued. A Nexus 7 with 32 gigabytes of storage is being introduced for $249 in an apparent effort to discourage even more people from buying the iPad Mini. The cheapest Nexus 7 is still pricier than the Kindle Fire, which starts at $159 for a no-frills model.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The Nexus 7 tablets will continue to be sold at Google&#39;s Play store online as well as such retailers as GameStop, Office Depot, Office Max, Staples and Wal-Mart.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Analysts estimate Google has sold several million Nexus 7 tablets so far. Google declined to disclose how many units have shipped. The tablet &quot;has been an amazing success,&quot; said Hugo Barra, Android&#39;s director of product management. &quot;We had to work extra hard to meet demand.&quot;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Nexus 7 owners have been buying and looking at so much content on the tablet that Google decided to create a larger version with Samsung, Barra said. The Nexus 7 is made by AsusTek Computer Inc.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The Nexus 10 tablet with 16 gigabytes of storage will sell for $399. That&#39;s $100 less than the comparable version of the latest iPad, though the older iPad 2 is still available at that price. The Nexus 10 goes on sale in Google&#39;s online store Nov. 13.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Both the Nexus 10 and the new Nexus 7 models will allow multiple users to create separate personal profiles on the devices by using different account names and passwords.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The Nexus 4 phone boasts a 4.7-inch screen, larger than Apple&#39;s recently released iPhone 5 and just slightly smaller than Samsung&#39;s flagship phone, the Galaxy S III. A 16-gigabyte model of the Nexus 4 will sell for $199 with a two-year contract to buy phone service and Internet access from T-Mobile. A contract-free version is available for $299 with 8 gigabytes of storage and $349 for the 16-gigabyte model. Google is touting the Nexus 4&#39;s wireless charging capability as a major selling point.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Microsoft entered the tablet fray last week with the Surface. The initial model runs Windows RT, part of the Windows 8 family of operating systems. Microsoft has radically redesigned Windows to appeal to people who want the utility of a personal computer coupled with the convenience of smaller mobile devices that rely on touch controls. More than 1,000 PCs and other devices are expected to run on Windows 8.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Microsoft launched its version of Windows 8 for smartphones in San Francisco at an event Monday that included an appearance by actress Jessica Alba. Google had hoped to upstage Microsoft&#39;s celebration by rolling out its latest gadgets at an event a few hours earlier in New York, but that got canceled because of Hurricane Sandy. The company, which is based in Mountain View, Calif., instead released details about the devices in a blog post.</div>\r\n', '', '', '', '1602293490', '1602293490', 'true', '', 'SAN FRANCISCO (AP) Google is cramming a few more gadgets on to already crowded holiday shopping lists. The devices announced Monday include the latest in Googles line of Nexus smartphones and a larger version of the 7-inch Nexus 7 tablet, w', 'Google,unveils,another,phone,l', '162', '1602293490', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('5', '10', 'Panasonic may curb solar panel, lithium battery', '', '', '<div>\r\n	TOKYO (Reuters) - Electronics conglomerate Panasonic Corp may curtail its expanded production ofsolar panels and small lithium batteries used in PCs and other devices as part of new round of restructuring, two sources at the company told Reuters.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Panasonic recently built a solar panel plant in Malaysia for 45 billion yen ($564 million), upping capacity by one-third to 900 megawatts. Plans to further ramp up production to 1.5 gigawatts may be scaled back, however, because of weak demand, particularly in Europe, the sources said on condition they were not identified.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Panasonic&#39;s new president, Kazuhiro Tsuga, has promised a new revival plan for the Japanese company by the end of the current business year next March 31. He has said he will weed out loss-making or low-profitability units.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The firm&#39;s business in small lithium batteries has been hurt by price competition from Korean and Chinese competitors. Falling into the red last year, it was aiming to return to profit this year by shifting production to China, where costs are lower, but may post a loss instead, the sources said.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	As a result of the squeeze on expanded output of solar panels and batteries, Panasonic&#39;s energy unit may struggle to reach a target of raising sales to more than 1 trillion yen, or 10 percent of overall sales, and operating margin to at least 10 percent by March 2016, the sources said.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The unit retains 202 billion yen of goodwill following the acquisition of Sanyo in 2010. Analysts estimate that two-thirds of that is related to solar panels and small lithium batteries.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Shares of Panasonic, which releases its results on Wednesday for the quarter ended September 30, rose 3 percent in morning trading in Tokyo to 507 yen. ($1 = 79.8150 Japanese yen) (Writing by Tim Kelly; Editing by Michael Watson)</div>\r\n', '', '', '', '1602293502', '1602293502', 'true', '', 'TOKYO (Reuters) - Electronics conglomerate Panasonic Corp may curtail its expanded production ofsolar panels and small lithium batteries used in PCs and other devices as part of new round of restructuring, two sources at the company told Re', 'Panasonic,may,curb,solar,panel', '60', '1602293502', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('6', '10', 'Apple software, retail chiefs out in sweeping overhaul', '', '', '<div>\r\n	SAN FRANCISCO (Reuters) - Apple Inc Chief Executive Tim Cookon Monday replaced the heads of its software and retail units in the company&#39;s most sweeping executive shake-up in a decade following embarrassing problems with its new mapping program and unpopular store-related decisions.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Software chief Scott Forstall, who oversaw the launch of the flawed mapping software and much criticized Siri voice-enabled assistant, will leave Apple next year and serve as an advisor to Cook in the meantime.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Forstall, seen as a polarizing figure inside Apple, had been billed as one of the future candidates to take the top job at Apple. He was the executive behind the panned Apple Maps app that the company announced with much fanfare in summer.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The moves, which come a little more than a year into Cook&#39;s tenure as CEO, were described by Apple as a way to increase &quot;collaboration&quot; across its hardware, software and services business.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	&quot;These changes show that Tim Cook is stamping his authority on the business,&quot; Ben Wood, analyst with CCS Insight, said. &quot;Perhaps disappointed with the Maps issues, Forstall became the scapegoat.&quot;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Critics of the maps debacle, which led Cook to apologize to customers, had been calling for Forstall&#39;s head. &quot;Does Apple have a Scott Forstall problem?&quot; Fortune editor Philip Elmer Dewitt wrote on Sept 29.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The moves hand over substantially more responsibility to Cue, the head of Internet Software and Services who helped create the iTunes music store and App Store. The 23-year Apple veteran already is in charge of Cloud services and will take on Apple Maps and Siri.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Apple said a search is underway for a new retail chief to replace John Browett and that the retail team would report directly to Cook. Browett had riled up the retail store staff when he decided to reduce the number of retail employees.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Browett took over as head of Apple&#39;s retail stores earlier this year, replacing Ron Johnson, who went on to become the CEO of JC Penney.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Last week Apple delivered a second straight quarter of disappointing financial results, and iPad sales fell short of Wall Street&#39;s targets, marring its record of consistently blowing past investors&#39; expectations.</div>\r\n', '', '', '', '1602293502', '1602293502', 'true', '', 'SAN FRANCISCO (Reuters) - Apple Inc Chief Executive Tim Cookon Monday replaced the heads of its software and retail units in the companys most sweeping executive shake-up in a decade following embarrassing problems with its new mapping prog', 'Apple,software,retail,chiefs,o', '169', '1602293502', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('7', '10', 'How new Google Nexus 10 compares with rivals', '', '', '<p>\r\n	Google Inc.&nbsp;has announced a larger version of its Nexus tablet computer, one that comes closer to competing with&nbsp;Apple&#39;s full-sized iPad and other tablets. Here&#39;s a look at how the Nexus 10 compares with other tablets with comparable screens.</p>\r\n<div>\r\n	<p>\r\n		Google Inc.&#39;s Nexus 10 (available Nov. 13):</p>\r\n	<p>\r\n		— Price: $399 for 16 gigabytes of storage, $499 for 32 GB</p>\r\n	<p>\r\n		—&nbsp;Screen size: 10.1 inches diagonally</p>\r\n	<p>\r\n		— Screen resolution: 2560 by 1600 pixels</p>\r\n	<p>\r\n		— Weight: 1.33 pounds.</p>\r\n	<p>\r\n		— Cameras: 5-megapixel camera on back and a low-resolution camera on front, for videoconferencing</p>\r\n	<p>\r\n		— Battery life: 9 hours for video playback, 7 hours for Web browsing.</p>\r\n	<p>\r\n		— Operating system:&nbsp;Google&#39;s Android</p>\r\n	<p>\r\n		Pros: Access to a variety of games, utilities and other software for Android devices, though not as extensive as apps available for iPad. Cheaper than newest full-sized iPad.</p>\r\n	<p>\r\n		Cons: Integrates with Google Play store, which is still new and isn&#39;t as robust as&nbsp;Apple&nbsp;or Amazon&#39;s stores. Data storage cannot be expanded with&nbsp;memory cards. No option for cellular&nbsp;wireless broadband.</p>\r\n	<p>\r\n		Apple Inc.&#39;s iPad:</p>\r\n	<p>\r\n		— Price: Starts at $499 for 16 gigabytes of storage, goes up to $699 for 64 gigabytes, more for versions with cellular data access. (Apple&nbsp;still sells the older, iPad 2 for $399.)</p>\r\n	<p>\r\n		—&nbsp;Screen size: 9.7 inches diagonally</p>\r\n	<p>\r\n		— Screen resolution: 2048 by 1536 pixels</p>\r\n	<p>\r\n		— Weight: 1.44 pounds</p>\r\n	<p>\r\n		— Cameras: 5-megapixel camera on back and a low-resolution camera on front, for videoconferencing</p>\r\n	<p>\r\n		— Battery life: 10 hours.</p>\r\n	<p>\r\n		— Operating system:&nbsp;Apple&#39;s iOS</p>\r\n	<p>\r\n		Pros: Unmatched access to third-party applications, high-quality&nbsp;Apple&nbsp;software and the iTunes store. Unique high-resolution screen. Widest range of cases and accessories available. Available with access to fast 4G wireless broadband networks, starting at $629.</p>\r\n	<p>\r\n		Cons: Data storage cannot be expanded with&nbsp;memory cards.</p>\r\n	<p>\r\n		Amazon.com Inc.&#39;s Kindle Fire HD 8.9&quot; (available Nov. 20):</p>\r\n	<p>\r\n		— Price: $299 for 16 gigabytes of storage, $369 for 32 GB.</p>\r\n	<p>\r\n		—&nbsp;Screen size: 8.9 inches diagonally</p>\r\n	<p>\r\n		— Screen resolution: 1920 by 1200 pixels</p>\r\n	<p>\r\n		— Weight: 1.25 pounds.</p>\r\n	<p>\r\n		— Cameras: Front-facing camera.</p>\r\n	<p>\r\n		— Battery life: Undisclosed.</p>\r\n	<p>\r\n		— Operating system: Modified version of&nbsp;Google&#39;s Android</p>\r\n	<p>\r\n		Pros: Cheap and portable. Convenient access to Amazon store. Large high-definition screen. Dolby audio. Available with access to fast 4G wireless broadband networks, for $499.</p>\r\n	<p>\r\n		Cons: Small selection of third-party applications available from Amazon. No rear camera for taking video and photos.</p>\r\n	<p>\r\n		Samsung Electronic Co.&#39;s Galaxy Tab 2 10.1:</p>\r\n	<p>\r\n		— Price: $399 for 16 gigabytes of storage</p>\r\n	<p>\r\n		—&nbsp;Screen size: 10.1 inches diagonally</p>\r\n	<p>\r\n		— Screen resolution: 1280 by 800 pixels</p>\r\n	<p>\r\n		— Weight: 1.24 pounds</p>\r\n	<p>\r\n		— Cameras: low-resolution front camera, 3-megapixel back.</p>\r\n	<p>\r\n		— Battery life: 11 hours.</p>\r\n	<p>\r\n		— Operating system:&nbsp;Google&#39;s Android</p>\r\n	<p>\r\n		Pros: Also with 7-inch screen for $250. Storage is expandable with microSD&nbsp;memory cards. Can act as a universal remote control for an entertainment center.</p>\r\n	<div>\r\n		&nbsp;</div>\r\n</div>\r\n<br />\r\n', '', '', '', '1602293502', '1602293502', 'true', '', 'Google Inc.has announced a larger version of its Nexus tablet computer, one that comes closer to competing withApples full-sized iPad and other tablets. Heres a look at how the Nexus 10 compares with other tablets with comparable screens. G', 'How,new,Google,Nexus,compares,', '112', '1602293502', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('8', '10', 'Sed mollis elementum lectus rhoncus', '', '', '<div>\r\n	Nunc varius venenatis sem sed adipiscing. Mauris suscipit mauris in purus mattis placerat. Ut rhoncus imperdiet nibh sit amet sagittis. Aliquam erat volutpat. In pellentesque sagittis dictum. Aliquam erat volutpat. Donec ac aliquam neque. Sed tellus diam, consequat nec volutpat et, cursus ac nisi. Mauris in risus in diam consequat suscipit non ac enim.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Nunc varius venenatis sem sed adipiscing. Mauris suscipit mauris in purus mattis placerat. Ut rhoncus imperdiet nibh sit amet sagittis. Aliquam erat volutpat. In pellentesque sagittis dictum. Aliquam erat volutpat. Donec ac aliquam neque. Sed tellus diam, consequat nec volutpat et, cursus ac nisi. Mauris in risus in diam consequat suscipit non ac enim.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Nunc varius venenatis sem sed adipiscing. Mauris suscipit mauris in purus mattis placerat. Ut rhoncus imperdiet nibh sit amet sagittis. Aliquam erat volutpat. In pellentesque sagittis dictum. Aliquam erat volutpat. Donec ac aliquam neque. Sed tellus diam, consequat nec volutpat et, cursus ac nisi. Mauris in risus in diam consequat suscipit non ac enim.Nunc varius venenatis sem sed adipiscing. Mauris suscipit mauris in purus mattis placerat. Ut rhoncus imperdiet nibh sit amet sagittis. Aliquam erat volutpat. In pellentesque sagittis dictum. Aliquam erat volutpat. Donec ac aliquam neque. Sed tellus diam, consequat nec volutpat et, cursus ac nisi. Mauris in risus in diam consequat suscipit non ac enim.</div>\r\n', '', '', '', '1602293502', '1602293502', 'true', '', 'Nunc varius venenatis sem sed adipiscing. Mauris suscipit mauris in purus mattis placerat. Ut rhoncus imperdiet nibh sit amet sagittis. Aliquam erat volutpat. In pellentesque sagittis dictum. Aliquam erat volutpat. Donec ac aliquam neque. S', 'Sed,mollis,elementum,lectus,rh', '185', '1602293502', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('9', '10', 'Apple Sells Out of All iPad Mini Models', '', '', '<div>\r\n	Apple has sold out of its initial inventory of all iPad Mini models just three days after the new device became available for pre-order online.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	[More from Mashable: Smug Apple Fans Secretly Lust After Microsoft Surface Tablets [SUNDAY COMICS]]</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	The shipping times for all three Wi-Fi versions of the black and white iPad Mini have now been pushed back to two weeks, indicating that the initial stock is sold out. The LTE-enabled iPad Mini models have not yet gone on sale.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Apple worried some investors with its decision to the price the new 7.9 inch tablets starting at $329, significantly more than competing tablets like the Nexus 7 and Kindle Fire, but the sales so far suggest that demand for the iPad Mini is strong even with the higher price.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	[More from Mashable: Top Comments on Mashable This Week]</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Have you ordered an iPad Mini? Let us know in the comments below.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	Apple iPad Mini Hands-on</div>\r\n<div>\r\n	Click here to view this gallery.</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	This story originally published on Mashable here.</div>\r\n', '', '', '', '1602293502', '1602293502', 'true', '', 'Apple has sold out of its initial inventory of all iPad Mini models just three days after the new device became available for pre-order online. [More from Mashable: Smug Apple Fans Secretly Lust After Microsoft Surface Tablets [SUNDAY COMIC', 'Apple,Sells,Out,All,iPad,Mini,', '155', '1602293502', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('10', '15', 'Flexible chain conveyor', '/storage/images/20201010/1-1Z91Q145020-L.jpg', '', '<p data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14524119.jpg\" /></div>\r\n<br />\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00925618.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00925618.jpg\">\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14533638.jpg\" /></div>\r\n', '', '', '', '1602293543', '1602293543', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Flexible,chain,conveyor,Spring', '79', '1602293543', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('11', '15', 'Flexible chain conveyor', '/storage/images/20201010/1-1Z91Q145020-L.jpg', '', '<p data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14524119.jpg\" /></div>\r\n<br />\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00925618.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00925618.jpg\">\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14533638.jpg\" /></div>\r\n', '', '', '', '1602293543', '1602293543', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Flexible,chain,conveyor,Spring', '199', '1602293543', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('12', '15', 'Flexible chain conveyor', '/storage/images/20201010/1-1Z91Q145020-L.jpg', '', '<p data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14524119.jpg\" /></div>\r\n<br />\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00925618.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00925618.jpg\">\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14533638.jpg\" /></div>\r\n', '', '', '', '1602293543', '1602293543', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Flexible,chain,conveyor,Spring', '177', '1602293543', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('13', '15', 'Flexible chain conveyor', '/storage/images/20201010/1-1Z91Q145020-L.jpg', '', '<p data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14524119.jpg\" /></div>\r\n<br />\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00925618.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00925618.jpg\">\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14533638.jpg\" /></div>\r\n', '', '', '', '1602293543', '1602293543', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Flexible,chain,conveyor,Spring', '171', '1602293543', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('14', '15', 'Flexible chain conveyor', '/storage/images/20201010/1-1Z91Q145020-L.jpg', '', '<p data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14524119.jpg\" /></div>\r\n<br />\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00925618.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00925618.jpg\">\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14533638.jpg\" /></div>\r\n', '', '', '', '1602293543', '1602293543', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Flexible,chain,conveyor,Spring', '74', '1602293543', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('15', '15', 'Flexible chain conveyor', '/storage/images/20201010/1-1Z91Q145020-L.jpg', '', '<p data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00Z3127.jpg\">\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14524119.jpg\" /></div>\r\n<br />\r\n<div data-exthumbimage=\"/uploads/allimg/160907/1-160ZG00925618.jpg\" data-src=\"/uploads/allimg/160907/1-160ZG00925618.jpg\">\r\n	<img alt=\"\" src=\"/storage/images/20201008/1-1Z91Q14533638.jpg\" /></div>\r\n', '', '', '', '1602293543', '1602293543', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Flexible,chain,conveyor,Spring', '76', '1602293543', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('16', '17', 'Spring up across the chest', '/storage/images/20201010/1-1Z91Q132390-L.jpg', '', '<p>\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;<br />\r\n	&nbsp;</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '', '', '1602293572', '1602293572', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Spring,across,the,chest,Spring', '145', '1602293572', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('17', '17', 'Spring up across the chest', '/storage/images/20201010/1-1Z91Q132390-L.jpg', '', '<p>\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;<br />\r\n	&nbsp;</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '', '', '1602293572', '1602293572', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Spring,across,the,chest,Spring', '182', '1602293572', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('18', '17', 'Spring up across the chest', '/storage/images/20201010/1-1Z91Q132390-L.jpg', '', '<p>\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;<br />\r\n	&nbsp;</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '', '', '1602293572', '1602293572', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Spring,across,the,chest,Spring', '66', '1602293572', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('19', '17', 'Spring up across the chest', '/storage/images/20201010/1-1Z91Q132390-L.jpg', '', '<p>\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;<br />\r\n	&nbsp;</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '', '', '1602293572', '1602293572', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Spring,across,the,chest,Spring', '195', '1602293572', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('20', '17', 'Spring up across the chest', '/storage/images/20201010/1-1Z91Q132390-L.jpg', '', '<p>\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;<br />\r\n	&nbsp;</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '', '', '1602293572', '1602293572', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Spring,across,the,chest,Spring', '60', '1602293572', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('21', '17', 'Spring up across the chest', '/storage/images/20201010/1-1Z91Q132390-L.jpg', '', '<p>\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;<br />\r\n	&nbsp;</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '', '', '1602293572', '1602293572', 'true', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', 'Spring,across,the,chest,Spring', '78', '1602293572', '0', '0', '0', '100');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '五金电器出口外贸网站', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20201010/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2002-2050 IMPORT AND EXPORT TRADING COMPANY .ALL', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '响应式五金电器出口英文外贸类网站(自适应手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某制造公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', 'Guangdong Province, China TianHe District, GuangZhou Num 888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '22.94703,113.38555', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'wx88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', '/storage/images/20201010/qr.png', 'webinfo', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线留言', 'a:4:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:4:\"Name\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:5:\"Phone\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:5:\"Email\";s:8:\"required\";s:1:\"1\";}i:3;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:6:\"Conten\";s:8:\"required\";s:1:\"0\";}}', '1602146963', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';

-- -----------------------------
-- Records of `rrz_goods`
-- -----------------------------
INSERT INTO `rrz_goods` VALUES ('1', 'Beolit I15 omnidirectional', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diffe', '1', '/storage/images/20201010/1-1Z923153617.png', '/storage/images/20201010/1-1Z923153617.png,/storage/images/20201010/1-1Z923153612.png,/storage/images/20201010/1-1Z923153614.png,/storage/images/20201010/1-1Z923153617.png', '0.00', '0.00', '0', 'false', '0.00', '', '', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;', '', '0', '1602293803', '0', '0', '0', '0', '130', '100', '');
INSERT INTO `rrz_goods` VALUES ('2', 'Beolit I15 omnidirectional sound', 'Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These', '1', '/storage/images/20201010/1-1Z91Q159250-L.png', '/storage/images/20201010/1-1Z91Q159250-L.png,/storage/images/20201010/1-1Z91Q15934.jpg,/storage/images/20201010/1-1Z91Q15935.png', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These delightful little surprise at first may seem incredible, but will soon be integrated into your pleasure to enjoy. Today, the Bang &amp; Olufsen 15 product design has become the permanent collection. These exquisite products bearing the museum for product quality and the era significance must be a strict standard, the 20th century.</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '0', '1602293803', '0', '0', '0', '0', '168', '100', '');
INSERT INTO `rrz_goods` VALUES ('3', 'Bass, Bass type A1', 'Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These', '1', '/storage/images/20201010/1-1Z91Q15Z50-L.png', '/storage/images/20201010/1-1Z91Q15Z50-L.png,/storage/images/20201010/1-1Z91Q15910.png,/storage/images/20201010/1-1Z91Q15912.png', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These delightful little surprise at first may seem incredible, but will soon be integrated into your pleasure to enjoy. Today, the Bang &amp; Olufsen 15 product design has become the permanent collection. These exquisite products bearing the museum for product quality and the era significance must be a strict standard, the 20th century.</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '0', '1602293803', '0', '0', '0', '0', '61', '100', '');
INSERT INTO `rrz_goods` VALUES ('4', 'Opponents box', 'Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These', '1', '/storage/images/20201010/1-1Z91Q15T50-L.png', '/storage/images/20201010/1-1Z91Q15T50-L.png,/storage/images/20201010/1-1Z91Q15912.png,/storage/images/20201010/1-1Z91Q15Z50-L.png', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These delightful little surprise at first may seem incredible, but will soon be integrated into your pleasure to enjoy. Today, the Bang &amp; Olufsen 15 product design has become the permanent collection. These exquisite products bearing the museum for product quality and the era significance must be a strict standard, the 20th century.</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '0', '1602293803', '0', '0', '0', '0', '130', '100', '');
INSERT INTO `rrz_goods` VALUES ('5', 'BeoPlay two speakers', 'Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These', '1', '/storage/images/20201010/1-1Z91Q15Z50-L.png', '/storage/images/20201010/1-1Z91Q15Z50-L.png,/storage/images/20201010/1-1Z91Q15934.jpg,/storage/images/20201010/1-1Z91Q15R9.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These delightful little surprise at first may seem incredible, but will soon be integrated into your pleasure to enjoy. Today, the Bang &amp; Olufsen 15 product design has become the permanent collection. These exquisite products bearing the museum for product quality and the era significance must be a strict standard, the 20th century.</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '0', '1602293803', '0', '0', '0', '0', '171', '100', '');
INSERT INTO `rrz_goods` VALUES ('6', 'BeoPlay A9 wireless speakers', 'Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These', '1', '/storage/images/20201010/1-1Z91Q15K20-L.png', '/storage/images/20201010/1-1Z91Q15K20-L.png,/storage/images/20201010/1-1Z91Q15912.png,/storage/images/20201010/1-1Z91Q15934.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These delightful little surprise at first may seem incredible, but will soon be integrated into your pleasure to enjoy. Today, the Bang &amp; Olufsen 15 product design has become the permanent collection. These exquisite products bearing the museum for product quality and the era significance must be a strict standard, the 20th century.</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '0', '1602293803', '0', '0', '0', '0', '159', '100', '');
INSERT INTO `rrz_goods` VALUES ('7', 'Beosound rotation control', 'Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These', '1', '/storage/images/20201010/1-1Z91Q15H9.png', '/storage/images/20201010/1-1Z91Q15H9.png,/storage/images/20201010/1-1Z91Q15H9.png,/storage/images/20201010/1-1Z91Q15T50-L.png', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These delightful little surprise at first may seem incredible, but will soon be integrated into your pleasure to enjoy. Today, the Bang &amp; Olufsen 15 product design has become the permanent collection. These exquisite products bearing the museum for product quality and the era significance must be a strict standard, the 20th century.</p>\r\n<div>\r\n	<br />\r\n	<p>\r\n		SPRING insulation sample transfer cases</p>\r\n	<p>\r\n		L used to transfer need insulation samples;</p>\r\n	<p>\r\n		L impact resistant plastic material;</p>\r\n	<p>\r\n		L internal filled with expanded polystyrene insulation materials;</p>\r\n	<p>\r\n		L with a handle;</p>\r\n	<p>\r\n		L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n	<p>\r\n		L overall size: 410 x250x355h mm</p>\r\n	<p>\r\n		L internal size: 375 x208x305h mm</p>\r\n	<p>\r\n		Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n	<p>\r\n		Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n	<p>\r\n		The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n	<p>\r\n		&nbsp;</p>\r\n	<p>\r\n		L used to transfer need insulation samples;</p>\r\n	<p>\r\n		L impact resistant plastic material;</p>\r\n	<p>\r\n		L internal filled with expanded polystyrene insulation materials;</p>\r\n	<p>\r\n		L with a handle;</p>\r\n	<p>\r\n		L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n	<p>\r\n		L overall size: 410 x250x355h mm</p>\r\n	<p>\r\n		L internal size: 375 x208x305h mm</p>\r\n</div>\r\n<br />\r\n', '', '0', '1602293803', '0', '0', '0', '0', '170', '100', '');
INSERT INTO `rrz_goods` VALUES ('8', 'Spring up across the chest', 'Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These', '1', '/storage/images/20201010/1-1Z91Q156440-L.png', '/storage/images/20201010/1-1Z91Q156440-L.png,/storage/images/20201010/1-1Z91Q15A0.png,/storage/images/20201010/1-1Z91Q15910.png', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Panel speaker amplifier or device takes up little space, but it can sound effects to bring strong, highly artistic charm. When you put Aston Martin, turning on the power supply acoustic lens will slowly into the line of sight of you. These delightful little surprise at first may seem.</p>\r\n<div>\r\n	<p>\r\n		SPRING insulation sample transfer cases</p>\r\n	<p>\r\n		L used to transfer need insulation samples;</p>\r\n	<p>\r\n		L impact resistant plastic material;</p>\r\n	<p>\r\n		L internal filled with expanded polystyrene insulation materials;</p>\r\n	<p>\r\n		L with a handle;</p>\r\n	<p>\r\n		L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n	<p>\r\n		L overall size: 410 x250x355h mm</p>\r\n	<p>\r\n		L internal size: 375 x208x305h mm</p>\r\n	<p>\r\n		Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n	<p>\r\n		Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n	<p>\r\n		The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n	<p>\r\n		&nbsp;</p>\r\n	<p>\r\n		L used to transfer need insulation samples;</p>\r\n	<p>\r\n		L impact resistant plastic material;</p>\r\n	<p>\r\n		L internal filled with expanded polystyrene insulation materials;</p>\r\n	<p>\r\n		L with a handle;</p>\r\n	<p>\r\n		L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n	<p>\r\n		L overall size: 410 x250x355h mm</p>\r\n	<p>\r\n		L internal size: 375 x208x305h mm</p>\r\n</div>\r\n<br />\r\n', '', '0', '1602293803', '0', '0', '0', '0', '171', '100', '');
INSERT INTO `rrz_goods` VALUES ('9', 'Panel speaker', 'Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of diff', '1', '/storage/images/20201010/1-1Z91Q15934.jpg', '/storage/images/20201010/1-1Z91Q15934.jpg,/storage/images/20201010/1-1Z91Q15934.jpg,/storage/images/20201010/1-1Z91Q15934.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	Spring insulation sample transfer box is used to transfer samples need heat preservation; Impact resistant plastic material; Thermal insulation layer is filled with expanded polystyrene material; With the handle; Form a complete set of different temperature insulation components, can be more than 8 hours continuous heat preservation;<br />\r\n	&nbsp;</p>\r\n<p>\r\n	SPRING insulation sample transfer cases</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n<p>\r\n	Standard configuration includes 2 0 degrees heat preservation plate,</p>\r\n<p>\r\n	Optional - 30 degrees, to 18 degrees, 4 degrees, 22 degrees and 37 degrees heat components.</p>\r\n<p>\r\n	The most ideal used to transport blood, vaccines, such as temperature sensitive drugs.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	L used to transfer need insulation samples;</p>\r\n<p>\r\n	L impact resistant plastic material;</p>\r\n<p>\r\n	L internal filled with expanded polystyrene insulation materials;</p>\r\n<p>\r\n	L with a handle;</p>\r\n<p>\r\n	L supporting different temperature insulation components, can be more than 8 hours continuous heat preservation;</p>\r\n<p>\r\n	L overall size: 410 x250x355h mm</p>\r\n<p>\r\n	L internal size: 375 x208x305h mm</p>\r\n', '', '0', '1602293803', '0', '0', '0', '0', '141', '100', '');

-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';

-- -----------------------------
-- Records of `rrz_goods_cat`
-- -----------------------------
INSERT INTO `rrz_goods_cat` VALUES ('1', '0', 'PRODUCTSA', '', '0', '', '1', '1', '1', '1001', '', '', '', '', '', '', '1602145678');
INSERT INTO `rrz_goods_cat` VALUES ('2', '0', 'PRODUCTSB', '', '0', '', '2', '1', '2', '1002', '', '', '', '', '', '', '1602145687');
INSERT INTO `rrz_goods_cat` VALUES ('3', '0', 'PRODUCTSC', '', '0', '', '3', '1', '3', '1003', '', '', '', '', '', '', '1602145695');
INSERT INTO `rrz_goods_cat` VALUES ('4', '0', 'PRODUCTSD', '', '0', '', '4', '1', '4', '1004', '', '', '', '', '', '', '1602145701');
INSERT INTO `rrz_goods_cat` VALUES ('5', '0', 'PRODUCTSE', '', '0', '', '5', '1', '5', '1005', '', '', '', '', '', '', '1602145706');

-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481203', '1590481203');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', '', '100', '1', '', '', '1', 'cn', '1590481246', '1591322028');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481266', '1590481266');
INSERT INTO `rrz_site_links` VALUES ('4', '百度', 'http://www.baidu.com', '', '100', '1', '', '', '1', 'cn', '1590822377', '1590822377');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', 'ABOUT US', 'about', '0', '1', '1', '/node/1.html', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', 'PRODUCTS', 'products', '0', '2', '1', '/cats.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', 'NEWS', 'news', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', 'SERVICE', 'service', '0', '4', '1', '/node/3.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', 'CASE', 'case', '0', '5', '1', '/node/4.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', 'Photo', 'photo', '0', '6', '1', '/node/5.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', 'CONTACT', 'contact', '0', '7', '1', '/node/6.html', '7', '1007', 'false', '');
