-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.2.8
-- Date : 2021-08-26 16:47:27
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1629958648', '127.0.0.1', '251', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', 'SVÄRTAN\'s Brand Story', '', '0', '/storage/images/20210826/about1.jpg', '1', '1', '1', '1001', 'single', '', '', 'SVÄRTAN 斯瓦顿系列品牌故事', '', '<p style=\"text-align:center\"><img src=\"/storage/images/20210826/about1_1.jpg\"/></p><p>SVÄRTAN 斯瓦顿 系列图案的设计灵感源于城市景观，带领我们探索印度的另一面，这个美丽的国家不仅具有生动的色彩。由瑞典纺织品设计师Martin Bergström与印度时装专业学生合力创作的SVÄRTAN斯瓦顿系列采用黑白灰三色，包括床上用品、纺织品、纸质产品、地毯、碗、玻璃器皿和金属物品等。这一系列融合了多功能性和独特性。<br/>Karin Larsson并不只是打造了一个打破陈规的家，更突破时下流行趋势，为自己和孩子们设计了更加舒适实用的衣物。<br/>瑞典室内设计师Lena Larsson提出“ALLRUMMET”的概念，旨在为整个家庭打造一个多功能的家。<br/>无论全家人想要聚在一起，还是各自忙碌，能够迅速将东西整理得井井有条，将带来极大便利。如果你想将各种杂物隐藏起来，让一切井然有序，SÄLLSKAP 赛索 玻璃柜门储物柜是理想的选择。<br/>从极致合理的生产工序中诞生的商品非常简洁，但就风格而言却并非极简主义。就如“空容器”一样。正因为其单纯、空白，所以那里才诞生了能够容纳所有人思想的终极的自由性。<br/>作为一个在意大利从事家庭纺织品印花生意的男孩，设计师获得了知识和对纺织品的热爱。当他移居澳大利亚时，他带着对质量的重要性的内在理解，以及他对艺术和美的热爱.。克劳迪奥认为，艺术的美属于每个人，无处不在--不只是画廊墙壁或华丽的黄金框架。他的愿景是“将创造性的思想和美引入日常生活中的事物”，他脚踏实地、平等主义的思维方式与澳大利亚精神完美契合。这是一个愿景，仍然适用于设计师今天和指导我们在我们做的一切。我们熟知和喜爱的设计师在澳大利亚和世界各地为我们设计精美、优质的产品使生活只是多一点宽容在家，是床卧室床单，毛巾的浴室，桌布，休闲服装和家居饰品。<br/></p>', '        ', 'true', '1629966487');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '品牌故事', '品牌故事', '', '0', '/storage/images/20210826/text.jpg', '2', '1', '2', '1002', 'text', '', '', 'SVÄRTAN 斯瓦顿系列品牌故事', '', '<p>SVÄRTAN 斯瓦顿系列图案的设计灵感源于城市景观，带领我们探索印度的另一面，这个美丽的国家不仅具有生动的色彩。由瑞典纺织品设计师Martin Bergström与印度时装专业学生合力创作的SVÄRTAN斯瓦顿系列采用黑白灰三色，包括床上用品、纺织品、纸质产品、地毯、碗、玻璃器皿和金属物品等。这一系列融合了多功能性和独特性。<br/>Karin Larsson并不只是打造了一个打破陈规的家，更突破时下流行趋势，为自己和孩子们设计了更加舒适实用的衣物。<br/>瑞典室内设计师Lena Larsson提出“ALLRUMMET”的概念，旨在为整个家庭打造一个多功能的家。无论全家人想要聚在一起，还是各自忙碌，能够迅速将东西整理得井井有条，将带来极大便利。如果你想将各种杂物隐藏起来，让一切井然有序，SÄLLSKAP 赛索 玻璃柜门储物柜是理想的选择。</p><p><iframe frameborder=\"0\" height=\"420\" src=\"https://player.youku.com/embed/XNDk5ODk0ODA0\" width=\"100%\"></iframe></p>', '      ', 'true', '1629966594');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '新闻资讯', '', '', '0', '/storage/images/20210826/news1.jpg', '3', '1', '3', '1003', '', '', '', '  ', '', '    ', '    ', 'true', '1629966007');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '联系我们', '客服服务中心', '', '0', '', '4', '1', '4', '1004', 'contact', '', '', '  ', '', '<h5>联系信息</h5><div>欢迎任何形式的媒体与商务合作<br/>深入的了解，有利于为您提供更优质的服务<br/><p>QQ：9999999</p><p>邮箱：9999999@qq.com</p><p>地址：某省温某市某地</p><p>邮编：021</p></div><p><br/></p>', '      ', 'true', '1629966968');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', '公司历史', 'GRIND\'s Development History', '', '1', '/storage/images/20210826/about2.jpg', '1,5', '2', '1', '10011001', 'single', '', '', 'GRIND 集团发展历程', '', '<p>• 2000年，又在四个新的国家开设门店，包括奥地利、丹麦、卡塔尔和安道尔，并开始在Arteixo建立新的总部大楼和配送中心加大物流配送的能力，增强快速配送的核心能力。<br/>• 2001年5月23日，GRIND 集团公开上市；同年，集团设立OYSHO品牌，并进入以下市场，包括波多黎各、约旦、爱尔兰、冰岛、卢森堡、捷克共和国和意大利。发行当天的认购额就超过了发行量的26倍，仅此一项就为公司募得资金21亿欧元；加强了对女性内衣市场的攻势。<br/>• 2002年，开始修建GRIND 位于Zaragoza新的物流中心，同年，开始在以下国家开设门店，包括萨尔瓦多、芬兰、多米尼加共和国、新加坡和瑞士，进一步增强自身的物流配送能力，协调较远市场的快速反应机制。<br/>• 2003年，开设第一家GRIND HOME的门店；GRIND 的第二家配送中心Plataforma Europa在GRINDgoza落成，集团在俄罗斯、斯洛伐克、斯洛文尼亚以及马来西亚首次开设门店。弥补了位于Arteixo的老物流中心的工作。<br/>• 2004年，GRIND 在香港开设集团的第2000家门店，同年，集团在摩洛哥、爱沙尼亚、拉脱维亚、罗马尼亚、匈牙利、立陶宛和巴拿马首次开设门店，到此集团的销售门店已经遍布欧、美、亚、非洲的56个国家。<br/>• 2005年，GRIND 集团在摩纳哥、印尼、泰国、菲律宾和哥斯达黎加首次开设门店。至此，INDITEX已在全球拥有2893家门店，旗下领导八大子品牌。其中ZARA门店917家，遍布世界五十多个国家和地区。<br/>• 2006年，集团在塞尔维亚、中国大陆和突尼斯开设门店。<br/>• 2013年9月12日，GRIND 的六大姊妹品牌 Oysho、Bershka、Stradivarius、Pull &amp; Bear、GRIND Home、Massimo Dutti登陆杭州西溪印象城一层。<br/>• 2016年6月8日，《2016年BrandZ全球最具价值品牌百强榜》公布，GRIND 排第35名。</p>', '    ', 'true', '1629966352');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '设计理念', 'GRIND\'s Design For Each Person', '', '1', '/storage/images/20210826/about3.jpg', '1,6', '2', '2', '10011002', 'single', '', '', 'GRIND 为每个人而设计', '', '<p>对GRIND 而言，优秀的设计应该是美观、实用、优质、可持续和低价的完美结合。我们称之为“民主设计”，因为我们相信卓越的家居装饰产品是人人都应享有的。这就是我们不断地探索更精巧、更实惠的解决方案的原因。以LAMPAN拉姆本沙发为例。我们不仅仅是跳出框架思考，而是直接摈除了框架。<br/>“家”不仅仅是一个地方，更是一种感觉。这种感觉就好像自己身处全世界最舒适的地方。因此，我们所做的一切都要从了解人们的居家生活开始。每年，我们都会拜访世界各地的家庭，希望了解人们梦想拥有什么样的居家生活。然后，我们将他们的需求与供应商的能力联系起来，打造出能够让日常生活更美好的全新解决方案。<br/>我们从60年前开始学习如何打造家具。我们刚刚开始设计自己的家具，需要学习如何将供应商的供应能力与顾客的需求做好地结合起来。我们通过拉近供应商与顾客间的距离，使产品价格保持在较低的水平。<br/>从那时开始，我们就一直使用这一方法，并且留在工厂里与供应商一起工作。如今，GRIND 的方方面面都受到民主设计这一概念的影响，并从中受益——从我们设在阿姆霍特的开发设施，到我们遍布全球的供应商，还有在像印度及东南亚这样地方的本地手艺人。</p>', '    ', 'true', '1629966360');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', '主题活动', '來自GRIND的创意灵感和特惠活动', '', '3', '/storage/images/20210826/news1.jpg', '3,7', '2', '1', '10031001', '', '', '', '  ', '', '      ', '      ', 'true', '1629966099');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '春夏新品', '2017 春夏新品情报，阐释不纯粹和不规则的设计手法', '', '3', '/storage/images/20210826/news2.jpg', '3,8', '2', '2', '10031002', '', '', '', '  ', '', '      ', '      ', 'true', '1629966109');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '创意灵感', '从家居装饰创意到收纳技巧，再到让你的家充满更多绿色灵感，一应俱全', '', '3', '/storage/images/20210826/news3.jpg', '3,9', '2', '3', '10031003', '', '', '', '  ', '', '      ', '      ', 'true', '1629966123');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '首页轮播图', '', '', '0', '', '10', '1', '5', '1005', '', '', '', '', '', '  ', '  ', 'false', '1629962103');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '7', '如何举办一场胜利的观赛派对', '/storage/images/20210826/1-1F6151252140-L.jpg', '', '世界杯快到啦，这就意味着要整天黏在电视上了。半夜起床看最爱的队伍比赛，享受与队员们庆祝胜利的乐趣。以下是我们庆祝这一盛事的方式。', '', 'admin', '', '1629961191', '1629961191', 'true', '', '半夜起床看最爱的队伍比赛，享受与队员们庆祝胜利的乐趣。', '如何,举办,一场,胜利,的,观赛,派对,世界杯,', '197', '1629961191', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('2', '7', '设计师的秘诀：浴室用架展示', '/storage/images/20210826/1-1F6151253340-L.jpg', '', '想给浴室注入一抹清新活力？清新怡人的墙面展示是个绝佳方案。以下建议来自我们的设计师Amanda，可以帮助你设计出理想的墙面展示。', '', 'admin', '', '1629961191', '1629961191', 'true', '', '想给浴室注入一抹清新活力？清新怡人的墙面展示是个绝佳方案。', '设计师,的,秘诀,浴室,用架,展示,想,给,浴室,', '147', '1629961191', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('3', '7', '瑞典的手工艺传统历史悠久', '/storage/images/20210826/1-1F6151254580-L.jpg', '', '瑞典室内设计师Lena Larsson提出“ALLRUMMET”的概念，旨在为整个家庭打造一个多功能的家。<br />\r\n无论全家人想要聚在一起，还是各自忙碌，能够迅速将东西整理得井井有条，将带来极大便利。如果你想将各种杂物隐藏起来，让一切井然有序，S&Auml;LLSKAP 赛索玻璃柜门储物柜是理想的选择。 ', '', 'admin', '', '1629961191', '1629961191', 'true', '', '坚实耐用的实心松木桌子和凳子，在用餐时使用，满足日常生活需求。', '瑞典,的,手工艺,传统,历史悠久,瑞典,室内,', '138', '1629961191', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('4', '8', '与你更柔软的一面亲密接触', '/storage/images/20210826/1-1F6151245560-L.jpg', '', '我们致力于打造美观又柔软的浴室纺织品，即使在经过无数次泡泡浴后也让您感到它的柔软。因为包裹在干净柔软的毛巾里或踩在温暖的浴室垫上，是件多么舒适惬意的事情。我们认为这些时刻值得好好享受。', '', 'admin', '', '1629961195', '1629961195', 'true', '', '我们致力于打造美观又柔软的浴室纺织品。', '与你,更,柔软,的,一面,亲密,接触,我们,致力于,', '133', '1629961195', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('5', '8', '坐具灵感，找到全新舒适座椅', '/storage/images/20210826/1-1F615124F50-L.jpg', '', '花一点时间尽情休闲放松是生活中一种简单的快乐。这正是我们打造柔软舒适的沙发的原因。还有可以让您“深陷”其中的扶手椅。因为如果您有机会坐下来放松休闲时，您需要担心的唯一的事情就是谁来填满零食碗。', '', 'admin', '', '1629961195', '1629961195', 'true', '', '花一点时间尽情休闲放松是生活中一种简单的快乐。', '坐具,灵感,找到,全新,舒适,座椅,花,一点,时间,', '56', '1629961195', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('6', '8', '即刻享受休闲毯带来的舒适', '/storage/images/20210826/1-1F615124Z20-L.jpg', '', '无论搭在肩上还是沙发扶手上，GRIND毯子和休闲毯都能让您的居室更加温暖。GRIND休闲毯能够为居室增添色彩、纹理，或是让人忍不住想要将其裹在身上。它们能让老旧的扶手椅焕然一新，改变整个居室的风格，展现您的另一面。<img src=\"/storage/images/20210826/12502T0H-0.jpg\" /><img src=\"/storage/images/20210826/12502W218-1.jpg\" /><img src=\"/storage/images/20210826/12502S3J-2.jpg\" /> ', '', 'admin', '', '1629961195', '1629961195', 'true', '', '无论搭在肩上还是沙发扶手上，GRIND毯子都能让居室更加温暖。', '即刻,享受,休闲,毯,带来,的,舒适,无论,搭,在,', '104', '1629961195', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('7', '9', '五种装饰品助你打造精彩派对', '/storage/images/20210826/1-1F615123Z80-L.jpg', '', '把日常住所变为超级时尚的派对现场，你准备好了吗？我们请设计师Amanda Rodriguez分享了她最喜欢的五种方法，帮助你为婚礼、派对和其他庆祝场合制作能够营造相应氛围的装饰品。', '', 'admin', '', '1629961200', '1629961200', 'true', '', '把日常住所变为超级时尚的派对现场，你准备好了吗？', '五种,装饰品,助你,打造,精彩,派对,把,日常,', '189', '1629961200', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('8', '9', '4种方法帮助你留出私人空间', '/storage/images/20210826/1-1F6151240250-L.jpg', '', '你一定有过这种经历。在阳光明媚的日子，当你去户外放松时，发现跟你有同样想法的人不计其数。人群异常拥挤时，即使最善交际的人也会渴望拥有专属的私人空间。但是，你也不用躲进你家后院。创意团队几经尝试，为你找到了户外专属空间（至少在白天）。', '', 'admin', '', '1629961200', '1629961200', 'true', '', '你也不用躲进你家后院。创意团队几经尝试，为你找到了户外专属空间。', '4种,方法,帮助,你,留出,私人空间,你,一定,', '70', '1629961200', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('9', '9', '冲泡一杯完美咖啡的小诀窍', '/storage/images/20210826/1-1F6151243140-L.jpg', '', '你如何选择咖啡？是选择简单的浓香咖啡粉，还是现磨咖啡，抑或是加入适量肉桂的泡沫咖啡？咖啡爱好者都喜欢 P&Aring;T&Aring;R 巴塔尔——现在商场有售的新款100%有机咖啡产品系列，于是，我们邀请前咖啡师Shalony分享了她的冲泡秘诀。 <img src=\"/storage/images/20210826/124415J25-0.jpg\" /> <span style=\"font-weight: bold;display: block;text-align: center;\">“有一杯咖啡在手，我就会感到很高兴。早上6:30，取出马克杯，泡上一杯咖啡，细细品味——全新的一天由此开始。”</span> <span style=\"display: block;text-align: center;\">Shalon，设计人、教师和前咖啡师，瑞典</span>', '', 'admin', '', '1629961200', '1629961200', 'true', '', '你如何选择咖啡？我们邀请前咖啡师Shalony分享了她的冲泡秘诀。', '冲泡,一杯,完美,咖啡,的,小,诀窍,你,如何,', '188', '1629961200', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('10', '10', '浴室里的轻奢风设计', '/storage/images/20210826/banner1.jpg', '', '', '', '', '', '1629962261', '1629962261', 'true', '', '好的设计让生活变得更好。这里是浴室新的开始。', '', '0', '1629962261', '0', '0', '0', '100', '', 'http://www.rrzcms.com');
INSERT INTO `rrz_articles` VALUES ('11', '10', '有一百把北欧椅，就有一百个故事', '/storage/images/20210826/banner2.jpg', '', '', '', '', '', '1629962302', '1629962302', 'true', '', '', '', '0', '1629962302', '0', '0', '0', '100', '', 'http://www.rrzcms.com/');
INSERT INTO `rrz_articles` VALUES ('12', '10', '卧室现代简约风 白色系家居设计', '/storage/images/20210826/banner3.jpg', '', '', '', '', '', '1629962336', '1629962336', 'true', '', '这里不仅有新产品，更有居家新创意和生活新方式！', '', '0', '1629962336', '0', '0', '0', '100', '', 'http://www.rrzcms.com/');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某官网', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20210826/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20210826/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2050 某某公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '高端响应式品牌家居装饰设计人人站梦模板(自适应手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'hide_plugin', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '1e71ca64986dec963bd66fb3663077d3', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某有限公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '某某省某某市某某开发区', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '39.903970449129694,116.39786991534426', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|金牌|名牌|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|畅销|全效|标杆|精确|仅此|遥遥|高档|真皮|超赚|精准|指定|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '2', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '3', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', 'http://www.rrzcms.com/Public/images/wxaqrrrz.png', 'webinfo', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线留言', 'a:4:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"称呼\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"邮箱\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:9:\"手机号\";s:8:\"required\";s:1:\"1\";}i:3;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:13:\"想法/意见\";s:8:\"required\";s:1:\"1\";}}', '1629967048', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';

-- -----------------------------
-- Records of `rrz_goods`
-- -----------------------------
INSERT INTO `rrz_goods` VALUES ('1', '斯德哥尔摩休闲沙发', '', '1', '0', '/storage/images/20210826/1-1F6152315490-L.jpg', '/storage/images/20210826/1-1F6152315490-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '125', '100', '', 'true', '', '', '斯德,哥尔,摩,休闲,沙发,斯德,哥尔,摩,休闲,');
INSERT INTO `rrz_goods` VALUES ('2', '汉思蓝色沙发', '', '1', '0', '/storage/images/20210826/1-1F6152316350-L.jpg', '/storage/images/20210826/1-1F6152316350-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '134', '100', '', 'true', '', '', '汉思,蓝色,沙发,汉思,蓝色,沙发,');
INSERT INTO `rrz_goods` VALUES ('3', '丹麦印象风情布艺沙发', '', '1', '0', '/storage/images/20210826/1-1F615231F60-L.jpg', '/storage/images/20210826/1-1F615231F60-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '150', '100', '', 'true', '', '', '丹麦,印象,风情,布艺沙发,丹麦,印象,风情,');
INSERT INTO `rrz_goods` VALUES ('4', '诺姆拉休闲椅', '', '1', '0', '/storage/images/20210826/1-1F615231J50-L.jpg', '/storage/images/20210826/1-1F615231J50-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '190', '100', '', 'true', '', '', '诺姆拉,休闲椅,诺姆拉,休闲椅,');
INSERT INTO `rrz_goods` VALUES ('5', '斯德哥尔摩高背扶手椅', '', '1', '0', '/storage/images/20210826/1-1F615231Q50-L.jpg', '/storage/images/20210826/1-1F615231Q50-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '164', '100', '', 'true', '', '', '斯德,哥尔,摩,高背,扶手,椅,斯德,哥尔,摩,');
INSERT INTO `rrz_goods` VALUES ('6', '简约灰色沙发系列', '', '1', '0', '/storage/images/20210826/1-1F615231U40-L.jpg', '/storage/images/20210826/1-1F615231U40-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '195', '100', '', 'true', '', '', '简约,灰色,沙发,系列,简约,灰色,沙发,系列,');
INSERT INTO `rrz_goods` VALUES ('7', '诺斯伯休闲沙发系列', '', '1', '0', '/storage/images/20210826/1-1F6152319530-L.jpg', '/storage/images/20210826/1-1F6152319530-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '146', '100', '', 'true', '', '', '诺斯,伯,休闲,沙发,系列,诺斯,伯,休闲,沙发,');
INSERT INTO `rrz_goods` VALUES ('8', '索德汉浅灰三人沙发', '', '1', '0', '/storage/images/20210826/1-1F6152320290-L.jpg', '/storage/images/20210826/1-1F6152320290-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '111', '100', '', 'true', '', '', '索德,汉,浅灰,三人,沙发,索德,汉,浅灰,三人,');
INSERT INTO `rrz_goods` VALUES ('9', '居家搭配，完美生活', '', '1', '0', '/storage/images/20210826/1-1F6152321120-L.jpg', '/storage/images/20210826/1-1F6152321120-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961239', '0', '0', '0', '0', '178', '100', '', 'true', '', '', '居家,搭配,完美,生活,居家,搭配,完美,生活,');
INSERT INTO `rrz_goods` VALUES ('10', '北欧格调窗台沙发', '花一点时间尽情休闲放松是生活中一种简单的快乐。这正是我们打造柔软舒适的沙发的原因。还有可以让您深陷其中的扶手椅。因为如果您有机会坐下来放松休闲时，您需要担心的唯一', '1', '0', '/storage/images/20210826/1-1F6152322090-L.jpg', '/storage/images/20210826/1-1F6152322090-L.jpg,/storage/images/20210826/1-1F6152315490-L.jpg,/storage/images/20210826/1-1F615231U40-L.jpg,/storage/images/20210826/1-1F6152320290-L.jpg,/storage/images/20210826/1-1F6152319530-L.jpg,/storage/images/20210826/categories1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>花一点时间尽情休闲放松是生活中一种简单的快乐。这正是我们打造柔软舒适的沙发的原因。还有可以让您“深陷”其中的扶手椅。因为如果您有机会坐下来放松休闲时，您需要担心的唯一的事情就是谁来填满零食碗。<img src=\"/storage/images/20210826/1-1F6152321120-L.jpg\"/><img src=\"/storage/images/20210826/1-1F6152320290-L.jpg\"/><img src=\"/storage/images/20210826/1-1F6152319530-L.jpg\"/><img src=\"/storage/images/20210826/2323331222-3.jpg\"/> <em><img src=\"/storage/images/20210826/1-1F615231U40-L.jpg\"/></em> <span style=\"display: block;text-align: center;\">汉林比简约布艺沙发<br/></span></p>', '', '0', '1629961239', '0', '0', '0', '0', '183', '100', '', 'true', '', '花一点时间尽情休闲放松是生活中一种简单的快乐。这正是我们打造柔软舒适的沙发的原因。还有可以让您深陷其中的扶手椅。因为如果您有机会坐下来放松休闲时，您需要担心的唯一', '北欧,格调,窗台,沙发,花,一点,时间,尽情,休闲,');
INSERT INTO `rrz_goods` VALUES ('11', '巴洛克风情床品六件套', '', '2', '0', '/storage/images/20210826/12502S3J-2.jpg', '/storage/images/20210826/12502S3J-2.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961247', '0', '0', '0', '0', '142', '100', '', 'true', '', '', '巴,洛克,风情,床品,六,件套,巴,洛克,风情,');
INSERT INTO `rrz_goods` VALUES ('12', '提赛尔浅色床品系列', '', '2', '0', '/storage/images/20210826/1-1F6152314290-L.jpg', '/storage/images/20210826/1-1F6152314290-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961247', '0', '0', '0', '0', '188', '100', '', 'true', '', '', '提,赛尔,浅色,床品,系列,提,赛尔,浅色,床品,');
INSERT INTO `rrz_goods` VALUES ('13', '纯棉浴巾白色系列', '', '3', '0', '/storage/images/20210826/1-1F6152310290-L.jpg', '/storage/images/20210826/1-1F6152310290-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961254', '0', '0', '0', '0', '153', '100', '', 'true', '', '', '纯棉,浴巾,白色,系列,纯棉,浴巾,白色,系列,');
INSERT INTO `rrz_goods` VALUES ('14', '浴室纺织品白色系列', '', '3', '0', '/storage/images/20210826/1-1F6152311060-L.jpg', '/storage/images/20210826/1-1F6152311060-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961254', '0', '0', '0', '0', '189', '100', '', 'true', '', '', '浴室,纺织品,白色,系列,浴室,纺织品,白色,');
INSERT INTO `rrz_goods` VALUES ('15', '特瑞拉浴巾', '', '4', '0', '/storage/images/20210826/1-1F6151352340-L.jpg', '/storage/images/20210826/1-1F6151352340-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<img src=\"/storage/images/20210826/1-1F615135U0910.jpg\" /><img src=\"/storage/images/20210826/1-1F61514013J61.jpg\" /><img src=\"/storage/images/20210826/1-1F61514015S00.jpg\" /><img src=\"/storage/images/20210826/1-1F615140221535.jpg\" />', '', '0', '1629961262', '0', '0', '0', '0', '123', '100', '', 'true', '', '', '特,瑞拉,浴巾,特,瑞拉,浴巾,');
INSERT INTO `rrz_goods` VALUES ('16', '奥朗利亚休闲毯', '', '4', '0', '/storage/images/20210826/1-1F6152305380-L.jpg', '/storage/images/20210826/1-1F6152305380-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961262', '0', '0', '0', '0', '175', '100', '', 'true', '', '', '奥朗,利亚,休闲,毯,奥朗,利亚,休闲,毯,');
INSERT INTO `rrz_goods` VALUES ('17', '索菲亚纯色系列布料', '', '4', '0', '/storage/images/20210826/1-1F6152306340-L.jpg', '/storage/images/20210826/1-1F6152306340-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961262', '0', '0', '0', '0', '90', '100', '', 'true', '', '', '索菲亚,纯色,系列,布料,索菲亚,纯色,系列,');
INSERT INTO `rrz_goods` VALUES ('18', '奥荷赛运动休闲毯', '', '4', '0', '/storage/images/20210826/1-1F615230H90-L.jpg', '/storage/images/20210826/1-1F615230H90-L.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961262', '0', '0', '0', '0', '185', '100', '', 'true', '', '', '奥荷,赛,运动休闲,毯,奥荷,赛,运动休闲,毯,');
INSERT INTO `rrz_goods` VALUES ('19', '威特摩蓝色休闲毯', '', '4', '0', '/storage/images/20210826/12502W218-1.jpg', '/storage/images/20210826/12502W218-1.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '', '', '0', '1629961262', '0', '0', '0', '0', '106', '100', '', 'true', '', '', '威特,摩,蓝色,休闲,毯,威特,摩,蓝色,休闲,毯,');

-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';

-- -----------------------------
-- Records of `rrz_goods_cat`
-- -----------------------------
INSERT INTO `rrz_goods_cat` VALUES ('1', '0', '沙发和扶手椅', '牢固 · 优雅 · 舒适，不懈的追求与设计', '', '0', '/storage/images/20210826/categories1.jpg', '1', '1', '1', '1001', '', '', '', '', '', '', '1629964639');
INSERT INTO `rrz_goods_cat` VALUES ('2', '0', '床品系列', '就在这里，每件床品都独具特色', '', '0', '/storage/images/20210826/categories2.jpg', '2', '1', '2', '1002', '', '', '', '', '', '', '1629964664');
INSERT INTO `rrz_goods_cat` VALUES ('3', '0', '浴室家居与香薰', '在这里，尽情享受专属于你的宁静时刻', '', '0', '/storage/images/20210826/categories3.jpg', '3', '1', '3', '1003', '', '', '', '', '', '', '1629964679');
INSERT INTO `rrz_goods_cat` VALUES ('4', '0', '纺织品', '柔软蓬松的纺织品，让家充满生机', '', '0', '/storage/images/20210826/categories4.jpg', '4', '1', '4', '1004', '', '', '', '', '', '', '1629964692');

-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', 'http://weibo.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244551', '1627543210');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', '', 'shouye', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', '', 'guanyuwomen', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '品牌故事', '', 'pinpaigushi', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '产品中心', 'PRODUCT DISPLAY', 'chanpinzhongxin', '0', '4', '1', '/cats.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '新闻资讯', '', 'xinwenzixun', '0', '5', '1', '/node/3.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '联系我们', '', 'lianxiwomen', '0', '6', '1', '/node/4.html', '6', '1006', 'false', '');
