# 1.5.2(2024.10.11)

## 功能

1. server酱<sup>3</sup>支持
2. 弹幕转换支持不保存屏蔽弹幕（仅支持部分，不支持主动屏蔽的弹幕） [#31](https://github.com/renmu123/biliLive-tools/issues/31)
3. B站上传选项支持可见范围参数

## 优化

1. 弹幕转换设置时的分辨率参数在开启“自适应分辨率”参数时仍可修改

## Bug修复

1. 修复某些情况下上传视频时任务状态持续为运行中 [#30](https://github.com/renmu123/biliLive-tools/issues/30)
2. 修复下载视频时默认视频标题中非法字符串未被过滤的bug
3. 修复上传时部分错误未被重试

# 1.5.1

## Bug修复

1. 修复host为0.0.0.0情况请求错误的bug [#23](https://github.com/renmu123/biliLive-tools/issues/23)

# 1.5.0

## CLI

由于我对CLI功能的不重视，~~大概也没人用~~，导致年久失修~~之后我一定好好测试~~，请升级的用户按照最新[文档](https://github.com/renmu123/biliLive-tools/tree/master/packages/CLI)重新进行配置并测试

**`binFolder`参数已被移除，请为可执行文件单独配置**

## 功能

1. B站上传优化，分P分开上传，支持上传重试、重试延迟、线路、并发、同时上传限制、自动评论检查间隔选项，暂时没有添加如手动重试等更多控制功能，如果有bug请反馈
2. webhook标题支持ejs模板引擎，具体使用见文档 ([#21](https://github.com/renmu123/biliLive-tools/issues/21))
3. 新增log直接查看功能
4. ffmpeg配置增加缩放算法，分辨率默认值修改为2880x1620
5. 缩放支持先缩放后渲染和先渲染后缩放两种模式
6. 用户页增加B站帐号过期时间
7. 弹幕过滤
   - 目前支持三种屏蔽方式，分别是弹幕内容，uid，用户名，需以**英文逗号**分隔
   - 弹幕内容：部分匹配，包含sc内容
   - uid：全匹配，格式为<10995238>，弹幕姬用户注意，即是你开启了记录raw，出于性能原因，此过滤也是无法使用的，请使用用户名替代
   - 用户名：全匹配，格式为[暮色312]

## 优化

1. 应用关闭时，对临时数据进行清理
   ~~切片时支持不选中弹幕分割~~忘记做了
2. 手动取消任务时不会触发错误事件
3. 斗鱼弹幕元数据增加`video_start_time`参数
4. webhook标题支持预览输出
5. 移除完成后删除源文件和完成后打开文件夹功能，由于这两个选项在各个页面中或无效或存在问题
6. 增加设置栏目
7. 移除弹幕转换的"同一用户相同礼物自动合并的时间窗"功能，上游[移除](https://github.com/hihkm/DanmakuFactory/pull/89)
8. 优化弹幕判空函数

## 其他

**将部分函数使用http协议重构，如果有bug请反馈，为之后的web版做准备**

## Bug修复

1. 修复断播续传设置关闭失效的bug
2. 修复弹幕姬未保存raw的sc价格，[上游修复](https://github.com/hihkm/DanmakuFactory/pull/91)
3. 修复某些情况下的缓冲区溢出，[上游修复](https://github.com/hihkm/DanmakuFactory/pull/94)

# 1.4.0

## 功能

1. 上传配置支持话题
2. webhook支持只在某段时间执行上传操作
3. 为首页增加预览窗弹框，**预览仅供参考，以实际渲染为主！**
4. 切片功能页支持高能弹幕以及sc分析，xml和ass均支持高能进度条，但是两者在不同的配置下会不同，两者的解析有不少区别
5. 为工具页面的确认按钮提供快捷键“ctrl+enter”快捷键操作
6. 优化设置中的可执行文件路径设置，增加选项是否开启自定义，默认为关，关了则使用软件默认路径，**之前有过自定义的需要手动启动**
7. 支持压缩包便携模式，数据保存在可执行文件路径下，在可执行文件所在文件夹创建一个`portable`文件，无拓展名如`.txt`
8. 支持斗鱼录播下载
9. 切片支持弹幕搜索

## 优化

1. 续传支持翻页
2. 优化文件拖拽栏拖拽
3. 错误推送事件会返回错误信息了
4. 当设置任务数量限制后，每当有任务暂停时，未开始任务会自动开始
5. 优化部分函数下读取视频时长失败时的错误处理
6. 优化弹幕姬弹幕大文件下高能弹幕的性能
7. 优化B站上传的重试机制

## Bug修复

1. 修复某些xml文件高能弹幕解析错误的bug
2. 修复DanmakuFactory的blrec价格解析错误，[由上游修复](https://github.com/hihkm/DanmakuFactory/pull/85)
3. 修复DanmakuFactory某些情况下转换ass内容错误，[由上游修复](https://github.com/hihkm/DanmakuFactory/pull/87)
4. 修复DanmakuFactory sc文本存在`\n`时，渲染ass错误，由[上游修复](https://github.com/renmu123/DanmakuFactory/commit/0df54629b382b3398bcea2be8a06e6e45f241ba3)
5. 修复推送成功事件被错误设置为开始事件的bug
6. 修复登录二维码第二次使用时错误使用上一个的bug

# 1.3.0

## DanmakuFactory性能优化

**win版本的DanmakuFactory并非使用官方项目，而是使用[自编译版本](https://github.com/renmu123/DanmakuFactory/tree/test)，大幅优化录播姬弹幕的转换速度**

## 切片工具页

很高兴给大家带来这个功能，这个功能是在软件一开始就被定下来制作的功能，由于某些原因~~懒~~一直被拖到了现在，这个版本终于和大家见面了，功能本身并不复杂，一些UI如何实现比较费我的脑子。

支持[lossless-cut](https://github.com/mifi/lossless-cut)项目导入直接读取~~使用该软件的用户有福了~~
，读取后可以针对视频和弹幕来进行局部渲染，如果你不使用该软件，我们页支持在软件中直接增加片段，以及支持ass在视频中渲染，本来不想做这个功能的，因为losslese-cut的体验已经非常优秀了，但写着写着就写完了，该工具页也带来了快捷键的支持。

你也可以在本软件中编辑后保存到llc项目，便于你进行二次编辑。

### 我们支持哪些快捷键

- `ctrl+s` 保存到llc项目
- `ctrl+shift+s` 另存为llc项目
- `ctrl+enter` 导出
- `ctrl+z` 撤销
- `ctrl+shift+z` 重做
- `I` 在当前时间开始当前片段
- `O` 在当前时间结束当前片段
- `up` 上一个片段
- `down` 下一个片段
- `del` 删除片段
- `space` 播放/暂停
- `ctrl+left` 后退1秒
- `ctrl+right` 前进1秒

## 功能

1. 首页工具栏支持续传
2. 增加切片工具页
   1. 支持导入lossless-cut项目文件
   2. 支持ctrl+s,ctrl+shift+s,ctrl+z,ctrl+shif+z,f2等快捷键，更多见文档
   3. 支持编辑后保存lossless-cut项目文件
   4. 支持局部渲染
3. qsv支持预设参数
4. 弹幕设置-不透明度设置修改为百分比参数，原参数弃用，**请使用者进行手动迁移修改**
5. 支持配置导入和导出
6. 弹幕转换支持“显示用户名”参数

## 优化

1. 优化弹幕黑名单使用原生实现
2. 优化webhook视频标题输入变量优化
3. 为应用添加最小宽高
4. 重构webhook方便写单元测试
5. 队列页面更好的错误显示

## Bug修复

1. 修复另存为ffmepg的cpu默认预设后切换其他部分编码器会转换失败的bug
2. 修复ffmpeg批量添加时最大任务设置可能失败的bug
3. 修复工具页切换时页面未被缓存的bug
4. 修复某些情况下无法修改稿件简介的[bug](https://github.com/renmu123/biliLive-tools/issues/4#issuecomment-2233626419)
5. 修复多P上传的暂停错误，由[上游修复](https://github.com/renmu123/biliAPI/commit/b07b25a2a7c61177abdc0d5b893e610d96b56ef1)
6. 修复上传暂停后进度计算错误，由[上游修复](https://github.com/renmu123/biliAPI/commit/c5106bc8710d950590878f3874323673414c5055)
7. 修复DanmakuFactory可执行路径存在空格时无法处理的bug
8. 修复文件拖拽栏可以选择任意文件的bug

# 1.2.0

## 功能

1. 弹幕密度增加按条数配置
2. 转封装页面升级为转码页面，支持对视频进行重编码
3. 版本更新后首次进入出现更新日志

## 优化

1. 工具页UI优化
2. ffmpeg预设增加copy预设
3. 弹幕压制时如果视频编码器为copy则报错
4. 弹幕配置的“简易模式”可以被记住

## Bug修复

1. 修复多个b站账户同时操作时cookie有概率混淆 [#16](https://github.com/renmu123/biliLive-tools/issues/16)
2. 修复“断播续传”与“使用直播间封面”功能同时使用时，“使用直播间封面”功能失效的bug [#17](https://github.com/renmu123/biliLive-tools/issues/17)
3. 修复webhook增加房间时保存了额外不必要数据的bug
4. 修复“打开稿件”按钮错误的bug

# 1.1.0

## 功能

1. ntfy推送支持
2. 系统推送支持，仅限app,CLI无法使用
3. webhook支持"不压制后处理"
4. 新增对ffmepg 编码器copy参数的支持
5. 新增对ffmepg audio参数的支持
6. webhook上传标题支持`{{HH}}``{{mm}}``{{ss}}`小时，分钟，秒格式化字段
7. Linux下的zip包支持

## 优化

1. 弹幕转换&转封装保存到特定文件夹时验证文件夹是否存在
2. 修改菜单栏展开时占据的空间，展开状态可以被记住

## Bug修复

1. 修复webhook弹幕转换后未清理临时ass文件的Bug
2. 修复webhook中“使用文件作为文件名”失效的bug

# 1.0.0

**整体架构调整，为支持CLI以及网页版做准备，如果有任何bug请及时反馈**

## 开发者的屁话

经过的大半年的开发，这个软件总算进入了1.0版本，时间是过得真快啊，我推得某些V都因为某些原因不看了，我也用不着传录播了，自己用得次数反而变少（笑），只是偶尔传传自己的录播，都怪B站屎一样的上传系统。

感谢那些帮助软件迭代开发的用户，我也希望这个软件可以帮助到部分有需要的人，减少一点做录播的门槛，，节约些许时间，但请让我知道你们正在使用本软件，无论是B站带上软件tag还是赞助我[爱发电](https://afdian.net/a/renmu123) 、[B站充电](https://space.bilibili.com/10995238)还是关注[我](https://space.bilibili.com/10995238)

接下来谈一下这个项目之后可能的需求，优先会做我自己的需求~~已经没啥需求了~~，如果你有什么需求，可以提issue，如果你不提那我肯定看不到  
~~1. 我一直很想做的是根据弹幕出现频次做切片功能，但是因为我不切片了，所以这个功能被鸽了~~
~~2. web版的支持以及cli的扩充，这个需求不有趣，所以看心情~~

1. 批量压制转码工具页，UI已经脑补完了
2. 斗鱼录播下载，很奇怪市面上竟然没有类似的工具
3. srt ai翻译，单纯是为我自己偶尔的烤肉

## webhook端点修改

**webhook的请求端点修改，请使用者进行迁移**
B站录播姬：`/webhook`修改为`/webhook/bililiverecorder`  
blrec：`/blrec`修改为`/webhook/blrec`  
自定义：`/custom`修改为`/webhook/custom`

## CLI的使用

CLI是GUI的拓展，使用前需要设置相关目录，由于配置文件很多且复杂，推荐在GUI中生成并进行修改配置后复制到CLI所配置的目录，或直接将目录设置为GUI的配置目录。  
暂时只支持webhook相关的指令，也即启动webhook server，可以避免启动electron带来的消耗。

**CLI版本暂时不支持删除到回收站，高能进度条功能**

## 最大任务数的相关说明

1. 目前只支持ffmepg任务最大任务数，可以在“设置-任务-ffmpeg最大任务数”中进行设置，默认为不限制
2. 手动暂停的任务不会被自动启动
3. 当任务暂停时，不会有任务被自动启动，也就是说只有当任务完成或者失败时才会自动启用下一个未开始的任务
4. 高能进度条任务会自动进行，因为速度会很快

## 特性

1. 为文件选择栏增加更多功能
2. 暗色模式支持
3. 视频预设增加“高级选项”参数，支持自定义ffmpeg输出参数，libsvtav1高级参数默认为`-svtav1-params tune=0`，libsvtav1支持10bit参数，qsv支持ICQ模式
4. cli支持
5. ffmpeg任务支持设置最大任务数
6. 为ffmpeg任务在“中止”操作时添加“保存进度”选项， **默认不保存，之前行为为默认保存**
7. 为弹幕转换增加屏蔽词功能，如果出现开启后无法转换的情况请反馈
8. 弹幕转换任务支持取消操作
9. 新增 `danmakuFactory路径`、`port`、`host`配置，webhook服务器自启动，默认为18010端口
10. 新增 `/webhook/bililiverecorder` 、`/webhook/blrec`、`/webhook/custom` webhook端点，移除`/webhook`、`/blrec`、`/custom`端点

## 优化

1. ffmpeg 版本升级至7.0
2. 登录优化（退出账号后默认使用第一个账号）
3. 修改ffmpeg预设中cbr名称为“平均比特率”
4. server酱的key输入框type设置为password
5. 修改视频合并的进度条计算，现改为使用时间长度计算，由于ffmpeg7.0中合并时frame参数不见了
6. 修改上传参数的排序，尽量与B站web端保持一致
7. 优化webhook上传后aid查询
8. 交换“中止”和“删除记录”的icon
9. 为部分弹框增加“不再提示”按钮
10. 在webhook弹幕转换时复制输入文件到临时文件夹来避免某些情况下danmafactory读取文件失败，比如文件名有emoji
11. hvenc下cq**默认值修改为28**，**使用的是-rc vbr而非-rc constqp**

## Bug修复

1. 修复hvenc下cq失效的bug
2. 修复hvenc下预设名称错误的bug [#13](https://github.com/renmu123/biliLive-tools/pull/13)
3. 修复libsvtav1 预设展示错误，**默认值修改为6**
4. 修复某些情况下登录后获取信息失败
5. 修改弹幕为空的判断逻辑，如果文件中存在`</d>`, `</gift>`, `</sc>`, `</guard>`任意标签则认为不为空
6. 修复blrec的webhook无法使用的bug [#15](https://github.com/renmu123/biliLive-tools/issues/15)

# 1.0.0-aplha.1

**上个版本的host设置有误，可能导致webhook无法访问，请修改为127.0.0.1（仅对本机开放），或0.0.0.0（其他机器可访问）**  
**整体架构调整，为支持CLI以及网页版做准备，如果有任何bug请及时反馈**  
**webhook的请求端点修改，请使用者尽快进行迁移，将会在1.0.0正式版中被移除**

B站录播姬：`/webhook`修改为`/webhook/bililiverecorder`  
blrec：`/blrec`修改为`/webhook/blrec`  
自定义：`/custom`修改为`/webhook/custom`

## 最大任务数的相关说明

1. 目前只支持ffmepg任务最大任务数，可以在“设置-任务-ffmpeg最大任务数”中进行设置，默认为不限制
2. 手动暂停的任务不会被自动启动
3. 当任务暂停时，不会有任务被自动启动，也就是说只有当任务完成或者失败时才会自动启用下一个未开始的任务
4. 高能进度条任务会自动进行，因为速度会很快
5. webhook中的mp4转码任务不会受限制

## CLI的使用

CLI是GUI的拓展，使用前需要设置相关目录，由于配置文件很多且复杂，推荐在GUI中生成并进行修改配置后复制到CLI所配置的目录，或直接将目录设置为GUI的配置目录。  
暂时只支持webhook相关的指令，也即启动webhook server，可以避免启动electron带来的消耗。

**CLI版本暂时不支持删除到回收站，高能进度条功能**

### 配置

使用前通过 `biliLive config gen` 生成默认配置文件，如果你已经安装客户端，相关配置会被自动设置（仅限win）

```js
{
  port: 18010, // 启动端口，如果不希望与客户端的冲突，请修改为其他端口号
  host: "127.0.0.1",  // host
  configFolder: "", // 配置文件夹，推荐在GUI中生成并进行修改配置后复制到CLI所配置的目录，可在“打开log文件夹”上一层文件夹找到
  binFolder: "",  // 二进制文件夹，如果你配置了选项，那么默认会从这个文件夹读取相关二进制文件
  ffmpegPath: "ffmpeg.exe", // 覆盖binFolder中的ffmpeg二进制路径
  ffprobePath: "ffprobe.exe",  // 覆盖binFolder中的ffprobe二进制路径
  danmakuFactoryPath: "DanmakuFactory.exe",  // 覆盖binFolder中的DanmakuFactory二进制路径
  logPath: "main.log",  // log文件路径
}
```

## 特性

1. cli支持
2. ffmpeg任务支持设置最大任务数
3. 为ffmpeg任务重在“中止”操作时添加“保存进度”选项， **默认不保存，之前行为为默认保存**
4. 主题现在可以跟着系统主题自动变化了
5. 为文件选择框增加“清空”操作

## 其他

1. 修改host默认值为 127.0.0.1
2. 修改部分深色模式的UI
3. 修改视频合并的进度条计算，现改为使用时间长度计算，由于ffmpeg7.0中合并时frame参数不见了
4. 修改上传参数的排序，尽量与B站web端保持一致

## Bug修复

1. 修复未正确记录任务相关的log
2. 修复log level未正确初始化的bug
3. 修复某些文件选择栏无法添加文件的bug
4. 修复ffmpeg 7.0版本下无法进行合并的 bug [#1265](https://github.com/fluent-ffmpeg/node-fluent-ffmpeg/pull/1265)

# 1.0.0-alpha

**本版本的host设置有误，可能导致webhook无法访问，请修改为127.0.0.1（仅对本机开放），或0.0.0.0（其他机器可访问）**

**这个版本有时间就把架构改了，经过大半年的开发，终于要进入1.0.0版本了，虽然还有好几个想做的需求没做**  
**整体架构调整，为支持CLI以及网页版做准备，如果有任何bug请及时反馈**  
**webhook的请求端点修改，请使用者尽快进行迁移，将会在1.0.0正式版中被移除**

B站录播姬：`/webhook`修改为`/webhook/bililiverecorder`  
blrec：`/blrec`修改为`/webhook/blrec`  
自定义：`/custom`修改为`/webhook/custom`

## 特性

1. 新增 `danmakuFactory路径`、`port`、`host`配置，webhook服务器自启动，默认为18010端口
2. 新增 `/webhook/bililiverecorder` 、`/webhook/blrec`、`/webhook/custom` webhook端点
3. 优化工具页的文件选择栏&部分组件UI优化
4. 暗色模式支持
5. 视频预设增加“高级选项”参数，支持自定义ffmpeg输出参数，libsvtav1高级参数默认为`-svtav1-params tune=0`，libsvtav1支持10bit参数，qsv支持ICQ模式
6. 为部分弹框增加“不再提示”按钮

## 其他

1. ffmpeg 版本升级至7.0
2. 登录优化（退出账号后默认使用第一个账号）
3. 修改ffmpeg预设中cbr名称为“平均比特率”
4. server酱的key输入框type设置为password

## Bug 修复

1. 修复hvenc下cq失效的bug，**默认值修改为28**，**使用的是-rc vbr而非-rc constqp**
2. 修复hvenc下预设名称错误的bug [#13](https://github.com/renmu123/biliLive-tools/pull/13)
3. 修复libsvtav1 预设展示错误，默认值修改为6
4. 修复某些情况下登录后获取信息失败

## 开发

1. 使用pnpm包管理器，修改架构为mono repo

# 0.13.0

**移除biliup支持**

## 特性

1. 移除biliup支持
2. 支持上传任务审核后自动评论
3. 优化下载任务选择
4. 新增最小化任务栏和关闭到任务栏选项，支持记住窗口位置和大小

## Bug修复

1. 修复某些情况下无法保存配置的bug

## 其他

1. electron 依赖升级至30版本

# 0.12.0

**预计之后的版本会移除biliup的支持，如果有还在使用的用户且认为有保留必要的，请发issue**

## 特性

1. 为通知增加测试按钮
2. 为webhook增加完成后删除文件选项
3. 支持开机自启动
4. 投稿分区修改为动态获取，支持不同分区的简介字数不同
5. 优化上传UI，支持修改分P名称以及拖动排序

## Bug fix

1. 修复高能进度配置项设置为全局失败的bug
2. 修复`nvenc`相关编码错误的默认预设参数

# 0.11.0

**预计之后的版本会移除biliup的支持，如果有还在使用的用户且认为有保留必要的，请发issue**

## 特性

1. 修改任务队列为在首页请求
2. 为不同任务增加不同的自定义参数，如下载速度，比特率，速度
3. webhook支持转封装为mp4选项
4. 弹幕压制支持文件名中带有空格的弹幕文件
5. 鼠标悬浮于进度条之上显示百分比进度
6. 上传预设合集增加“小节”，“此稿件不生成更新推送”选项、增加“二创声明”选项
7. webhook标题支持“使用文件名”选项
8. 为文件选择栏，统一增加“所有文件”选项
9. 为压制任务页面增加m4s支持
10. 房间号为空保存时增加提示

## Bug fix

1. 修复webhook中压制任务错误后状态未进行流转
2. 修复上传暂停后无法继续开始的bug
3. 修复弹幕为空时，压制失败的bug
4. 修复上传失败时，触发两次错误通知的bug

# 0.10.0

## 特性

1. 增加通知功能，支持邮件，server酱，tg bot
2. 弹幕压制支持分辨率缩放，可用于激活b站4k档位保证更高码率
3. nvidia相关编码增加cq和preset参数，以及支持硬件解码
4. 检查更新使用Chromium原生网络库，支持系统代理
5. “下载页”解析链接时增加加载过渡效果
6. 续传时添加提醒：已在合集中的稿件无法添加分P

## Bug fix

1. 修复ffmpeg设置中libsvtav1错误的预设参数
2. 修复无法为审核中的稿件续传的bug
3. 修复高能进度配置项设置为全局失败的bug

# 0.9.0

## 特性

1. 下载视频功能
2. 支持自定义webhook
3. webhook账号支持设置为无
4. 为视频合并增加默认标题
5. 部分按钮UI修改为图标
6. “打开文件夹”功能在打开时会尽可能选中文件

## Bug修复

1. 修复“弹幕转换”页面的“完成后打开文件夹”功能失效
2. 修复ffmpeg任务在暂停后删除任务后，ffmpeg进程未被释放的bug
3. 修复设置了房间号的情况下，全局上传预设为空时，不使用房间号内设置的预设的bug

# 0.8.2

## 特性

1. “压制任务”输出文件添加默认文件名
2. “压制任务”添加到队列后删除文件列表
3. 为队列添加名称筛选

## Bug fix

1. 删除“压制任务”时使用xml生成的中间临时ass文件
2. 修复“压制任务”的“移除源文件”选项为只有完成全部步骤后才会执行

# 0.8.1

**修复兼容性导致的新用户配置生成错误** 新用户请勿使用0.8.0版本

## Bug fix

1. 修复未勾选“高能进度条”时，ass文件无法用于压制的bug
2. 修复兼容性导致的新用户配置生成错误

## 特性

1. 为上传预设增加重命名操作
2. 为另存为与重命名操作增加回车快捷方式
3. 修改检查更新的代理github域名，我不D了
4. 取消ffmpeg任务的中断操作，中断操作的行为更换为中止操作

# 0.8.0

## Breaking change

webhook配置黑名单支持通配符，配置从黑名单优先修改为房间优先。  
之前为：黑名单优先，如果配置了黑名单，那么房间配置为开启也是没有效果的。  
现在修改为：房间配置优先，即如果房间配置了开启，那么即使配置黑名单也是无效的

## Bug fix

1. 修复某些情况下主页“完成后打开文件夹”选项失效
2. 修复主页弹幕预设没有“保存预设”选项
3. 修复webhook中弹幕自适应分辨率bug
4. 修复某些情况下上传预设设置错误的bug

## 特性

1. webhook支持使用直播间封面
2. 支持高能进度条
3. webhook标题支持更多参数
4. 上传预设支持合集参数
5. 优化房间配置
6. 增加录播姬工作目录可用性检查
7. 中断任务不再被认为完成状态，不会执行后续操作
8. UI优化
9. 为主页面的部分配置添加持久化

## 其他

依赖升级
UI优化

# 0.7.0

支持了非biliup上传，如需使用biliup上传，请在设置修改
房间支持单独开启关闭，已有数据默认为关，请手动开启

## 特性

1. 多账号支持
2. 移除biliup登录选项
3. 房间支持单独开启关闭，与黑名单共存
4. “断播续传”支持自定义时间间隔
5. 上传支持更多配置项，如关闭弹幕，关闭评论，开启精选评论，自制声明，开启充电面板
6. **支持非biliup上传**
7. 简介增加艾特用户功能
8. 增加赞赏功能
9. 退出时如果有任务存在增加提醒
10. 如果检测到webhook server从关闭更改为开启状态，提醒用户重启
11. 弹幕分辨率支持自适应视频分辨率

## 其他

1. 重构webhook房间配置
2. 重构配置项相关代码
3. 依赖升级

## Bug修复

1. 修复上传视频验证失效的bug

# 0.6.0

1. 支持同场直播上传到同一投稿
2. 如果预设正在被使用，删除时增加额外提醒
3. 重构弹幕预设的实现
4. 修复登录时未保存cookie的bug

# 0.5.0

1. 优化webhook，支持弹幕压制后上传
2. electron升级到28.0.0
3. 修复更换b站账号后cookie未刷新的问题
4. 增加非biliup实现的登录
5. 增加ffmpeg的预设设置
6. ffmpeg任务区分中断和中止操作
7. 修复弹幕密度默认设置错误
8. 修复续传视频后不提醒的bug

# 0.4.0

新增blrec的webhook支持  
增加队列页面，所有任务移入队列执行  
修复合并功能的ffmpeg参数错误  
优化压制功能  
优化合并功能的进度条计算

# 0.3.1

修复“弹幕设置-画面设置-调试”选项无法使用  
卸载时删除用户数据  
增加弹幕的预设功能  
修改ffmpeg中断信号  
修复上传预设不同步bug  
修复confirm组件的bug  
增加压制时预计剩余时间的显示

# 0.3.0

支持上传视频至b站  
支持合并视频工具  
支持选择删除文件或者删除至回收站  
增加自动更新检测

# 0.2.0

1. 打包自动化
2. 修复找不到 ffprobe 的 bug
3. 修复弹幕文件无法覆盖的 bug
4. 支持修改 ffmpeg 和 ffprobe 的可执行文件路径
5. 打包了没有 ffmpeg 和 ffprobe 可执行文件的安装包

# 0.1.0

1. 支持 Danmufactory GUI
2. 支持 ffmpeg 转封装
3. 支持视频与弹幕压制
4. 支持压制时修改 ffmpeg 部分配置项
