export const packageMap: Record<string, string> = {
  "react-dom/client": "ReactDomClient",
  "./reportWebVitals": "ReportWebVitals",
  "@refinedev/core": "RefineCore",
  "@refinedev/react-router": "RefineReactRouter",
  "@refinedev/antd": "RefineAntd",
  "@refinedev/mui": "RefineMui",
  "@refinedev/mantine": "RefineMantine",
  "@refinedev/chakra-ui": "RefineChakra",
  "@refinedev/simple-rest": "RefineSimpleRest",
  "@refinedev/react-hook-form": "RefineReactHookForm",
  "@refinedev/react-table": "RefineReactTable",
  "@refinedev/inferencer/antd": "RefineAntdInferencer",
  "@refinedev/inferencer/mui": "RefineMuiInferencer",
  "@refinedev/inferencer/mantine": "RefineMantineInferencer",
  "@refinedev/inferencer/chakra-ui": "RefineChakraInferencer",
  "@refinedev/inferencer/headless": "RefineHeadlessInferencer",
  "@refinedev/kbar": "RefineKBar",
  "@refinedev/airtable": "RefineAirtable",
  "@refinedev/appwrite": "RefineAppwrite",
  "@refinedev/hasura": "RefineHasura",
  "@refinedev/nestjsx-crud": "RefineNestjsxCrud",
  "@refinedev/nestjs-query": "RefineNestjsQuery",
  "@refinedev/strapi-v4": "RefineStrapiV4",
  "@refinedev/strapi-graphql": "RefineStrapiGraphql",
  "@refinedev/supabase": "RefineSupabase",
  "@refinedev/devtools": "RefineDevtools",
  axios: "AxiosScope",
  "@auth0/auth0-react": "Auth0ReactScope",
  "keycloak-js": "KeycloakScope",
  "@react-keycloak/web": "ReactKeycloakWebScope",
  "react-router": "ReactRouter",
  antd: "AntdCore",
  "@ant-design/icons": "AntDesignIcons",
  "@mantine/core": "MantineCore",
  "@mantine/hooks": "MantineHooks",
  "@mantine/form": "MantineForm",
  "@mantine/notifications": "MantineNotifications",
  "@emotion/react": "EmotionReact",
  "@emotion/styled": "EmotionStyled",
  "@mui/lab": "MuiLab",
  "@mui/material": "MuiMaterial",
  "@mui/material/styles": "MuiMaterialStyles",
  "@mui/icons-material": "MuiIconsMaterial",
  "@mui/x-data-grid": "MuiXDataGrid",
  // To make sure we're still able to use the old package name, we're also mapping the old package name to the related scope
  "@tabler/icons": "TablerIcons",
  "@tabler/icons-react": "TablerIcons",
  "@chakra-ui/react": "ChakraUI",
  "react-hook-form": "ReactHookForm",
  "@tanstack/react-table": "TanstackReactTable",
  "react-i18next": "ReactI18Next",
  i18next: "I18Next",
  "i18next-browser-languagedetector": "I18NextBrowserLanguageDetector",
  "i18next-xhr-backend": "I18NextXhrBackend",
  casbin: "Casbin",
  "@uiw/react-md-editor": "MDEditorNamespace",
  uuid: "UUID",
  "graphql-tag": "GraphQLTag",
  "graphql-ws": "GraphQLWS",
};

export const packageScopeMap: Record<string, RegExp> = {
  "@mui/lab": /@mui\/lab\/(.*)/,
  "@mui/material/styles": /@mui\/material\/styles\/(.*)/,
  "@mui/material": /@mui\/material\/(.*)/,
  "@mui/icons-material": /@mui\/icons-material\/(.*)/,
  "@mui/x-data-grid": /@mui\/x-data-grid\/(.*)/,
};
