import React from "react";

export const LogoIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width={168}
    height={40}
    viewBox="0 0 168 40"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M23.9975 12.3333C23.9975 14.5425 22.2066 16.3333 19.9975 16.3333C17.7884 16.3333 15.9975 14.5425 15.9975 12.3333C15.9975 10.1242 17.7884 8.33334 19.9975 8.33334C22.2066 8.33334 23.9975 10.1242 23.9975 12.3333Z"
      fill="url(#paint0_linear_934_2030)"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M13.7975 12.2C13.7975 8.77583 16.5733 6 19.9975 6C23.4217 6 26.1975 8.77583 26.1975 12.2V27.8C26.1975 31.2242 23.4217 34 19.9975 34C16.5733 34 13.7975 31.2242 13.7975 27.8V12.2ZM19.9975 7C17.1256 7 14.7975 9.32812 14.7975 12.2V27.8C14.7975 30.6719 17.1256 33 19.9975 33C22.8694 33 25.1975 30.6719 25.1975 27.8V12.2C25.1975 9.32812 22.8694 7 19.9975 7Z"
      fill="url(#paint1_linear_934_2030)"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M15.5279 1.05573C18.3431 -0.351909 21.6569 -0.351909 24.4721 1.05573L34.4721 6.05573C37.86 7.74965 40 11.2123 40 15V25C40 28.7877 37.86 32.2504 34.4721 33.9443L24.4721 38.9443C21.6569 40.3519 18.3431 40.3519 15.5279 38.9443L5.52786 33.9443C2.14002 32.2504 0 28.7877 0 25V15C0 11.2123 2.14002 7.74965 5.52786 6.05573L15.5279 1.05573ZM15.9751 1.95016C18.5088 0.683282 21.4912 0.683282 24.0249 1.95016L34.0249 6.95016C37.074 8.47468 39 11.5911 39 15V25C39 28.4089 37.074 31.5253 34.0249 33.0498L24.0249 38.0498C21.4912 39.3167 18.5088 39.3167 15.9751 38.0498L5.97508 33.0498C2.92602 31.5253 1 28.4089 1 25V15C1 11.5911 2.92602 8.47468 5.97508 6.95016L15.9751 1.95016Z"
      fill="url(#paint2_linear_934_2030)"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M15.9751 1.95016C18.5088 0.683282 21.4912 0.683282 24.0249 1.95016L34.0249 6.95016C37.074 8.47468 39 11.5911 39 15V25C39 28.4089 37.074 31.5253 34.0249 33.0498L24.0249 38.0498C21.4912 39.3167 18.5088 39.3167 15.9751 38.0498L5.97508 33.0498C2.92602 31.5253 1 28.4089 1 25V15C1 11.5911 2.92602 8.47468 5.97508 6.95016L15.9751 1.95016ZM19.9975 6C16.5733 6 13.7975 8.77583 13.7975 12.2V27.8C13.7975 31.2242 16.5733 34 19.9975 34C23.4217 34 26.1975 31.2242 26.1975 27.8V12.2C26.1975 8.77583 23.4217 6 19.9975 6Z"
      fill="url(#paint3_radial_934_2030)"
    />
    <path
      d="M52.7926 16V9.45455H54.2884V10.5455H54.3565C54.4759 10.1676 54.6804 9.87642 54.9702 9.67188C55.2628 9.46449 55.5966 9.3608 55.9716 9.3608C56.0568 9.3608 56.152 9.36506 56.2571 9.37358C56.3651 9.37926 56.4545 9.3892 56.5256 9.40341V10.8224C56.4602 10.7997 56.3565 10.7798 56.2145 10.7628C56.0753 10.7429 55.9403 10.733 55.8097 10.733C55.5284 10.733 55.2756 10.794 55.0511 10.9162C54.8295 11.0355 54.6548 11.2017 54.527 11.4148C54.3991 11.6278 54.3352 11.8736 54.3352 12.152V16H52.7926ZM60.1786 16.1278C59.5224 16.1278 58.9556 15.9915 58.4783 15.7188C58.0039 15.4432 57.6388 15.054 57.3832 14.5511C57.1275 14.0455 56.9996 13.4503 56.9996 12.7656C56.9996 12.0923 57.1275 11.5014 57.3832 10.9929C57.6417 10.4815 58.0025 10.0838 58.4656 9.79972C58.9286 9.51278 59.4727 9.36932 60.0977 9.36932C60.5011 9.36932 60.8817 9.43466 61.2397 9.56534C61.6005 9.69318 61.9187 9.89205 62.1942 10.1619C62.4727 10.4318 62.6914 10.7756 62.8505 11.1932C63.0096 11.608 63.0891 12.1023 63.0891 12.6761V13.1491H57.7241V12.1094H61.6104C61.6076 11.8139 61.5437 11.5511 61.4187 11.321C61.2937 11.0881 61.119 10.9048 60.8945 10.7713C60.6729 10.6378 60.4144 10.571 60.119 10.571C59.8036 10.571 59.5266 10.6477 59.288 10.8011C59.0494 10.9517 58.8633 11.1506 58.7298 11.3977C58.5991 11.642 58.5323 11.9105 58.5295 12.2031V13.1108C58.5295 13.4915 58.5991 13.8182 58.7383 14.0909C58.8775 14.3608 59.0721 14.5682 59.3221 14.7131C59.5721 14.8551 59.8647 14.9261 60.1999 14.9261C60.4244 14.9261 60.6275 14.8949 60.8093 14.8324C60.9911 14.767 61.1488 14.6719 61.2823 14.5469C61.4158 14.4219 61.5167 14.267 61.5849 14.0824L63.0252 14.2443C62.9343 14.625 62.761 14.9574 62.5053 15.2415C62.2525 15.5227 61.9286 15.7415 61.5337 15.8977C61.1388 16.0511 60.6871 16.1278 60.1786 16.1278ZM67.7095 9.45455V10.6477H63.8402V9.45455H67.7095ZM64.8075 16V8.83665C64.8075 8.39631 64.8984 8.02983 65.0803 7.73722C65.2649 7.4446 65.5121 7.22585 65.8217 7.08097C66.1314 6.93608 66.4751 6.86364 66.853 6.86364C67.12 6.86364 67.3572 6.88494 67.5646 6.92756C67.772 6.97017 67.9254 7.00852 68.0249 7.04261L67.718 8.2358C67.6527 8.21591 67.5703 8.19602 67.4709 8.17614C67.3714 8.15341 67.2607 8.14205 67.1385 8.14205C66.8516 8.14205 66.6484 8.21165 66.5291 8.35085C66.4126 8.48722 66.3544 8.68324 66.3544 8.93892V16H64.8075ZM68.9176 16V9.45455H70.4602V16H68.9176ZM69.6932 8.52557C69.4489 8.52557 69.2386 8.4446 69.0625 8.28267C68.8864 8.1179 68.7983 7.92045 68.7983 7.69034C68.7983 7.45739 68.8864 7.25994 69.0625 7.09801C69.2386 6.93324 69.4489 6.85085 69.6932 6.85085C69.9403 6.85085 70.1506 6.93324 70.3239 7.09801C70.5 7.25994 70.5881 7.45739 70.5881 7.69034C70.5881 7.92045 70.5 8.1179 70.3239 8.28267C70.1506 8.4446 69.9403 8.52557 69.6932 8.52557ZM73.5891 12.1648V16H72.0465V9.45455H73.521V10.5668H73.5977C73.7482 10.2003 73.9883 9.90909 74.3178 9.69318C74.6502 9.47727 75.0607 9.36932 75.5494 9.36932C76.0011 9.36932 76.3945 9.46591 76.7298 9.65909C77.0678 9.85227 77.3292 10.1321 77.5138 10.4986C77.7013 10.8651 77.7937 11.3097 77.7908 11.8324V16H76.2482V12.071C76.2482 11.6335 76.1346 11.2912 75.9073 11.044C75.6829 10.7969 75.3718 10.6733 74.9741 10.6733C74.7042 10.6733 74.4641 10.733 74.2539 10.8523C74.0465 10.9687 73.8832 11.1378 73.7638 11.3594C73.6474 11.581 73.5891 11.8494 73.5891 12.1648ZM82.2567 16.1278C81.6005 16.1278 81.0337 15.9915 80.5565 15.7188C80.082 15.4432 79.717 15.054 79.4613 14.5511C79.2056 14.0455 79.0778 13.4503 79.0778 12.7656C79.0778 12.0923 79.2056 11.5014 79.4613 10.9929C79.7198 10.4815 80.0806 10.0838 80.5437 9.79972C81.0067 9.51278 81.5508 9.36932 82.1758 9.36932C82.5792 9.36932 82.9599 9.43466 83.3178 9.56534C83.6786 9.69318 83.9968 9.89205 84.2724 10.1619C84.5508 10.4318 84.7695 10.7756 84.9286 11.1932C85.0877 11.608 85.1673 12.1023 85.1673 12.6761V13.1491H79.8022V12.1094H83.6886C83.6857 11.8139 83.6218 11.5511 83.4968 11.321C83.3718 11.0881 83.1971 10.9048 82.9727 10.7713C82.7511 10.6378 82.4925 10.571 82.1971 10.571C81.8817 10.571 81.6048 10.6477 81.3661 10.8011C81.1275 10.9517 80.9414 11.1506 80.8079 11.3977C80.6772 11.642 80.6104 11.9105 80.6076 12.2031V13.1108C80.6076 13.4915 80.6772 13.8182 80.8164 14.0909C80.9556 14.3608 81.1502 14.5682 81.4002 14.7131C81.6502 14.8551 81.9428 14.9261 82.2781 14.9261C82.5025 14.9261 82.7056 14.8949 82.8874 14.8324C83.0692 14.767 83.2269 14.6719 83.3604 14.5469C83.494 14.4219 83.5948 14.267 83.663 14.0824L85.1033 14.2443C85.0124 14.625 84.8391 14.9574 84.5835 15.2415C84.3306 15.5227 84.0067 15.7415 83.6119 15.8977C83.217 16.0511 82.7653 16.1278 82.2567 16.1278Z"
      fill="#A3ADC2"
    />
    <path
      d="M53.152 32C53.08 32 53.016 31.976 52.96 31.928C52.912 31.872 52.888 31.808 52.888 31.736V24.032C52.888 23.96 52.912 23.9 52.96 23.852C53.016 23.796 53.08 23.768 53.152 23.768H57.352C57.64 23.768 57.912 23.824 58.168 23.936C58.432 24.048 58.66 24.2 58.852 24.392C59.044 24.584 59.196 24.808 59.308 25.064C59.42 25.32 59.476 25.596 59.476 25.892V29.876C59.476 30.172 59.42 30.448 59.308 30.704C59.196 30.96 59.044 31.184 58.852 31.376C58.66 31.568 58.432 31.72 58.168 31.832C57.912 31.944 57.64 32 57.352 32H53.152ZM54.532 30.356H57.352C57.488 30.356 57.6 30.312 57.688 30.224C57.776 30.128 57.82 30.012 57.82 29.876V25.892C57.82 25.756 57.776 25.644 57.688 25.556C57.6 25.46 57.488 25.412 57.352 25.412H54.532V30.356ZM67.7112 25.16C67.7112 25.232 67.6872 25.292 67.6392 25.34C67.5912 25.388 67.5312 25.412 67.4592 25.412H63.0192V27.068H67.0392C67.1112 27.068 67.1712 27.092 67.2192 27.14C67.2752 27.188 67.3032 27.248 67.3032 27.32V28.448C67.3032 28.52 67.2752 28.584 67.2192 28.64C67.1712 28.688 67.1112 28.712 67.0392 28.712H63.0192V30.356H67.4592C67.5312 30.356 67.5912 30.384 67.6392 30.44C67.6872 30.488 67.7112 30.548 67.7112 30.62V31.736C67.7112 31.808 67.6872 31.872 67.6392 31.928C67.5912 31.976 67.5312 32 67.4592 32H61.6272C61.5552 32 61.4952 31.976 61.4472 31.928C61.3992 31.872 61.3752 31.808 61.3752 31.736V24.032C61.3752 23.96 61.3992 23.9 61.4472 23.852C61.4952 23.796 61.5552 23.768 61.6272 23.768H67.4592C67.5312 23.768 67.5912 23.796 67.6392 23.852C67.6872 23.9 67.7112 23.96 67.7112 24.032V25.16ZM74.0147 32H71.7827C71.7107 32 71.6387 31.976 71.5667 31.928C71.4947 31.88 71.4467 31.824 71.4227 31.76L69.7067 27.464C69.6747 27.4 69.6507 27.32 69.6347 27.224C69.6187 27.12 69.6107 27.032 69.6107 26.96V24.032C69.6107 23.96 69.6347 23.9 69.6827 23.852C69.7307 23.796 69.7907 23.768 69.8627 23.768H70.9907C71.0627 23.768 71.1227 23.796 71.1707 23.852C71.2267 23.9 71.2547 23.96 71.2547 24.032V26.648C71.2547 26.72 71.2627 26.804 71.2787 26.9C71.2947 26.996 71.3187 27.076 71.3507 27.14L72.6347 30.356H73.1627L74.4467 27.14C74.4787 27.076 74.5027 26.996 74.5187 26.9C74.5347 26.804 74.5427 26.72 74.5427 26.648V24.032C74.5427 23.96 74.5667 23.9 74.6147 23.852C74.6707 23.796 74.7347 23.768 74.8067 23.768H75.9347C76.0067 23.768 76.0667 23.796 76.1147 23.852C76.1627 23.9 76.1867 23.96 76.1867 24.032V26.96C76.1867 27.032 76.1787 27.12 76.1627 27.224C76.1467 27.32 76.1227 27.4 76.0907 27.464L74.3747 31.76C74.3507 31.824 74.3027 31.88 74.2307 31.928C74.1587 31.976 74.0867 32 74.0147 32ZM84.2901 23.768C84.3621 23.768 84.4221 23.796 84.4701 23.852C84.5261 23.9 84.5541 23.96 84.5541 24.032V25.16C84.5541 25.232 84.5261 25.292 84.4701 25.34C84.4221 25.388 84.3621 25.412 84.2901 25.412H82.0821V31.736C82.0821 31.808 82.0541 31.872 81.9981 31.928C81.9501 31.976 81.8901 32 81.8181 32H80.6901C80.6181 32 80.5581 31.976 80.5101 31.928C80.4621 31.872 80.4381 31.808 80.4381 31.736V25.412H78.2301C78.1581 25.412 78.0941 25.388 78.0381 25.34C77.9901 25.292 77.9661 25.232 77.9661 25.16V24.032C77.9661 23.96 77.9901 23.9 78.0381 23.852C78.0941 23.796 78.1581 23.768 78.2301 23.768H84.2901ZM90.7973 23.78C91.0933 23.78 91.3693 23.836 91.6253 23.948C91.8813 24.06 92.1053 24.212 92.2973 24.404C92.4893 24.596 92.6413 24.82 92.7533 25.076C92.8653 25.332 92.9213 25.604 92.9213 25.892V29.888C92.9213 30.176 92.8653 30.448 92.7533 30.704C92.6413 30.96 92.4893 31.184 92.2973 31.376C92.1053 31.568 91.8813 31.72 91.6253 31.832C91.3693 31.944 91.0933 32 90.7973 32H88.4573C88.1613 32 87.8853 31.944 87.6293 31.832C87.3733 31.72 87.1493 31.568 86.9573 31.376C86.7653 31.184 86.6133 30.96 86.5013 30.704C86.3893 30.448 86.3333 30.176 86.3333 29.888V25.892C86.3333 25.604 86.3893 25.332 86.5013 25.076C86.6133 24.82 86.7653 24.596 86.9573 24.404C87.1493 24.212 87.3733 24.06 87.6293 23.948C87.8853 23.836 88.1613 23.78 88.4573 23.78H90.7973ZM91.2773 25.892C91.2773 25.756 91.2293 25.644 91.1333 25.556C91.0453 25.468 90.9333 25.424 90.7973 25.424H88.4573C88.3213 25.424 88.2053 25.468 88.1093 25.556C88.0213 25.644 87.9773 25.756 87.9773 25.892V29.888C87.9773 30.024 88.0213 30.136 88.1093 30.224C88.2053 30.312 88.3213 30.356 88.4573 30.356H90.7973C90.9333 30.356 91.0453 30.312 91.1333 30.224C91.2293 30.136 91.2773 30.024 91.2773 29.888V25.892ZM99.1645 23.78C99.4605 23.78 99.7365 23.836 99.9925 23.948C100.249 24.06 100.473 24.212 100.665 24.404C100.857 24.596 101.009 24.82 101.121 25.076C101.233 25.332 101.289 25.604 101.289 25.892V29.888C101.289 30.176 101.233 30.448 101.121 30.704C101.009 30.96 100.857 31.184 100.665 31.376C100.473 31.568 100.249 31.72 99.9925 31.832C99.7365 31.944 99.4605 32 99.1645 32H96.8245C96.5285 32 96.2525 31.944 95.9965 31.832C95.7405 31.72 95.5165 31.568 95.3245 31.376C95.1325 31.184 94.9805 30.96 94.8685 30.704C94.7565 30.448 94.7005 30.176 94.7005 29.888V25.892C94.7005 25.604 94.7565 25.332 94.8685 25.076C94.9805 24.82 95.1325 24.596 95.3245 24.404C95.5165 24.212 95.7405 24.06 95.9965 23.948C96.2525 23.836 96.5285 23.78 96.8245 23.78H99.1645ZM99.6445 25.892C99.6445 25.756 99.5965 25.644 99.5005 25.556C99.4125 25.468 99.3005 25.424 99.1645 25.424H96.8245C96.6885 25.424 96.5725 25.468 96.4765 25.556C96.3885 25.644 96.3445 25.756 96.3445 25.892V29.888C96.3445 30.024 96.3885 30.136 96.4765 30.224C96.5725 30.312 96.6885 30.356 96.8245 30.356H99.1645C99.3005 30.356 99.4125 30.312 99.5005 30.224C99.5965 30.136 99.6445 30.024 99.6445 29.888V25.892ZM109.296 32H103.68C103.608 32 103.544 31.976 103.488 31.928C103.44 31.872 103.416 31.808 103.416 31.736V24.032C103.416 23.96 103.44 23.9 103.488 23.852C103.544 23.796 103.608 23.768 103.68 23.768H104.796C104.868 23.768 104.928 23.796 104.976 23.852C105.032 23.9 105.06 23.96 105.06 24.032V30.356H109.296C109.368 30.356 109.428 30.384 109.476 30.44C109.524 30.488 109.548 30.548 109.548 30.62V31.736C109.548 31.808 109.524 31.872 109.476 31.928C109.428 31.976 109.368 32 109.296 32ZM116.631 26.24C116.559 26.24 116.495 26.216 116.439 26.168C116.391 26.112 116.367 26.048 116.367 25.976V25.892C116.367 25.756 116.323 25.644 116.235 25.556C116.147 25.46 116.035 25.412 115.899 25.412H113.547C113.419 25.412 113.307 25.46 113.211 25.556C113.123 25.644 113.079 25.756 113.079 25.892V26.588C113.079 26.724 113.123 26.84 113.211 26.936C113.307 27.024 113.419 27.068 113.547 27.068H115.899C116.187 27.068 116.459 27.124 116.715 27.236C116.971 27.348 117.195 27.5 117.387 27.692C117.579 27.884 117.731 28.108 117.843 28.364C117.955 28.62 118.011 28.892 118.011 29.18V29.876C118.011 30.172 117.955 30.448 117.843 30.704C117.731 30.96 117.579 31.184 117.387 31.376C117.195 31.568 116.971 31.72 116.715 31.832C116.459 31.944 116.187 32 115.899 32H113.547C113.259 32 112.987 31.944 112.731 31.832C112.475 31.72 112.251 31.568 112.059 31.376C111.867 31.184 111.715 30.96 111.603 30.704C111.491 30.448 111.435 30.172 111.435 29.876V29.792C111.435 29.72 111.459 29.66 111.507 29.612C111.563 29.556 111.627 29.528 111.699 29.528H112.815C112.887 29.528 112.947 29.556 112.995 29.612C113.051 29.66 113.079 29.72 113.079 29.792V29.876C113.079 30.012 113.123 30.128 113.211 30.224C113.307 30.312 113.419 30.356 113.547 30.356H115.899C116.035 30.356 116.147 30.312 116.235 30.224C116.323 30.128 116.367 30.012 116.367 29.876V29.18C116.367 29.044 116.323 28.932 116.235 28.844C116.147 28.756 116.035 28.712 115.899 28.712H113.547C113.259 28.712 112.987 28.656 112.731 28.544C112.475 28.432 112.251 28.28 112.059 28.088C111.867 27.896 111.715 27.672 111.603 27.416C111.491 27.152 111.435 26.876 111.435 26.588V25.892C111.435 25.596 111.491 25.32 111.603 25.064C111.715 24.808 111.867 24.584 112.059 24.392C112.251 24.2 112.475 24.048 112.731 23.936C112.987 23.824 113.259 23.768 113.547 23.768H115.899C116.187 23.768 116.459 23.824 116.715 23.936C116.971 24.048 117.195 24.2 117.387 24.392C117.579 24.584 117.731 24.808 117.843 25.064C117.955 25.32 118.011 25.596 118.011 25.892V25.976C118.011 26.048 117.987 26.112 117.939 26.168C117.891 26.216 117.831 26.24 117.759 26.24H116.631Z"
      fill="white"
    />
    <rect x={125} y={21} width={34} height={14} rx={7} fill="#47EBEB" />
    <path
      d="M131.886 31V25.1818H134.312C134.747 25.1818 135.112 25.2434 135.406 25.3665C135.701 25.4896 135.923 25.6619 136.07 25.8835C136.22 26.1051 136.295 26.3617 136.295 26.6534C136.295 26.875 136.248 27.0729 136.156 27.2472C136.063 27.4195 135.935 27.5625 135.772 27.6761C135.609 27.7898 135.421 27.8693 135.207 27.9148V27.9716C135.442 27.983 135.658 28.0464 135.857 28.1619C136.058 28.2775 136.219 28.4384 136.34 28.6449C136.461 28.8494 136.522 29.0919 136.522 29.3722C136.522 29.6847 136.442 29.964 136.283 30.2102C136.124 30.4545 135.894 30.6477 135.593 30.7898C135.292 30.9299 134.926 31 134.496 31H131.886ZM133.292 29.8665H134.161C134.466 29.8665 134.691 29.8087 134.835 29.6932C134.98 29.5777 135.053 29.4167 135.053 29.2102C135.053 29.0606 135.018 28.9318 134.948 28.8239C134.878 28.714 134.779 28.6297 134.65 28.571C134.521 28.5104 134.367 28.4801 134.187 28.4801H133.292V29.8665ZM133.292 27.5739H134.07C134.224 27.5739 134.36 27.5483 134.479 27.4972C134.599 27.446 134.692 27.3722 134.758 27.2756C134.826 27.179 134.86 27.0625 134.86 26.9261C134.86 26.7311 134.791 26.5777 134.653 26.4659C134.514 26.3542 134.328 26.2983 134.093 26.2983H133.292V27.5739ZM137.198 31V25.1818H141.255V26.3239H138.604V27.517H141.048V28.6619H138.604V29.858H141.255V31H137.198ZM141.945 26.3239V25.1818H146.863V26.3239H145.099V31H143.712V26.3239H141.945ZM148.082 31H146.57L148.533 25.1818H150.406L152.369 31H150.857L149.491 26.6477H149.445L148.082 31ZM147.88 28.7102H151.039V29.7784H147.88V28.7102Z"
      fill="#14141F"
    />
    <defs>
      <linearGradient
        id="paint0_linear_934_2030"
        x1={20}
        y1={8.5}
        x2={20}
        y2={16.5}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#47EBEB" />
        <stop offset={1} stopColor="#47EBEB" stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="paint1_linear_934_2030"
        x1={20}
        y1={6}
        x2={20}
        y2={34}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#47EBEB" />
        <stop offset={1} stopColor="#47EBEB" stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="paint2_linear_934_2030"
        x1={20}
        y1={0}
        x2={20}
        y2={40}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#47EBEB" />
        <stop offset={0.5} stopColor="#47EBEB" stopOpacity={0.5} />
        <stop offset={1} stopColor="#47EBEB" stopOpacity={0.5} />
      </linearGradient>
      <radialGradient
        id="paint3_radial_934_2030"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(20) rotate(90) scale(40)"
      >
        <stop stopColor="#47EBEB" stopOpacity={0} />
        <stop offset={0.5} stopColor="#47EBEB" stopOpacity={0.25} />
        <stop offset={1} stopColor="#47EBEB" stopOpacity={0.5} />
      </radialGradient>
    </defs>
  </svg>
);
