import {
  type DetailedHTMLProps,
  type ImgHTMLAttributes,
  useLayoutEffect,
  useRef,
} from "react";
// @ts-ignore
import DitherJS from "ditherjs";

const palette = [
  [0, 0, 0],
  [128, 0, 0],
  [0, 128, 0],
  [128, 128, 0],
  [0, 0, 128],
  [128, 0, 128],
  [0, 128, 128],
  [192, 192, 192],
  [192, 220, 192],
  [166, 202, 240],
  [42, 63, 170],
  [42, 63, 255],
  [42, 95, 0],
  [42, 95, 85],
  [42, 95, 170],
  [42, 95, 255],
  [42, 127, 0],
  [42, 127, 85],
  [42, 127, 170],
  [42, 127, 255],
  [42, 159, 0],
  [42, 159, 85],
  [42, 159, 170],
  [42, 159, 255],
  [42, 191, 0],
  [42, 191, 85],
  [42, 191, 170],
  [42, 191, 255],
  [42, 223, 0],
  [42, 223, 85],
  [42, 223, 170],
  [42, 223, 255],
  [42, 255, 0],
  [42, 255, 85],
  [42, 255, 170],
  [42, 255, 255],
  [85, 0, 0],
  [85, 0, 85],
  [85, 0, 170],
  [85, 0, 255],
  [85, 31, 0],
  [85, 31, 85],
  [85, 31, 170],
  [85, 31, 255],
  [85, 63, 0],
  [85, 63, 85],
  [85, 63, 170],
  [85, 63, 255],
  [85, 95, 0],
  [85, 95, 85],
  [85, 95, 170],
  [85, 95, 255],
  [85, 127, 0],
  [85, 127, 85],
  [85, 127, 170],
  [85, 127, 255],
  [85, 159, 0],
  [85, 159, 85],
  [85, 159, 170],
  [85, 159, 255],
  [85, 191, 0],
  [85, 191, 85],
  [85, 191, 170],
  [85, 191, 255],
  [85, 223, 0],
  [85, 223, 85],
  [85, 223, 170],
  [85, 223, 255],
  [85, 255, 0],
  [85, 255, 85],
  [85, 255, 170],
  [85, 255, 255],
  [127, 0, 0],
  [127, 0, 85],
  [127, 0, 170],
  [127, 0, 255],
  [127, 31, 0],
  [127, 31, 85],
  [127, 31, 170],
  [127, 31, 255],
  [127, 63, 0],
  [127, 63, 85],
  [127, 63, 170],
  [127, 63, 255],
  [127, 95, 0],
  [127, 95, 85],
  [127, 95, 170],
  [127, 95, 255],
  [127, 127, 0],
  [127, 127, 85],
  [127, 127, 170],
  [127, 127, 255],
  [127, 159, 0],
  [127, 159, 85],
  [127, 159, 170],
  [127, 159, 255],
  [127, 191, 0],
  [127, 191, 85],
  [127, 191, 170],
  [127, 191, 255],
  [127, 223, 0],
  [127, 223, 85],
  [127, 223, 170],
  [127, 223, 255],
  [127, 255, 0],
  [127, 255, 85],
  [127, 255, 170],
  [127, 255, 255],
  [170, 0, 0],
  [170, 0, 85],
  [170, 0, 170],
  [170, 0, 255],
  [170, 31, 0],
  [170, 31, 85],
  [170, 31, 170],
  [170, 31, 255],
  [170, 63, 0],
  [170, 63, 85],
  [170, 63, 170],
  [170, 63, 255],
  [170, 95, 0],
  [170, 95, 85],
  [170, 95, 170],
  [170, 95, 255],
  [170, 127, 0],
  [170, 127, 85],
  [170, 127, 170],
  [170, 127, 255],
  [170, 159, 0],
  [170, 159, 85],
  [170, 159, 170],
  [170, 159, 255],
  [170, 191, 0],
  [170, 191, 85],
  [170, 191, 170],
  [170, 191, 255],
  [170, 223, 0],
  [170, 223, 85],
  [170, 223, 170],
  [170, 223, 255],
  [170, 255, 0],
  [170, 255, 85],
  [170, 255, 170],
  [170, 255, 255],
  [212, 0, 0],
  [212, 0, 85],
  [212, 0, 170],
  [212, 0, 255],
  [212, 31, 0],
  [212, 31, 85],
  [212, 31, 170],
  [212, 31, 255],
  [212, 63, 0],
  [212, 63, 85],
  [212, 63, 170],
  [212, 63, 255],
  [212, 95, 0],
  [212, 95, 85],
  [212, 95, 170],
  [212, 95, 255],
  [212, 127, 0],
  [212, 127, 85],
  [212, 127, 170],
  [212, 127, 255],
  [212, 159, 0],
  [212, 159, 85],
  [212, 159, 170],
  [212, 159, 255],
  [212, 191, 0],
  [212, 191, 85],
  [212, 191, 170],
  [212, 191, 255],
  [212, 223, 0],
  [212, 223, 85],
  [212, 223, 170],
  [212, 223, 255],
  [212, 255, 0],
  [212, 255, 85],
  [212, 255, 170],
  [212, 255, 255],
  [255, 0, 85],
  [255, 0, 170],
  [255, 31, 0],
  [255, 31, 85],
  [255, 31, 170],
  [255, 31, 255],
  [255, 63, 0],
  [255, 63, 85],
  [255, 63, 170],
  [255, 63, 255],
  [255, 95, 0],
  [255, 95, 85],
  [255, 95, 170],
  [255, 95, 255],
  [255, 127, 0],
  [255, 127, 85],
  [255, 127, 170],
  [255, 127, 255],
  [255, 159, 0],
  [255, 159, 85],
  [255, 159, 170],
  [255, 159, 255],
  [255, 191, 0],
  [255, 191, 85],
  [255, 191, 170],
  [255, 191, 255],
  [255, 223, 0],
  [255, 223, 85],
  [255, 223, 170],
  [255, 223, 255],
  [255, 255, 85],
  [255, 255, 170],
  [204, 204, 255],
  [255, 204, 255],
  [51, 255, 255],
  [102, 255, 255],
  [153, 255, 255],
  [204, 255, 255],
  [0, 127, 0],
  [0, 127, 85],
  [0, 127, 170],
  [0, 127, 255],
  [0, 159, 0],
  [0, 159, 85],
  [0, 159, 170],
  [0, 159, 255],
  [0, 191, 0],
  [0, 191, 85],
  [0, 191, 170],
  [0, 191, 255],
  [0, 223, 0],
  [0, 223, 85],
  [0, 223, 170],
  [0, 223, 255],
  [0, 255, 85],
  [0, 255, 170],
  [42, 0, 0],
  [42, 0, 85],
  [42, 0, 170],
  [42, 0, 255],
  [42, 31, 0],
  [42, 31, 85],
  [42, 31, 170],
  [42, 31, 255],
  [42, 63, 0],
  [42, 63, 85],
  [255, 251, 240],
  [160, 160, 164],
  [128, 128, 128],
  [255, 0, 0],
  [0, 255, 0],
  [255, 255, 0],
  [0, 0, 255],
  [255, 0, 255],
  [0, 255, 255],
  [255, 255, 255],
];

const ditherjs = new DitherJS({
  step: 2,
  algorithm: "atkinson",
  palette: palette,
});

type Props = {} & DetailedHTMLProps<
  ImgHTMLAttributes<HTMLImageElement>,
  HTMLImageElement
>;

export const ImagePixelated = (props: Props) => {
  const imgRef = useRef<HTMLImageElement>(null);

  useLayoutEffect(() => {
    if (imgRef.current) {
      ditherjs.dither("#pixelated-img");
    }
  }, []);

  return (
    <img
      {...props}
      alt={props.alt || "Pixelated"}
      ref={imgRef}
      id="pixelated-img"
      crossOrigin="anonymous"
    />
  );
};
