import {
  Link,
  useMenu,
  useNavigation,
  type LayoutProps,
} from "@refinedev/core";

export const Layout: React.FC<LayoutProps> = ({ children }) => {
  const { menuItems } = useMenu();
  const { push } = useNavigation();

  return (
    <div className="flex min-h-screen flex-col max-w-7xl mx-auto pt-6">
      <div className="mb-2 border-b py-2 px-4">
        <div className="container mx-auto">
          <div className="flex items-center gap-2">
            <Link to="/">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="88"
                height="24"
                viewBox="0 0 88 24"
                fill="none"
                className="dark:text-gray-0 text-gray-900"
              >
                <path
                  fill="currentColor"
                  d="M35.477 7.168h2.17c.511 0 1.002.203 1.364.563a1.914 1.914 0 0 1 0 2.714c-.362.36-.853.563-1.364.563h-2.041a.34.34 0 0 0-.339.337v10.159a2.485 2.485 0 0 1-.735 1.765 2.511 2.511 0 0 1-1.774.73 2.516 2.516 0 0 1-1.774-.73 2.49 2.49 0 0 1-.735-1.765V6.4c0-1.962.584-3.52 1.753-4.672C33.17.575 34.816-.001 36.938 0c.72-.002 1.439.08 2.14.243.422.096.832.238 1.222.423a.588.588 0 0 1 .3.73l-.916 2.512a.58.58 0 0 1-.557.38.588.588 0 0 1-.233-.05c-.463-.2-.963-.3-1.467-.295-1.523 0-2.284.832-2.283 2.496v.399a.337.337 0 0 0 .332.33ZM67.99 14.719c0-2.58-.771-4.606-2.315-6.08-1.544-1.471-3.689-2.207-6.434-2.206-2.745 0-4.89.737-6.433 2.208-1.544 1.471-2.316 3.497-2.316 6.079v6.784c0 .662.264 1.297.735 1.765a2.516 2.516 0 0 0 3.548 0 2.49 2.49 0 0 0 .735-1.765V14.88c-.001-1.425.31-2.502.932-3.231.623-.73 1.534-1.094 2.734-1.094 1.223.005 2.151.37 2.783 1.094.633.724.949 1.802.949 3.231v6.623c0 .662.264 1.297.734 1.765.471.468 1.11.73 1.775.73h.064c.666 0 1.304-.262 1.775-.73a2.49 2.49 0 0 0 .735-1.765v-6.784Z"
                />
                <path
                  fill="currentColor"
                  fillRule="evenodd"
                  d="M86.604 16.447H75.155a.268.268 0 0 0-.262.218.264.264 0 0 0 .007.121c.26.89.82 1.664 1.588 2.189.876.618 1.969.927 3.277.927a6.688 6.688 0 0 0 2.397-.4c.234-.09.462-.196.68-.318.774-.43 1.886-.276 2.488.372l.026.03a2 2 0 0 1 .508 1.656 1.996 1.996 0 0 1-.982 1.431c-1.416.82-3.164 1.23-5.245 1.23-1.956 0-3.682-.38-5.18-1.136a8.355 8.355 0 0 1-3.473-3.153c-.815-1.343-1.222-2.868-1.222-4.576a8.76 8.76 0 0 1 1.206-4.56 8.434 8.434 0 0 1 3.314-3.168c1.405-.756 2.975-1.134 4.71-1.134 1.694 0 3.228.362 4.6 1.087a7.974 7.974 0 0 1 3.234 3.121c.783 1.354 1.174 2.928 1.174 4.72v.017a1.382 1.382 0 0 1-.43.943c-.26.247-.606.384-.966.383Zm-10.442-5.535a3.97 3.97 0 0 0-1.336 2.215.333.333 0 0 0 .328.408h7.713a.336.336 0 0 0 .326-.41 4.03 4.03 0 0 0-1.333-2.197c-.773-.649-1.716-.973-2.83-.973-1.14-.003-2.096.316-2.868.957Z"
                  clipRule="evenodd"
                />
                <path
                  fill="currentColor"
                  d="M44.602 11.838c1.054 0 1.91-.85 1.91-1.899s-.856-1.899-1.91-1.899c-1.054 0-1.909.85-1.909 1.9 0 1.048.855 1.898 1.909 1.898Z"
                />
                <path
                  fill="currentColor"
                  fillRule="evenodd"
                  d="M44.602 6.434c-.95.002-1.86.377-2.53 1.045a3.558 3.558 0 0 0-1.05 2.519v10.346c0 .945.377 1.85 1.048 2.519a3.59 3.59 0 0 0 5.064 0 3.553 3.553 0 0 0 1.05-2.519V9.998c-.002-.945-.38-1.85-1.05-2.519a3.595 3.595 0 0 0-2.532-1.045Zm0 1.068c.666 0 1.304.263 1.774.73a2.49 2.49 0 0 1 .735 1.766v10.346a2.49 2.49 0 0 1-.735 1.765 2.516 2.516 0 0 1-3.548 0 2.49 2.49 0 0 1-.735-1.765V9.998a2.485 2.485 0 0 1 .735-1.765 2.51 2.51 0 0 1 1.774-.731Z"
                  clipRule="evenodd"
                />
                <path
                  fill="currentColor"
                  d="M11.042 6.54a11.102 11.102 0 0 0-2.116 2.584c-.227.386-.43.785-.61 1.194-1.02.068-1.808.425-2.365 1.074-.622.725-.933 1.802-.933 3.231v6.88a2.49 2.49 0 0 1-.735 1.764 2.516 2.516 0 0 1-3.548 0A2.49 2.49 0 0 1 0 21.502v-7.04c0-2.58.772-4.606 2.316-6.078C3.86 6.912 6.005 6.176 8.75 6.176c.786-.005 1.572.064 2.346.206l-.054.159Z"
                />
                <path
                  fill="currentColor"
                  fillRule="evenodd"
                  d="M15.426 16.447h11.45c.359 0 .704-.137.963-.385.26-.247.413-.584.428-.941v-.017c0-1.792-.392-3.366-1.174-4.72a7.983 7.983 0 0 0-3.233-3.12c-1.373-.726-2.906-1.088-4.6-1.088-1.737 0-3.308.378-4.713 1.136a8.438 8.438 0 0 0-3.31 3.167 8.76 8.76 0 0 0-1.206 4.559c0 1.708.408 3.233 1.223 4.576a8.367 8.367 0 0 0 3.474 3.153c1.498.757 3.224 1.135 5.18 1.135 2.079 0 3.828-.41 5.245-1.229a2.008 2.008 0 0 0 .982-1.43 1.99 1.99 0 0 0-.509-1.658l-.025-.03c-.602-.647-1.714-.802-2.488-.371a5.23 5.23 0 0 1-.68.318 6.688 6.688 0 0 1-2.397.4c-1.309 0-2.401-.309-3.278-.927a4.023 4.023 0 0 1-1.589-2.189.266.266 0 0 1 .257-.339Zm-.329-3.32a3.968 3.968 0 0 1 1.336-2.215c.772-.64 1.725-.96 2.86-.957 1.115 0 2.06.324 2.832.973a4.037 4.037 0 0 1 1.336 2.198.334.334 0 0 1-.327.41h-7.71a.337.337 0 0 1-.327-.26.333.333 0 0 1 0-.15Z"
                  clipRule="evenodd"
                />
              </svg>
            </Link>

            <ul className="pt-1">
              {menuItems.map(({ name, label, icon, route }) => (
                <li key={name}>
                  <a
                    className="flex cursor-pointer flex-col items-center gap-1 capitalize hover:decoration-indigo-500 transition duration-300 ease-in-out underline"
                    onClick={() => push(route || "")}
                  >
                    {icon}
                    <span>{label ?? name}</span>
                  </a>
                </li>
              ))}
            </ul>
          </div>
        </div>
      </div>

      <div className="bg-white py-2 px-4 w-full mx-auto">{children}</div>
    </div>
  );
};
