import React from "react";

const TailzupLogo = ({ color }) => {
  const tail = {
    fontSize: "660px",
    fontWeight: "light",
  };

  return (
    <div>
      <svg
        version="1.0"
        xmlns="http://www.w3.org/2000/svg"
        width="180"
        height="auto"
        viewBox="0 0 2400 500"
        preserveAspectRatio="xMidYMid meet"
        className="logo"
      >
        <g transform="translate(0.000000,524.000000) scale(0.100000,-0.100000)">
          <path
            className="move"
            stroke={color}
            fill={color}
            d="M2705 4560 c-55 -3 -125 -14 -155 -24 -269 -85 -430 -188 -569 -361
            -68 -85 -71 -91 -117 -185 -92 -193 -89 -189 -289 -315 -190 -119 -422 -296
            -537 -408 -31 -30 -69 -75 -85 -99 -26 -41 -28 -49 -27 -153 0 -110 14 -172
            60 -272 7 -17 14 -34 14 -38 0 -13 109 -241 148 -310 77 -136 208 -289 302
            -351 144 -95 346 -142 505 -116 111 18 230 44 240 52 6 4 26 11 45 15 19 4 49
            13 65 20 17 8 63 28 103 45 40 17 94 44 120 61 26 16 66 38 90 50 l42 20 43
            -29 c52 -36 182 -171 223 -232 17 -25 43 -73 58 -105 15 -33 33 -69 39 -80 22
            -40 21 -200 -1 -288 -11 -45 -28 -113 -38 -152 -12 -49 -19 -126 -22 -256 -4
            -183 -3 -186 23 -250 39 -94 67 -116 160 -124 42 -4 416 -6 833 -3 735 3 758
            4 784 23 15 11 32 31 38 44 6 14 15 108 20 210 12 237 12 2311 0 2451 l-8 105
            -43 38 c-24 22 -57 46 -74 54 -65 33 -186 136 -420 358 -222 209 -250 234
            -335 296 -175 128 -390 226 -620 285 -103 26 -404 38 -615 24z m349 -206 c23
            -9 20 -25 -14 -98 -17 -35 -42 -101 -57 -147 -24 -80 -26 -95 -26 -299 0 -140
            4 -231 12 -260 7 -25 18 -72 26 -105 12 -57 49 -177 75 -240 26 -66 103 -228
            123 -259 7 -11 26 -43 44 -72 18 -28 56 -76 85 -106 50 -52 157 -128 179 -128
            5 0 24 -8 42 -17 18 -9 64 -22 102 -29 300 -55 562 71 693 331 40 79 53 118
            72 218 23 120 24 160 5 247 -18 84 -18 109 0 116 14 6 114 -59 163 -105 l22
            -22 0 -1222 c0 -976 -3 -1227 -13 -1241 -12 -16 -55 -17 -687 -14 -564 3 -680
            5 -703 17 -28 15 -28 16 -25 90 5 89 23 212 44 295 8 32 22 113 30 180 13 100
            13 137 3 216 -6 52 -20 114 -30 137 -11 23 -19 44 -19 48 0 20 -115 197 -165
            254 -92 104 -194 195 -269 241 -58 35 -154 33 -229 -6 -186 -97 -264 -134
            -278 -134 -9 0 -22 -7 -29 -15 -14 -17 -50 -20 -50 -5 0 6 6 10 13 10 7 0 24
            12 38 28 14 15 38 36 54 47 119 82 374 303 410 355 36 52 34 107 -5 145 -38
            37 -83 38 -130 5 -19 -14 -37 -27 -40 -30 -20 -20 -234 -198 -277 -230 -19
            -14 -57 -43 -86 -65 -29 -23 -77 -57 -107 -77 -30 -20 -72 -49 -92 -64 -20
            -16 -62 -45 -94 -64 -31 -19 -71 -44 -88 -55 -17 -11 -49 -28 -72 -39 -41 -18
            -41 -18 -90 7 -92 47 -192 161 -293 335 l-31 53 56 57 c65 66 122 134 149 177
            57 91 60 371 4 461 -41 67 -29 81 174 208 31 20 59 36 62 36 6 0 74 45 130 86
            51 37 120 116 131 150 4 11 28 64 55 119 99 207 241 336 464 423 49 19 202 49
            280 55 78 7 244 7 259 1z m423 -93 c10 -5 54 -26 97 -45 64 -30 94 -52 161
            -119 89 -90 216 -256 345 -452 40 -62 74 -126 96 -184 21 -54 24 -81 24 -185
            0 -117 -4 -141 -32 -216 -35 -92 -133 -194 -226 -238 -45 -20 -69 -24 -151
            -24 -106 0 -162 17 -249 75 -42 29 -123 115 -147 159 -30 52 -106 211 -120
            251 -101 279 -126 477 -89 711 21 131 82 263 136 292 22 12 115 -4 155 -25z
            m-2160 -1108 c5 -16 8 -65 7 -109 -1 -69 -5 -90 -29 -135 -15 -30 -38 -65 -52
            -78 l-24 -25 -25 26 c-18 18 -31 49 -44 109 -17 77 -18 86 -3 116 21 45 109
            123 139 123 17 0 26 -7 31 -27z"
          />

          <path
            fill={color}
            d="M2137 3730 c-40 -12 -55 -27 -62 -61 -11 -47 4 -87 41 -115 29 -22
          45 -26 98 -26 67 0 127 25 140 58 11 29 6 89 -9 111 -26 38 -135 55 -208 33z"
          />
        </g>
        <text
          x="450"
          y="450"
          stroke={color}
          fill={color}
          style={{ fontSize: "520px" }}
        >
          tailzup
        </text>
        <text
          id="tail"
          x="1923"
          y="340"
          stroke={color}
          fill={color}
          style={tail}
        >
          <animate
            attributeName="rotate"
            transformOrigin="center"
            values="20;40;20"
            dur="2s"
            repeatCount="indefinite"
          />
          !
        </text>
      </svg>
    </div>
  );
};

export default TailzupLogo;
