---
id: overview
title: Overview
slug: /
---

## What is refine?

**refine** is a React-based framework for the rapid ✨ development of web applications.
It eliminates the repetitive tasks demanded by **CRUD** operations and provides industry standard solutions for critical parts like **authentication**, **access control**, **routing**, **networking**, **state management**, and **i18n**.

**refine** is _headless by design_ offering unlimited styling and customization options.

## What do you mean by "headless" ?

Instead of being a limited set of pre-styled components, **refine** is a collection of helper `hooks`, `components` and `providers`. They are all decoupled from your _UI components_ and _business logic_, so they never keep you from customizing your _UI_ or coding your own flow.

**refine** seamlessly works with any **custom design** or **UI framework you favor**. For convenience, it ships with ready-made integrations for [Ant Design](https://ant.design/), [Material UI](https://mui.com/material-ui/getting-started/overview/), [Mantine](https://mantine.dev/), and [Chakra UI](https://chakra-ui.com/).

## Use cases

**refine** shines on _data-intensive_ applications like _admin panels_, _dashboards_ and _internal tools_. Thanks to built-in **SSR support**, **refine** can also power _customer-facing_ applications like _storefronts_.

<img src="https://refine.ams3.cdn.digitaloceanspaces.com/website/static/img/diagram.png" alt="Refine diagram" />

## Key Features

⚙️ Zero-config, **one-minute setup** with a **single CLI command**

🔌 Connectors for **15+ backend services** including [REST API](https://github.com/refinedev/refine/tree/v3/packages/simple-rest), [GraphQL](https://github.com/refinedev/refine/tree/v3/packages/graphql), [NestJs CRUD](https://github.com/refinedev/refine/tree/v3/packages/nestjsx-crud), [Airtable](https://github.com/refinedev/refine/tree/v3/packages/airtable), [Strapi](https://github.com/refinedev/refine/tree/v3/packages/strapi), [Strapi v4](https://github.com/refinedev/refine/tree/v3/packages/strapi-v4), [Strapi GraphQL](https://github.com/refinedev/refine/tree/v3/packages/strapi-graphql), [Supabase](https://github.com/refinedev/refine/tree/v3/packages/supabase), [Hasura](https://github.com/refinedev/refine/tree/v3/packages/hasura), [Appwrite](https://github.com/refinedev/refine/tree/v3/packages/appwrite), [Firebase](https://firebase.google.com/) and [Directus](https://directus.io/).

🌐 **SSR support** with **Next.js** or **Remix**

🔍 Auto-generated **CRUD** UIs from **your API data structure**

⚛ Perfect **state management** & **mutations** with **React Query**

🔀 **Advanced routing** with any router library of your choice

🔐 Providers for seamless **authentication** and **access control** flows

⚡ Out-of-the-box support for **live / real-time applications**

📄 Easy **audit logs** & **document versioning**

💬 Support for any **i18n** framework

💪 Future-proof, **robust architecture**

⌛️ Built-in [CLI](https://refine.dev/docs/packages/documentation/cli/) with time-saving features

✅ Full **test coverage**

## Community

**refine** has a very friendly community and we are always happy to help you get started:

- [Join the Discord Community](https://discord.gg/refine) – it is the easiest way to get help, all questions are usually answered in about 30 minutes.
- [GitHub Discussions](https://github.com/refinedev/refine/discussions) – ask anything about the project or give feedback.
- [Contributing](/docs/3.xx.xx/contributing/) – learn how to contribute refine project.
- [Guest Technical Writer Program](https://refine.dev/blog/refine-writer-program/) – join the program and become a blog writer for refine.

## Next Steps

👉 Continue with [Quickstart guide](/docs/3.xx.xx/getting-started/quickstart/) to setup and run your first **refine** project.

👉 Or jump directly to [Tutorial](/docs/3.xx.xx/tutorial/introduction/index/) to learn refine by building a full-blown CRUD application.
