import clsx from "clsx";
import React, { type FC } from "react";
import { LandingSectionCtaButton } from "./landing-section-cta-button";

type Props = {
  className?: string;
};

export const LandingAlreadyInvented: FC<Props> = ({ className }) => {
  const ref = React.useRef<HTMLDivElement>(null);

  return (
    <div className={clsx(className)}>
      <div
        ref={ref}
        className={clsx(
          "not-prose",
          "flex-shrink-0",
          "h-full",
          "p-2 landing-sm:p-4",
          "rounded-2xl landing-sm:rounded-3xl",
          "dark:bg-landing-noise",
          "dark:bg-gray-800 bg-gray-50",
        )}
      >
        <div
          className={clsx(
            "h-[288px]",
            "bg-gray-0",
            "dark:bg-gray-900",
            "dark:bg-landing-wai-bg-dark",
            "w-full",
            "bg-no-repeat",
            "bg-right",
            "flex",
            "flex-col",
            "rounded-lg",
            "overflow-hidden",
            "py-[23px]",
            "px-[15px]",
            "relative",
            "border-t-solid border-t",
            "border-t-gray-200 dark:border-t-gray-700",
            "border-opacity-60 dark:border-opacity-60",
            "shadow-landing-wai-shadow-light dark:shadow-landing-wai-shadow-dark",
            "drop-shadow-sm",
          )}
        >
          <div
            className={clsx(
              "pointer-events-none",
              // "z-0",
              "absolute",
              "left-0",
              "top-0",
              "dark:opacity-[0.35]",
              "w-full",
              "h-full",
              "bg-landing-wai-sunshine-light",
              "dark:bg-landing-wai-sunshine-dark",
              "dark:mix-blend-color-dodge",
              "bg-[position:right_top]",
              "bg-cover",
            )}
          />
          <div className={clsx("w-full", "h-full", "flex", "relative")}>
            <div
              className={clsx(
                "pointer-events-none",
                "z-0",
                "absolute",
                "left-0",
                "top-0",
                "dark:opacity-20",
                "w-full",
                "h-full",
                "bg-landing-wai-grid-light",
                "dark:bg-landing-wai-grid-dark",
                "bg-repeat",
                "bg-[size:16px]",
                "dark:mix-blend-overlay",
              )}
            />
            <RowsSvg
              className={clsx(
                "absolute",
                "left-0",
                "bottom-[29px]",
                "w-full",
                "h-[122px]",
              )}
            />
            <RecordsSvg
              className={clsx(
                "absolute",
                "right-[430px]",
                "bottom-[27px]",
                "landing-sm:right-auto",
                "landing-sm:left-0",
                "text-gray-1000 dark:text-gray-0",
              )}
            />
            <DotsSvg className={clsx("absolute", "right-0", "bottom-[34px]")} />
            <ContextSvg
              className={clsx(
                "absolute",
                "hidden",
                "dark:block",
                "top-[17px]",
                "right-[37px]",
              )}
            />
            <ContextLightSvg
              className={clsx(
                "block",
                "dark:hidden",
                "absolute",
                "top-[17px]",
                "right-[37px]",
              )}
            />
          </div>
        </div>
        <div
          className={clsx(
            "not-prose",
            "mt-4 landing-sm:mt-6 landing-lg:mt-10",
            "px-4 landing-sm:px-6",
          )}
        >
          <h6
            className={clsx(
              "p-0",
              "font-semibold",
              "text-base landing-sm:text-2xl",
              "dark:text-gray-300 text-gray-900",
            )}
          >
            Wheel? Already invented.
          </h6>
          <div
            className={clsx(
              "not-prose",
              "flex",
              "items-center",
              "justify-between",
              "flex-wrap",
              "gap-4 landing-sm:gap-8",
              "mb-4 landing-sm:mb-6",
            )}
          >
            <p
              className={clsx(
                "h-auto landing-md:h-[72px] landing-lg:h-auto",
                "p-0",
                "mt-2 landing-sm:mt-4",
                "text-base",
                "dark:text-gray-400 text-gray-600",
              )}
            >
              Start with a well-structured boilerplate, built around the
              industry’s best practices.
            </p>
            <LandingSectionCtaButton to="/docs">
              Learn more
            </LandingSectionCtaButton>
          </div>
        </div>
      </div>
    </div>
  );
};

const RowsSvg = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={578}
    height={122}
    // viewBox="0 0 578 122"
    fill="none"
    {...props}
  >
    <path
      fill="url(#rows-a-dark)"
      className="opacity-0 dark:opacity-100"
      strokeWidth="0"
      d="M1 41V1l576 .038V41H1Z"
    />
    <path
      fill="url(#rows-a-light)"
      className="opacity-100 dark:opacity-0"
      strokeWidth="0"
      d="M1 41V1l576 .038V41H1Z"
    />
    <path
      className="stroke-[#6C779326] dark:stroke-gray-0 dark:mix-blend-overlay"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeOpacity={0.5}
      d="M1 1h576M1 41h576M1 81h576M1 121h576"
    />
    <defs>
      <linearGradient
        id="rows-a-dark"
        x1={1}
        x2={577}
        y1={21}
        y2={21}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopOpacity={0.05} />
        <stop offset={0.15} stopOpacity={0.2} />
        <stop offset={1} stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="rows-a-light"
        x1={1}
        x2={577}
        y1={21}
        y2={21}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopOpacity={0.05} stopColor="#fff" />
        <stop offset={0.15} stopOpacity={0.75} stopColor="#fff" />
        <stop offset={1} stopOpacity={0.1} stopColor="#fff" />
      </linearGradient>
    </defs>
  </svg>
);

const RecordsSvg = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={79}
    height={116}
    viewBox="0 0 79 116"
    fill="none"
    {...props}
  >
    <path
      fill="currentColor"
      fillOpacity={0.8}
      d="M1.41 18V6.364h3.93c.91 0 1.656.155 2.24.466.583.306 1.015.729 1.295 1.267.28.537.42 1.15.42 1.835s-.14 1.293-.42 1.824c-.28.53-.71.947-1.29 1.25-.58.299-1.32.448-2.221.448H2.182v-1.272h3.136c.621 0 1.121-.091 1.5-.273.383-.182.66-.44.83-.773.174-.337.261-.738.261-1.204 0-.466-.087-.873-.261-1.222a1.782 1.782 0 0 0-.835-.807c-.383-.193-.889-.29-1.518-.29H2.818V18H1.41Zm5.476-5.227L9.75 18H8.114l-2.819-5.227h1.591Zm8.141 5.409c-.84 0-1.566-.186-2.176-.557a3.737 3.737 0 0 1-1.404-1.568c-.325-.674-.488-1.458-.488-2.352 0-.894.163-1.682.488-2.364.33-.686.788-1.22 1.375-1.602.591-.387 1.28-.58 2.069-.58.454 0 .903.076 1.346.227.443.152.847.398 1.21.739.364.337.654.784.87 1.34.216.558.324 1.243.324 2.058v.568h-6.728v-1.16h5.364c0-.492-.099-.931-.296-1.317a2.226 2.226 0 0 0-.829-.915c-.356-.224-.777-.335-1.261-.335-.534 0-.997.132-1.387.397a2.615 2.615 0 0 0-.892 1.023c-.208.42-.312.871-.312 1.352v.773c0 .66.113 1.218.34 1.676.232.455.552.801.96 1.04.41.235.885.352 1.427.352.352 0 .67-.049.955-.148.287-.102.535-.253.744-.454.208-.204.37-.458.483-.761l1.295.363c-.136.44-.365.826-.687 1.16-.322.329-.72.587-1.193.772a4.426 4.426 0 0 1-1.597.273Zm9.199 0c-.818 0-1.523-.193-2.114-.58a3.777 3.777 0 0 1-1.363-1.596c-.319-.678-.478-1.453-.478-2.324 0-.886.163-1.669.489-2.347.33-.682.788-1.214 1.375-1.596.59-.387 1.28-.58 2.068-.58.614 0 1.167.114 1.66.341.492.227.895.546 1.21.954.314.41.509.887.585 1.432h-1.341c-.102-.397-.33-.75-.682-1.056-.349-.311-.818-.466-1.41-.466-.522 0-.98.136-1.374.409-.39.269-.695.65-.915 1.142-.216.488-.324 1.062-.324 1.721 0 .675.106 1.262.318 1.762.216.5.52.888.91 1.165.393.276.855.414 1.386.414.348 0 .665-.06.949-.181.284-.122.524-.296.721-.523.197-.227.337-.5.42-.819h1.342c-.076.516-.264.98-.563 1.393-.295.409-.687.734-1.176.977-.485.238-1.05.358-1.693.358Zm8.937 0c-.787 0-1.479-.188-2.073-.563-.591-.375-1.053-.9-1.387-1.573-.33-.675-.494-1.463-.494-2.364 0-.91.165-1.703.494-2.38.334-.679.796-1.205 1.387-1.58.594-.375 1.286-.563 2.073-.563.788 0 1.478.188 2.069.563.594.375 1.056.901 1.386 1.58.333.677.5 1.47.5 2.38 0 .901-.167 1.69-.5 2.364a3.769 3.769 0 0 1-1.387 1.573c-.59.375-1.28.563-2.068.563Zm0-1.205c.599 0 1.091-.153 1.478-.46.386-.307.672-.71.858-1.21.185-.5.278-1.042.278-1.625 0-.584-.093-1.127-.278-1.63a2.749 2.749 0 0 0-.858-1.223c-.387-.31-.88-.465-1.478-.465s-1.09.155-1.477.465c-.386.311-.672.718-.858 1.222a4.681 4.681 0 0 0-.278 1.63c0 .584.092 1.126.278 1.626.186.5.472.903.858 1.21.386.307.879.46 1.477.46ZM39.165 18V9.273h1.295v1.318h.091c.16-.432.447-.782.864-1.051a2.542 2.542 0 0 1 1.409-.404c.098 0 .221.002.37.006.147.004.259.01.334.017v1.364a3.999 3.999 0 0 0-.312-.051 3.077 3.077 0 0 0-.506-.04c-.424 0-.803.089-1.136.267-.33.174-.591.417-.784.727a1.96 1.96 0 0 0-.284 1.051V18h-1.341Zm8.983.182c-.728 0-1.37-.184-1.926-.551-.557-.372-.993-.894-1.307-1.569-.315-.678-.472-1.479-.472-2.403 0-.917.157-1.712.472-2.386.314-.675.752-1.195 1.312-1.563.56-.367 1.209-.55 1.944-.55.568 0 1.017.094 1.346.283.333.186.587.398.761.636.178.235.317.429.415.58h.114V6.364h1.34V18h-1.295v-1.34h-.159a8.63 8.63 0 0 1-.42.601c-.182.239-.442.453-.779.642-.337.186-.786.279-1.346.279Zm.181-1.205c.538 0 .993-.14 1.364-.42.371-.284.654-.676.847-1.176.193-.504.29-1.085.29-1.745 0-.651-.095-1.221-.285-1.71-.189-.492-.47-.875-.84-1.148-.372-.276-.83-.414-1.375-.414-.569 0-1.042.145-1.42.437-.376.288-.658.68-.847 1.176a4.675 4.675 0 0 0-.279 1.66c0 .62.095 1.185.284 1.692.193.504.477.906.852 1.205.38.296.849.443 1.41.443ZM63.632 18 65.54 6.364h1.136L64.767 18h-1.136Zm-5.296-3.227.182-1.137h8.682l-.182 1.137h-8.682ZM59.54 18l1.909-11.636h1.136L60.676 18H59.54Zm-.523-7.273.182-1.136h8.682l-.182 1.136h-8.682Zm14.435-4.363V18h-1.41V7.84h-.068l-2.84 1.887V8.295l2.909-1.931h1.409Z"
    />
    <path
      fill="currentColor"
      fillOpacity={0.4}
      d="M1.41 58V46.364h3.93c.91 0 1.656.155 2.24.466.583.306 1.015.729 1.295 1.267.28.538.42 1.15.42 1.835s-.14 1.293-.42 1.824c-.28.53-.71.947-1.29 1.25-.58.299-1.32.449-2.221.449H2.182v-1.273h3.136c.621 0 1.121-.091 1.5-.273.383-.182.66-.44.83-.773.174-.337.261-.738.261-1.204 0-.466-.087-.873-.261-1.222a1.782 1.782 0 0 0-.835-.807c-.383-.193-.889-.29-1.518-.29H2.818V58H1.41Zm5.476-5.227L9.75 58H8.114l-2.819-5.227h1.591Zm8.141 5.409c-.84 0-1.566-.186-2.176-.557a3.737 3.737 0 0 1-1.404-1.568c-.325-.674-.488-1.459-.488-2.352 0-.894.163-1.682.488-2.364.33-.686.788-1.22 1.375-1.602.591-.387 1.28-.58 2.069-.58.454 0 .903.076 1.346.227.443.152.847.398 1.21.739.364.337.654.784.87 1.34.216.558.324 1.243.324 2.058v.568h-6.728v-1.16h5.364c0-.492-.099-.931-.296-1.317a2.226 2.226 0 0 0-.829-.915c-.356-.224-.777-.335-1.261-.335-.534 0-.997.132-1.387.397a2.615 2.615 0 0 0-.892 1.023c-.208.42-.312.871-.312 1.352v.773c0 .66.113 1.218.34 1.676.232.455.552.801.96 1.04.41.235.885.352 1.427.352.352 0 .67-.049.955-.147.287-.103.535-.254.744-.455.208-.205.37-.458.483-.761l1.295.363c-.136.44-.365.826-.687 1.16-.322.329-.72.587-1.193.772a4.426 4.426 0 0 1-1.597.273Zm9.199 0c-.818 0-1.523-.193-2.114-.58a3.777 3.777 0 0 1-1.363-1.596c-.319-.678-.478-1.453-.478-2.324 0-.887.163-1.669.489-2.347.33-.682.788-1.214 1.375-1.596.59-.387 1.28-.58 2.068-.58.614 0 1.167.114 1.66.341.492.227.895.545 1.21.955.314.409.509.886.585 1.431h-1.341c-.102-.397-.33-.75-.682-1.056-.349-.311-.818-.466-1.41-.466-.522 0-.98.136-1.374.409-.39.269-.695.65-.915 1.142-.216.488-.324 1.062-.324 1.721 0 .675.106 1.262.318 1.762.216.5.52.888.91 1.164.393.277.855.415 1.386.415.348 0 .665-.06.949-.181.284-.122.524-.296.721-.523.197-.228.337-.5.42-.819h1.342c-.076.516-.264.98-.563 1.393-.295.409-.687.734-1.176.977-.485.239-1.05.358-1.693.358Zm8.937 0c-.787 0-1.479-.188-2.073-.563-.591-.375-1.053-.9-1.387-1.574-.33-.674-.494-1.462-.494-2.363 0-.91.165-1.703.494-2.38.334-.679.796-1.205 1.387-1.58.594-.375 1.286-.563 2.073-.563.788 0 1.478.188 2.069.563.594.375 1.056.901 1.386 1.58.333.677.5 1.47.5 2.38 0 .901-.167 1.69-.5 2.363a3.769 3.769 0 0 1-1.387 1.574c-.59.375-1.28.563-2.068.563Zm0-1.205c.599 0 1.091-.153 1.478-.46.386-.307.672-.71.858-1.21.185-.5.278-1.042.278-1.625 0-.584-.093-1.127-.278-1.63a2.749 2.749 0 0 0-.858-1.222c-.387-.311-.88-.466-1.478-.466s-1.09.155-1.477.466c-.386.31-.672.717-.858 1.221a4.681 4.681 0 0 0-.278 1.63c0 .584.092 1.126.278 1.626.186.5.472.903.858 1.21.386.307.879.46 1.477.46ZM39.165 58v-8.727h1.295v1.318h.091c.16-.432.447-.782.864-1.051a2.541 2.541 0 0 1 1.409-.404c.098 0 .221.002.37.006.147.004.259.01.334.017v1.364a3.999 3.999 0 0 0-.312-.051 3.077 3.077 0 0 0-.506-.04c-.424 0-.803.089-1.136.267-.33.174-.591.416-.784.727a1.96 1.96 0 0 0-.284 1.051V58h-1.341Zm8.983.182c-.728 0-1.37-.184-1.926-.551-.557-.371-.993-.894-1.307-1.569-.315-.677-.472-1.479-.472-2.403 0-.917.157-1.712.472-2.386.314-.675.752-1.195 1.312-1.563.56-.367 1.209-.55 1.944-.55.568 0 1.017.094 1.346.283.333.186.587.398.761.637.178.234.317.428.415.58h.114v-4.296h1.34V58h-1.295v-1.34h-.159a8.63 8.63 0 0 1-.42.601c-.182.239-.442.453-.779.642-.337.186-.786.279-1.346.279Zm.181-1.205c.538 0 .993-.14 1.364-.42.371-.284.654-.676.847-1.176.193-.504.29-1.086.29-1.745 0-.651-.095-1.221-.285-1.71-.189-.492-.47-.875-.84-1.148-.372-.276-.83-.414-1.375-.414-.569 0-1.042.146-1.42.437-.376.288-.658.68-.847 1.176a4.675 4.675 0 0 0-.279 1.66c0 .62.095 1.185.284 1.693.193.503.477.905.852 1.204.38.296.849.443 1.41.443ZM63.632 58l1.909-11.636h1.136L64.767 58h-1.136Zm-5.296-3.227.182-1.137h8.682l-.182 1.137h-8.682ZM59.54 58l1.909-11.636h1.136L60.676 58H59.54Zm-.523-7.273.182-1.136h8.682l-.182 1.136h-8.682ZM69.361 58v-1.023l3.84-4.204c.452-.493.823-.92 1.114-1.284.292-.368.508-.712.648-1.034.144-.326.216-.667.216-1.023 0-.41-.099-.763-.296-1.063-.193-.299-.458-.53-.795-.693a2.58 2.58 0 0 0-1.136-.244c-.447 0-.837.093-1.17.278-.33.182-.586.438-.768.767-.178.33-.267.716-.267 1.16h-1.34c0-.682.156-1.28.47-1.796a3.277 3.277 0 0 1 1.285-1.205 3.87 3.87 0 0 1 1.835-.431c.682 0 1.286.144 1.813.431.526.288.94.676 1.238 1.165.3.489.45 1.032.45 1.63 0 .429-.079.847-.234 1.257-.151.405-.416.857-.795 1.357-.375.497-.896 1.103-1.563 1.819l-2.613 2.795v.091h5.409V58H69.36ZM1.41 98V86.364h3.93c.91 0 1.656.155 2.24.465.583.307 1.015.73 1.295 1.268s.42 1.15.42 1.835-.14 1.293-.42 1.824c-.28.53-.71.947-1.29 1.25-.58.299-1.32.448-2.221.448H2.182v-1.272h3.136c.621 0 1.121-.091 1.5-.273.383-.182.66-.44.83-.773.174-.337.261-.738.261-1.204 0-.466-.087-.873-.261-1.222a1.782 1.782 0 0 0-.835-.807c-.383-.193-.889-.29-1.518-.29H2.818V98H1.41Zm5.476-5.227L9.75 98H8.114l-2.819-5.227h1.591Zm8.141 5.409c-.84 0-1.566-.186-2.176-.557a3.737 3.737 0 0 1-1.404-1.568c-.325-.674-.488-1.459-.488-2.353 0-.893.163-1.681.488-2.363.33-.686.788-1.22 1.375-1.602.591-.387 1.28-.58 2.069-.58.454 0 .903.076 1.346.227.443.152.847.398 1.21.739.364.337.654.784.87 1.34.216.558.324 1.243.324 2.058v.568h-6.728v-1.16h5.364c0-.492-.099-.931-.296-1.317a2.226 2.226 0 0 0-.829-.915c-.356-.224-.777-.335-1.261-.335-.534 0-.997.132-1.387.397a2.615 2.615 0 0 0-.892 1.023c-.208.42-.312.871-.312 1.352v.773c0 .66.113 1.218.34 1.676.232.455.552.801.96 1.04.41.235.885.352 1.427.352.352 0 .67-.049.955-.148.287-.102.535-.253.744-.454.208-.204.37-.458.483-.761l1.295.363c-.136.44-.365.826-.687 1.16-.322.329-.72.587-1.193.772a4.426 4.426 0 0 1-1.597.273Zm9.199 0c-.818 0-1.523-.193-2.114-.58a3.777 3.777 0 0 1-1.363-1.596c-.319-.678-.478-1.453-.478-2.324 0-.886.163-1.669.489-2.347.33-.682.788-1.214 1.375-1.596.59-.387 1.28-.58 2.068-.58.614 0 1.167.114 1.66.341.492.227.895.546 1.21.954.314.41.509.887.585 1.432h-1.341c-.102-.397-.33-.75-.682-1.056-.349-.311-.818-.466-1.41-.466-.522 0-.98.136-1.374.409-.39.269-.695.65-.915 1.142-.216.488-.324 1.062-.324 1.721 0 .675.106 1.262.318 1.762.216.5.52.888.91 1.165.393.276.855.414 1.386.414.348 0 .665-.06.949-.181.284-.122.524-.296.721-.523.197-.227.337-.5.42-.819h1.342c-.076.516-.264.98-.563 1.393-.295.409-.687.734-1.176.977-.485.239-1.05.358-1.693.358Zm8.937 0c-.787 0-1.479-.188-2.073-.563-.591-.375-1.053-.9-1.387-1.573-.33-.675-.494-1.463-.494-2.364 0-.91.165-1.703.494-2.38.334-.679.796-1.205 1.387-1.58.594-.375 1.286-.563 2.073-.563.788 0 1.478.188 2.069.563.594.375 1.056.901 1.386 1.58.333.677.5 1.47.5 2.38 0 .901-.167 1.69-.5 2.364a3.769 3.769 0 0 1-1.387 1.573c-.59.375-1.28.563-2.068.563Zm0-1.205c.599 0 1.091-.153 1.478-.46.386-.307.672-.71.858-1.21.185-.5.278-1.042.278-1.625 0-.584-.093-1.127-.278-1.63a2.749 2.749 0 0 0-.858-1.223c-.387-.31-.88-.465-1.478-.465s-1.09.155-1.477.465c-.386.311-.672.718-.858 1.222a4.681 4.681 0 0 0-.278 1.63c0 .584.092 1.126.278 1.626.186.5.472.903.858 1.21.386.307.879.46 1.477.46ZM39.165 98v-8.727h1.295v1.318h.091c.16-.432.447-.782.864-1.051a2.541 2.541 0 0 1 1.409-.404c.098 0 .221.002.37.006.147.004.259.01.334.017v1.364a3.999 3.999 0 0 0-.312-.051 3.077 3.077 0 0 0-.506-.04c-.424 0-.803.089-1.136.267-.33.174-.591.416-.784.727a1.96 1.96 0 0 0-.284 1.051V98h-1.341Zm8.983.182c-.728 0-1.37-.184-1.926-.551-.557-.371-.993-.894-1.307-1.569-.315-.677-.472-1.479-.472-2.403 0-.917.157-1.712.472-2.386.314-.674.752-1.195 1.312-1.563.56-.367 1.209-.55 1.944-.55.568 0 1.017.094 1.346.283.333.186.587.398.761.636.178.235.317.429.415.58h.114v-4.295h1.34V98h-1.295v-1.34h-.159a8.63 8.63 0 0 1-.42.601c-.182.239-.442.453-.779.642-.337.186-.786.279-1.346.279Zm.181-1.205c.538 0 .993-.14 1.364-.42.371-.284.654-.676.847-1.176.193-.504.29-1.085.29-1.745 0-.651-.095-1.221-.285-1.71-.189-.492-.47-.875-.84-1.148-.372-.276-.83-.414-1.375-.414-.569 0-1.042.145-1.42.437-.376.288-.658.68-.847 1.176a4.675 4.675 0 0 0-.279 1.66c0 .62.095 1.185.284 1.692.193.504.477.906.852 1.205.38.295.849.443 1.41.443ZM63.632 98l1.909-11.636h1.136L64.767 98h-1.136Zm-5.296-3.227.182-1.137h8.682l-.182 1.137h-8.682ZM59.54 98l1.909-11.636h1.136L60.676 98H59.54Zm-.523-7.273.182-1.136h8.682l-.182 1.136h-8.682Zm14.276 7.432c-.75 0-1.419-.129-2.006-.386-.583-.258-1.047-.616-1.392-1.074a2.887 2.887 0 0 1-.557-1.608h1.432c.03.375.159.699.386.972.227.268.525.477.892.624.368.148.775.222 1.222.222.5 0 .943-.087 1.33-.261.386-.174.689-.417.909-.727.22-.311.33-.671.33-1.08 0-.428-.107-.805-.32-1.13-.211-.33-.522-.588-.93-.773-.41-.186-.91-.279-1.5-.279h-.933v-1.25h.932c.462 0 .868-.083 1.216-.25.352-.167.627-.401.824-.705.2-.302.301-.658.301-1.068 0-.394-.087-.736-.261-1.028a1.787 1.787 0 0 0-.739-.682c-.314-.163-.686-.244-1.114-.244-.401 0-.78.074-1.136.221-.352.144-.64.355-.864.631a1.642 1.642 0 0 0-.363.989h-1.364a2.77 2.77 0 0 1 .551-1.602 3.47 3.47 0 0 1 1.353-1.08 4.37 4.37 0 0 1 1.846-.386c.72 0 1.337.145 1.852.437.516.288.911.669 1.188 1.142.276.474.415.985.415 1.534 0 .656-.173 1.214-.517 1.676-.341.462-.805.782-1.392.96v.092c.734.12 1.308.433 1.721.937.413.5.62 1.12.62 1.858 0 .633-.173 1.2-.518 1.705-.34.5-.806.893-1.397 1.181-.591.288-1.264.432-2.017.432Z"
    />
  </svg>
);

const DotsSvg = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={32}
    height={112}
    viewBox="0 0 32 112"
    fill="none"
    {...props}
  >
    <rect
      x="1"
      y="1"
      fillOpacity={0.6}
      rx={16}
      className={clsx(
        "w-[30px] h-[30px]",
        "fill-gray-0 dark:fill-gray-1000",
        "stroke stroke-gray-200 dark:stroke-gray-1000",
      )}
    />
    <path
      className="fill-gray-600 dark:fill-gray-300"
      d="M12 16a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM18 16a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM22 18a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"
    />
    <path
      className="fill-gray-300 dark:fill-gray-0 opacity-0 dark:opacity-100"
      fillOpacity={0.2}
      d="M12 56a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM18 56a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM22 58a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12 96a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM18 96a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM22 98a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"
    />
    <path
      className="fill-gray-300 dark:opacity-0 opacity-100"
      d="M12 56a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM18 56a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM22 58a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12 96a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM18 96a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM22 98a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"
    />
  </svg>
);

const ContextSvg = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={184}
    height={208}
    viewBox="0 0 184 208"
    fill="none"
    {...props}
  >
    <g filter="url(#context-a)">
      <rect width={184} height={48} fill="#000" fillOpacity={0.4} rx={24} />
      <g filter="url(#context-b)">
        <path
          fill="url(#context-c)"
          fillRule="evenodd"
          d="M22 32a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-1a7 7 0 1 0 0-14 7 7 0 0 0 0 14Zm0-10a.5.5 0 0 1 .5.5v2h2a.5.5 0 0 1 0 1h-2v2a.5.5 0 0 1-1 0v-2h-2a.5.5 0 0 1 0-1h2v-2a.5.5 0 0 1 .5-.5Z"
          clipRule="evenodd"
        />
      </g>
      <path
        fill="url(#context-d)"
        fillRule="evenodd"
        d="M22 32a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-1a7 7 0 1 0 0-14 7 7 0 0 0 0 14Zm0-10a.5.5 0 0 1 .5.5v2h2a.5.5 0 0 1 0 1h-2v2a.5.5 0 0 1-1 0v-2h-2a.5.5 0 0 1 0-1h2v-2a.5.5 0 0 1 .5-.5Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-e)"
        d="M46.312 29h-1.969l3.585-10.182h2.277L53.794 29h-1.969l-2.72-8.094h-.079L46.312 29Zm.064-3.992h5.37v1.481h-5.37v-1.481Zm11.281 4.126a2.89 2.89 0 0 1-1.61-.462c-.475-.308-.85-.756-1.124-1.343-.276-.586-.413-1.299-.413-2.137 0-.849.14-1.565.418-2.148.281-.587.66-1.03 1.138-1.327a2.926 2.926 0 0 1 1.596-.453c.447 0 .815.076 1.104.229.288.149.517.33.686.542.169.209.3.406.392.591h.075v-3.808h1.805V29h-1.77v-1.203h-.11a3.078 3.078 0 0 1-.402.591 2.216 2.216 0 0 1-.696.527c-.289.146-.652.22-1.089.22Zm.502-1.476c.381 0 .706-.103.974-.309.269-.208.473-.498.612-.87.14-.37.209-.803.209-1.297 0-.494-.07-.923-.209-1.288-.136-.364-.338-.648-.606-.85-.266-.202-.592-.303-.98-.303-.401 0-.736.104-1.004.313-.269.209-.47.497-.607.865a3.63 3.63 0 0 0-.204 1.263c0 .477.068.903.204 1.277.14.372.343.665.612.88.272.213.605.319 1 .319Zm8.316 1.476a2.89 2.89 0 0 1-1.61-.462c-.474-.308-.849-.756-1.124-1.343-.275-.586-.413-1.299-.413-2.137 0-.849.14-1.565.418-2.148.282-.587.661-1.03 1.138-1.327a2.926 2.926 0 0 1 1.596-.453c.448 0 .816.076 1.104.229.288.149.517.33.686.542.17.209.3.406.393.591h.074v-3.808h1.805V29h-1.77v-1.203h-.11a3.073 3.073 0 0 1-.402.591 2.215 2.215 0 0 1-.696.527c-.288.146-.651.22-1.089.22Zm.503-1.476c.38 0 .705-.103.974-.309.268-.208.472-.498.611-.87.14-.37.21-.803.21-1.297 0-.494-.07-.923-.21-1.288-.136-.364-.338-.648-.606-.85-.265-.202-.592-.303-.98-.303-.4 0-.735.104-1.004.313-.268.209-.47.497-.606.865a3.63 3.63 0 0 0-.204 1.263c0 .477.068.903.204 1.277.139.372.343.665.611.88.272.213.605.319 1 .319Zm10.754-3.132V29h-1.8v-7.636h1.72v1.297h.09c.176-.427.456-.767.84-1.019.388-.252.867-.378 1.437-.378.527 0 .986.113 1.377.338.395.226.7.552.915.98.219.427.326.946.323 1.556V29h-1.8v-4.584c0-.51-.132-.91-.397-1.198-.262-.288-.625-.433-1.089-.433-.315 0-.595.07-.84.21a1.448 1.448 0 0 0-.572.59c-.136.26-.204.573-.204.94Zm10.112 4.623c-.765 0-1.426-.159-1.983-.477a3.233 3.233 0 0 1-1.278-1.362c-.298-.59-.447-1.285-.447-2.083 0-.786.149-1.475.447-2.069a3.384 3.384 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .915.076 1.332.229.421.149.793.381 1.114.696.325.315.58.716.766 1.203.185.484.278 1.06.278 1.73v.552h-6.26v-1.213h4.535a1.936 1.936 0 0 0-.224-.92 1.626 1.626 0 0 0-.611-.641 1.719 1.719 0 0 0-.905-.234c-.368 0-.691.09-.97.269a1.85 1.85 0 0 0-.65.696c-.153.285-.231.598-.234.94v1.058c0 .444.08.825.243 1.144.162.315.39.556.681.726.292.165.633.248 1.024.248.262 0 .5-.036.711-.11.212-.075.396-.186.552-.332.156-.146.273-.327.353-.542l1.68.189a2.62 2.62 0 0 1-.606 1.163 2.957 2.957 0 0 1-1.134.766c-.46.179-.987.268-1.58.268ZM94.298 29l-2.158-7.636h1.834l1.343 5.369h.07l1.371-5.37h1.815l1.372 5.34h.075l1.322-5.34h1.84L101.019 29h-1.874l-1.432-5.16h-.104L96.177 29h-1.88Zm13.613 0v-7.636h1.745v1.272h.08c.139-.44.377-.78.716-1.019.341-.242.73-.363 1.168-.363.099 0 .21.005.333.015.126.007.23.018.313.035v1.655a1.888 1.888 0 0 0-.363-.07 3.336 3.336 0 0 0-.472-.034c-.328 0-.623.071-.885.214a1.568 1.568 0 0 0-.835 1.442V29h-1.8Zm8.617.15c-.766 0-1.427-.16-1.984-.478a3.232 3.232 0 0 1-1.277-1.362c-.299-.59-.448-1.285-.448-2.083 0-.786.149-1.475.448-2.069a3.38 3.38 0 0 1 1.262-1.392c.541-.334 1.175-.502 1.905-.502.47 0 .914.076 1.332.229.421.149.792.381 1.114.696.324.315.58.716.765 1.203.186.484.279 1.06.279 1.73v.552h-6.26v-1.213h4.535a1.942 1.942 0 0 0-.224-.92 1.627 1.627 0 0 0-.612-.641 1.717 1.717 0 0 0-.905-.234c-.367 0-.691.09-.969.269a1.845 1.845 0 0 0-.651.696 1.993 1.993 0 0 0-.234.94v1.058c0 .444.081.825.244 1.144.162.315.389.556.681.726.291.165.633.248 1.024.248.262 0 .499-.036.711-.11.212-.075.396-.186.552-.332.155-.146.273-.327.353-.542l1.68.189a2.622 2.622 0 0 1-.606 1.163 2.957 2.957 0 0 1-1.134.766c-.461.179-.988.268-1.581.268Zm8.249 0c-.762 0-1.417-.168-1.964-.503a3.355 3.355 0 0 1-1.257-1.387c-.292-.593-.438-1.276-.438-2.048 0-.776.149-1.46.448-2.054a3.34 3.34 0 0 1 1.262-1.392c.547-.334 1.193-.502 1.939-.502.62 0 1.169.115 1.646.343.48.226.863.546 1.148.96.285.41.448.891.487 1.442h-1.72a1.64 1.64 0 0 0-.497-.92c-.258-.249-.605-.373-1.039-.373-.368 0-.691.1-.969.298-.279.196-.496.477-.652.845-.152.368-.228.81-.228 1.323 0 .52.076.968.228 1.342.153.371.367.658.642.86.278.2.605.299.979.299.265 0 .502-.05.711-.15.212-.102.389-.25.532-.442.142-.192.24-.426.293-.701h1.72a2.999 2.999 0 0 1-.477 1.437c-.275.414-.649.739-1.123.974-.474.232-1.031.348-1.671.348Zm8.08 0c-.745 0-1.392-.165-1.939-.493a3.336 3.336 0 0 1-1.272-1.377c-.299-.59-.448-1.28-.448-2.068 0-.79.149-1.48.448-2.073a3.329 3.329 0 0 1 1.272-1.383c.547-.328 1.194-.492 1.939-.492.746 0 1.392.164 1.939.492a3.3 3.3 0 0 1 1.268 1.383c.302.593.452 1.284.452 2.073 0 .788-.15 1.478-.452 2.068a3.308 3.308 0 0 1-1.268 1.377c-.547.328-1.193.492-1.939.492Zm.01-1.443c.405 0 .743-.11 1.014-.333a2.01 2.01 0 0 0 .607-.904c.136-.378.204-.8.204-1.263 0-.468-.068-.89-.204-1.268a2.009 2.009 0 0 0-.607-.91c-.271-.225-.609-.338-1.014-.338-.414 0-.759.113-1.034.338a2.031 2.031 0 0 0-.611.91 3.8 3.8 0 0 0-.199 1.268c0 .464.066.885.199 1.262.135.378.339.68.611.905.275.222.62.333 1.034.333ZM138.044 29v-7.636h1.745v1.272h.079c.14-.44.378-.78.716-1.019a1.972 1.972 0 0 1 1.169-.363c.099 0 .21.005.333.015.126.007.23.018.313.035v1.655a1.888 1.888 0 0 0-.363-.07 3.336 3.336 0 0 0-.472-.034c-.328 0-.623.071-.885.214-.259.14-.463.333-.612.582a1.64 1.64 0 0 0-.223.86V29h-1.8Zm8.07.134a2.89 2.89 0 0 1-1.611-.462c-.474-.308-.848-.756-1.123-1.343-.275-.586-.413-1.299-.413-2.137 0-.849.139-1.565.418-2.148.281-.587.661-1.03 1.138-1.327a2.925 2.925 0 0 1 1.596-.453c.447 0 .815.076 1.104.229.288.149.517.33.686.542.169.209.3.406.392.591h.075v-3.808h1.805V29h-1.77v-1.203h-.11a3.062 3.062 0 0 1-.402.591 2.224 2.224 0 0 1-.696.527c-.289.146-.652.22-1.089.22Zm.502-1.476c.381 0 .706-.103.975-.309.268-.208.472-.498.611-.87.139-.37.209-.803.209-1.297 0-.494-.07-.923-.209-1.288-.136-.364-.338-.648-.606-.85-.266-.202-.592-.303-.98-.303-.401 0-.736.104-1.004.313a1.894 1.894 0 0 0-.607.865 3.628 3.628 0 0 0-.204 1.263c0 .477.068.903.204 1.277a2 2 0 0 0 .612.88c.272.213.605.319.999.319Z"
      />
    </g>
    <g filter="url(#context-f)">
      <path
        fill="url(#context-g)"
        fillRule="evenodd"
        d="M24 64C10.745 64 0 74.745 0 88v96c0 13.255 10.745 24 24 24h112c13.255 0 24-10.745 24-24v-78.167c0-1.823 1.003-3.526 2.672-4.538l4.992-3.026C168.499 97.763 169 96.912 169 96c0-.912-.501-1.763-1.336-2.27l-4.992-3.025C161.003 89.694 160 87.99 160 86.167V86c0-12.15-9.85-22-22-22H24Z"
        clipRule="evenodd"
      />
    </g>
    <g filter="url(#context-h)">
      <g filter="url(#context-i)">
        <path
          fill="url(#context-j)"
          d="M22 97.5a1.5 1.5 0 1 0-.442-2.934.75.75 0 1 1-.992.992A1.5 1.5 0 0 0 22 97.5Z"
        />
        <path
          fill="url(#context-k)"
          fillRule="evenodd"
          d="M22 92c5.333 0 8 4 8 4s-2.667 4-8 4-8-4-8-4 2.667-4 8-4Zm-3.18 1.573A9.274 9.274 0 0 0 15.282 96a9.274 9.274 0 0 0 3.538 2.427A3.982 3.982 0 0 1 18 96c0-.913.306-1.754.82-2.427ZM22 99a3 3 0 1 1 0-6 3 3 0 0 1 0 6Zm3.18-5.427A9.274 9.274 0 0 1 28.718 96a9.274 9.274 0 0 1-3.538 2.427c.514-.673.82-1.514.82-2.427s-.306-1.754-.82-2.427Z"
          clipRule="evenodd"
        />
      </g>
      <path
        fill="url(#context-l)"
        d="M22 97.5a1.5 1.5 0 1 0-.442-2.934.75.75 0 1 1-.992.992A1.5 1.5 0 0 0 22 97.5Z"
      />
      <path
        fill="url(#context-m)"
        fillRule="evenodd"
        d="M22 92c5.333 0 8 4 8 4s-2.667 4-8 4-8-4-8-4 2.667-4 8-4Zm-3.18 1.573A9.274 9.274 0 0 0 15.282 96a9.274 9.274 0 0 0 3.538 2.427A3.982 3.982 0 0 1 18 96c0-.913.306-1.754.82-2.427ZM22 99a3 3 0 1 1 0-6 3 3 0 0 1 0 6Zm3.18-5.427A9.274 9.274 0 0 1 28.718 96a9.274 9.274 0 0 1-3.538 2.427c.514-.673.82-1.514.82-2.427s-.306-1.754-.82-2.427Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-n)"
        d="m46.367 90.818 2.65 8.014h.104l2.645-8.014h2.028L50.204 101h-2.276l-3.585-10.182h2.023ZM55.056 101v-7.636h1.8V101h-1.8Zm.904-8.72a1.05 1.05 0 0 1-.735-.284.913.913 0 0 1-.309-.69c0-.272.103-.503.309-.692a1.04 1.04 0 0 1 .735-.288c.289 0 .534.096.736.288.206.19.308.42.308.691a.913.913 0 0 1-.308.691 1.038 1.038 0 0 1-.736.284Zm6.127 8.869c-.766 0-1.427-.159-1.984-.477a3.236 3.236 0 0 1-1.278-1.362c-.298-.59-.447-1.285-.447-2.083 0-.786.149-1.475.447-2.069a3.384 3.384 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .915.076 1.333.229.42.149.792.381 1.113.696.325.315.58.716.766 1.203.185.484.278 1.06.278 1.73v.552h-6.259v-1.213h4.534a1.936 1.936 0 0 0-.224-.92 1.627 1.627 0 0 0-.611-.641 1.719 1.719 0 0 0-.905-.234c-.368 0-.691.09-.97.269a1.85 1.85 0 0 0-.65.696c-.153.285-.231.598-.234.94v1.058c0 .444.08.825.243 1.144.163.315.39.556.681.726.292.165.633.248 1.024.248.262 0 .5-.036.711-.11.213-.075.396-.186.552-.332.156-.146.274-.327.353-.542l1.68.189a2.62 2.62 0 0 1-.606 1.163 2.967 2.967 0 0 1-1.133.766c-.461.179-.988.268-1.581.268ZM68.54 101l-2.158-7.636h1.835l1.342 5.369h.07L71 93.363h1.814l1.373 5.34h.074l1.323-5.34h1.839L75.261 101h-1.874l-1.432-5.16h-.104L70.419 101h-1.88Z"
      />
    </g>
    <g filter="url(#context-o)">
      <g filter="url(#context-p)">
        <path
          fill="url(#context-q)"
          fillRule="evenodd"
          d="M26.182 130.061c-.5-.171-1.089.042-1.58.534l-.645.645 2.793 2.795.644-.645c.492-.492.704-1.081.534-1.582a2.831 2.831 0 0 0-.655-1.092 2.836 2.836 0 0 0-1.091-.655Zm-.14 4.681-2.792-2.795-5.985 5.991a1.5 1.5 0 0 0-.403.736l-.703 3.167 3.164-.704a1.5 1.5 0 0 0 .735-.404l5.985-5.991Zm-2.148-4.855c.634-.633 1.606-1.117 2.611-.773a3.822 3.822 0 0 1 1.475.895c.46.46.732 1.002.894 1.476.344 1.006-.14 1.979-.773 2.613l-7.336 7.343a2.5 2.5 0 0 1-1.225.673l-3.931.874a.5.5 0 0 1-.597-.597l.874-3.934c.103-.465.336-.89.672-1.227l7.336-7.343ZM23 142.5a.5.5 0 0 1 .5-.501h5a.5.5 0 0 1 0 1.001h-5a.5.5 0 0 1-.5-.5Z"
          clipRule="evenodd"
        />
      </g>
      <path
        fill="url(#context-r)"
        fillRule="evenodd"
        d="M26.182 130.061c-.5-.171-1.089.042-1.58.534l-.645.645 2.793 2.795.644-.645c.492-.492.704-1.081.534-1.582a2.831 2.831 0 0 0-.655-1.092 2.836 2.836 0 0 0-1.091-.655Zm-.14 4.681-2.792-2.795-5.985 5.991a1.5 1.5 0 0 0-.403.736l-.703 3.167 3.164-.704a1.5 1.5 0 0 0 .735-.404l5.985-5.991Zm-2.148-4.855c.634-.633 1.606-1.117 2.611-.773a3.822 3.822 0 0 1 1.475.895c.46.46.732 1.002.894 1.476.344 1.006-.14 1.979-.773 2.613l-7.336 7.343a2.5 2.5 0 0 1-1.225.673l-3.931.874a.5.5 0 0 1-.597-.597l.874-3.934c.103-.465.336-.89.672-1.227l7.336-7.343ZM23 142.5a.5.5 0 0 1 .5-.501h5a.5.5 0 0 1 0 1.001h-5a.5.5 0 0 1-.5-.5Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-s)"
        d="M45.004 141v-10.182h6.622v1.546H46.85v2.765h4.434v1.546H46.85v2.779h4.817V141h-6.662Zm11.258.134c-.6 0-1.136-.154-1.61-.462-.474-.308-.849-.756-1.124-1.342-.275-.587-.413-1.3-.413-2.138 0-.849.14-1.565.418-2.148.282-.587.661-1.029 1.139-1.327a2.923 2.923 0 0 1 1.595-.453c.448 0 .816.076 1.104.229.288.149.517.33.686.542.17.209.3.406.393.591h.075v-3.808h1.804V141h-1.77v-1.203h-.11a3.065 3.065 0 0 1-.402.591 2.194 2.194 0 0 1-.696.527c-.288.146-.651.219-1.089.219Zm.503-1.476c.38 0 .706-.103.974-.309.269-.208.472-.498.611-.87.14-.371.21-.803.21-1.297 0-.494-.07-.923-.21-1.288-.135-.364-.338-.648-.606-.85-.265-.202-.592-.303-.98-.303-.4 0-.735.104-1.004.313-.268.209-.47.497-.606.865a3.632 3.632 0 0 0-.204 1.263c0 .477.068.903.204 1.278.139.371.343.664.611.879.272.213.605.319 1 .319ZM62.247 141v-7.636h1.8V141h-1.8Zm.905-8.72a1.05 1.05 0 0 1-.736-.284.912.912 0 0 1-.308-.691c0-.271.103-.502.308-.691a1.04 1.04 0 0 1 .736-.288c.288 0 .533.096.736.288.205.189.308.42.308.691a.912.912 0 0 1-.308.691 1.039 1.039 0 0 1-.736.284Zm6.559 1.084v1.392h-4.39v-1.392h4.39Zm-3.306-1.83h1.8v7.169c0 .242.036.428.109.557a.587.587 0 0 0 .298.258c.123.047.258.07.407.07a2.196 2.196 0 0 0 .527-.07l.304 1.407c-.096.034-.234.07-.413.11-.175.04-.391.063-.646.069a2.925 2.925 0 0 1-1.218-.203 1.9 1.9 0 0 1-.86-.706c-.21-.319-.312-.716-.308-1.194v-7.467Z"
      />
    </g>
    <g filter="url(#context-t)">
      <g filter="url(#context-u)">
        <path
          fill="url(#context-v)"
          fillRule="evenodd"
          d="M21 170a.5.5 0 0 0-.5.5v1h3v-1a.5.5 0 0 0-.5-.5h-2Zm3.5 1.5v-1A1.5 1.5 0 0 0 23 169h-2a1.5 1.5 0 0 0-1.5 1.5v1h-4a.5.5 0 0 0 0 1h1.066l1.316 9.212A1.5 1.5 0 0 0 19.367 183h5.266a1.5 1.5 0 0 0 1.485-1.288l1.316-9.212H28.5a.5.5 0 0 0 0-1h-4Zm1.924 1h-8.848l1.296 9.071a.5.5 0 0 0 .495.429h5.266a.5.5 0 0 0 .495-.429l1.296-9.071Z"
          clipRule="evenodd"
        />
      </g>
      <path
        fill="url(#context-w)"
        fillRule="evenodd"
        d="M21 170a.5.5 0 0 0-.5.5v1h3v-1a.5.5 0 0 0-.5-.5h-2Zm3.5 1.5v-1A1.5 1.5 0 0 0 23 169h-2a1.5 1.5 0 0 0-1.5 1.5v1h-4a.5.5 0 0 0 0 1h1.066l1.316 9.212A1.5 1.5 0 0 0 19.367 183h5.266a1.5 1.5 0 0 0 1.485-1.288l1.316-9.212H28.5a.5.5 0 0 0 0-1h-4Zm1.924 1h-8.848l1.296 9.071a.5.5 0 0 0 .495.429h5.266a.5.5 0 0 0 .495-.429l1.296-9.071Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-x)"
        d="M48.455 181h-3.45v-10.182h3.52c1.01 0 1.878.204 2.604.612.73.404 1.29.986 1.68 1.745.392.759.587 1.667.587 2.724 0 1.061-.197 1.972-.591 2.735a4.085 4.085 0 0 1-1.696 1.754c-.735.408-1.62.612-2.654.612Zm-1.606-1.596h1.516c.71 0 1.301-.129 1.775-.388a2.48 2.48 0 0 0 1.069-1.168c.238-.52.358-1.17.358-1.949 0-.779-.12-1.425-.358-1.939a2.439 2.439 0 0 0-1.06-1.158c-.463-.259-1.04-.388-1.73-.388h-1.57v6.99Zm11.6 1.745c-.765 0-1.426-.159-1.983-.477a3.238 3.238 0 0 1-1.277-1.362c-.299-.59-.448-1.285-.448-2.083 0-.786.15-1.475.448-2.069a3.39 3.39 0 0 1 1.262-1.392c.54-.334 1.175-.502 1.904-.502.471 0 .915.076 1.333.229.42.149.792.381 1.113.696.325.315.58.716.766 1.203.186.484.279 1.061.279 1.73v.552h-6.26v-1.213h4.534a1.938 1.938 0 0 0-.223-.92 1.627 1.627 0 0 0-.612-.641 1.718 1.718 0 0 0-.905-.234c-.368 0-.69.09-.97.269a1.84 1.84 0 0 0-.65.696 2 2 0 0 0-.234.939v1.059c0 .444.081.826.243 1.144.163.315.39.557.682.726.291.165.633.248 1.024.248.262 0 .499-.036.71-.109.213-.076.397-.187.553-.333.155-.146.273-.327.353-.542l1.68.189a2.617 2.617 0 0 1-.607 1.163 2.967 2.967 0 0 1-1.133.766c-.46.179-.988.268-1.581.268Zm6.719-10.331V181h-1.8v-10.182h1.8Zm5.231 10.331c-.766 0-1.427-.159-1.984-.477a3.238 3.238 0 0 1-1.277-1.362c-.299-.59-.448-1.285-.448-2.083 0-.786.15-1.475.448-2.069a3.39 3.39 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .914.076 1.332.229.421.149.792.381 1.114.696.325.315.58.716.765 1.203.186.484.279 1.061.279 1.73v.552h-6.26v-1.213h4.535a1.938 1.938 0 0 0-.224-.92 1.627 1.627 0 0 0-.612-.641 1.717 1.717 0 0 0-.904-.234c-.368 0-.692.09-.97.269a1.84 1.84 0 0 0-.651.696c-.153.285-.23.598-.234.939v1.059c0 .444.081.826.244 1.144.162.315.39.557.68.726.293.165.634.248 1.025.248.262 0 .499-.036.71-.109.213-.076.397-.187.553-.333.156-.146.273-.327.353-.542l1.68.189a2.617 2.617 0 0 1-.606 1.163 2.967 2.967 0 0 1-1.134.766c-.46.179-.988.268-1.58.268Zm8.731-7.785v1.392h-4.39v-1.392h4.39Zm-3.306-1.83h1.8v7.169c0 .242.037.428.11.557a.587.587 0 0 0 .298.258c.122.047.258.07.407.07a2.196 2.196 0 0 0 .527-.07l.304 1.407c-.096.034-.234.07-.413.11-.176.04-.391.063-.646.069a2.925 2.925 0 0 1-1.218-.203 1.9 1.9 0 0 1-.86-.706c-.21-.319-.312-.716-.309-1.194v-7.467Zm8.11 9.615c-.765 0-1.427-.159-1.983-.477a3.238 3.238 0 0 1-1.278-1.362c-.298-.59-.448-1.285-.448-2.083 0-.786.15-1.475.448-2.069a3.392 3.392 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .915.076 1.332.229.421.149.792.381 1.114.696.325.315.58.716.766 1.203.185.484.278 1.061.278 1.73v.552h-6.26v-1.213h4.535a1.938 1.938 0 0 0-.224-.92 1.625 1.625 0 0 0-.612-.641 1.717 1.717 0 0 0-.904-.234c-.368 0-.691.09-.97.269a1.84 1.84 0 0 0-.651.696 2 2 0 0 0-.234.939v1.059c0 .444.081.826.244 1.144.162.315.39.557.681.726.292.165.633.248 1.024.248.262 0 .499-.036.711-.109a1.57 1.57 0 0 0 .552-.333c.156-.146.273-.327.353-.542l1.68.189a2.616 2.616 0 0 1-.606 1.163 2.967 2.967 0 0 1-1.134.766c-.46.179-.987.268-1.58.268Z"
      />
    </g>
    <defs>
      <linearGradient
        id="context-c"
        x1={14}
        x2={30}
        y1={16}
        y2={32}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#26D97F" />
        <stop offset={1} stopColor="#47EBEB" />
      </linearGradient>
      <linearGradient
        id="context-d"
        x1={14}
        x2={30}
        y1={16}
        y2={32}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#26D97F" />
        <stop offset={1} stopColor="#47EBEB" />
      </linearGradient>
      <linearGradient
        id="context-e"
        x1={98}
        x2={98}
        y1={12}
        y2={36}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" />
        <stop offset={1} stopColor="#fff" stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="context-g"
        x1={169}
        x2={0}
        y1={64}
        y2={208}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={0.265} stopOpacity={0.6} />
        <stop offset={1} stopOpacity={0.3} />
      </linearGradient>
      <linearGradient
        id="context-j"
        x1={14}
        x2={20.4}
        y1={92}
        y2={104.8}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F93" />
        <stop offset={1} stopColor="#FFBF00" />
      </linearGradient>
      <linearGradient
        id="context-k"
        x1={14}
        x2={20.4}
        y1={92}
        y2={104.8}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F93" />
        <stop offset={1} stopColor="#FFBF00" />
      </linearGradient>
      <linearGradient
        id="context-l"
        x1={14}
        x2={20.4}
        y1={92}
        y2={104.8}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F93" />
        <stop offset={1} stopColor="#FFBF00" />
      </linearGradient>
      <linearGradient
        id="context-m"
        x1={14}
        x2={20.4}
        y1={92}
        y2={104.8}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F93" />
        <stop offset={1} stopColor="#FFBF00" />
      </linearGradient>
      <linearGradient
        id="context-n"
        x1={61}
        x2={61}
        y1={84}
        y2={108}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" />
        <stop offset={1} stopColor="#fff" stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="context-q"
        x1={15}
        x2={31}
        y1={127}
        y2={143}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0080FF" />
        <stop offset={1} stopColor="#6EB3F7" />
      </linearGradient>
      <linearGradient
        id="context-r"
        x1={15}
        x2={31}
        y1={127}
        y2={143}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0080FF" />
        <stop offset={1} stopColor="#6EB3F7" />
      </linearGradient>
      <linearGradient
        id="context-s"
        x1={57.5}
        x2={57.5}
        y1={124}
        y2={148}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" />
        <stop offset={1} stopColor="#fff" stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="context-v"
        x1={15}
        x2={29}
        y1={169}
        y2={183}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FF4C4D" />
        <stop offset={1} stopColor="#ED5EC9" />
      </linearGradient>
      <linearGradient
        id="context-w"
        x1={15}
        x2={29}
        y1={169}
        y2={183}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FF4C4D" />
        <stop offset={1} stopColor="#ED5EC9" />
      </linearGradient>
      <linearGradient
        id="context-x"
        x1={66}
        x2={66}
        y1={164}
        y2={188}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" />
        <stop offset={1} stopColor="#fff" stopOpacity={0.5} />
      </linearGradient>
      <filter
        id="context-a"
        width={216}
        height={80}
        x={-16}
        y={-16}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_4359_577"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_4359_577"
          result="shape"
        />
      </filter>
      <filter
        id="context-b"
        width={32}
        height={32}
        x={6}
        y={8}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur
          result="effect1_foregroundBlur_4359_577"
          stdDeviation={4}
        />
      </filter>
      <filter
        id="context-f"
        width={201}
        height={176}
        x={-16}
        y={48}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_4359_577"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_4359_577"
          result="shape"
        />
      </filter>
      <filter
        id="context-h"
        width={168}
        height={56}
        x={-4}
        y={68}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_4359_577"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_4359_577"
          result="shape"
        />
      </filter>
      <filter
        id="context-i"
        width={32}
        height={24}
        x={6}
        y={84}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur
          result="effect1_foregroundBlur_4359_577"
          stdDeviation={4}
        />
      </filter>
      <filter
        id="context-o"
        width={168}
        height={56}
        x={-4}
        y={108}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_4359_577"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_4359_577"
          result="shape"
        />
      </filter>
      <filter
        id="context-p"
        width={30}
        height={30}
        x={7}
        y={121}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur
          result="effect1_foregroundBlur_4359_577"
          stdDeviation={4}
        />
      </filter>
      <filter
        id="context-t"
        width={168}
        height={56}
        x={-4}
        y={148}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_4359_577"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_4359_577"
          result="shape"
        />
      </filter>
      <filter
        id="context-u"
        width={30}
        height={30}
        x={7}
        y={161}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feGaussianBlur
          result="effect1_foregroundBlur_4359_577"
          stdDeviation={4}
        />
      </filter>
    </defs>
  </svg>
);

const ContextLightSvg = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={184}
    height={208}
    fill="none"
    {...props}
  >
    <g filter="url(#context-light-a)">
      <rect width={184} height={48} fill="#fff" fillOpacity={0.8} rx={24} />
      <rect
        width={183}
        height={47}
        x={0.5}
        y={0.5}
        stroke="#CFD7E2"
        rx={23.5}
      />
      <path
        fill="url(#context-light-b)"
        fillRule="evenodd"
        d="M22 32a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-1a7 7 0 1 0 0-14 7 7 0 0 0 0 14Zm0-10a.5.5 0 0 1 .5.5v2h2a.5.5 0 0 1 0 1h-2v2a.5.5 0 0 1-1 0v-2h-2a.5.5 0 0 1 0-1h2v-2a.5.5 0 0 1 .5-.5Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-light-c)"
        d="M46.312 29h-1.969l3.585-10.182h2.277L53.794 29h-1.969l-2.72-8.094h-.079L46.312 29Zm.064-3.992h5.37v1.481h-5.37v-1.481Zm11.281 4.126a2.89 2.89 0 0 1-1.61-.462c-.475-.308-.85-.756-1.124-1.343-.276-.586-.413-1.299-.413-2.137 0-.849.14-1.565.418-2.148.281-.587.66-1.03 1.138-1.327a2.926 2.926 0 0 1 1.596-.453c.447 0 .815.076 1.104.229.288.149.517.33.686.542.169.209.3.406.392.591h.075v-3.808h1.805V29h-1.77v-1.203h-.11a3.078 3.078 0 0 1-.402.591 2.216 2.216 0 0 1-.696.527c-.289.146-.652.22-1.089.22Zm.502-1.476c.381 0 .706-.103.974-.309.269-.208.473-.498.612-.87.14-.37.209-.803.209-1.297 0-.494-.07-.923-.209-1.288-.136-.364-.338-.648-.606-.85-.266-.202-.592-.303-.98-.303-.401 0-.736.104-1.004.313-.269.209-.47.497-.607.865a3.63 3.63 0 0 0-.204 1.263c0 .477.068.903.204 1.277.14.372.343.665.612.88.272.213.605.319 1 .319Zm8.316 1.476a2.89 2.89 0 0 1-1.61-.462c-.474-.308-.849-.756-1.124-1.343-.275-.586-.413-1.299-.413-2.137 0-.849.14-1.565.418-2.148.282-.587.661-1.03 1.138-1.327a2.926 2.926 0 0 1 1.596-.453c.448 0 .816.076 1.104.229.288.149.517.33.686.542.17.209.3.406.393.591h.074v-3.808h1.805V29h-1.77v-1.203h-.11a3.073 3.073 0 0 1-.402.591 2.215 2.215 0 0 1-.696.527c-.288.146-.651.22-1.089.22Zm.503-1.476c.38 0 .705-.103.974-.309.268-.208.472-.498.611-.87.14-.37.21-.803.21-1.297 0-.494-.07-.923-.21-1.288-.136-.364-.338-.648-.606-.85-.265-.202-.592-.303-.98-.303-.4 0-.735.104-1.004.313-.268.209-.47.497-.606.865a3.63 3.63 0 0 0-.204 1.263c0 .477.068.903.204 1.277.139.372.343.665.611.88.272.213.605.319 1 .319Zm10.754-3.132V29h-1.8v-7.636h1.72v1.297h.09c.176-.427.456-.767.84-1.019.388-.252.867-.378 1.437-.378.527 0 .986.113 1.377.338.395.226.7.552.915.98.219.427.326.946.323 1.556V29h-1.8v-4.584c0-.51-.132-.91-.397-1.198-.262-.288-.625-.433-1.089-.433-.315 0-.595.07-.84.21a1.448 1.448 0 0 0-.572.59c-.136.26-.204.573-.204.94Zm10.112 4.623c-.765 0-1.426-.159-1.983-.477a3.233 3.233 0 0 1-1.278-1.362c-.298-.59-.447-1.285-.447-2.083 0-.786.149-1.475.447-2.069a3.384 3.384 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .915.076 1.332.229.421.149.793.381 1.114.696.325.315.58.716.766 1.203.185.484.278 1.06.278 1.73v.552h-6.26v-1.213h4.535a1.936 1.936 0 0 0-.224-.92 1.626 1.626 0 0 0-.611-.641 1.719 1.719 0 0 0-.905-.234c-.368 0-.691.09-.97.269a1.85 1.85 0 0 0-.65.696c-.153.285-.231.598-.234.94v1.058c0 .444.08.825.243 1.144.162.315.39.556.681.726.292.165.633.248 1.024.248.262 0 .5-.036.711-.11.212-.075.396-.186.552-.332.156-.146.273-.327.353-.542l1.68.189a2.62 2.62 0 0 1-.606 1.163 2.957 2.957 0 0 1-1.134.766c-.46.179-.987.268-1.58.268ZM94.298 29l-2.158-7.636h1.834l1.343 5.369h.07l1.371-5.37h1.815l1.372 5.34h.075l1.322-5.34h1.84L101.019 29h-1.874l-1.432-5.16h-.104L96.177 29h-1.88Zm13.613 0v-7.636h1.745v1.272h.08c.139-.44.377-.78.716-1.019.341-.242.73-.363 1.168-.363.099 0 .21.005.333.015.126.007.23.018.313.035v1.655a1.888 1.888 0 0 0-.363-.07 3.336 3.336 0 0 0-.472-.034c-.328 0-.623.071-.885.214a1.568 1.568 0 0 0-.835 1.442V29h-1.8Zm8.617.15c-.766 0-1.427-.16-1.984-.478a3.232 3.232 0 0 1-1.277-1.362c-.299-.59-.448-1.285-.448-2.083 0-.786.149-1.475.448-2.069a3.38 3.38 0 0 1 1.262-1.392c.541-.334 1.175-.502 1.905-.502.47 0 .914.076 1.332.229.421.149.792.381 1.114.696.324.315.58.716.765 1.203.186.484.279 1.06.279 1.73v.552h-6.26v-1.213h4.535a1.942 1.942 0 0 0-.224-.92 1.627 1.627 0 0 0-.612-.641 1.717 1.717 0 0 0-.905-.234c-.367 0-.691.09-.969.269a1.845 1.845 0 0 0-.651.696 1.993 1.993 0 0 0-.234.94v1.058c0 .444.081.825.244 1.144.162.315.389.556.681.726.291.165.633.248 1.024.248.262 0 .499-.036.711-.11.212-.075.396-.186.552-.332.155-.146.273-.327.353-.542l1.68.189a2.622 2.622 0 0 1-.606 1.163 2.957 2.957 0 0 1-1.134.766c-.461.179-.988.268-1.581.268Zm8.249 0c-.762 0-1.417-.168-1.964-.503a3.355 3.355 0 0 1-1.257-1.387c-.292-.593-.438-1.276-.438-2.048 0-.776.149-1.46.448-2.054a3.34 3.34 0 0 1 1.262-1.392c.547-.334 1.193-.502 1.939-.502.62 0 1.169.115 1.646.343.48.226.863.546 1.148.96.285.41.448.891.487 1.442h-1.72a1.64 1.64 0 0 0-.497-.92c-.258-.249-.605-.373-1.039-.373-.368 0-.691.1-.969.298-.279.196-.496.477-.652.845-.152.368-.228.81-.228 1.323 0 .52.076.968.228 1.342.153.371.367.658.642.86.278.2.605.299.979.299.265 0 .502-.05.711-.15.212-.102.389-.25.532-.442.142-.192.24-.426.293-.701h1.72a2.999 2.999 0 0 1-.477 1.437c-.275.414-.649.739-1.123.974-.474.232-1.031.348-1.671.348Zm8.08 0c-.745 0-1.392-.165-1.939-.493a3.336 3.336 0 0 1-1.272-1.377c-.299-.59-.448-1.28-.448-2.068 0-.79.149-1.48.448-2.073a3.329 3.329 0 0 1 1.272-1.383c.547-.328 1.194-.492 1.939-.492.746 0 1.392.164 1.939.492a3.3 3.3 0 0 1 1.268 1.383c.302.593.452 1.284.452 2.073 0 .788-.15 1.478-.452 2.068a3.308 3.308 0 0 1-1.268 1.377c-.547.328-1.193.492-1.939.492Zm.01-1.443c.405 0 .743-.11 1.014-.333a2.01 2.01 0 0 0 .607-.904c.136-.378.204-.8.204-1.263 0-.468-.068-.89-.204-1.268a2.009 2.009 0 0 0-.607-.91c-.271-.225-.609-.338-1.014-.338-.414 0-.759.113-1.034.338a2.031 2.031 0 0 0-.611.91 3.8 3.8 0 0 0-.199 1.268c0 .464.066.885.199 1.262.135.378.339.68.611.905.275.222.62.333 1.034.333ZM138.044 29v-7.636h1.745v1.272h.079c.14-.44.378-.78.716-1.019a1.972 1.972 0 0 1 1.169-.363c.099 0 .21.005.333.015.126.007.23.018.313.035v1.655a1.888 1.888 0 0 0-.363-.07 3.336 3.336 0 0 0-.472-.034c-.328 0-.623.071-.885.214-.259.14-.463.333-.612.582a1.64 1.64 0 0 0-.223.86V29h-1.8Zm8.07.134a2.89 2.89 0 0 1-1.611-.462c-.474-.308-.848-.756-1.123-1.343-.275-.586-.413-1.299-.413-2.137 0-.849.139-1.565.418-2.148.281-.587.661-1.03 1.138-1.327a2.925 2.925 0 0 1 1.596-.453c.447 0 .815.076 1.104.229.288.149.517.33.686.542.169.209.3.406.392.591h.075v-3.808h1.805V29h-1.77v-1.203h-.11a3.062 3.062 0 0 1-.402.591 2.224 2.224 0 0 1-.696.527c-.289.146-.652.22-1.089.22Zm.502-1.476c.381 0 .706-.103.975-.309.268-.208.472-.498.611-.87.139-.37.209-.803.209-1.297 0-.494-.07-.923-.209-1.288-.136-.364-.338-.648-.606-.85-.266-.202-.592-.303-.98-.303-.401 0-.736.104-1.004.313a1.894 1.894 0 0 0-.607.865 3.628 3.628 0 0 0-.204 1.263c0 .477.068.903.204 1.277a2 2 0 0 0 .612.88c.272.213.605.319.999.319Z"
      />
    </g>
    <g filter="url(#context-light-d)">
      <mask id="context-light-e" fill="#fff">
        <path
          fillRule="evenodd"
          d="M24 64C10.745 64 0 74.745 0 88v96c0 13.255 10.745 24 24 24h112c13.255 0 24-10.745 24-24v-78.167c0-1.823 1.003-3.526 2.672-4.538l4.992-3.026C168.499 97.763 169 96.912 169 96c0-.912-.501-1.763-1.336-2.27l-4.992-3.025C161.003 89.694 160 87.99 160 86.167V86c0-12.15-9.85-22-22-22H24Z"
          clipRule="evenodd"
        />
      </mask>
      <path
        fill="#fff"
        fillRule="evenodd"
        d="M24 64C10.745 64 0 74.745 0 88v96c0 13.255 10.745 24 24 24h112c13.255 0 24-10.745 24-24v-78.167c0-1.823 1.003-3.526 2.672-4.538l4.992-3.026C168.499 97.763 169 96.912 169 96c0-.912-.501-1.763-1.336-2.27l-4.992-3.025C161.003 89.694 160 87.99 160 86.167V86c0-12.15-9.85-22-22-22H24Z"
        clipRule="evenodd"
      />
      <path
        fill="#CFD7E2"
        d="m162.672 101.295-.519-.855.519.855Zm4.992-3.026.518.855-.518-.855Zm0-4.538.518-.855-.518.855Zm-4.992-3.026-.519.855.519-.855ZM1 88c0-12.703 10.297-23 23-23v-2C10.193 63-1 74.193-1 88h2Zm0 96V88h-2v96h2Zm23 23c-12.703 0-23-10.297-23-23h-2c0 13.807 11.193 25 25 25v-2Zm112 0H24v2h112v-2Zm23-23c0 12.703-10.297 23-23 23v2c13.807 0 25-11.193 25-25h-2Zm0-76v76h2v-76h-2Zm2 0v-2.167h-2V108h2Zm0-2.167c0-1.445.795-2.837 2.19-3.683l-1.037-1.71c-1.942 1.177-3.153 3.191-3.153 5.393h2Zm2.19-3.683 4.992-3.026-1.036-1.71-4.993 3.026 1.037 1.71Zm4.992-3.026C169.291 98.453 170 97.29 170 96h-2c0 .533-.293 1.074-.854 1.414l1.036 1.71ZM170 96c0-1.29-.709-2.453-1.818-3.124l-1.036 1.71c.561.34.854.88.854 1.414h2Zm-1.818-3.124-4.992-3.026-1.037 1.71 4.993 3.026 1.036-1.71Zm-4.992-3.026c-1.395-.846-2.19-2.238-2.19-3.683h-2c0 2.202 1.211 4.216 3.153 5.393l1.037-1.71ZM161 86.167V86h-2v.167h2ZM138 65c11.598 0 21 9.402 21 21h2c0-12.703-10.297-23-23-23v2ZM24 65h114v-2H24v2Z"
        mask="url(#context-light-e)"
      />
    </g>
    <g filter="url(#context-light-f)">
      <path
        fill="url(#context-light-g)"
        d="M22 97.5a1.5 1.5 0 1 0-.442-2.934.75.75 0 1 1-.992.992A1.5 1.5 0 0 0 22 97.5Z"
      />
      <path
        fill="url(#context-light-h)"
        fillRule="evenodd"
        d="M22 92c5.333 0 8 4 8 4s-2.667 4-8 4-8-4-8-4 2.667-4 8-4Zm-3.18 1.573A9.274 9.274 0 0 0 15.282 96a9.274 9.274 0 0 0 3.538 2.427A3.982 3.982 0 0 1 18 96c0-.913.306-1.754.82-2.427ZM22 99a3 3 0 1 1 0-6 3 3 0 0 1 0 6Zm3.18-5.427A9.274 9.274 0 0 1 28.718 96a9.274 9.274 0 0 1-3.538 2.427c.514-.673.82-1.514.82-2.427s-.306-1.754-.82-2.427Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-light-i)"
        d="m46.367 90.818 2.65 8.014h.104l2.645-8.014h2.028L50.204 101h-2.276l-3.585-10.182h2.023ZM55.056 101v-7.636h1.8V101h-1.8Zm.904-8.72a1.05 1.05 0 0 1-.735-.284.913.913 0 0 1-.309-.69c0-.272.103-.503.309-.692a1.04 1.04 0 0 1 .735-.288c.289 0 .534.096.736.288.206.19.308.42.308.691a.913.913 0 0 1-.308.691 1.038 1.038 0 0 1-.736.284Zm6.127 8.869c-.766 0-1.427-.159-1.984-.477a3.236 3.236 0 0 1-1.278-1.362c-.298-.59-.447-1.285-.447-2.083 0-.786.149-1.475.447-2.069a3.384 3.384 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .915.076 1.333.229.42.149.792.381 1.113.696.325.315.58.716.766 1.203.185.484.278 1.06.278 1.73v.552h-6.259v-1.213h4.534a1.936 1.936 0 0 0-.224-.92 1.627 1.627 0 0 0-.611-.641 1.719 1.719 0 0 0-.905-.234c-.368 0-.691.09-.97.269a1.85 1.85 0 0 0-.65.696c-.153.285-.231.598-.234.94v1.058c0 .444.08.825.243 1.144.163.315.39.556.681.726.292.165.633.248 1.024.248.262 0 .5-.036.711-.11.213-.075.396-.186.552-.332.156-.146.274-.327.353-.542l1.68.189a2.62 2.62 0 0 1-.606 1.163 2.967 2.967 0 0 1-1.133.766c-.461.179-.988.268-1.581.268ZM68.54 101l-2.158-7.636h1.835l1.342 5.369h.07L71 93.363h1.814l1.373 5.34h.074l1.323-5.34h1.839L75.261 101h-1.874l-1.432-5.16h-.104L70.419 101h-1.88Z"
      />
    </g>
    <g filter="url(#context-light-j)">
      <path
        fill="url(#context-light-k)"
        fillRule="evenodd"
        d="M26.182 130.061c-.5-.171-1.089.042-1.58.534l-.645.645 2.793 2.795.644-.645c.492-.492.704-1.081.534-1.582a2.831 2.831 0 0 0-.655-1.092 2.836 2.836 0 0 0-1.091-.655Zm-.14 4.681-2.792-2.795-5.985 5.991a1.5 1.5 0 0 0-.403.736l-.703 3.167 3.164-.704a1.5 1.5 0 0 0 .735-.404l5.985-5.991Zm-2.148-4.855c.634-.633 1.606-1.117 2.611-.773a3.822 3.822 0 0 1 1.475.895c.46.46.732 1.002.894 1.476.344 1.006-.14 1.979-.773 2.613l-7.336 7.343a2.5 2.5 0 0 1-1.225.673l-3.931.874a.5.5 0 0 1-.597-.597l.874-3.934c.103-.465.336-.89.672-1.227l7.336-7.343ZM23 142.5a.5.5 0 0 1 .5-.501h5a.5.5 0 0 1 0 1.001h-5a.5.5 0 0 1-.5-.5Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-light-l)"
        d="M45.004 141v-10.182h6.622v1.546H46.85v2.765h4.434v1.546H46.85v2.779h4.817V141h-6.662Zm11.258.134c-.6 0-1.136-.154-1.61-.462-.474-.308-.849-.756-1.124-1.342-.275-.587-.413-1.3-.413-2.138 0-.849.14-1.565.418-2.148.282-.587.661-1.029 1.139-1.327a2.923 2.923 0 0 1 1.595-.453c.448 0 .816.076 1.104.229.288.149.517.33.686.542.17.209.3.406.393.591h.075v-3.808h1.804V141h-1.77v-1.203h-.11a3.065 3.065 0 0 1-.402.591 2.194 2.194 0 0 1-.696.527c-.288.146-.651.219-1.089.219Zm.503-1.476c.38 0 .706-.103.974-.309.269-.208.472-.498.611-.87.14-.371.21-.803.21-1.297 0-.494-.07-.923-.21-1.288-.135-.364-.338-.648-.606-.85-.265-.202-.592-.303-.98-.303-.4 0-.735.104-1.004.313-.268.209-.47.497-.606.865a3.632 3.632 0 0 0-.204 1.263c0 .477.068.903.204 1.278.139.371.343.664.611.879.272.213.605.319 1 .319ZM62.247 141v-7.636h1.8V141h-1.8Zm.905-8.72a1.05 1.05 0 0 1-.736-.284.912.912 0 0 1-.308-.691c0-.271.103-.502.308-.691a1.04 1.04 0 0 1 .736-.288c.288 0 .533.096.736.288.205.189.308.42.308.691a.912.912 0 0 1-.308.691 1.039 1.039 0 0 1-.736.284Zm6.559 1.084v1.392h-4.39v-1.392h4.39Zm-3.306-1.83h1.8v7.169c0 .242.036.428.109.557a.587.587 0 0 0 .298.258c.123.047.258.07.407.07a2.196 2.196 0 0 0 .527-.07l.304 1.407c-.096.034-.234.07-.413.11-.175.04-.391.063-.646.069a2.925 2.925 0 0 1-1.218-.203 1.9 1.9 0 0 1-.86-.706c-.21-.319-.312-.716-.308-1.194v-7.467Z"
      />
    </g>
    <g filter="url(#context-light-m)">
      <path
        fill="url(#context-light-n)"
        fillRule="evenodd"
        d="M21 170a.5.5 0 0 0-.5.5v1h3v-1a.5.5 0 0 0-.5-.5h-2Zm3.5 1.5v-1A1.5 1.5 0 0 0 23 169h-2a1.5 1.5 0 0 0-1.5 1.5v1h-4a.5.5 0 0 0 0 1h1.066l1.316 9.212A1.5 1.5 0 0 0 19.367 183h5.266a1.5 1.5 0 0 0 1.485-1.288l1.316-9.212H28.5a.5.5 0 0 0 0-1h-4Zm1.924 1h-8.848l1.296 9.071a.5.5 0 0 0 .495.429h5.266a.5.5 0 0 0 .495-.429l1.296-9.071Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#context-light-o)"
        d="M48.455 181h-3.45v-10.182h3.52c1.01 0 1.878.204 2.604.612.73.404 1.29.986 1.68 1.745.392.759.587 1.667.587 2.724 0 1.061-.197 1.972-.591 2.735a4.085 4.085 0 0 1-1.696 1.754c-.735.408-1.62.612-2.654.612Zm-1.606-1.596h1.516c.71 0 1.301-.129 1.775-.388a2.48 2.48 0 0 0 1.069-1.168c.238-.52.358-1.17.358-1.949 0-.779-.12-1.425-.358-1.939a2.439 2.439 0 0 0-1.06-1.158c-.463-.259-1.04-.388-1.73-.388h-1.57v6.99Zm11.6 1.745c-.765 0-1.426-.159-1.983-.477a3.238 3.238 0 0 1-1.277-1.362c-.299-.59-.448-1.285-.448-2.083 0-.786.15-1.475.448-2.069a3.39 3.39 0 0 1 1.262-1.392c.54-.334 1.175-.502 1.904-.502.471 0 .915.076 1.333.229.42.149.792.381 1.113.696.325.315.58.716.766 1.203.186.484.279 1.061.279 1.73v.552h-6.26v-1.213h4.534a1.938 1.938 0 0 0-.223-.92 1.627 1.627 0 0 0-.612-.641 1.718 1.718 0 0 0-.905-.234c-.368 0-.69.09-.97.269a1.84 1.84 0 0 0-.65.696 2 2 0 0 0-.234.939v1.059c0 .444.081.826.243 1.144.163.315.39.557.682.726.291.165.633.248 1.024.248.262 0 .499-.036.71-.109.213-.076.397-.187.553-.333.155-.146.273-.327.353-.542l1.68.189a2.617 2.617 0 0 1-.607 1.163 2.967 2.967 0 0 1-1.133.766c-.46.179-.988.268-1.581.268Zm6.719-10.331V181h-1.8v-10.182h1.8Zm5.231 10.331c-.766 0-1.427-.159-1.984-.477a3.238 3.238 0 0 1-1.277-1.362c-.299-.59-.448-1.285-.448-2.083 0-.786.15-1.475.448-2.069a3.39 3.39 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .914.076 1.332.229.421.149.792.381 1.114.696.325.315.58.716.765 1.203.186.484.279 1.061.279 1.73v.552h-6.26v-1.213h4.535a1.938 1.938 0 0 0-.224-.92 1.627 1.627 0 0 0-.612-.641 1.717 1.717 0 0 0-.904-.234c-.368 0-.692.09-.97.269a1.84 1.84 0 0 0-.651.696c-.153.285-.23.598-.234.939v1.059c0 .444.081.826.244 1.144.162.315.39.557.68.726.293.165.634.248 1.025.248.262 0 .499-.036.71-.109.213-.076.397-.187.553-.333.156-.146.273-.327.353-.542l1.68.189a2.617 2.617 0 0 1-.606 1.163 2.967 2.967 0 0 1-1.134.766c-.46.179-.988.268-1.58.268Zm8.731-7.785v1.392h-4.39v-1.392h4.39Zm-3.306-1.83h1.8v7.169c0 .242.037.428.11.557a.587.587 0 0 0 .298.258c.122.047.258.07.407.07a2.196 2.196 0 0 0 .527-.07l.304 1.407c-.096.034-.234.07-.413.11-.176.04-.391.063-.646.069a2.925 2.925 0 0 1-1.218-.203 1.9 1.9 0 0 1-.86-.706c-.21-.319-.312-.716-.309-1.194v-7.467Zm8.11 9.615c-.765 0-1.427-.159-1.983-.477a3.238 3.238 0 0 1-1.278-1.362c-.298-.59-.448-1.285-.448-2.083 0-.786.15-1.475.448-2.069a3.392 3.392 0 0 1 1.263-1.392c.54-.334 1.175-.502 1.904-.502.47 0 .915.076 1.332.229.421.149.792.381 1.114.696.325.315.58.716.766 1.203.185.484.278 1.061.278 1.73v.552h-6.26v-1.213h4.535a1.938 1.938 0 0 0-.224-.92 1.625 1.625 0 0 0-.612-.641 1.717 1.717 0 0 0-.904-.234c-.368 0-.691.09-.97.269a1.84 1.84 0 0 0-.651.696 2 2 0 0 0-.234.939v1.059c0 .444.081.826.244 1.144.162.315.39.557.681.726.292.165.633.248 1.024.248.262 0 .499-.036.711-.109a1.57 1.57 0 0 0 .552-.333c.156-.146.273-.327.353-.542l1.68.189a2.616 2.616 0 0 1-.606 1.163 2.967 2.967 0 0 1-1.134.766c-.46.179-.987.268-1.58.268Z"
      />
    </g>
    <defs>
      <linearGradient
        id="context-light-b"
        x1={14}
        x2={30}
        y1={16}
        y2={32}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#24A866" />
        <stop offset={1} stopColor="#0F8A8A" />
      </linearGradient>
      <linearGradient
        id="context-light-c"
        x1={98}
        x2={98}
        y1={12}
        y2={36}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="context-light-g"
        x1={14}
        x2={20.4}
        y1={92}
        y2={104.8}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FF710A" />
        <stop offset={1} stopColor="#F93" />
      </linearGradient>
      <linearGradient
        id="context-light-h"
        x1={14}
        x2={20.4}
        y1={92}
        y2={104.8}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FF710A" />
        <stop offset={1} stopColor="#F93" />
      </linearGradient>
      <linearGradient
        id="context-light-i"
        x1={61}
        x2={61}
        y1={84}
        y2={108}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="context-light-k"
        x1={15}
        x2={31}
        y1={127}
        y2={143}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#33F" />
        <stop offset={1} stopColor="#0080FF" />
      </linearGradient>
      <linearGradient
        id="context-light-l"
        x1={57.5}
        x2={57.5}
        y1={124}
        y2={148}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="context-light-n"
        x1={15}
        x2={29}
        y1={169}
        y2={183}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#CB3100" />
        <stop offset={1} stopColor="#FF4C4D" />
      </linearGradient>
      <linearGradient
        id="context-light-o"
        x1={66}
        x2={66}
        y1={164}
        y2={188}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <filter
        id="context-light-a"
        width={216}
        height={80}
        x={-16}
        y={-16}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_5831_306"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_5831_306"
          result="shape"
        />
      </filter>
      <filter
        id="context-light-d"
        width={201}
        height={176}
        x={-16}
        y={48}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_5831_306"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_5831_306"
          result="shape"
        />
      </filter>
      <filter
        id="context-light-f"
        width={168}
        height={56}
        x={-4}
        y={68}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_5831_306"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_5831_306"
          result="shape"
        />
      </filter>
      <filter
        id="context-light-j"
        width={168}
        height={56}
        x={-4}
        y={108}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_5831_306"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_5831_306"
          result="shape"
        />
      </filter>
      <filter
        id="context-light-m"
        width={168}
        height={56}
        x={-4}
        y={148}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={8} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_5831_306"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_5831_306"
          result="shape"
        />
      </filter>
    </defs>
  </svg>
);
